/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstHistoricoRecBaixaTitulo;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoDocOpcoesCtbBaixaTit;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosOpcoesCtbBaixaTit;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.opcoes.ExceptionOpBaixaTitulosNaoDefinidas;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.historico.CompHistoricoLancBaixaTitulos;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidCheck;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CompLancamentoBaseBaixaTitulo
extends CompLancamentoBase {
    private ValidCheck validCheck = new ValidCheck();
    @Autowired
    private CompHistoricoLancBaixaTitulos compHistoricoLancBaixaTitulos;
    @Autowired
    private ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulos;

    public Double getValorOperacao(BaixaTitulo baixa) {
        Double vrTotal = baixa.getValor() + baixa.getVrJuros() - baixa.getVrDesconto() - baixa.getVrAbatimento() + baixa.getVrMulta() - baixa.getVrPis() - baixa.getVrTaxaCartao() - baixa.getVrConfins() - baixa.getVrContribSocial() - baixa.getVrIR();
        vrTotal = this.isEquals(baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue()) ? Double.valueOf(vrTotal + baixa.getVrDespesaCartorioPaga() - baixa.getVrDespesaCartorioRecebida() - baixa.getVrAtualizacaoMonetariaRecebida() + baixa.getVrAtualizacaoMonetariaPaga() - baixa.getVrDespBancariaRecebida() + baixa.getVrDespBancariaPaga() + baixa.getVrIOFPago() - baixa.getVrIOFRecebido()) : Double.valueOf(vrTotal - baixa.getVrDespesaCartorioPaga() + baixa.getVrDespesaCartorioRecebida() + baixa.getVrAtualizacaoMonetariaRecebida() - baixa.getVrAtualizacaoMonetariaPaga() + baixa.getVrDespBancariaRecebida() - baixa.getVrDespBancariaPaga() - baixa.getVrIOFPago() + baixa.getVrIOFRecebido());
        return vrTotal;
    }

    public OpcoesContabeisBaixaTitulos getOpcoesContabeisBaixaTitulos(BaixaTitulo b, Empresa empresa) throws ExceptionOpBaixaTitulosNaoDefinidas {
        OpcoesContabeisBaixaTitulos op = this.getServiceOpcoesContabeisBaixaTitulos().getOpcoesContabeisByBaixa(b, empresa);
        if (op == null) {
            throw new ExceptionOpBaixaTitulosNaoDefinidas("E.ERP.0376.002", new Object[]{b.toString(), empresa.toString()});
        }
        return op;
    }

    public String completarHistoricoPadrao(BaixaTitulo b, HistoricoPadrao h) {
        return this.getCompHistoricoLancBaixaTitulos().completarHistoricoPadrao(b, h);
    }

    public String criarHistorico(EnumConstTipoTitulo pagRec, EnumConstHistoricoRecBaixaTitulo tipo, BaixaTitulo b) {
        return this.getCompHistoricoLancBaixaTitulos().criarHistorico(pagRec, tipo, b);
    }

    public String getOrigemTitulo(Titulo t) {
        return this.getCompHistoricoLancBaixaTitulos().getOrigemTitulo(t);
    }

    public void getLancamentoTitulo(BaixaTitulo b, LoteContabil lote, EnumConstTipoTitulo pagRec, OpcoesContabeisBaixaTitulos op, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        Lancamento l = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            l.setPlanoContaDeb(b.getTitulo().getPlanoConta());
            if (op != null && op.getHistDevValorBaixa() != null) {
                l.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
            } else {
                l.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            }
        } else {
            l.setPlanoContaCred(b.getTitulo().getPlanoConta());
            if (op != null && op.getHistCredValorBaixa() != null) {
                l.setHistorico(this.completarHistoricoPadrao(b, op.getHistCredValorBaixa()));
            } else {
                l.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            }
        }
        l.setValor(Double.valueOf(b.getValor() - b.getVrMultaEmbutido() - b.getVrJurosEmbutido() - b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido()));
        l.setValor(Double.valueOf(b.getValor() - b.getVrMultaEmbutido() - b.getTitulo().getValorDespesaBancariaEmbutida() - b.getVrJurosEmbutido() - b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido()));
        if ((l.getPlanoContaCred() != null || l.getPlanoContaDeb() != null) && this.arrredondarNumero(l.getValor(), 2) > 0.0) {
            lancamentos.add(l);
        } else if (this.getValidCheck().isCheckItem("V.ERP.0650.125", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.125", new Object[]{b.getTitulo(), op});
        }
    }

    public void getOutrosLancamentos(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (this.arrredondarNumero(b.getVrMulta()) > 0.0) {
                lancamentos.add(this.getLancamentoMulta(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrJuros()) > 0.0) {
                lancamentos.add(this.getLancamentoJuros(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrAtualizacaoMonetariaRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoAtMonetariaRecebida(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrAtualizacaoMonetariaPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoAtMonetariaPaga(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespBancariaPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoDespBancariaPag(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrIOFPago()) > 0.0) {
                lancamentos.add(this.getLancamentoIofPag(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespBancariaRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespBancariaRec(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrIOFRecebido()) > 0.0) {
                lancamentos.add(this.getLancamentoIofRec(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDesconto()) > 0.0) {
                lancamentos.add(this.getLancamentoDesconto(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrAbatimento()) > 0.0) {
                lancamentos.add(this.getLancamentoAbatimento(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrConfins()) > 0.0) {
                lancamentos.add(this.getLancamentoCofins(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrPis()) > 0.0) {
                lancamentos.add(this.getLancamentoPis(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrContribSocial()) > 0.0) {
                lancamentos.add(this.getLancamentoContSocial(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrMultaEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoMultaEmbutida(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrJurosEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoJurosEmbutidos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getTitulo().getValorDescontosEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoDescontosEmbutidos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getTitulo().getValorDespesaBancariaEmbutida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaBancEmb(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getValorAdicional()) > 0.0) {
                lancamentos.add(this.getLancamentoValorAdicional(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (b.getVrIR() != null && this.arrredondarNumero(b.getVrIR()) > 0.0) {
                lancamentos.add(this.getLancamentoValorIR(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO));
            }
            if (this.arrredondarNumero(b.getVrDespesaCartorioPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaCartorioPaga(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespesaCartorioRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaCartorioRecebida(b, lote, contasBaixa, op));
            }
            if (ToolMethods.isWithData((Collection)b.getTitulo().getTipoValoresTitulosTitulos()) && op.getPcCredRepasse() != null && op.getPcDebRepasse() != null) {
                for (TipoValoresTitulosTitulos tipoTitulo : b.getTitulo().getTipoValoresTitulosTitulos()) {
                    Boolean achou = true;
                    for (TipoValoresTitulosOpcoesCtbBaixaTit tipoBaixa : op.getTipoValoresTitulosOpcoesCtbBaixaTit()) {
                        if (!this.isEquals(tipoTitulo.getTipoValoresTitulos(), tipoBaixa.getTipoValoresTitulos())) continue;
                        lancamentos.add(this.getLancamentoRepasseRecebida(b, lote, op, EnumConstTipoTitulo.RECEBIMENTO, tipoTitulo.getValor()));
                        achou = true;
                    }
                    if (achou.booleanValue()) continue;
                }
            }
            if (b.getTitulo().getTipoDoc() != null && this.isEquals(b.getTitulo().getTipoDoc().getGerarLancamentoPisCofins(), EnumConstantsMentorSimNao.SIM.getValue())) {
                for (TipoDocOpcoesCtbBaixaTit i : op.getTipoDocOpcoesCtbBaixaTit()) {
                    Lancamento lancamentoCofins;
                    Double valorCofins;
                    Lancamento lancamentoPis;
                    if (!this.isEquals(i.getTipoDoc(), b.getTitulo().getTipoDoc())) continue;
                    Double valorPis = this.getValorOperacao(b) * (b.getTitulo().getTipoDoc().getAliquotaPis() / 100.0);
                    if (this.arrredondarNumero(valorPis) > 0.0 && ToolMethods.isNotNull((Object)(lancamentoPis = this.getLancamentoPisCofins(b, lote, op, op.getPlanoContaPisCred(), op.getPlanoContaPisDeb(), op.getHistLancamentoPis(), EnumConstTipoTitulo.RECEBIMENTO, valorPis))).booleanValue()) {
                        lancamentos.add(lancamentoPis);
                    }
                    if (!(this.arrredondarNumero(valorCofins = Double.valueOf(this.getValorOperacao(b) * (b.getTitulo().getTipoDoc().getAliquotaCofins() / 100.0))) > 0.0) || !ToolMethods.isNotNull((Object)(lancamentoCofins = this.getLancamentoPisCofins(b, lote, op, op.getPlanoContaCofinsCred(), op.getPlanoContaCofinsDeb(), op.getHistLancamentoCofins(), EnumConstTipoTitulo.RECEBIMENTO, valorCofins))).booleanValue()) continue;
                    lancamentos.add(lancamentoCofins);
                }
            }
            if (this.arrredondarNumero(b.getVrTaxaCartao()) > 0.0) {
                throw new ExceptionRuntimeBase(MessagesBaseMentor.getMsg((String)"sistemaNaoContabilizaTaxaCartao", (Object[])new Object[0]));
            }
        } else {
            if (this.arrredondarNumero(b.getVrMulta()) > 0.0) {
                lancamentos.add(this.getLancamentoMulta(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrJuros()) > 0.0) {
                lancamentos.add(this.getLancamentoJuros(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrAtualizacaoMonetariaPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoAtMonetariaPaga(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrAtualizacaoMonetariaRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoAtMonetariaRecebida(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespBancariaPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoDespBancariaPag(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrIOFPago()) > 0.0) {
                lancamentos.add(this.getLancamentoIofPag(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespBancariaRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespBancariaRec(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrTaxaCartao()) > 0.0) {
                lancamentos.add(this.getLancamentoTaxaCartaoRec(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrIOFRecebido()) > 0.0) {
                lancamentos.add(this.getLancamentoIofRec(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDesconto()) > 0.0) {
                lancamentos.add(this.getLancamentoDesconto(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrAbatimento()) > 0.0) {
                lancamentos.add(this.getLancamentoAbatimento(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrConfins()) > 0.0) {
                lancamentos.add(this.getLancamentoCofins(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrPis()) > 0.0) {
                lancamentos.add(this.getLancamentoPis(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrContribSocial()) > 0.0) {
                lancamentos.add(this.getLancamentoContSocial(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrMultaEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoMultaEmbutida(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrJurosEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoJurosEmbutidos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getTitulo().getValorDescontosEmbutido()) > 0.0) {
                lancamentos.add(this.getLancamentoDescontosEmbutidos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getTitulo().getValorDespesaBancariaEmbutida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaBancEmb(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getValorAdicional()) > 0.0) {
                lancamentos.add(this.getLancamentoValorAdicional(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (this.arrredondarNumero(b.getVrDespesaCartorioPaga()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaCartorioPaga(b, lote, contasBaixa, op));
            }
            if (this.arrredondarNumero(b.getVrDespesaCartorioRecebida()) > 0.0) {
                lancamentos.add(this.getLancamentoDespesaCartorioRecebida(b, lote, contasBaixa, op));
            }
            if (b.getVrIR() != null && this.arrredondarNumero(b.getVrIR()) > 0.0) {
                lancamentos.add(this.getLancamentoValorIR(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO));
            }
            if (ToolMethods.isWithData((Collection)b.getTitulo().getTipoValoresTitulosTitulos()) && op.getPcCredRepasse() != null && op.getPcDebRepasse() != null) {
                for (TipoValoresTitulosTitulos tipoTitulo : b.getTitulo().getTipoValoresTitulosTitulos()) {
                    Boolean achou = true;
                    for (TipoValoresTitulosOpcoesCtbBaixaTit tipoBaixa : op.getTipoValoresTitulosOpcoesCtbBaixaTit()) {
                        if (!this.isEquals(tipoTitulo.getTipoValoresTitulos(), tipoBaixa.getTipoValoresTitulos())) continue;
                        lancamentos.add(this.getLancamentoRepasseRecebida(b, lote, op, EnumConstTipoTitulo.RECEBIMENTO, tipoTitulo.getValor()));
                        achou = true;
                    }
                    if (achou.booleanValue()) continue;
                }
            }
            if (b.getTitulo().getTipoDoc() != null && this.isEquals(b.getTitulo().getTipoDoc().getGerarLancamentoPisCofins(), EnumConstantsMentorSimNao.SIM.getValue())) {
                for (TipoDocOpcoesCtbBaixaTit i : op.getTipoDocOpcoesCtbBaixaTit()) {
                    if (!this.isEquals(i.getTipoDoc(), b.getTitulo().getTipoDoc())) continue;
                    Double valorPis = this.getValorOperacao(b) * (b.getTitulo().getTipoDoc().getAliquotaPis() / 100.0);
                    Lancamento lancamentoPis = this.getLancamentoPisCofins(b, lote, op, op.getPlanoContaPisCred(), op.getPlanoContaPisDeb(), op.getHistLancamentoPis(), EnumConstTipoTitulo.RECEBIMENTO, valorPis);
                    if (ToolMethods.isNotNull((Object)lancamentoPis).booleanValue()) {
                        lancamentos.add(lancamentoPis);
                    }
                    Double valorCofins = this.getValorOperacao(b) * (b.getTitulo().getTipoDoc().getAliquotaPis() / 100.0);
                    Lancamento lancamentoCofins = this.getLancamentoPisCofins(b, lote, op, op.getPlanoContaCofinsCred(), op.getPlanoContaCofinsDeb(), op.getHistLancamentoCofins(), EnumConstTipoTitulo.RECEBIMENTO, valorCofins);
                    if (!ToolMethods.isNotNull((Object)lancamentoCofins).booleanValue()) continue;
                    lancamentos.add(lancamentoCofins);
                }
            }
        }
    }

    public Lancamento getLancamentoDespesaCartorioPaga(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaCartorioPag() != null) {
            lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaCartorioPag());
        } else {
            lancamento.setPlanoContaDeb(op.getPlanoDespesaCartorioPag());
        }
        if (op != null && op.getHistDespesaCartorio() != null) {
            HistoricoPadrao histPadrao = op.getHistDespesaCartorio();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESPESA_CARTORIO_PAGA, b));
        }
        lancamento.setValor(b.getVrDespesaCartorioPaga());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.123", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.123", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoValorAdicional(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaValorAdd() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaValorAdd());
            } else {
                lancamento.setPlanoContaDeb(op.getPcVrAdicionalPago());
            }
            if (op != null && op.getHistValorAdicional() != null) {
                HistoricoPadrao histPadrao = op.getHistValorAdicional();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESC_EMB, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaValorAdd() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaValorAdd());
            } else {
                lancamento.setPlanoContaCred(op.getPcVrAdicionalRecebido());
            }
            if (op != null && op.getHistValorAdicional() != null) {
                HistoricoPadrao histPadrao = op.getHistValorAdicional();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESC_EMB, b));
            }
        }
        lancamento.setValor(b.getTitulo().getValorAdicional());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.122", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.122", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDescontosEmbutidos(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaDescontosEmb() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaDescontosEmb());
            } else {
                lancamento.setPlanoContaCred(op.getPcDescEmbutidoPag());
            }
            if (op != null && op.getHistDevValorDescEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorDescEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESC_EMB, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaDescontosEmb() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaDescontosEmb());
            } else {
                lancamento.setPlanoContaDeb(op.getPcDescEmbutidoRec());
            }
            if (op != null && op.getHistCredValorDescEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorDescEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESC_EMB, b));
            }
        }
        lancamento.setValor(b.getTitulo().getValorDescontosEmbutido());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.121", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.121", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDespesaBancEmb(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaDespBancPag() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaDespBancPag());
            } else {
                lancamento.setPlanoContaDeb(op.getPcDespBanEmbutidoPag());
            }
            if (op != null && op.getHistDevValorDespBancaria() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorDespBancaria();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESP_BANC, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaDespBancRec() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaDespBancRec());
            } else {
                lancamento.setPlanoContaCred(op.getPcDespBanEmbutidoRec());
            }
            if (op != null && op.getHistCredValorDespBancaria() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorDespBancaria();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESP_BANC, b));
            }
        }
        lancamento.setValor(b.getTitulo().getValorDespesaBancariaEmbutida());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.120", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.120", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoJurosEmbutidos(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaJurosEmb() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaJurosEmb());
            } else {
                lancamento.setPlanoContaDeb(op.getPcJurosEmbutidoPag());
            }
            if (op != null && op.getHistDevValorJurosEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorJurosEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_JUROS_EMB, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaJurosEmb() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaJurosEmb());
            } else {
                lancamento.setPlanoContaCred(op.getPcJurosEmbutidoRec());
            }
            if (op != null && op.getHistCredValorJurosEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorJurosEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_JUROS_EMB, b));
            }
        }
        lancamento.setValor(b.getVrJurosEmbutido());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.119", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.119", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDespesaCartorioRecebida(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaCartorioRec() != null) {
            lancamento.setPlanoContaCred(contasBaixa.getPlanoContaCartorioRec());
        } else {
            lancamento.setPlanoContaCred(op.getPlanoDespesaCartorioRec());
        }
        if (op != null && op.getHistDespesaCartorio() != null) {
            HistoricoPadrao histPadrao = op.getHistDespesaCartorio();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESPESA_CARTORIO_RECEBIDA, b));
        }
        lancamento.setValor(b.getVrDespesaCartorioRecebida());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.118", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.118", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoRepasseRecebida(BaixaTitulo b, LoteContabil lote, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagrec, Double valorTipoTitulo) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        lancamento.setPlanoContaCred(op.getPcCredRepasse());
        lancamento.setPlanoContaDeb(op.getPcDebRepasse());
        lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(pagrec, EnumConstHistoricoRecBaixaTitulo.HIST_REPASSE, b));
        lancamento.setValor(this.getValorLancamentoRepasseRecebida(b, valorTipoTitulo));
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.117", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.117", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoPisCofins(BaixaTitulo b, LoteContabil lote, OpcoesContabeisBaixaTitulos op, PlanoConta planoContaCred, PlanoConta planoContaDeb, HistoricoPadrao historicoPadrao, EnumConstTipoTitulo pagrec, Double valor) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        lancamento.setPlanoContaCred(planoContaCred);
        lancamento.setPlanoContaDeb(planoContaDeb);
        lancamento.setValor(valor);
        if (historicoPadrao != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, historicoPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(pagrec, EnumConstHistoricoRecBaixaTitulo.HIST_PIS_COFINS, b));
        }
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.116", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.116", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoAtMonetariaPaga(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaAtualMonPaga() != null) {
            lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaAtualMonPaga());
        } else {
            lancamento.setPlanoContaDeb(op.getPlanoContaAt2());
        }
        if (op != null && op.getHistDevValorAtMonetaria() != null) {
            HistoricoPadrao histPadrao = op.getHistDevValorAtMonetaria();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_AT_MONET, b));
        }
        lancamento.setValor(b.getVrAtualizacaoMonetariaPaga());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.115", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.115", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoMulta(BaixaTitulo baixa, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, baixa.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaMulta() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaMulta());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoContaMulta2());
            }
            if (op != null && op.getHistDevValorMulta() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorMulta();
                lancamento.setHistorico(this.completarHistoricoPadrao(baixa, histPadrao));
            } else {
                lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_MULTA, baixa));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaMulta() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaMulta());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoContaMulta1());
            }
            if (op != null && op.getHistCredValorMulta() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorMulta();
                lancamento.setHistorico(this.completarHistoricoPadrao(baixa, histPadrao));
            } else {
                lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_MULTA, baixa));
            }
        }
        lancamento.setValor(baixa.getVrMulta());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.100", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.100", new Object[]{baixa.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoJuros(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaJuros() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaJuros());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoContaJuros2());
            }
            if (op != null && op.getHistDevValorJuros() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorJuros();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_JUROS, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaJuros() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaJuros());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoContaJuros1());
            }
            if (op != null && op.getHistCredValorJuros() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorJuros();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_JUROS, b));
            }
        }
        lancamento.setValor(b.getVrJuros());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.101", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.101", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoAtMonetariaRecebida(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaAtualMonRecebida() != null) {
            lancamento.setPlanoContaCred(contasBaixa.getPlanoContaAtualMonRecebida());
        } else {
            lancamento.setPlanoContaCred(op.getPlanoContaAt1());
        }
        if (op != null && op.getHistCredValorAtMonetaria() != null) {
            HistoricoPadrao histPadrao = op.getHistCredValorAtMonetaria();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_AT_MONET, b));
        }
        lancamento.setValor(b.getVrAtualizacaoMonetariaRecebida());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.102", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.102", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDespBancariaPag(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaDespBancPag() != null) {
            lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaDespBancPag());
        } else {
            lancamento.setPlanoContaDeb(op.getPlanoContaDespBan2());
        }
        if (op != null && op.getHistDevValorDespBancaria() != null) {
            HistoricoPadrao histPadrao = op.getHistDevValorDespBancaria();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESP_BANC, b));
        }
        lancamento.setValor(b.getVrDespBancariaPaga());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.103", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.103", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoIofPag(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaIofPag() != null) {
            lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaIofPag());
        } else {
            lancamento.setPlanoContaDeb(op.getPcIOFPagos());
        }
        if (op != null && op.getHistDevValorIOF() != null) {
            HistoricoPadrao histPadrao = op.getHistDevValorIOF();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_IOF, b));
        }
        lancamento.setValor(b.getVrIOFPago());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.104", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.104", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDespBancariaRec(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaDespBancRec() != null) {
            lancamento.setPlanoContaCred(contasBaixa.getPlanoContaDespBancRec());
        } else {
            lancamento.setPlanoContaCred(op.getPlanoContaDespBan1());
        }
        if (op != null && op.getHistCredValorDespBancaria() != null) {
            HistoricoPadrao histPadrao = op.getHistCredValorDespBancaria();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESP_BANC, b));
        }
        lancamento.setValor(b.getVrDespBancariaRecebida());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.105", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.105", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoTaxaCartaoRec(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaTaxaCartao() != null) {
            lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaTaxaCartao());
        } else {
            lancamento.setPlanoContaDeb(op.getPcCartaoCredito());
        }
        if (op != null && op.getHistTaxaCartao() != null) {
            HistoricoPadrao histPadrao = op.getHistTaxaCartao();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_TAXA_CARTAO, b));
        }
        lancamento.setValor(b.getVrTaxaCartao());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.106", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.106", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoIofRec(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (contasBaixa != null && contasBaixa.getPlanoContaIofRec() != null) {
            lancamento.setPlanoContaCred(contasBaixa.getPlanoContaIofRec());
        } else {
            lancamento.setPlanoContaCred(op.getPcIOFRecebidos());
        }
        if (op != null && op.getHistCredValorIOF() != null) {
            HistoricoPadrao histPadrao = op.getHistCredValorIOF();
            lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_IOF, b));
        }
        lancamento.setValor(b.getVrIOFRecebido());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.107", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.107", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoCofins(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaCofins() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaCofins());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoConfins2());
            }
            if (op != null && op.getHistDevValorCofins() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorCofins();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COFINS, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaCofins() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaCofins());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoConfins1());
            }
            if (op != null && op.getHistCredValorCofins() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorCofins();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COFINS, b));
            }
        }
        lancamento.setValor(b.getVrConfins());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.108", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.108", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoValorIR(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaIR() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaIR());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoContaIRPag());
            }
            if (op != null && op.getHistIR() != null) {
                HistoricoPadrao histPadrao = op.getHistIR();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_IR, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaIR() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaIR());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoContaIRRec());
            }
            if (op != null && op.getHistIR() != null) {
                HistoricoPadrao histPadrao = op.getHistIR();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_IR, b));
            }
        }
        lancamento.setValor(b.getVrIR());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.109", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.109", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoPis(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaPis() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaPis());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoPis2());
            }
            if (op != null && op.getHistDevValorPis() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorPis();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_PIS, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaPis() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaPis());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoPis1());
            }
            if (op != null && op.getHistCredValorPis() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorPis();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_PIS, b));
            }
        }
        lancamento.setValor(b.getVrPis());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.110", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.110", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoContSocial(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaContrSoc() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaContrSoc());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoContrSoc2());
            }
            if (op != null && op.getHistDevValorContrSocial() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorContrSocial();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_CONTR_SOCIAL, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaContrSoc() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaContrSoc());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoContrSoc1());
            }
            if (op != null && op.getHistCredValorContrSocial() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorContrSocial();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_CONTR_SOCIAL, b));
            }
        }
        lancamento.setValor(b.getVrContribSocial());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.111", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.111", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoDesconto(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaDesc() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaDesc());
            } else {
                lancamento.setPlanoContaCred(op.getPlanoContaDesc2());
            }
            if (op != null && op.getHistDevValorDesconto() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorDesconto();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESCONTO, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaDesc() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaDesc());
            } else {
                lancamento.setPlanoContaDeb(op.getPlanoContaDesc1());
            }
            if (op != null && op.getHistCredValorDesconto() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorDesconto();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_DESCONTO, b));
            }
        }
        lancamento.setValor(b.getVrDesconto());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.112", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.112", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoAbatimento(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaAbatimento() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaAbatimento());
            } else {
                lancamento.setPlanoContaCred(op.getPcAbatimentosPagos());
            }
            if (op != null && op.getHistDevValorAbatimento() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorAbatimento();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_ABATIMENTO, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaAbatimento() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaAbatimento());
            } else {
                lancamento.setPlanoContaDeb(op.getPcAbatimentosRecebidos());
            }
            if (op != null && op.getHistCredValorAbatimento() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorAbatimento();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_ABATIMENTO, b));
            }
        }
        lancamento.setValor(b.getVrAbatimento());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.113", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.113", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    public Lancamento getLancamentoMultaEmbutida(BaixaTitulo b, LoteContabil lote, ContasBaixa contasBaixa, OpcoesContabeisBaixaTitulos op, EnumConstTipoTitulo pagRec) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancamentoBaseBaixaTitulo.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (contasBaixa != null && contasBaixa.getPlanoContaMultaEmb() != null) {
                lancamento.setPlanoContaDeb(contasBaixa.getPlanoContaMultaEmb());
            } else {
                lancamento.setPlanoContaDeb(op.getPcMultaEmbutidaPag());
            }
            if (op != null && op.getHistDevValorMultaEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistDevValorMultaEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_MULTA_EMB, b));
            }
        } else {
            if (contasBaixa != null && contasBaixa.getPlanoContaMultaEmb() != null) {
                lancamento.setPlanoContaCred(contasBaixa.getPlanoContaMultaEmb());
            } else {
                lancamento.setPlanoContaCred(op.getPcMultaEmbutidaRec());
            }
            if (op != null && op.getHistCredValorMultaEmb() != null) {
                HistoricoPadrao histPadrao = op.getHistCredValorMultaEmb();
                lancamento.setHistorico(this.completarHistoricoPadrao(b, histPadrao));
            } else {
                lancamento.setHistorico(this.getCompHistoricoLancBaixaTitulos().criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_MULTA_EMB, b));
            }
        }
        lancamento.setValor(b.getVrMultaEmbutido());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            return lancamento;
        }
        if (this.getValidCheck().isCheckItem("V.ERP.0650.114", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.114", new Object[]{b.getTitulo(), op});
        }
        return null;
    }

    private Double getValorLancamentoRepasseRecebida(BaixaTitulo b, Double valorTipoTitulo) {
        return ToolFormatter.arrredondarNumero((Double)(b.getValor() * valorTipoTitulo / b.getTitulo().getValor()), (int)2);
    }

    public ValidCheck getValidCheck() {
        return this.validCheck;
    }

    public CompHistoricoLancBaixaTitulos getCompHistoricoLancBaixaTitulos() {
        return this.compHistoricoLancBaixaTitulos;
    }

    public void setCompHistoricoLancBaixaTitulos(CompHistoricoLancBaixaTitulos compHistoricoLancBaixaTitulos) {
        this.compHistoricoLancBaixaTitulos = compHistoricoLancBaixaTitulos;
    }

    public ServiceOpcoesContabeisBaixaTitulosImpl getServiceOpcoesContabeisBaixaTitulos() {
        return this.serviceOpcoesContabeisBaixaTitulos;
    }

    public void setServiceOpcoesContabeisBaixaTitulos(ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulos) {
        this.serviceOpcoesContabeisBaixaTitulos = serviceOpcoesContabeisBaixaTitulos;
    }
}

