/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.historico;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstHistoricoRecBaixaTitulo;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstCamposTitulo;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompHistoricoLancBaixaTitulos
extends CompLancamentoBase {
    public String criarHistorico(EnumConstTipoTitulo pagRec, EnumConstHistoricoRecBaixaTitulo tipo, BaixaTitulo b) {
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            return this.getHistoricoPagamento(tipo, b);
        }
        return this.getHistoricoRecebimento(tipo, b);
    }

    private String getHistoricoPagamento(EnumConstHistoricoRecBaixaTitulo tipo, BaixaTitulo b) {
        switch (tipo) {
            case HIST_NORMAL: {
                return "Valor baixado referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_MULTA: {
                return "Valor da multa paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_MULTA_EMB: {
                return "Valor da multa embutida paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_JUROS: {
                return "Valor dos juros pagos referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_JUROS_EMB: {
                return "Valor dos juros embutidos pagos referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESCONTO: {
                return "Valor do desconto recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_ABATIMENTO: {
                return "Valor do abatimento recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_AT_MONET: {
                return "Valor da At. Monetaria paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESP_BANC: {
                return "Valor da Desp. Bancaria paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_IOF: {
                return "Valor do IOF pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_CONTR_SOCIAL: {
                return "Valor da Contr. Social paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_PIS: {
                return "Valor do PIS pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_COFINS: {
                return "Valor do Cofins pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESC_EMB: {
                return "Valor do desconto embutido pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESPESA_CARTORIO_PAGA: {
                return "Valor de Despesa Cartorio paga referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_IR: {
                return "Valor IR pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_REPASSE: {
                return "Valor Repasse pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_PIS_COFINS: {
                return "Valor Pis/Cofins pago referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_COMPENSACAO: {
                return "Compensacao de titulo de " + b.getTitulo().getPessoa().getNome();
            }
        }
        return "";
    }

    private String getHistoricoRecebimento(EnumConstHistoricoRecBaixaTitulo tipo, BaixaTitulo b) {
        switch (tipo) {
            case HIST_NORMAL: {
                return "Valor baixado referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_MULTA: {
                return "Valor da multa recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_MULTA_EMB: {
                return "Valor da multa embutida recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_JUROS: {
                return "Valor dos juros recebidos referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_JUROS_EMB: {
                return "Valor dos juros embutidos recebidos referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESCONTO: {
                return "Valor do desconto concedido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_ABATIMENTO: {
                return "Valor do abatimento concedido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_AT_MONET: {
                return "Valor da At. Monetaria recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESP_BANC: {
                return "Valor da Desp. Bancaria recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_IOF: {
                return "Valor do IOF recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_CONTR_SOCIAL: {
                return "Valor da Contr. Social recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_PIS: {
                return "Valor do PIS recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_COFINS: {
                return "Valor do Cofins recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESC_EMB: {
                return "Valor do Desconto embutido recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_DESPESA_CARTORIO_RECEBIDA: {
                return "Valor de Despesa Cartorio recebida referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_IR: {
                return "Valor IR referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_TAXA_CARTAO: {
                return "Valor Taxa Cartao Credito/Debito ref. ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_COMPENSACAO: {
                return "Compensacao de titulo de " + b.getTitulo().getPessoa().getNome();
            }
            case HIST_REPASSE: {
                return "Valor Repasse recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
            case HIST_PIS_COFINS: {
                return "Valor Pis/Cofins recebido referente ao titulo nr: " + b.getTitulo().getIdentificador() + " de " + b.getTitulo().getPessoa().getNome() + ". " + this.getOrigemTitulo(b.getTitulo());
            }
        }
        return "";
    }

    public String getOrigemTitulo(Titulo t) {
        Object origem = "";
        if (t.getInfPagamentoNfPropria() != null && t.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            origem = "a NF Propria nr: " + t.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota();
        } else if (t.getInfPagamentoNfTerceiros() != null && t.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
            origem = "a NF Terceiros nr: " + t.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota();
        } else if (t.getCte() != null) {
            origem = "ao CTe nr: " + t.getCte().getNumero();
        } else if (t.getRps() != null) {
            origem = "ao RPS nr: " + t.getRps().getNumeroNFse();
        } else if (t.getAdiantamentoViagem() != null) {
            origem = "ao Adiantamento de Viagem nr: " + t.getAdiantamentoViagem().getIdentificador();
        } else if (t.getAdiantamentoViagemFechamento() != null) {
            origem = "ao Adiantamento de Viagem de Fechamento nr: " + t.getAdiantamentoViagemFechamento().getIdentificador();
        } else if (t.getFaturaCte() != null) {
            origem = "a Fatura CTe nr: " + t.getFaturaCte().getIdentificador();
        } else if (t.getFaturaTitulos() != null) {
            origem = "a Fatura Titulos nr: " + t.getFaturaTitulos().getIdentificador();
        } else if (t.getFechamentoFolha() != null) {
            origem = "ao Fechamento Folha nr: " + t.getFechamentoFolha().getIdentificador();
        } else if (t.getTitulosFolha() != null) {
            origem = "ao titulos da folha pagamento nr: " + t.getTitulosFolha().getIdentificador();
        } else if (t.getNotaContratoLocacao() != null) {
            origem = "a Nota Contrato Locacao nr: " + t.getNotaContratoLocacao().getIdentificador();
        } else if (t.getContratoLocacao() != null) {
            origem = "ao Contrato Locacao nr: " + t.getContratoLocacao().getIdentificador();
        } else if (t.getPedidoComercio() != null) {
            origem = "ao Pedido Comercio nr: " + t.getPedidoComercio().getIdentificador();
        } else if (t.getApuracaoLocacaoContrato() != null) {
            origem = "a Apuracao Locacao Contrato nr: " + t.getApuracaoLocacaoContrato().getIdentificador();
        } else if (t.getLancamentoCooperado() != null) {
            origem = "ao Lanc. Evento Cooperado nr: " + t.getLancamentoCooperado().getIdentificador();
        }
        if (!((String)origem).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Titulo referente ");
            sb.append((String)origem);
            sb.append(".");
            return sb.toString();
        }
        return origem;
    }

    public String completarHistoricoPadrao(BaixaTitulo b, HistoricoPadrao h) {
        String st = h.getDescricao();
        List token = ToolString.getReplaceTokens((String)st);
        HashMap<String, String> m = new HashMap<String, String>();
        for (StringToken sk : token) {
            m.put(sk.getChave(), this.getFixedValue(sk.getChave(), b).toString());
        }
        st = ToolString.build((String)st, m);
        return st;
    }

    private String getFixedValue(String valorStr, BaixaTitulo b) {
        EnumConstCamposTitulo valor = EnumConstCamposTitulo.get((String)valorStr);
        if (valor == null) {
            return "";
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NR_TITULO)) {
            return b.getTitulo().getIdentificador().toString();
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NUMERO_NOTA_TITULO)) {
            return CompHistoricoLancBaixaTitulos.findNumeroNotaTerceiroTitulo(b);
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NOME_PESSOA_TITULO)) {
            return b.getTitulo().getPessoa().getNome();
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.CPF_PESSOA_TITULO)) {
            return b.getTitulo().getPessoa().getComplemento().getCnpj();
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DATA_BAIXA_TITULO)) {
            return ToolDate.dateToStr((Date)b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao());
        }
        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.FAVORECIDO_CHEQUE)) {
            if (b.getCheque() != null) {
                return b.getCheque().getFavorecido();
            }
        } else if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NR_CHEQUE_PROPRIO)) {
            if (b.getCheque() != null) {
                return b.getCheque().getNumero().toString();
            }
        } else {
            if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NR_CHEQUE_TERCEIROS)) {
                StringBuilder cheques = new StringBuilder();
                if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                    for (ChequeTerceiros c : b.getGrupoDeBaixaFormas().getChequeTerceirosPag()) {
                        cheques.append(c.getNumero().toString()).append(",");
                    }
                } else {
                    for (ChequeTerceiros c : b.getGrupoDeBaixaFormas().getChequeTerceirosRec()) {
                        cheques.append(c.getNumero().toString()).append(",");
                    }
                }
                if (cheques.length() > 0) {
                    return cheques.substring(0, cheques.toString().trim().length() - 1);
                }
                return cheques.toString();
            }
            if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_CHEQUE_PROPRIO)) {
                if (b.getCheque() != null) {
                    return ToolFormatter.formataNumero((Number)b.getCheque().getValor(), (int)2);
                }
            } else {
                if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_CHEQUE_TERCEIROS)) {
                    Double vrCheques = 0.0;
                    if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                        for (ChequeTerceiros c : b.getGrupoDeBaixaFormas().getChequeTerceirosPag()) {
                            vrCheques = vrCheques + c.getValor();
                        }
                    } else {
                        for (ChequeTerceiros c : b.getGrupoDeBaixaFormas().getChequeTerceirosRec()) {
                            vrCheques = vrCheques + c.getValor();
                        }
                    }
                    return vrCheques.toString();
                }
                if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DT_VENC_CHEQUE)) {
                    if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                        return ToolDate.dateToStr((Date)((ChequeTerceiros)b.getGrupoDeBaixaFormas().getChequeTerceirosPag().get(0)).getDataVencimento());
                    }
                    return ToolDate.dateToStr((Date)((ChequeTerceiros)b.getGrupoDeBaixaFormas().getChequeTerceirosRec().get(0)).getDataVencimento());
                }
                if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DT_VENC_TITULO)) {
                    return ToolDate.dateToStr((Date)b.getTitulo().getDataVencimento());
                }
                if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_TOTAL_BAIXA)) {
                    Double vrTotal = b.getValor() + b.getVrJuros() + b.getVrMulta() + b.getVrContribSocial() + b.getVrConfins() + this.getValoresPagRec(b) + b.getVrPis() - b.getVrDesconto();
                    return vrTotal.toString();
                }
                if (b == null || !this.isEquals(valor, EnumConstCamposTitulo.VLR_TOTAL_CHEQUES)) {
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NOME_PESSOA)) {
                        return b.getTitulo().getPessoa().getNome();
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DATA_VENC_TITULO)) {
                        return ToolDate.dateToStr((Date)b.getTitulo().getDataVencimento());
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.TIPO_DOC_FINANC)) {
                        return b.getTitulo().getTipoDoc().getNome();
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.OBSERVACAO)) {
                        return b.getTitulo().getObservacao();
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.SERIE_NOTA)) {
                        if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getSerie();
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getSerie();
                        }
                        return "";
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.NR_NOTA)) {
                        if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota().toString();
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString();
                        }
                        return "";
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DT_EMISSAO_NOTA)) {
                        if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO)) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return ToolDate.dateToStr((Date)b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEmissao());
                            }
                            return null;
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return ToolDate.dateToStr((Date)b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEmissaoNota());
                        }
                        return null;
                    }
                    if (b != null && this.isEquals(valor, EnumConstCamposTitulo.DT_ENT_SAIDA_NOTA)) {
                        if (this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return ToolDate.dateToStr((Date)b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEntrada());
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return ToolDate.dateToStr((Date)b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEntradaSaida());
                        }
                        return "";
                    }
                    if (b != null && b.getGrupoDeBaixaFormas() != null && this.isEquals(valor, EnumConstCamposTitulo.DATA_BAIXA)) {
                        return ToolDate.dateToStr((Date)b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao());
                    }
                    if (b == null || !this.isEquals(valor, EnumConstCamposTitulo.FAVORECIDO_BAIXA)) {
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_DESCONTO)) {
                            return ToolFormatter.formataNumero((Number)b.getVrDesconto(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_AT_MONETARIA_REC)) {
                            return ToolFormatter.formataNumero((Number)b.getVrAtualizacaoMonetariaRecebida(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_AT_MONETARIA_PAG)) {
                            return ToolFormatter.formataNumero((Number)b.getVrAtualizacaoMonetariaPaga(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_DESPESA_BANC_PAG)) {
                            return ToolFormatter.formataNumero((Number)b.getVrDespBancariaPaga(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_DESPESA_BANC_REC)) {
                            return ToolFormatter.formataNumero((Number)b.getVrDespBancariaRecebida(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_MULTA)) {
                            return ToolFormatter.formataNumero((Number)b.getVrMulta(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_PIS)) {
                            return ToolFormatter.formataNumero((Number)b.getVrPis(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_CONFINS)) {
                            return ToolFormatter.formataNumero((Number)b.getVrConfins(), (int)3);
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.OBSERVACAO_BAIXA)) {
                            return b.getObservacao();
                        }
                        if (b != null && this.isEquals(valor, EnumConstCamposTitulo.VLR_CONT_SOCIAL)) {
                            return ToolFormatter.formataNumero((Number)b.getVrContribSocial(), (int)3);
                        }
                    }
                }
            }
        }
        return "";
    }

    private static String findNumeroNotaTerceiroTitulo(BaixaTitulo b) {
        if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
            return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota().toString();
        }
        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString();
        }
        return "";
    }

    public Double getValorTotalBaixa(BaixaTitulo b) {
        return b.getValor() + b.getVrJuros() + b.getVrMulta() + b.getVrContribSocial() + b.getVrConfins() + this.getValoresPagRec(b) + b.getVrPis() - b.getVrDesconto();
    }

    public Double getValoresPagRec(BaixaTitulo b) {
        Double valorTotal = 0.0;
        valorTotal = this.isEquals(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue()) ? Double.valueOf(valorTotal + (b.getVrDespBancariaPaga() - b.getVrDespBancariaRecebida() + b.getVrAtualizacaoMonetariaPaga() - b.getVrAtualizacaoMonetariaRecebida())) : Double.valueOf(valorTotal + (b.getVrDespBancariaRecebida() - b.getVrDespBancariaPaga() - b.getVrAtualizacaoMonetariaPaga() + b.getVrAtualizacaoMonetariaRecebida()));
        return valorTotal;
    }
}

