/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstHistoricoRecBaixaTitulo;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloAntecipacao
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorAntecipacao(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTituloAntecipacao(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                this.getLancamentoContaAntecipacao(b, contasBaixa, lote, EnumConstTipoTitulo.PAGAMENTO, lancamentos, op);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
            }
        } else {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTituloAntecipacao(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getLancamentoContaAntecipacao(b, contasBaixa, lote, EnumConstTipoTitulo.RECEBIMENTO, lancamentos, op);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            }
        }
    }

    public void getLancamentoContaAntecipacao(BaixaTitulo b, ContasBaixa contasBaixa, LoteContabil lote, EnumConstTipoTitulo pagRec, List<Lancamento> lancamentos, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancBaixaTituloAntecipacao.newLancamento(lote, b.getTitulo().getEmpresa());
        PlanoConta pc = contasBaixa != null && contasBaixa.getPlanoContaAntecipacao() != null ? contasBaixa.getPlanoContaAntecipacao() : (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO) ? opcoesContabeisBaixaTitulos.getPlanoContaBaixaAntPag() : opcoesContabeisBaixaTitulos.getPlanoContaBaixaAntRec());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            lancamento.setPlanoContaCred(pc);
        } else {
            lancamento.setPlanoContaDeb(pc);
        }
        lancamento.setValor(this.getValorOperacao(b));
        lancamento.setHistorico("Valor baixado por antecipacao referente ao titulo nr " + b.getTitulo().getIdentificador() + ". " + this.getOrigemTitulo(b.getTitulo()));
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            lancamentos.add(lancamento);
        } else if (this.getValidCheck().isCheckItem("V.ERP.0650.126", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.126", new Object[]{b.getTitulo(), opcoesContabeisBaixaTitulos});
        }
    }

    public void getLancamentoTituloAntecipacao(BaixaTitulo b, LoteContabil lote, EnumConstTipoTitulo pagRec, OpcoesContabeisBaixaTitulos op, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        Lancamento l = CompLancBaixaTituloAntecipacao.newLancamento(lote, b.getTitulo().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            l.setPlanoContaDeb(b.getTitulo().getPlanoConta());
            if (op != null && op.getHistDevValorBaixa() != null) {
                l.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
            } else {
                l.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            }
        } else {
            l.setPlanoContaCred(b.getTitulo().getPlanoConta());
            if (op != null && op.getHistCredValorBaixa() != null) {
                l.setHistorico(this.completarHistoricoPadrao(b, op.getHistCredValorBaixa()));
            } else {
                l.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            }
        }
        l.setValor(Double.valueOf(b.getValor() - b.getTitulo().getValorMultaEmbutida() - b.getTitulo().getValorJurosEmbutido()));
        if (l.getPlanoContaCred() != null || l.getPlanoContaDeb() != null) {
            lancamentos.add(l);
        } else if (this.getValidCheck().isCheckItem("V.ERP.0650.125", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.125", new Object[]{b.getTitulo(), op});
        }
    }
}

