/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloBorderoTitulos
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorBorderoTitulos(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        Double valorTotal = 0.0;
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                valorTotal = valorTotal + this.getValorOperacao(b);
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
            }
            this.getLancamentoTotalizadorBordero(lote, vo, EnumConstTipoTitulo.PAGAMENTO, valorTotal, lancamentos);
        } else {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                valorTotal = valorTotal + this.getValorOperacao(b);
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            }
            this.getLancamentoTotalizadorBordero(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, valorTotal, lancamentos);
        }
    }

    public void getLancamentoTotalizadorBordero(LoteContabil lote, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec, Double valorTotal, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        if (valorTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloBorderoTitulos.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
            if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
                lancamento.setPlanoContaCred(vo.getBorderoTitulos().getCarteiraCobranca().getContaValor().getPlanoConta());
            } else {
                lancamento.setPlanoContaDeb(vo.getBorderoTitulos().getCarteiraCobranca().getContaValor().getPlanoConta());
            }
            lancamento.setValor(valorTotal);
            lancamento.setHistorico("Bordero de Titulos nr " + vo.getBorderoTitulos().getIdentificador().toString());
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.130", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.130", new Object[]{vo.getBorderoTitulos().getCarteiraCobranca()});
            }
        }
    }
}

