/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloCartao
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentoPorCartao(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, OpcoesContabeis op, Empresa empresa) throws ExceptionBase {
        if (this.isEquals(vo.getAgrupamento(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isEquals(op.getNaoAgruparLancamentoBaixaTitulo(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.getLancamentosPorCartaoNaoAgrupados(vo, lote, lancamentos, empresa);
        } else {
            this.getLancamentosPorCartaoAgrupados(vo, lote, lancamentos, empresa);
        }
    }

    public void getLancamentosPorCartaoAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        Double valorTotal = 0.0;
        for (BaixaTitulo baixa : vo.getBaixaTitulo()) {
            PlanoConta planoConta;
            OpcoesContabeisBaixaTitulos op;
            ContasBaixa contasBaixa;
            if (vo.getGrupoDeBaixa().getPagRec().equals(EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                valorTotal = valorTotal + this.getValorOperacao(baixa);
                contasBaixa = baixa.getContasBaixa();
                op = this.getOpcoesContabeisBaixaTitulos(baixa, empresa);
                this.getLancamentoTitulo(baixa, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                planoConta = vo.getFormaPagamentoCartao().getPlanoConta();
                this.getOutrosLancamentos(baixa, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                this.getLancamentoTotalizadorCartaoAgrupado(lote, vo, EnumConstTipoTitulo.PAGAMENTO, valorTotal, lancamentos);
                continue;
            }
            valorTotal = valorTotal + this.getValorOperacao(baixa);
            contasBaixa = baixa.getContasBaixa();
            op = this.getOpcoesContabeisBaixaTitulos(baixa, empresa);
            this.getLancamentoTitulo(baixa, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
            planoConta = vo.getFormaPagamentoCartao().getPlanoConta();
            this.getOutrosLancamentos(baixa, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            this.getLancamentoTotalizadorCartaoAgrupado(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, valorTotal, lancamentos);
        }
    }

    public void getLancamentoTotalizadorCartaoAgrupado(LoteContabil lote, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec, Double vrTotal, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        if (vrTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloCartao.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
            if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
                lancamento.setPlanoContaCred(vo.getFormaPagamentoCartao().getPlanoConta());
            } else {
                lancamento.setPlanoContaDeb(vo.getFormaPagamentoCartao().getPlanoConta());
            }
            lancamento.setHistorico("Forma Pagamento: " + vo.getFormaPagamentoCartao().getDescricao());
            lancamento.setValor(vrTotal);
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.127", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.127", new Object[]{vo.getFormaPagamento()});
            }
        }
    }

    private void getLancamentosPorCartaoNaoAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        for (BaixaTitulo baixa : vo.getBaixaTitulo()) {
            PlanoConta planoConta;
            OpcoesContabeisBaixaTitulos op;
            ContasBaixa contasBaixas;
            if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
                contasBaixas = baixa.getContasBaixa();
                op = this.getOpcoesContabeisBaixaTitulos(baixa, empresa);
                this.getLancamentoTotalizadorCartaoNaoAgrupado(vo, baixa, lote, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                this.getLancamentoTitulo(baixa, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                planoConta = vo.getFormaPagamentoCartao().getPlanoConta();
                this.getOutrosLancamentos(baixa, lote, contasBaixas, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                continue;
            }
            contasBaixas = baixa.getContasBaixa();
            op = this.getOpcoesContabeisBaixaTitulos(baixa, empresa);
            this.getLancamentoTotalizadorCartaoNaoAgrupado(vo, baixa, lote, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            this.getLancamentoTitulo(baixa, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
            planoConta = vo.getFormaPagamentoCartao().getPlanoConta();
            this.getOutrosLancamentos(baixa, lote, contasBaixas, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
        }
    }

    public void getLancamentoTotalizadorCartaoNaoAgrupado(GrupoDeBaixaFormas vo, BaixaTitulo baixa, LoteContabil lote, EnumConstTipoTitulo pagRec, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        Double vrTotal = this.getValorOperacao(baixa);
        if (vrTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloCartao.newLancamento(lote, baixa.getTitulo().getEmpresa());
            if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
                lancamento.setPlanoContaCred(vo.getFormaPagamentoCartao().getPlanoConta());
            } else {
                lancamento.setPlanoContaDeb(vo.getFormaPagamentoCartao().getPlanoConta());
            }
            lancamento.setHistorico("Forma de Pagamento: " + vo.getFormaPagamentoCartao().getDescricao());
            lancamento.setValor(vrTotal);
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.127", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.127", new Object[]{baixa.getTitulo()});
            }
        }
    }
}

