/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloCheque
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorCheque(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, OpcoesContabeis op, Empresa empresa) throws ExceptionBase {
        if (this.isEquals(vo.getAgrupamento(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isEquals(op.getNaoAgruparLancamentoBaixaTitulo(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.getLancamentosPorChequeNaoAgrupados(vo, lote, lancamentos, empresa);
        } else {
            this.getLancamentosPorChequeAgrupados(vo, lote, lancamentos, empresa);
        }
    }

    private void getLancamentosPorChequeAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        if (vo.getGrupoDeBaixa().getPagRec().shortValue() == EnumConstTipoTitulo.PAGAMENTO.getValue()) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar()) || !this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) continue;
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                PlanoConta planoConta = vo.getContaValor().getPcChequeTransito() == null ? vo.getContaValor().getPlanoConta() : vo.getContaValor().getPcChequeTransito();
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                this.getLancamentoTotalizadorChequeAgrupado(lote, vo, EnumConstTipoTitulo.PAGAMENTO, this.getValorOperacao(b), lancamentos);
            }
        }
    }

    private void getLancamentosPorChequeNaoAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar()) || vo.getContaValor() == null || !this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) continue;
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTotalizadorChequeNaoAgrupado(vo, b, lote, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                PlanoConta planoConta = vo.getContaValor().getPcChequeTransito() == null ? vo.getContaValor().getPlanoConta() : vo.getContaValor().getPcChequeTransito();
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
            }
        }
    }

    public void getLancamentoTotalizadorChequeNaoAgrupado(GrupoDeBaixaFormas vo, BaixaTitulo b, LoteContabil lote, EnumConstTipoTitulo pagRec, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        Double vrTotal = this.getValorOperacao(b);
        if (vrTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloCheque.newLancamento(lote, b.getTitulo().getEmpresa());
            this.setPlanoConta(lancamento, vo, pagRec);
            lancamento.setHistorico("Vr cheque nr. " + b.getCheque().getNumero());
            lancamento.setValor(vrTotal);
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.129", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.129", new Object[]{b.getTitulo()});
            }
        }
    }

    public void setPlanoConta(Lancamento lancamento, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec) {
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            if (vo.getContaValor().getPcChequeTransito() == null) {
                lancamento.setPlanoContaCred(vo.getContaValor().getPlanoConta());
            } else {
                lancamento.setPlanoContaCred(vo.getContaValor().getPcChequeTransito());
            }
        } else if (vo.getContaValor().getPcChequeTransito() == null) {
            lancamento.setPlanoContaDeb(vo.getContaValor().getPlanoConta());
        } else {
            lancamento.setPlanoContaDeb(vo.getContaValor().getPcChequeTransito());
        }
    }

    public void getLancamentoTotalizadorChequeAgrupado(LoteContabil lote, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec, Double vrTotal, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        if (vrTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloCheque.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
            this.setPlanoConta(lancamento, vo, pagRec);
            Cheque cheque = null;
            Iterator iterator = vo.getBaixaTitulo().iterator();
            if (iterator.hasNext()) {
                BaixaTitulo b = (BaixaTitulo)iterator.next();
                cheque = b.getCheque();
            }
            lancamento.setHistorico("Vr cheque nr. " + String.valueOf(cheque != null ? cheque.getNumero() : "NI"));
            lancamento.setValor(vrTotal);
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.129", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.129", new Object[]{cheque});
            }
        }
    }
}

