/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloChequeTerc
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorChequeTerceiros(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        Double valorBaixas = 0.0;
        Double valorCheques = 0.0;
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (ChequeTerceiros c : vo.getChequeTerceirosPag()) {
                valorCheques = valorCheques + c.getValor();
                this.getLancamentoTotalizadorChequeTerceiros(vo, lote, EnumConstTipoTitulo.PAGAMENTO, c, lancamentos);
            }
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar()) || !this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) continue;
                valorBaixas = valorBaixas + b.getTotalOperacao();
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
            }
            valorBaixas = this.arrredondarNumero(valorBaixas, 2);
            Double valorTroco = (valorCheques = Double.valueOf(this.arrredondarNumero(valorCheques, 2))) - valorBaixas;
            if (valorTroco > 0.0 && this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) {
                this.getLancamentoTrocoCheque(lote, EnumConstTipoTitulo.PAGAMENTO, lancamentos, valorTroco, vo);
            }
        } else {
            for (ChequeTerceiros c : vo.getChequeTerceirosRec()) {
                valorCheques = valorCheques + c.getValor();
                this.getLancamentoTotalizadorChequeTerceiros(vo, lote, EnumConstTipoTitulo.RECEBIMENTO, c, lancamentos);
            }
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar()) || !this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) continue;
                valorBaixas = valorBaixas + b.getTotalOperacao();
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            }
            valorBaixas = this.arrredondarNumero(valorBaixas, 2);
            Double valorTroco = (valorCheques = Double.valueOf(this.arrredondarNumero(valorCheques, 2))) - valorBaixas;
            if (valorTroco > 0.0 && this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) {
                this.getLancamentoTrocoCheque(lote, EnumConstTipoTitulo.RECEBIMENTO, lancamentos, valorTroco, vo);
            }
        }
    }

    public void getLancamentoTotalizadorChequeTerceiros(GrupoDeBaixaFormas vo, LoteContabil lote, EnumConstTipoTitulo pagRec, ChequeTerceiros c, List<Lancamento> lancamentos) throws ExceptionInvalidState {
        Lancamento lancamento = CompLancBaixaTituloChequeTerc.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            lancamento.setPlanoContaCred(vo.getContaValor().getPlanoConta());
        } else {
            lancamento.setPlanoContaDeb(vo.getContaValor().getPlanoConta());
        }
        lancamento.setValor(c.getValor());
        lancamento.setHistorico("Cheques de Terceiros referentes a baixa " + vo.getGrupoDeBaixa().getIdentificador().toString());
        if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
            lancamentos.add(lancamento);
        } else if (this.getValidCheck().isCheckItem("V.ERP.0650.131", EnumValidacaoTipo.VALIDAR)) {
            throw new ExceptionInvalidState("V.ERP.0650.131", new Object[]{c});
        }
    }

    public void getLancamentoTrocoCheque(LoteContabil lote, EnumConstTipoTitulo pagRec, List<Lancamento> lancamentos, Double valorTroco, GrupoDeBaixaFormas vo) {
        Lancamento l = CompLancBaixaTituloChequeTerc.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
        l.setValor(valorTroco);
        if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
            l.setPlanoContaDeb(vo.getContaValorTroco().getPlanoConta());
        } else {
            l.setPlanoContaCred(vo.getContaValorTroco().getPlanoConta());
        }
        if (l.getPlanoContaCred() != null || l.getPlanoContaDeb() != null) {
            lancamentos.add(l);
        }
        l.setHistorico("Troco referentes a baixa " + vo.getGrupoDeBaixa().getIdentificador().toString());
    }
}

