/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstHistoricoRecBaixaTitulo;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloCompensacao
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentoPorCompensacao(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        if (!this.validAndThrowContasDif(vo).booleanValue()) {
            return;
        }
        for (BaixaTitulo b : vo.getBaixaTitulo()) {
            ContasBaixa contasBaixa = b.getContasBaixa();
            OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
            Object lancamento = null;
            PlanoConta pcBaixaTit = b.getTitulo().getPlanoConta();
            PlanoConta pcTitulosComp = this.getPlanoContaCompensacao(vo.getGrupoBaixaCompensacao());
            if (this.isEquals(EnumConstTipoTitulo.PAGAMENTO.getValue(), vo.getGrupoDeBaixa().getPagRec())) {
                this.lancamentoPagValoresEmbutidos(lancamentos, pcBaixaTit, vo, b, op, lote);
                this.lancamentoPagTotalizadorBaixa(lancamentos, pcTitulosComp, vo, b, op, lote);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                continue;
            }
            this.lancamentoRecValoresEmbutidos(lancamentos, vo, b, op, pcBaixaTit, lote);
            this.lancamentoRecTotalizadorBaixa(lancamentos, vo, b, op, pcTitulosComp, lote);
            this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
        }
    }

    public void lancamentoPagValoresEmbutidos(List<Lancamento> lancamentos, PlanoConta pcBaixaTit, GrupoDeBaixaFormas vo, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, LoteContabil lote) {
        Lancamento lancamento;
        Optional<Lancamento> found = lancamentos.stream().filter(i -> Objects.equals(i.getPlanoContaDeb(), pcBaixaTit) && Objects.equals(i.getCentroResultadoContFin(), b.getTitulo().getEmpresa().getEmpresaDados().getCentroResultadoContFin())).findFirst();
        if (!found.isPresent()) {
            lancamento = CompLancBaixaTituloCompensacao.newLancamento(lote, b.getTitulo().getEmpresa());
            lancamento.setPlanoContaDeb(pcBaixaTit);
            lancamento.setValor(Double.valueOf(b.getValor() - b.getVrMultaEmbutido() - b.getVrJurosEmbutido() + b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido()));
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            lancamentos.add(lancamento);
        } else {
            lancamento = found.get();
            lancamento.setValor(Double.valueOf(lancamento.getValor() + (b.getValor() - b.getVrMultaEmbutido() - b.getVrJurosEmbutido() + b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido())));
        }
        if (op != null && op.getHistDevValorBaixa() != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COMPENSACAO, b));
        }
    }

    public void lancamentoPagTotalizadorBaixa(List<Lancamento> lancamentos, PlanoConta pcTitulosComp, GrupoDeBaixaFormas vo, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, LoteContabil lote) {
        Lancamento lancamento;
        Optional<Lancamento> found2 = lancamentos.stream().filter(i -> Objects.equals(i.getPlanoContaCred(), pcTitulosComp) && Objects.equals(i.getCentroResultadoContFin(), b.getTitulo().getEmpresa().getEmpresaDados().getCentroResultadoContFin())).findFirst();
        if (!found2.isPresent()) {
            lancamento = CompLancBaixaTituloCompensacao.newLancamento(lote, b.getTitulo().getEmpresa());
            lancamento.setPlanoContaCred(pcTitulosComp);
            lancamento.setValor(this.getValorOperacao(b));
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.PAGAMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            lancamentos.add(lancamento);
        } else {
            lancamento = found2.get();
            lancamento.setValor(Double.valueOf(lancamento.getValor() + this.getValorOperacao(b)));
        }
        if (op != null && op.getHistDevValorBaixa() != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COMPENSACAO, b));
        }
    }

    public void lancamentoRecValoresEmbutidos(List<Lancamento> lancamentos, GrupoDeBaixaFormas vo, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, PlanoConta pcBaixaTit, LoteContabil lote) {
        Lancamento lancamento;
        Optional<Lancamento> found = lancamentos.stream().filter(i -> Objects.equals(i.getPlanoContaCred(), pcBaixaTit) && Objects.equals(i.getCentroResultadoContFin(), b.getTitulo().getEmpresa().getEmpresaDados().getCentroResultadoContFin())).findFirst();
        if (!found.isPresent()) {
            lancamento = CompLancBaixaTituloCompensacao.newLancamento(lote, b.getTitulo().getEmpresa());
            lancamento.setPlanoContaCred(pcBaixaTit);
            lancamento.setValor(Double.valueOf(b.getValor() - b.getVrMultaEmbutido() - b.getVrJurosEmbutido() + b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido()));
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            lancamentos.add(lancamento);
        } else {
            lancamento = found.get();
            lancamento.setValor(Double.valueOf(lancamento.getValor() + (b.getValor() - b.getVrMultaEmbutido() - b.getVrJurosEmbutido() + b.getValorAdicional() + b.getTitulo().getValorDescontosEmbutido())));
        }
        if (op != null && op.getHistDevValorBaixa() != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COMPENSACAO, b));
        }
    }

    public void lancamentoRecTotalizadorBaixa(List<Lancamento> lancamentos, GrupoDeBaixaFormas vo, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, PlanoConta pcTitulosComp, LoteContabil lote) {
        Lancamento lancamento;
        Optional<Lancamento> found2 = lancamentos.stream().filter(i -> Objects.equals(i.getPlanoContaDeb(), pcTitulosComp) && Objects.equals(i.getCentroResultadoContFin(), b.getTitulo().getEmpresa().getEmpresaDados().getCentroResultadoContFin())).findFirst();
        if (!found2.isPresent()) {
            lancamento = CompLancBaixaTituloCompensacao.newLancamento(lote, b.getTitulo().getEmpresa());
            lancamento.setPlanoContaDeb(pcTitulosComp);
            lancamento.setValor(this.getValorOperacao(b));
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_NORMAL, b));
            lancamentos.add(lancamento);
        } else {
            lancamento = found2.get();
            lancamento.setValor(Double.valueOf(lancamento.getValor() + this.getValorOperacao(b)));
        }
        if (op != null && op.getHistDevValorBaixa() != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistDevValorBaixa()));
        } else {
            lancamento.setHistorico(this.criarHistorico(EnumConstTipoTitulo.RECEBIMENTO, EnumConstHistoricoRecBaixaTitulo.HIST_COMPENSACAO, b));
        }
    }

    public PlanoConta getPlanoContaCompensacao(GrupoDeBaixa grupoBaixaCompensacao) {
        GrupoDeBaixaFormas gf;
        if (TMethods.isWithData((Collection)grupoBaixaCompensacao.getGrupoDeBaixaFormas()) && TMethods.isWithData((Collection)(gf = (GrupoDeBaixaFormas)grupoBaixaCompensacao.getGrupoDeBaixaFormas().get(0)).getBaixaTitulo())) {
            return ((BaixaTitulo)gf.getBaixaTitulo().get(0)).getTitulo().getPlanoConta();
        }
        return null;
    }

    public GrupoDeBaixaFormas getGrupoDeBaixaFormasCompensacao(GrupoDeBaixaFormas vo) {
        if (TMethods.isWithData((Collection)vo.getGrupoBaixaCompensacao().getGrupoDeBaixaFormas())) {
            return (GrupoDeBaixaFormas)vo.getGrupoBaixaCompensacao().getGrupoDeBaixaFormas().get(0);
        }
        return null;
    }

    private Boolean validAndThrowContasDif(GrupoDeBaixaFormas vo) {
        PlanoConta pc = null;
        for (BaixaTitulo baixaTitulo : vo.getBaixaTitulo()) {
            if (pc != null && !this.isEquals(pc, baixaTitulo.getTitulo().getPlanoConta())) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0376.005", new Object[]{vo.getGrupoDeBaixa().getIdentificador()}));
            }
            pc = baixaTitulo.getTitulo().getPlanoConta();
        }
        GrupoDeBaixaFormas gf = this.getGrupoDeBaixaFormasCompensacao(vo);
        PlanoConta pc2 = null;
        if (TMethods.isNotNull((Object)gf).booleanValue()) {
            for (BaixaTitulo baixaTitulo : gf.getBaixaTitulo()) {
                if (pc2 != null && !this.isEquals(pc2, baixaTitulo.getTitulo().getPlanoConta())) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0376.006", new Object[]{vo.getGrupoDeBaixa().getIdentificador()}));
                }
                pc2 = baixaTitulo.getTitulo().getPlanoConta();
            }
        }
        if (this.isEquals(pc, pc2)) {
            return false;
        }
        return true;
    }
}

