/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.opcoes.ExceptionOpBaixaTitulosNaoDefinidas;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloContaValor
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorContaValor(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, OpcoesContabeis op, Empresa empresa) throws ExceptionBase {
        if (vo.getContaValor() != null && vo.getContaValor().getGerarLancamentoContabil() != null && this.isAffimative(vo.getContaValor().getGerarLancamentoContabil())) {
            if (!this.isAffimative(vo.getAgrupamento()) || this.isAffimative(op.getNaoAgruparLancamentoBaixaTitulo())) {
                this.getLancamentosPorContaValorNaoAgrupados(vo, lote, lancamentos, empresa);
            } else {
                this.getLancamentosPorContaValorAgrupados(vo, lote, lancamentos, empresa);
            }
        }
    }

    private void getLancamentosPorContaValorAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        Double valorTotal = 0.0;
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar())) continue;
                valorTotal = valorTotal + this.getValorOperacao(b);
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
            }
            this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.PAGAMENTO, valorTotal, lancamentos, vo.getContaValor().getPlanoConta(), null, null);
        } else {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar())) continue;
                valorTotal = valorTotal + this.getValorOperacao(b);
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
            }
            BaixaTitulo baixa = (BaixaTitulo)vo.getBaixaTitulo().get(0);
            if (this.isEquals(baixa.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca(), EnumConstSituacaoCobranca.DESCONTADA.getCodigo())) {
                this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, valorTotal, lancamentos, baixa.getTitulo().getCarteiraCobranca().getPlanoConta(), null, null);
            } else {
                this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, valorTotal, lancamentos, vo.getContaValor().getPlanoConta(), null, null);
            }
        }
    }

    private void getLancamentosPorContaValorNaoAgrupados(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionOpBaixaTitulosNaoDefinidas, ExceptionInvalidState {
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar())) continue;
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.PAGAMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.PAGAMENTO, lancamentos);
                this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.PAGAMENTO, this.getValorOperacao(b), lancamentos, vo.getContaValor().getPlanoConta(), op, b);
            }
        } else {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                if (!this.isAffimative(b.getTitulo().getContabilizar())) continue;
                ContasBaixa contasBaixa = b.getContasBaixa();
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
                if (this.isEquals(b.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca(), EnumConstSituacaoCobranca.DESCONTADA.getCodigo())) {
                    this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, this.getValorOperacao(b), lancamentos, b.getTitulo().getCarteiraCobranca().getPlanoConta(), op, b);
                    continue;
                }
                this.getLancamentoTotalizadorContaValor(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, this.getValorOperacao(b), lancamentos, vo.getContaValor().getPlanoConta(), op, b);
            }
        }
    }

    public Lancamento getLancamento(LoteContabil lote, BaixaTitulo b, GrupoDeBaixaFormas vo) {
        if (b != null) {
            return CompLancBaixaTituloContaValor.newLancamento(lote, b.getTitulo().getEmpresa());
        }
        return CompLancBaixaTituloContaValor.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
    }

    public void setHistoricoPagamento(Lancamento lancamento, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, GrupoDeBaixaFormas vo) {
        if (op != null && op.getHistFormaPagamento() != null && b != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistFormaPagamento()));
        } else {
            lancamento.setHistorico("Vr pago pela Conta " + vo.getContaValor().toString() + " referente a baixa nr " + vo.getGrupoDeBaixa().getIdentificador().toString() + ". ");
        }
    }

    public void setHistoricoRecebimento(Lancamento lancamento, BaixaTitulo b, OpcoesContabeisBaixaTitulos op, GrupoDeBaixaFormas vo) {
        if (op != null && op.getHistFormaPagamento() != null && b != null) {
            lancamento.setHistorico(this.completarHistoricoPadrao(b, op.getHistFormaPagamento()));
        } else {
            lancamento.setHistorico("Vr recebido pela Conta " + vo.getContaValor().toString() + " referente a baixa nr " + vo.getGrupoDeBaixa().getIdentificador().toString() + ". ");
        }
    }

    public void getLancamentoTotalizadorContaValor(LoteContabil lote, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec, Double vrTotal, List<Lancamento> lancamentos, PlanoConta planoConta, OpcoesContabeisBaixaTitulos op, BaixaTitulo b) throws ExceptionInvalidState {
        if (vrTotal > 0.0) {
            Lancamento lancamento = this.getLancamento(lote, b, vo);
            if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
                lancamento.setPlanoContaCred(planoConta);
                this.setHistoricoPagamento(lancamento, b, op, vo);
            } else {
                lancamento.setPlanoContaDeb(planoConta);
                this.setHistoricoRecebimento(lancamento, b, op, vo);
            }
            lancamento.setValor(vrTotal);
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.128", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.128", new Object[]{b.getTitulo(), op});
            }
        }
    }
}

