/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.lancamentos;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.constants.enums.validacao.EnumValidacaoTipo;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.baixatitulos.CompLancamentoBaseBaixaTitulo;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancBaixaTituloFaltaPag
extends CompLancamentoBaseBaixaTitulo {
    public void getLancamentosPorFaltaPagamento(GrupoDeBaixaFormas vo, LoteContabil lote, List<Lancamento> lancamentos, Empresa empresa) throws ExceptionBase {
        if (this.isEquals(vo.getGrupoDeBaixa().getPagRec(), EnumConstTipoTitulo.RECEBIMENTO.getValue())) {
            for (BaixaTitulo b : vo.getBaixaTitulo()) {
                OpcoesContabeisBaixaTitulos op = this.getOpcoesContabeisBaixaTitulos(b, empresa);
                ContasBaixa contasBaixa = b.getContasBaixa();
                this.getLancamentoTitulo(b, lote, EnumConstTipoTitulo.RECEBIMENTO, op, lancamentos);
                this.getOutrosLancamentos(b, lote, contasBaixa, op, EnumConstTipoTitulo.RECEBIMENTO, lancamentos);
                this.getLancamentoTotalizadorFaltaPagamento(lote, vo, EnumConstTipoTitulo.RECEBIMENTO, this.getValorOperacao(b), lancamentos, op);
            }
        }
    }

    public void getLancamentoTotalizadorFaltaPagamento(LoteContabil lote, GrupoDeBaixaFormas vo, EnumConstTipoTitulo pagRec, Double vrTotal, List<Lancamento> lancamentos, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos) throws ExceptionInvalidState {
        if (vrTotal > 0.0) {
            Lancamento lancamento = CompLancBaixaTituloFaltaPag.newLancamento(lote, vo.getGrupoDeBaixa().getEmpresa());
            if (this.isEquals(pagRec, EnumConstTipoTitulo.PAGAMENTO)) {
                if (vo.getFormaPagamento() != 3) {
                    lancamento.setPlanoContaCred(vo.getContaValor().getPlanoConta());
                } else if (vo.getFormaPagamento() == 3) {
                    lancamento.setPlanoContaCred(opcoesContabeisBaixaTitulos.getPlanoContaFaltaPagamento());
                }
            } else if (vo.getFormaPagamento() != 3) {
                lancamento.setPlanoContaDeb(vo.getContaValor().getPlanoConta());
            } else if (vo.getFormaPagamento() == 3) {
                lancamento.setPlanoContaDeb(opcoesContabeisBaixaTitulos.getPlanoContaFaltaPagamento());
            }
            lancamento.setValor(vrTotal);
            lancamento.setHistorico("Vr referente a falta de pagamento nr " + vo.getGrupoDeBaixa().getIdentificador().toString());
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            } else if (this.getValidCheck().isCheckItem("V.ERP.0650.124", EnumValidacaoTipo.VALIDAR)) {
                throw new ExceptionInvalidState("V.ERP.0650.124", new Object[]{opcoesContabeisBaixaTitulos});
            }
        }
    }
}

