/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.borderochequeterceiros;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.BorderoChequesTerceiros;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoBorderoChequeTerceiros
extends CompLancamentoBase {
    public LoteContabil contabilizar(BorderoChequesTerceiros vo, OpcoesContabeis opContabeis) throws ExceptionInvalidData {
        if (!this.isValidParamsByContabilizacao(vo, opContabeis)) {
            return null;
        }
        if (vo.getCarteiraCobranca() != null && vo.getCarteiraCobranca().getContaValor() != null && vo.getCarteiraOrigem() != null && vo.getCarteiraOrigem().getContaValor() != null && ToolMethods.isEquals((Object)vo.getCarteiraCobranca().getContaValor().getPlanoConta(), (Object)vo.getCarteiraOrigem().getContaValor().getPlanoConta())) {
            return null;
        }
        LoteContabil lote = vo.getLoteContabil();
        if (lote == null) {
            lote = this.criarLoteContabil(lote, vo.getDataBordero(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.BORDERO_FINANCEIRO);
        } else {
            lote.setDataLote(vo.getDataBordero());
            lote.getLancamentos().clear();
        }
        Double valor = 0.0;
        for (BorderoChequeTerceirosMovBancario b : vo.getChequesTerceirosMovBancarios()) {
            valor = valor + b.getMovimentoBancarioCredito().getValor();
        }
        if (valor > 0.0) {
            this.newLancamento(vo.getCarteiraCobranca().getContaValor().getPlanoConta(), vo.getCarteiraOrigem().getContaValor().getPlanoConta(), valor, this.getHistorico(vo), lote, null, vo.getEmpresa());
        }
        if (!ToolMethods.isWithData((Collection)lote.getLancamentos())) {
            return null;
        }
        return lote;
    }

    private String getHistorico(BorderoChequesTerceiros vo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bordero Cheque Terceiros do dia: ");
        sb.append(ToolDate.dateToStr((Date)vo.getDataBordero()));
        sb.append(". Cheques: ");
        int tamanho = vo.getChequesTerceirosMovBancarios().size();
        int count = 1;
        for (BorderoChequeTerceirosMovBancario b : vo.getChequesTerceirosMovBancarios()) {
            sb.append(b.getChequeTerceiros().getNumero());
            if (count < tamanho) {
                sb.append(",");
            } else {
                sb.append(".");
            }
            ++count;
        }
        return sb.toString();
    }

    private boolean isValidParamsByContabilizacao(BorderoChequesTerceiros vo, OpcoesContabeis opContabeis) {
        InstituicaoValores inst2;
        InstituicaoValores inst1;
        if (ToolMethods.isEquals((Object)opContabeis, null)) {
            return false;
        }
        if (!ToolMethods.isEquals((Object)opContabeis.getContabilizarBorderosCheque(), (Object)1)) {
            return false;
        }
        return !ToolMethods.isEquals((Object)opContabeis.getNaoContabilizarBorderosInternos(), (Object)1) || !ToolMethods.isEquals((Object)(inst1 = vo.getCarteiraOrigem().getContaValor().getAgenciaValor().getInstituicaoValor()), (Object)(inst2 = vo.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor())) || !ToolMethods.isEquals((Object)inst1.getNrBanco(), (Object)"999");
    }
}

