/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.compensacaochequeproprio;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.tipocompesacaocheque.EnumConstTipoCompesacaoCheque;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.GrupoCompensacao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import org.springframework.stereotype.Component;

@Component
public class CompCompensacaoChequeProprio
extends CompLancamentoBase {
    public void criaLoteContabil(GrupoCompensacao c, PlanoConta pc) throws ExceptionInvalidData {
        for (CompensacaoCheque compensacaoCheque : c.getCompensacaoCheques()) {
            if (this.isEquals(compensacaoCheque.getTipoCompensacao(), EnumConstTipoCompesacaoCheque.PRESCRITO.getValue())) {
                this.criaLoteContabilPrescrito(compensacaoCheque, pc);
                continue;
            }
            if (!this.isEquals(compensacaoCheque.getTipoCompensacao(), EnumConstTipoCompesacaoCheque.NORMAL.getValue())) continue;
            this.criaLoteContabilNormal(compensacaoCheque);
        }
    }

    private void criaLoteContabilPrescrito(CompensacaoCheque c, PlanoConta pc) throws ExceptionInvalidData {
        LoteContabil lote = this.criarLoteContabil(c.getDataCompensacao(), c.getGrupoCompensacao().getEmpresa(), ConstEnumOrigemLoteContabil.MOVIMENTO_BANCARIO);
        this.criaLancamentoPrescrito(c, pc, lote);
        c.setLoteContabil(lote);
    }

    private void criaLoteContabilNormal(CompensacaoCheque c) throws ExceptionInvalidData {
        LoteContabil lote = this.criarLoteContabil(c.getLoteContabil(), c.getDataCompensacao(), c.getCheque().getEmpresa(), ConstEnumOrigemLoteContabil.COMPENSACAO_CHEQUES);
        this.criaLancamentoNormal(c, lote);
        c.setLoteContabil(lote);
    }

    private void criaLancamentoPrescrito(CompensacaoCheque c, PlanoConta pc, LoteContabil lote) throws ExceptionInvalidData {
        Lancamento lanc = this.newLancamento(c.getCheque().getConta().getPcChequeTransito(), pc, c.getCheque().getValor(), c.getGrupoCompensacao().getDescricaoHistorico(), c.getGrupoCompensacao().getHistorico(), c.getGrupoCompensacao().getEmpresa());
        this.addLancamentoLote(lote, lanc, c.getGrupoCompensacao().getEmpresa());
    }

    private void criaLancamentoNormal(CompensacaoCheque c, LoteContabil lote) throws ExceptionInvalidData {
        PlanoConta pc = c.getCheque().getConta().getPcChequeTransito() != null ? c.getCheque().getConta().getPcChequeTransito() : c.getCheque().getConta().getPlanoConta();
        this.newLancamento(pc, c.getCheque().getConta().getPlanoConta(), c.getCheque().getValor(), MessagesBaseMentor.getMsg((String)"M.ERP.0326.001", (Object[])new Object[0]) + c.getCheque().getNumero(), lote, null, c.getGrupoCompensacao().getEmpresa());
    }
}

