/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.integracaocomunicadoprod.ConstEnumIntegracaoComunicadoProd;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.paramhistoricolancctb.EnumConstParamHistLancCtb;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdRateio;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoConta;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoContaCel;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao.CompLancComProducao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao.CompLancComProducaoRequisao;
import com.touchcomp.basementorvalidator.entities.impl.integracaocomunicadoproducao.ValidIntegracaoComunicadoProducao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompIntegComProducao
extends CompLancamentoBase {
    @Autowired
    CompLancComProducao compLancComProducao;
    @Autowired
    CompLancComProducaoRequisao compLancComProducaoReq;

    public IntegracaoComunicadoProducao gerarLancamentosContabeisComunicadoProducao(IntegracaoComunicadoProducao integracao, OpcoesContabeis opcoesContabeis, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParamReq) throws ExceptionInvalidData, ExceptionReflection {
        validInteg.isValidData((InterfaceVO)integracao);
        if (validInteg.hasErrors()) {
            return integracao;
        }
        this.gerarLancamentosContabeisComunicadoProducao(integracao, opcoesContabeis);
        if (opcoesContabeis.getOpcoesContabeisComProdReq() != null && this.isEquals(opcoesContabeis.getOpcoesContabeisComProdReq().getTipoIntegracaCom(), (short)1)) {
            this.compLancComProducaoReq.getLancamentosComunicadoProducao(integracao, opcoesContabeis, cache, validInteg, cacheParamReq);
        } else {
            this.compLancComProducao.getLancamentosComunicadoProducao(integracao, opcoesContabeis, cache, validInteg, cacheParamReq);
        }
        return integracao;
    }

    private void gerarLancamentosContabeisComunicadoProducao(IntegracaoComunicadoProducao integracao, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionReflection {
        if (!this.isEquals(integracao.getTipoIntegracao(), ConstEnumIntegracaoComunicadoProd.INTEGRACAO_ANALISE_CUSTOS.value)) {
            return;
        }
        if (integracao.getAnaliseCustoProducao().getAnaliseCustoProdLog() == null) {
            throw new ExceptionInvalidData("E.ERP.0940.003", new Object[0]);
        }
        LoteContabil lote = integracao.getLoteTransferenciaCustos();
        lote = this.criarLoteContabil(lote, integracao.getDataInicial(), integracao.getEmpresa(), ConstEnumOrigemLoteContabil.INTEG_CUSTO_PROD_VEND_DATA);
        this.adicionarLancAnaliseCusto(lote, integracao, opcoesContabeis);
        this.adicionarLancAnaliseCustoPorCelula(lote, integracao, opcoesContabeis);
        integracao.setLoteTransferenciaCustos(lote);
    }

    private void adicionarLancAnaliseCusto(LoteContabil lote, IntegracaoComunicadoProducao integracao, OpcoesContabeis op) throws ExceptionReflection, ExceptionReflection, ExceptionInvalidData {
        PlanoConta debito = op.getOpcoesContabeisComProdReq().getPcDebitoTrans();
        PlanoConta credito = op.getOpcoesContabeisComProdReq().getPcCreditoTrans();
        for (AnaliseCustoPlanoConta analiseCustoPlanoConta : integracao.getAnaliseCustoProducao().getAnaliseCustoPlanoConta()) {
            PlanoConta tempCredito = credito;
            if (analiseCustoPlanoConta.getPlanoContaTransitoria() != null) {
                tempCredito = analiseCustoPlanoConta.getPlanoContaTransitoria();
            }
            this.gerarLancAnaliseCusto(lote, analiseCustoPlanoConta.getValorConsiderarFinal(), op, analiseCustoPlanoConta.getPlanoConta(), integracao, this.getHistorico(analiseCustoPlanoConta), debito, tempCredito, integracao.getEmpresa());
        }
    }

    private void adicionarLancAnaliseCustoPorCelula(LoteContabil lote, IntegracaoComunicadoProducao integracao, OpcoesContabeis op) throws ExceptionReflection, ExceptionReflection, ExceptionInvalidData {
        PlanoConta debito = op.getOpcoesContabeisComProdReq().getPcDebitoTrans();
        PlanoConta credito = op.getOpcoesContabeisComProdReq().getPcCreditoTrans();
        for (AnaliseCustoCelProdRateio anaCel : integracao.getAnaliseCustoProducao().getAnaliseCustoCelProdRateio()) {
            for (AnaliseCustoPlanoContaCel analiseCustoPlanoConta : anaCel.getPlanosConta()) {
                PlanoConta tempCredito = credito;
                if (analiseCustoPlanoConta.getPlanoContaTransitoria() != null) {
                    tempCredito = analiseCustoPlanoConta.getPlanoContaTransitoria();
                }
                this.gerarLancAnaliseCusto(lote, analiseCustoPlanoConta.getValorConsiderarFinal(), op, analiseCustoPlanoConta.getPlanoConta(), integracao, this.getHistorico(analiseCustoPlanoConta), debito, tempCredito, integracao.getEmpresa());
            }
        }
    }

    private void gerarLancAnaliseCusto(LoteContabil lote, Double valor, OpcoesContabeis op, PlanoConta planoContaOrigem, IntegracaoComunicadoProducao integracao, String historico, PlanoConta debito, PlanoConta credito, Empresa emp) throws ExceptionReflection, ExceptionInvalidData {
        if (credito == null) {
            credito = planoContaOrigem;
        }
        if (valor < 0.0) {
            PlanoConta temp = credito;
            credito = debito;
            debito = temp;
        }
        valor = Math.abs(valor);
        Lancamento lanc = this.newLancamento(debito, credito, valor, historico, null, integracao.getEmpresa());
        this.addLancamentoLote(lote, lanc, emp);
    }

    public String getHistorico(AnaliseCustoPlanoConta analiseCustoPC) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, "HIST.ERP.0940.002", analiseCustoPC);
    }

    public String getHistorico(AnaliseCustoPlanoContaCel analiseCustoPC) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, "HIST.ERP.0940.003", analiseCustoPC);
    }
}

