/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.integracaocomunicadoprod.ConstEnumIntegracaoComunicadoProd;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstOpContabeisTipoContComunicado;
import com.touchcomp.basementor.constants.enums.paramhistoricolancctb.EnumConstParamHistLancCtb;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegComProdItemComunicadoProd;
import com.touchcomp.basementor.model.vo.IntegracaoComProducaoItem;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbcomprod.ServiceParametrizacaoCtbComProdImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.integracaocomunicadoproducao.ValidIntegracaoComunicadoProducao;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.DoubleStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancComProducao
extends CompLancamentoBase {
    @Autowired
    ServiceParametrizacaoCtbComProdImpl serviceParamCtb;

    void getLancamentosComunicadoProducao(IntegracaoComunicadoProducao integracao, OpcoesContabeis op, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParamReq) throws ExceptionInvalidData, ExceptionReflection {
        for (IntegracaoComProducaoItem item : integracao.getItensLotesContabeisDia()) {
            this.getLancamentosComunicadoProducao(item, ToolMethods.isAffirmative((Number)integracao.getGerarLancAnalitico()), integracao.getGerarLancCentroCusto(), integracao.getDataInicial(), integracao.getDataFinal(), op, cache, validInteg, cacheParamReq);
        }
    }

    void getLancamentosComunicadoProducao(IntegracaoComProducaoItem item, Boolean gerarLancAnalitico, Short integrarLancamentoCtb, Date dataInicial, Date dataFinal, OpcoesContabeis op, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParamReq) throws ExceptionInvalidData, ExceptionReflection {
        LinkedList<Lancamento> lanc = new LinkedList<Lancamento>();
        this.getLancamentosComunicadoProducao(lanc, item, op.getOpcoesContabeisComProdReq().getPcDebitoTrans(), item.getIntegracaoComunicadoProd().getEmpresa(), integrarLancamentoCtb, dataInicial, dataFinal, op, cache, validInteg, cacheParamReq);
        if (lanc.isEmpty() && item.getLoteContabil() == null) {
            return;
        }
        LoteContabil lote = item.getLoteContabil();
        lote = this.criarLoteContabil(lote, item.getDataLote(), item.getIntegracaoComunicadoProd().getEmpresa(), ConstEnumOrigemLoteContabil.INTEGRACAO_COM_PRODUCAO_ITEM);
        for (Lancamento lancamento : lanc) {
            this.addLancamentoLote(lote, lancamento, item.getIntegracaoComunicadoProd().getEmpresa());
        }
        if (!gerarLancAnalitico.booleanValue()) {
            this.aglutinarLancamentos(lote);
        }
        item.setLoteContabil(lote);
    }

    private void getLancamentosComunicadoProducao(List<Lancamento> lancamentos, IntegracaoComProducaoItem item, PlanoConta pcTransitoria, Empresa empresa, Short integrarLancamentoCtb, Date dataInicial, Date dataFinal, OpcoesContabeis opcoesContabeis, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParamReq) throws ExceptionInvalidData, ExceptionReflection {
        for (IntegComProdItemComunicadoProd vo : item.getComunicadosProducao()) {
            if (vo.getComunicadoProducao() == null) continue;
            for (ItemComunicadoProducao itemComunicado : vo.getComunicadoProducao().getItemComunicadoProducao()) {
                this.getLancamentosComunicadoProducao(lancamentos, item, itemComunicado, pcTransitoria, empresa, integrarLancamentoCtb, dataInicial, dataFinal, opcoesContabeis, cache, validInteg, cacheParamReq);
            }
        }
    }

    private void getLancamentosComunicadoProducao(List<Lancamento> lancamentos, IntegracaoComProducaoItem item, ItemComunicadoProducao itemComunicado, PlanoConta pcTransitoria, Empresa empresa, Short integrarLancamentoCtb, Date dataInicial, Date dataFinal, OpcoesContabeis opcoesContabeis, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParamReq) throws ExceptionInvalidData, ExceptionReflection {
        if (!this.isContabilizar(itemComunicado, dataInicial, dataFinal, opcoesContabeis)) {
            return;
        }
        ParametrizacaoCtbComProd param = this.getParametrizacaoCtbCom(empresa.getEmpresaDados().getGrupoEmpresa(), itemComunicado, cache);
        if (param == null) {
            validInteg.addError(new ValidMessages.Code("E.ERP.0940.002", new Object[]{itemComunicado.getComunicadoProducao(), itemComunicado.getProduto()}), cache);
            return;
        }
        Double vlrTotalOutrosCustos = this.getValorOutrosCustos(itemComunicado, opcoesContabeis, dataInicial, dataFinal);
        this.gerarLancOutrosCustos(lancamentos, vlrTotalOutrosCustos, itemComunicado, empresa, integrarLancamentoCtb, param);
        this.gerarLancamentosMateriais(lancamentos, item, itemComunicado, empresa, integrarLancamentoCtb, opcoesContabeis, dataInicial, dataFinal, param, validInteg, cacheParamReq);
        if (ToolMethods.isEquals((Object)item.getIntegracaoComunicadoProd().getTipoIntegracao(), (Object)ConstEnumIntegracaoComunicadoProd.INTEGRACAO_ANALISE_CUSTOS.value)) {
            Double valor = TMethods.isEquals((Object)opcoesContabeis.getOpcoesContabeisComProdReq().getTipoContabComunicado(), (Object)EnumConstOpContabeisTipoContComunicado.CONTABILIZAR_CUSTO_ITEM.getValue()) ? this.getValorIntegracaoCustoItem(itemComunicado, dataInicial, dataFinal) : itemComunicado.getValorCustoIndireto();
            if (!ToolMethods.isWithData((Number)valor)) {
                validInteg.addWarn(new ValidMessages.Code("W.ERP.0940.001", new Object[]{itemComunicado.getComunicadoProducao(), itemComunicado.getProduto()}), (Object)item);
            }
            this.gerarLancamentos(lancamentos, valor, pcTransitoria, param.getPlanoConta(), empresa, itemComunicado.getCentroCusto(), integrarLancamentoCtb, super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, "HIST.ERP.0940.005", itemComunicado));
        }
    }

    protected Double getValorIntegracaoCustoItem(ItemComunicadoProducao itemComunicado, Date dataInicial, Date dataFinal) {
        Double valor = 0.0;
        for (ItemComposicaoCusto icc : itemComunicado.getItemComposicaoCusto()) {
            if (!TMethods.isNotNull((Object)icc.getDataReferencia()).booleanValue() || !dataInicial.before(ToolDate.dataUltHora((Date)icc.getDataReferencia())) || !ToolDate.dataUltHora((Date)dataFinal).after(icc.getDataReferencia()) || !(icc.getValorReal() > 0.0)) continue;
            valor = valor + icc.getValorReal();
        }
        return valor;
    }

    protected void gerarLancamentosMateriais(List<Lancamento> lancamentos, IntegracaoComProducaoItem item, ItemComunicadoProducao itemComunicado, Empresa empresa, Short integrarLancamentoCtb, OpcoesContabeis opcoesContabeis, Date dataInicial, Date dataFinal, ParametrizacaoCtbComProd param, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParam) throws ExceptionInvalidData, ExceptionReflection {
        Double valor = 0.0;
        valor = TMethods.isEquals((Object)opcoesContabeis.getOpcoesContabeisComProdReq().getTipoContabComunicado(), (Object)EnumConstOpContabeisTipoContComunicado.CONTABILIZAR_CUSTO_ITEM.getValue()) ? this.getValorIntegracaoCustoItem(itemComunicado, dataInicial, dataFinal) : Double.valueOf(itemComunicado.getValorCustoMatPrima() + itemComunicado.getValorCustoEmProcesso());
        if (!ToolMethods.isWithData((Number)valor)) {
            validInteg.addWarn(new ValidMessages.Code("W.ERP.0940.002", new Object[]{itemComunicado.getComunicadoProducao(), itemComunicado.getProduto()}), (Object)item);
        }
        this.gerarLancamentos(lancamentos, valor, param.getPlanoContaCredito(), param.getPlanoConta(), empresa, itemComunicado.getCentroCusto(), integrarLancamentoCtb, this.getHistorico(itemComunicado));
    }

    private void gerarLancOutrosCustos(List<Lancamento> lancamentos, Double valorOutrosCustos, ItemComunicadoProducao itemComunicado, Empresa empresa, Short integrarLancamentoCtb, ParametrizacaoCtbComProd param) throws ExceptionReflection, ExceptionInvalidData {
        for (ItemComProdOutrosCustos item : itemComunicado.getItensOutrosCustos()) {
            PlanoConta pcCred = null;
            if (item.getGradeItemNFTerceirosOrigem() != null) {
                pcCred = item.getGradeItemNFTerceirosOrigem().getItemNotaTerceiros().getPlanoContaDeb();
            } else if (item.getGradeItemNFPropriaOrigem() != null) {
                pcCred = item.getGradeItemNFPropriaOrigem().getItemNotaFiscalPropria().getPlanoContaDeb();
            } else if (item.getRpsOrigem() != null) {
                pcCred = item.getGradeItemNFTerceirosOrigem().getItemNotaTerceiros().getPlanoContaDeb();
            }
            if (!(valorOutrosCustos > 0.0)) continue;
            this.gerarLancamentos(lancamentos, valorOutrosCustos, pcCred, param.getPlanoConta(), empresa, itemComunicado.getCentroCusto(), integrarLancamentoCtb, this.getHistoricoOutrosCustos(item));
        }
    }

    private Double getValorOutrosCustos(ItemComunicadoProducao itemComunicado, OpcoesContabeis opcoesContabeis, Date dataInicial, Date dataFinal) {
        if (TMethods.isEquals((Object)opcoesContabeis.getOpcoesContabeisComProdReq().getTipoContabComunicado(), (Object)EnumConstOpContabeisTipoContComunicado.CONTABILIZAR_CUSTO_ITEM.getValue())) {
            Double valorItem = 0.0;
            for (ItemComProdOutrosCustos item : itemComunicado.getItensOutrosCustos()) {
                if (!TMethods.isNotNull((Object)item.getDataReferencia()).booleanValue() || !dataInicial.before(ToolDate.dataUltHora((Date)item.getDataReferencia())) || !ToolDate.dataUltHora((Date)dataFinal).after(item.getDataReferencia()) || !(item.getValor() > 0.0)) continue;
                valorItem = valorItem + item.getValor();
            }
            return valorItem;
        }
        DoubleStream valorItem = itemComunicado.getItensOutrosCustos().stream().mapToDouble(i -> i.getValor());
        return valorItem.sum();
    }

    private void gerarLancamentos(List<Lancamento> lancamentos, Double valor, PlanoConta planoContaCred, PlanoConta planoContaDeb, Empresa empresa, CentroCusto centroCusto, Short integrarLancamentoCtb, String historico) throws ExceptionInvalidData {
        Lancamento l = ToolMethods.isEquals((Object)integrarLancamentoCtb, (Object)1) ? this.newLancamento(planoContaDeb, planoContaCred, valor, historico, null, empresa, centroCusto) : this.newLancamento(planoContaDeb, planoContaCred, valor, historico, null, empresa);
        if (l != null) {
            lancamentos.add(l);
        }
    }

    private boolean isContabilizar(ItemComunicadoProducao itemComunicado, Date dataInicial, Date dataFinal, OpcoesContabeis opcoesContabeis) {
        if (!this.isEquals(itemComunicado.getContabilizavel(), (short)1)) {
            return false;
        }
        if (!this.isEquals(itemComunicado.getCentroEstoque().getTipoEstProprioTerceiros(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) {
            return false;
        }
        boolean encontrou = false;
        if (this.isEquals(opcoesContabeis.getOpcoesContabeisComProdReq().getTipoContabComunicado(), EnumConstOpContabeisTipoContComunicado.CONTABILIZAR_CUSTO_ITEM.getValue())) {
            Double valorCusto = 0.0;
            if (TMethods.isWithData((Collection)itemComunicado.getItemComposicaoCusto())) {
                for (ItemComposicaoCusto item : itemComunicado.getItemComposicaoCusto()) {
                    if (!TMethods.isNotNull((Object)item.getDataReferencia()).booleanValue() || !dataInicial.before(ToolDate.dataUltHora((Date)item.getDataReferencia())) || !ToolDate.dataUltHora((Date)dataFinal).after(item.getDataReferencia())) continue;
                    encontrou = true;
                    valorCusto = valorCusto + item.getValorReal();
                }
            }
            return valorCusto > 0.0 && encontrou;
        }
        return true;
    }

    private ParametrizacaoCtbComProd getParametrizacaoCtbCom(GrupoEmpresa grupoEmpresa, ItemComunicadoProducao itemComunicado, List<ParametrizacaoCtbComProd> cache) {
        return this.serviceParamCtb.findParametrizacao(grupoEmpresa, itemComunicado.getProduto(), cache);
    }

    public String getHistorico(ItemComunicadoProducao item) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, "HIST.ERP.0940.001", item);
    }

    private String getHistoricoOutrosCustos(ItemComProdOutrosCustos item) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_COM_PRODUCAO, "HIST.ERP.0940.004", item);
    }
}

