/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoComProducaoItem;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.comunicadoproducao.CompLancComProducao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.requisicao.CompLancamentoRequisicao;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.integracaocomunicadoproducao.ValidIntegracaoComunicadoProducao;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancComProducaoRequisao
extends CompLancComProducao {
    @Autowired
    CompLancamentoRequisicao compLancRequisicao;

    @Override
    protected void gerarLancamentosMateriais(List<Lancamento> lancamentos, IntegracaoComProducaoItem item, ItemComunicadoProducao itemComunicado, Empresa empresa, Short integrarLancamentoCtb, OpcoesContabeis opcoesContabeis, Date dataInicial, Date dataFinal, ParametrizacaoCtbComProd param, ValidIntegracaoComunicadoProducao validInteg, List<ParametrizacaoCtbRequisicao> cacheParam) throws ExceptionInvalidData, ExceptionReflection {
        for (Requisicao req : itemComunicado.getRequisicoes()) {
            this.gerarLancamentosMateriais(lancamentos, itemComunicado, empresa, integrarLancamentoCtb, req, param, cacheParam, validInteg);
        }
    }

    private void gerarLancamentosMateriais(List<Lancamento> lancamentos, ItemComunicadoProducao itemComunicado, Empresa empresa, Short integrarLancamentoCtb, Requisicao req, ParametrizacaoCtbComProd param, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoComunicadoProducao validInteg) throws ExceptionInvalidData, ExceptionReflection {
        for (ItemRequisicao itemReq : req.getItensRequisicao()) {
            this.gerarLancamentosMateriais(lancamentos, itemComunicado, empresa, integrarLancamentoCtb, req, itemReq, param, cacheParam, validInteg);
        }
    }

    private void gerarLancamentosMateriais(List<Lancamento> lancamentos, ItemComunicadoProducao itemComunicado, Empresa empresa, Short integrarLancamentoCtb, Requisicao req, ItemRequisicao itemReq, ParametrizacaoCtbComProd param, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoComunicadoProducao validInteg) throws ExceptionInvalidData, ExceptionReflection {
        Lancamento l;
        if (!this.compLancRequisicao.isContabilizavel(itemReq)) {
            return;
        }
        ParametrizacaoCtbRequisicao found = this.compLancRequisicao.getParametrizacao(itemReq, empresa, cacheParam, (ValidGenericEntitiesImpl)validInteg);
        if (found == null) {
            validInteg.addError(new ValidMessages.Code("E.ERP.0375.001", new Object[]{empresa, itemReq.getNaturezaRequisicao(), itemReq.getProduto()}), (Object)itemReq.getRequisicao());
            return;
        }
        if (found.getPlanoContaCredito() != null && found.getPlanoConta() != null) {
            lancamentos.addAll(this.compLancRequisicao.buildLancamentosItemReq(found.getPlanoConta(), itemReq, empresa, integrarLancamentoCtb, cacheParam, (ValidGenericEntitiesImpl)validInteg));
        }
        if ((l = this.newLancamento(param.getPlanoConta(), found.getPlanoConta(), this.compLancRequisicao.getValor(itemReq), this.compLancRequisicao.getHistorico(itemReq), null, empresa)) != null) {
            lancamentos.add(l);
        }
    }
}

