/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.depreciacaobem;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaBemDepreciacao;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementor.model.vo.TipoDepreciacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.planocontabemdepreciacao.ServicePlanoContaBemDepreciacaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoDepreciacaoBem
extends CompLancamentoBase {
    @Autowired
    private ServicePlanoContaBemDepreciacaoImpl servicePlanoContaDepreciacao;

    public LoteContabil gerarLancContabilAdicionalDocFinanceiro(DepreciacaoBem depreciacaoBem, Date periodo, OpcoesPatrimonio opcoesPatrimonio) throws ExceptionInvalidData {
        LoteContabil loteContabil = this.criarLoteContabil(depreciacaoBem.getLoteContabil(), periodo, opcoesPatrimonio.getEmpresa(), ConstEnumOrigemLoteContabil.DEPRECIACAO_BEM);
        depreciacaoBem.setLoteContabil(loteContabil);
        Empresa empresa = opcoesPatrimonio.getEmpresa();
        TipoDepreciacao tipoDepreciacao = depreciacaoBem.getBemTipoDepreciacao().getTipoDepreciacao();
        TipoBem tipoBem = depreciacaoBem.getBemTipoDepreciacao().getBem().getTipoBem();
        PlanoContaBemDepreciacao param = this.servicePlanoContaDepreciacao.get(tipoDepreciacao, tipoBem);
        if (param == null) {
            throw new ExceptionInvalidData("E.ERP.0412.004", new Object[]{tipoDepreciacao, tipoBem});
        }
        String historico = "Vr. deprecia\u00e7\u00e3o neste m\u00eas ref. Bem nr. " + depreciacaoBem.getBemTipoDepreciacao().getBem().getIdentificador();
        this.novoLancamento(loteContabil, depreciacaoBem.getValorDepreciacao(), param.getPlanoContaDespesa(), param.getPlanoContaDepreciacao(), historico, empresa);
        historico = "Vr. deprecia\u00e7\u00e3o acelerada neste m\u00eas ref. Bem nr. " + depreciacaoBem.getBemTipoDepreciacao().getBem().getIdentificador();
        this.novoLancamento(loteContabil, depreciacaoBem.getValorDeprecAcelerada(), param.getPlanoContaDespesa(), param.getPlanoContaDeprAcelerada(), historico, empresa);
        if (this.isEquals(depreciacaoBem.getBemTipoDepreciacao().getBem().getBemUsadoPisCofins(), EnumConstantsMentorSimNao.SIM.getValue())) {
            double vrPis = depreciacaoBem.getValorDepreciacao() * (depreciacaoBem.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaPis() / 100.0);
            historico = "Vr. aproveitando credito neste m\u00eas ref. Bem nr. " + depreciacaoBem.getBemTipoDepreciacao().getBem().getIdentificador();
            this.novoLancamento(loteContabil, vrPis, opcoesPatrimonio.getPlanoContaPisDeb(), opcoesPatrimonio.getPlanoContaPisCred(), historico, empresa);
            double vrCofins = depreciacaoBem.getValorDepreciacao() * (depreciacaoBem.getBemTipoDepreciacao().getBem().getBemSpedPisCofins().getAliquotaPis() / 100.0);
            historico = "Vr. aproveitando credito neste m\u00eas ref. Bem nr. " + depreciacaoBem.getBemTipoDepreciacao().getBem().getIdentificador();
            this.novoLancamento(loteContabil, vrCofins, opcoesPatrimonio.getPlanoContaPisDeb(), opcoesPatrimonio.getPlanoContaPisCred(), historico, empresa);
        }
        if (!TMethods.isWithData((Collection)loteContabil.getLancamentos())) {
            return null;
        }
        return loteContabil;
    }

    private void novoLancamento(LoteContabil loteContabil, Double valorDepreciacao, PlanoConta pcDebito, PlanoConta pcCredito, String historico, Empresa empresa) throws ExceptionInvalidData {
        if (!TMethods.isWithData((Number)this.arrredondarNumero(valorDepreciacao))) {
            return;
        }
        Lancamento lancContabil = this.newLancamento(pcDebito, pcCredito, valorDepreciacao, historico, null, empresa);
        this.addLancamentoLote(loteContabil, lancContabil, empresa);
    }

    private void validarPlanosConta(OpcoesPatrimonio opcoesPatrimonio) throws ExceptionInvalidData {
        if (this.isEquals(opcoesPatrimonio.getPlanoContaPisCred(), null)) {
            throw new ExceptionInvalidData("E.ERP.0412.001", new Object[0]);
        }
        if (this.isEquals(opcoesPatrimonio.getPlanoContaPisDeb(), null)) {
            throw new ExceptionInvalidData("E.ERP.0412.002", new Object[0]);
        }
    }
}

