/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.OutrasObrigLivroFiscal;
import com.touchcomp.basementor.model.vo.TipoAjusteICMSDocFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.historicopadrao.CompHistoricoPadrao;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class AuxLancamentosAjustesIcmsDocFiscal {
    private final CompHistoricoPadrao compHistoricoPadrao;

    public AuxLancamentosAjustesIcmsDocFiscal(CompHistoricoPadrao compHistoricoPadrao) {
        this.compHistoricoPadrao = compHistoricoPadrao;
    }

    public List<Lancamento> gerarLancamentosAjustesIcmsDocFiscal(NotaFiscalPropria nota) throws ExceptionReflection, ExceptionInvalidData {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (TMethods.isWithData((Collection)nota.getLivrosFiscais()) && TMethods.isNotNull((Object)nota.getIntegracaoNotaPropriaNotas()).booleanValue()) {
            for (LivroFiscal lf : nota.getLivrosFiscais()) {
                if (!TMethods.isWithData((Collection)lf.getObsLivroFiscal())) continue;
                for (ObservacaoLivroFiscal obsLf : lf.getObsLivroFiscal()) {
                    if (!TMethods.isWithData((Collection)obsLf.getOutrasObrigLivroFiscal())) continue;
                    for (OutrasObrigLivroFiscal outrasObgLf : obsLf.getOutrasObrigLivroFiscal()) {
                        if (!TMethods.isAffirmative((Number)this.gerarLancamentosAjusteIcmsDocFiscal(outrasObgLf, nota.getIntegracaoNotaPropriaNotas().getLoteContabil()))) continue;
                        lancamentos.add(this.buildLancamento(nota, outrasObgLf));
                    }
                }
            }
        }
        return lancamentos;
    }

    private Lancamento buildLancamento(NotaFiscalPropria nota, OutrasObrigLivroFiscal outrasObgLf) throws ExceptionReflection, ExceptionInvalidData {
        Lancamento lanc = CompLancamentoBase.newLancamento(nota.getIntegracaoNotaPropriaNotas().getLoteContabil(), nota.getEmpresa());
        lanc.setPlanoContaCred(outrasObgLf.getTipoAjusteIcmsDocFiscal().getPlanoContaCredito());
        lanc.setPlanoContaDeb(outrasObgLf.getTipoAjusteIcmsDocFiscal().getPlanoContaDebito());
        lanc.setValor(outrasObgLf.getVlrOutros());
        lanc.setHistoricoPadrao(outrasObgLf.getTipoAjusteIcmsDocFiscal().getHistoricoPadrao());
        lanc.setHistorico(this.compHistoricoPadrao.buildHistoricoDinamico(outrasObgLf.getTipoAjusteIcmsDocFiscal().getHistoricoPadrao(), nota));
        return lanc;
    }

    private Short gerarLancamentosAjusteIcmsDocFiscal(OutrasObrigLivroFiscal outrasObgLf, LoteContabil lote) {
        TipoAjusteICMSDocFiscal tipoAjuste = outrasObgLf.getTipoAjusteIcmsDocFiscal();
        if (TMethods.isNotNull((Object)tipoAjuste).booleanValue() && TMethods.isNotNull((Object)outrasObgLf.getVlrOutros()).booleanValue() && outrasObgLf.getVlrOutros() > 0.0 && TMethods.isAffirmative((Number)tipoAjuste.getGerarContabilizacao())) {
            if (TMethods.isWithData((Collection)lote.getLancamentos())) {
                Optional<Lancamento> opt = lote.getLancamentos().stream().filter(i -> TMethods.isEquals((Object)i.getPlanoContaCred(), (Object)tipoAjuste.getPlanoContaCredito()) && TMethods.isEquals((Object)i.getPlanoContaDeb(), (Object)tipoAjuste.getPlanoContaDebito()) && TMethods.isEquals((Object)i.getValor(), (Object)outrasObgLf.getVlrOutros())).findAny();
                return opt.isPresent() ? EnumConstantsMentorSimNao.NAO.getValue() : EnumConstantsMentorSimNao.SIM.getValue();
            }
            return EnumConstantsMentorSimNao.SIM.getValue();
        }
        return EnumConstantsMentorSimNao.NAO.getValue();
    }
}

