/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbModFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.AuxLancamentosAjustesIcmsDocFiscal;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CompLancamentoEntradasFiscais
extends CompLancamentoBase {
    private OpcoesContabeis opcoesContabeis;
    @Autowired
    ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscalImpl;
    @Autowired
    SCompPlanoConta compPlanoConta;

    CompLancamentoEntradasFiscais() {
    }

    public LoteContabil gerarLancamentos(NotaFiscalTerceiros notaFiscalTerceiros, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        this.opcoesContabeis = opcoesContabeis;
        LoteContabil lote = this.contabilizarNota(notaFiscalTerceiros, opcoesContabeis.getIntegrarLancamentoCtb());
        return lote;
    }

    public LoteContabil gerarLancamentos(NotaFiscalPropria notaFiscalPropria, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionReflection {
        this.opcoesContabeis = opcoesContabeis;
        LoteContabil lote = this.contabilizarNota(notaFiscalPropria);
        return lote;
    }

    private LoteContabil contabilizarNota(NotaFiscalPropria nf) throws ExceptionInvalidData, ExceptionReflection {
        LoteContabil lote = null;
        if (nf.getIntegracaoNotaPropriaNotas() != null) {
            lote = nf.getIntegracaoNotaPropriaNotas().getLoteContabil();
        }
        lote = this.criarLoteContabil(lote, nf.getDataEmissaoNota(), nf.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_PROPRIA);
        ClassificacaoClientes classificacao = nf.getClassificacaoCliente();
        CategoriaPessoa categoria = nf.getCategoriaPessoa();
        if (classificacao == null) {
            classificacao = nf.getUnidadeFatCliente().getCliente().getClassificacaoClientes();
        }
        if (categoria == null) {
            categoria = nf.getUnidadeFatCliente().getCategoriaPessoa();
        }
        LinkedList<Lancamento> aux = new LinkedList<Lancamento>();
        aux.addAll(new AuxLancamentosAjustesIcmsDocFiscal(this.compHistoricoPadrao).gerarLancamentosAjustesIcmsDocFiscal(nf));
        for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
            if (!this.isEquals(item.getModeloFiscal().getOpcaoContabilizacao(), (short)1)) continue;
            ParametrizacaoCtbModFiscal parametrizacao = this.serviceParametrizacaoCtbModFiscalImpl.get(item.getModeloFiscal(), nf.getNaturezaOperacao(), item.getProduto().getSubEspecie(), nf.getEmpresa(), categoria, this.opcoesContabeis, nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), classificacao);
            if (parametrizacao == null) {
                throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.0983.001", new Object[]{nf.getNaturezaOperacao(), item.getModeloFiscal(), item.getProduto().getSubEspecie(), nf.getEmpresa(), categoria, nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), item.getNotaFiscalPropria()}));
            }
            ItemNotaLivroFiscal itemLF = item.getItemNotaLivroFiscal();
            Double valorIcms = itemLF.getVrIcms();
            if (this.isEquals(item.getModeloFiscal().getModeloFiscalIcms().getRecuperarTributosIcms(), (short)1)) {
                valorIcms = valorIcms + itemLF.getValorICMSSimples();
            }
            Double valorIss = 0.0;
            if (this.isEquals(item.getIssRetido(), (short)1)) {
                valorIss = itemLF.getVrIss();
            }
            this.contabilizarItemNotaPropria(aux, parametrizacao, item.getModeloFiscal(), item.getProduto(), item.getPlanoContaDeb(), item.getPlanoContaCred(), nf.getUnidadeFatCliente().getCliente().getPessoa(), nf.getNumeroNota().longValue(), nf.getDataEmissaoNota(), this.getDouble(itemLF.getValorTotal()), this.getDouble(valorIcms), this.getDouble(itemLF.getVrPis()), this.getDouble(itemLF.getVrCofins()), this.getDouble(itemLF.getVrIpiIndustria() + itemLF.getVrIpiComercio()), this.getDouble(itemLF.getVrIcmsSt() + itemLF.getVrCustoICMSST()), this.getDouble(valorIss), this.getDouble(itemLF.getVrInss()), this.getDouble(itemLF.getValorRat()), this.getDouble(itemLF.getValorSenar()), this.getDouble(itemLF.getVrInssNaoRetido()), this.getDouble(itemLF.getVrIrrf()), this.getDouble(itemLF.getVrLei10833()), this.getDouble(itemLF.getValorSestSenat()), this.getDouble(itemLF.getVrContSoc()), this.getDouble(itemLF.getVrDifAliquota()), this.getDouble(itemLF.getVrFunrural()), this.getDouble(itemLF.getVrOutros()), this.getDouble(itemLF.getVrPisSt()), this.getDouble(itemLF.getVrCofinsSt()), this.getDouble(this.getValorCustoNFPr(item)), this.getDouble(item.getValorFrete()), this.getDouble(item.getVrSeguro()), this.getDouble(item.getValorDespAcessoria()), nf.getEmpresa());
        }
        this.aglutinaLancamentos(aux);
        for (Lancamento lancamento : aux) {
            this.addLancamentoLote(lote, lancamento, nf.getEmpresa());
        }
        return lote;
    }

    private LoteContabil contabilizarNota(NotaFiscalTerceiros nf, Short integrarLancamentoCtb) throws ExceptionInvalidData {
        LoteContabil lote = null;
        if (nf.getIntegracaoNotaTerceiros() != null) {
            lote = nf.getIntegracaoNotaTerceiros().getLoteContabil();
        }
        lote = this.criarLoteContabil(lote, nf.getDataEntrada(), nf.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_TERCEIROS);
        ClassificacaoClientes classificacao = nf.getClassificacaoPessoas();
        CategoriaPessoa categoria = nf.getCategoriaPessoa();
        if (classificacao == null) {
            classificacao = nf.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa();
        }
        if (categoria == null) {
            categoria = nf.getUnidadeFatFornecedor().getCategoriaPessoa();
        }
        LinkedList<Lancamento> aux = new LinkedList<Lancamento>();
        for (ItemNotaTerceiros item : nf.getItemNotaTerceiros()) {
            if (!this.isEquals(item.getIndicadorTotal(), EnumConstantsMentorSimNao.SIM.getValue()) || !this.isEquals(item.getModeloFiscal().getOpcaoContabilizacao(), (short)1)) continue;
            ParametrizacaoCtbModFiscal parametrizacao = this.serviceParametrizacaoCtbModFiscalImpl.get(item.getModeloFiscal(), item.getNaturezaOperacao(), item.getProduto().getSubEspecie(), nf.getEmpresa(), categoria, this.opcoesContabeis, nf.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf(), classificacao);
            if (parametrizacao == null) {
                throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.0983.001", new Object[]{item.getNaturezaOperacao(), item.getModeloFiscal(), item.getProduto().getSubEspecie(), nf.getEmpresa(), nf.getUnidadeFatFornecedor().getCategoriaPessoa(), nf.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf(), item.getNotaFiscalTerceiros()}));
            }
            ItemNotaLivroFiscal itemLF = item.getItemNotaLivroFiscal();
            Double vrIcms = this.getDouble(itemLF.getVrIcms());
            if (this.isEquals(item.getModeloFiscal().getModeloFiscalIcms().getRecuperarTributosIcms(), (short)1)) {
                vrIcms = vrIcms + itemLF.getValorICMSSimples();
            }
            Double valorIss = 0.0;
            if (this.isEquals(item.getIssRetido(), (short)1)) {
                valorIss = itemLF.getVrIss();
            }
            this.contabilizarItem(aux, parametrizacao, item.getModeloFiscal(), item.getProduto(), item.getPlanoContaDeb(), item.getPlanoContaCred(), nf.getUnidadeFatFornecedor().getFornecedor(), nf.getNumeroNota().longValue(), this.getDouble(itemLF.getValorTotal()), this.getDouble(vrIcms), this.getDouble(itemLF.getVrPis()), this.getDouble(itemLF.getVrCofins()), this.getDouble(itemLF.getVrIpiIndustria() + itemLF.getVrIpiComercio()), this.getDouble(itemLF.getVrIcmsSt() + itemLF.getVrCustoICMSST()), this.getDouble(valorIss), this.getDouble(itemLF.getVrInss()), this.getDouble(itemLF.getValorRat()), this.getDouble(itemLF.getValorSenar()), this.getDouble(itemLF.getVrInssNaoRetido()), this.getDouble(itemLF.getVrIrrf()), this.getDouble(itemLF.getVrLei10833()), this.getDouble(itemLF.getValorSestSenat()), this.getDouble(itemLF.getVrContSoc()), this.getDouble(itemLF.getVrDifAliquota()), this.getDouble(itemLF.getVrFunrural()), this.getDouble(itemLF.getVrOutros()), this.getDouble(itemLF.getVrPisSt()), this.getDouble(itemLF.getVrCofinsSt()), this.getDouble(this.getValorCustoNFTerc(item)), this.getDouble(item.getValorAgregado()), nf.getEmpresa(), item, integrarLancamentoCtb);
        }
        this.aglutinaLancamentos(aux);
        for (Lancamento i : aux) {
            this.addLancamentoLote(lote, i, nf.getEmpresa());
        }
        return lote;
    }

    private void contabilizarItem(List<Lancamento> lancamentos, ParametrizacaoCtbModFiscal parametrizacao, ModeloFiscal modelo, Produto produto, PlanoConta pcDebito, PlanoConta pcCredito, Fornecedor f, Long numeroNota, Double vrTotal, Double vrIcms, Double vrPis, Double vrCofins, Double vrIpi, Double vrIcmsSt, Double vrIss, Double vrInss, Double vrRat, Double vrSenar, Double vrInssNaoRetido, Double vrIrrf, Double vrLei10833, Double vrSestSenat, Double vrContSoc, Double vrDifAliquota, Double vrFunrural, Double vrOutros, Double vrPisST, Double vrCofinsSt, Double valorCusto, Double valorAgregado, Empresa empresa, ItemNotaTerceiros item, Short integrarLancamentoCtb) throws ExceptionInvalidData {
        Lancamento l;
        PlanoConta credito;
        PlanoConta debito;
        Object historico;
        PlanoConta pcProduto = produto.getPlanoConta();
        Pessoa pessoa = f.getPessoa();
        if (!this.isEquals((short)1, parametrizacao.getNaoContabilizarDebCred())) {
            historico = "Valor da Nota Fiscal nr. " + numeroNota + " de " + pessoa.getNome();
            Lancamento l2 = this.newLancamento(pcDebito, pcCredito, vrTotal, (String)historico, null, empresa);
            if (item.getCentroCusto() != null && this.isEquals(integrarLancamentoCtb, (short)1)) {
                l2.getLancamentosCtbCentroCustos().add(new LancamentoCTBCentroCustos(item.getCentroCusto(), vrTotal, l2));
            }
            lancamentos.add(l2);
        }
        if (vrIcms > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "ICMS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsCredor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsCredor(), pcProduto);
            l = this.newLancamento(debito, credito, vrIcms, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrPis > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "PIS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaPisDevedor(), parametrizacao.getRespeitarPlanoContaProdutoPisDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaPisCredor(), parametrizacao.getRespeitarPlanoContaProdutoPisCredor(), pcProduto);
            l = this.newLancamento(debito, credito, vrPis, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrCofins > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "COFINS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsDevedor(), parametrizacao.getRespeitarPlanoContaProdutoCofinsDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsCredor(), parametrizacao.getRespeitarPlanoContaProdutoCofinsCredor(), pcProduto);
            l = this.newLancamento(debito, credito, vrCofins, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrIpi > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "IPI");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIpiDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIpiDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIpiCredor(), parametrizacao.getRespeitarPlanoContaProdutoIpiCredor(), pcProduto);
            l = this.newLancamento(debito, credito, vrIpi, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrIcmsSt > 0.0 && Objects.equals(modelo.getModeloFiscalIcms().getRecuperarTributosIcms(), (short)1)) {
            historico = this.getHistorico(numeroNota, pessoa, "Icms ST");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsStDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStCredor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsStCredor(), pcProduto);
            l = this.newLancamento(debito, credito, vrIcmsSt, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrIss > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Iss");
            PlanoConta pcFornecedor = this.compPlanoConta.getPlanoConta(f, this.opcoesContabeis);
            PlanoConta debito2 = this.getPlanoContaRetido(parametrizacao.getPlanoContaIssDebito(), parametrizacao.getRespeitarPlanoContaProdutoIssDevedor(), pcProduto, pcFornecedor);
            PlanoConta credito2 = this.getPlanoConta(parametrizacao.getPlanoContaIssCredito(), parametrizacao.getRespeitarPlanoContaProdutoIssCredor(), pcProduto);
            Lancamento l3 = this.newLancamento(debito2, credito2, vrIss, (String)historico, null, empresa);
            lancamentos.add(l3);
        }
        if (vrInss > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Inss");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaInss(), parametrizacao.getRespeitarPlanoContaProdutoInss(), pcProduto);
            l = this.newLancamento(debito, credito, vrInss, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrRat > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "RAT");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaRat(), parametrizacao.getRespeitarPlanoContaProdutoRat(), pcProduto);
            l = this.newLancamento(debito, credito, vrRat, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrSenar > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "SENAR");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaRat(), parametrizacao.getRespeitarPlanoContaProdutoSenar(), pcProduto);
            l = this.newLancamento(debito, credito, vrSenar, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrInssNaoRetido > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "INSS nao retido");
            debito = parametrizacao.getPlanoContaInssNaoRetDeb();
            credito = parametrizacao.getPlanoContaInssNaoRetCred();
            if (ToolMethods.isNotNull((Object)debito).booleanValue() || ToolMethods.isNotNull((Object)credito).booleanValue()) {
                l = this.newLancamento(debito, credito, vrInssNaoRetido, (String)historico, null, empresa);
                lancamentos.add(l);
            }
        }
        if (vrIrrf > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "IRRF");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIrrf(), parametrizacao.getRespeitarPlanoContaProdutoIrrf(), pcProduto);
            l = this.newLancamento(debito, credito, vrIrrf, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrLei10833 > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Lei 10833");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaLei10833(), parametrizacao.getRespeitarPlanoContaProdutoLei10833(), pcProduto);
            l = this.newLancamento(debito, credito, vrLei10833, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrSestSenat > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Sest/Senat");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoSestSenat(), parametrizacao.getRespeitarPlanoContaProdutoSestSenat(), pcProduto);
            l = this.newLancamento(debito, credito, vrSestSenat, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrContSoc > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Contribuicao Social");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContSocial(), parametrizacao.getRespeitarPlanoContaProdutoContSocial(), pcProduto);
            l = this.newLancamento(debito, credito, vrContSoc, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrDifAliquota > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Dif. Aliquota");
            debito = pcDebito;
            credito = this.getPlanoConta(parametrizacao.getPlanoDifAliquota(), parametrizacao.getRespeitarPlanoContaProdutoDifAliq(), pcProduto);
            l = this.newLancamento(debito, credito, vrDifAliquota, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrFunrural > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Funrural");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoFunrural(), parametrizacao.getRespeitarPlanoContaProdutoFunrural(), pcProduto);
            l = this.newLancamento(debito, credito, vrFunrural, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrOutros > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Outros");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaOutros(), parametrizacao.getRespeitarPlanoContaProdutoOutros(), pcProduto);
            l = this.newLancamento(debito, credito, vrOutros, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrPisST > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Pis ST");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaPisSt(), parametrizacao.getRespeitarPlanoContaProdutoPisSt(), pcProduto);
            l = this.newLancamento(debito, credito, vrPisST, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (vrCofinsSt > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Cofins ST");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsSt(), parametrizacao.getRespeitarPlanoContaProdutoCofinsSt(), pcProduto);
            l = this.newLancamento(debito, credito, vrCofinsSt, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (valorCusto > 0.0 && parametrizacao.getPlanoContaCredCustoProd() != null && parametrizacao.getPlanoContaDebCustoProd() != null) {
            historico = this.getHistorico(numeroNota, pessoa, "Estorno Custo CPV");
            debito = parametrizacao.getPlanoContaDebCustoProd();
            credito = parametrizacao.getPlanoContaCredCustoProd();
            l = this.newLancamento(debito, credito, valorCusto, (String)historico, null, empresa);
            lancamentos.add(l);
        }
        if (valorAgregado > 0.0 && parametrizacao.getPlanoContaValorAgregadoCredito() != null && parametrizacao.getPlanoContaValorAgregadoDebito() != null) {
            historico = this.getHistorico(numeroNota, pessoa, "Valor Agregado");
            debito = parametrizacao.getPlanoContaValorAgregadoDebito();
            credito = parametrizacao.getPlanoContaValorAgregadoCredito();
            l = this.newLancamento(debito, credito, valorAgregado, (String)historico, null, empresa);
            lancamentos.add(l);
        }
    }

    private PlanoConta getPlanoConta(PlanoConta pcMovimentacao, Short respeitarPCProduto, PlanoConta pcProduto) {
        if (this.isEquals(respeitarPCProduto, (short)1)) {
            return pcProduto;
        }
        if (pcMovimentacao != null) {
            return pcMovimentacao;
        }
        return null;
    }

    private PlanoConta getPlanoContaRetido(PlanoConta pcMovimentacao, Short respeitarPCProduto, PlanoConta pcProduto, PlanoConta pcFornecedor) {
        if (this.isEquals(respeitarPCProduto, (short)1)) {
            return pcProduto;
        }
        if (pcMovimentacao != null) {
            return pcMovimentacao;
        }
        if (pcFornecedor != null) {
            return pcFornecedor;
        }
        return null;
    }

    private String getHistorico(Long numeroNota, Pessoa pessoa, String imposto) {
        String historico = "Valor " + imposto + " sobre Nota Fiscal no. " + numeroNota + " de " + pessoa.getNome();
        return historico;
    }

    private void contabilizarItemNotaPropria(List<Lancamento> lancamentos, ParametrizacaoCtbModFiscal parametrizacao, ModeloFiscal modelo, Produto produto, PlanoConta pcDebito, PlanoConta pcCredito, Pessoa pessoa, Long numeroNota, Date dataEmissao, Double vrTotal, Double vrIcms, Double vrPis, Double vrCofins, Double vrIpi, Double vrIcmsSt, Double vrIss, Double vrInss, Double vrRat, Double vrSenar, Double vrInssNaoRetido, Double vrIrrf, Double vrLei10833, Double vrSestSenat, Double vrContSoc, Double vrDifAliquota, Double vrFunrural, Double vrOutros, Double vrPisST, Double vrCofinsSt, Double valorCusto, Double valorFrete, Double valorSeguro, Double valorDespAcessorias, Empresa empresa) throws ExceptionInvalidData {
        PlanoConta credito;
        PlanoConta debito;
        Object historico;
        PlanoConta pcProduto = produto.getPlanoConta();
        if (!this.isEquals((short)1, parametrizacao.getNaoContabilizarDebCred())) {
            historico = "Valor da Nota Fiscal nr. " + numeroNota + " de " + pessoa.getNome();
            lancamentos.add(this.newLancamento(pcDebito, pcCredito, vrTotal, (String)historico, null, empresa));
        }
        if (vrIcms > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "ICMS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsCredor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrIcms, (String)historico, null, empresa));
        }
        if (vrPis > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "PIS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaPisDevedor(), parametrizacao.getRespeitarPlanoContaProdutoPisDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaPisCredor(), parametrizacao.getRespeitarPlanoContaProdutoPisCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrPis, (String)historico, null, empresa));
        }
        if (vrCofins > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "COFINS");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsDevedor(), parametrizacao.getRespeitarPlanoContaProdutoCofinsDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsCredor(), parametrizacao.getRespeitarPlanoContaProdutoCofinsCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrCofins, (String)historico, null, empresa));
        }
        if (vrIpi > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "IPI");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIpiDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIpiDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIpiCredor(), parametrizacao.getRespeitarPlanoContaProdutoIpiCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrIpi, (String)historico, null, empresa));
        }
        if (vrIcmsSt > 0.0 && Objects.equals(modelo.getModeloFiscalIcms().getRecuperarTributosIcms(), (short)1)) {
            historico = this.getHistorico(numeroNota, pessoa, "Icms ST");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStDevedor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsStDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStCredor(), parametrizacao.getRespeitarPlanoContaProdutoIcmsStCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrIcmsSt, (String)historico, null, empresa));
        }
        if (vrIss > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Iss");
            debito = this.getPlanoConta(parametrizacao.getPlanoContaIssDebito(), parametrizacao.getRespeitarPlanoContaProdutoIssDevedor(), pcProduto);
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIssCredito(), parametrizacao.getRespeitarPlanoContaProdutoIssCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrIss, (String)historico, null, empresa));
        }
        if (vrInss > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Inss");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaInss(), parametrizacao.getRespeitarPlanoContaProdutoInss(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrInss, (String)historico, null, empresa));
        }
        if (vrRat > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Rat");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaRat(), parametrizacao.getRespeitarPlanoContaProdutoRat(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrRat, (String)historico, null, empresa));
        }
        if (vrSenar > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Senar");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaSenar(), parametrizacao.getRespeitarPlanoContaProdutoSenar(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrSenar, (String)historico, null, empresa));
        }
        if (vrInssNaoRetido > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "INSS n\u00c3\u00a3o retido");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaInss(), parametrizacao.getRespeitarPlanoContaProdutoInss(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrInssNaoRetido, (String)historico, null, empresa));
        }
        if (vrIrrf > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "IRRF");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaIrrf(), parametrizacao.getRespeitarPlanoContaProdutoIrrf(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrIrrf, (String)historico, null, empresa));
        }
        if (vrLei10833 > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Lei 10833");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaLei10833(), parametrizacao.getRespeitarPlanoContaProdutoLei10833(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrLei10833, (String)historico, null, empresa));
        }
        if (vrSestSenat > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Sest/Senat");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoSestSenat(), parametrizacao.getRespeitarPlanoContaProdutoSestSenat(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrSestSenat, (String)historico, null, empresa));
        }
        if (vrContSoc > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Contribui\u00c3\u00a7\u00c3\u00a3o Social");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContSocial(), parametrizacao.getRespeitarPlanoContaProdutoContSocial(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrContSoc, (String)historico, null, empresa));
        }
        if (vrDifAliquota > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Dif. Al\u00c3\u00adquota");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoDifAliquota(), parametrizacao.getRespeitarPlanoContaProdutoDifAliq(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrDifAliquota, (String)historico, null, empresa));
        }
        if (vrFunrural > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Funrural");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoFunrural(), parametrizacao.getRespeitarPlanoContaProdutoFunrural(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrFunrural, (String)historico, null, empresa));
        }
        if (vrOutros > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Outros");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaOutros(), parametrizacao.getRespeitarPlanoContaProdutoOutros(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrOutros, (String)historico, null, empresa));
        }
        if (vrPisST > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Pis ST");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaPisSt(), parametrizacao.getRespeitarPlanoContaProdutoPisSt(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrPisST, (String)historico, null, empresa));
        }
        if (vrCofinsSt > 0.0) {
            historico = this.getHistorico(numeroNota, pessoa, "Cofins ST");
            debito = pcCredito;
            credito = this.getPlanoConta(parametrizacao.getPlanoContaCofinsSt(), parametrizacao.getRespeitarPlanoContaProdutoCofinsSt(), pcProduto);
            lancamentos.add(this.newLancamento(debito, credito, vrCofinsSt, (String)historico, null, empresa));
        }
        if (valorCusto > 0.0 && parametrizacao.getPlanoContaCredCustoProd() != null && parametrizacao.getPlanoContaDebCustoProd() != null) {
            historico = this.getHistorico(numeroNota, pessoa, "Estorno Custo CPV");
            debito = parametrizacao.getPlanoContaDebCustoProd();
            credito = parametrizacao.getPlanoContaCredCustoProd();
            lancamentos.add(this.newLancamento(debito, credito, valorCusto, (String)historico, null, empresa));
        }
        if (valorFrete > 0.0 && parametrizacao.getPlanoContaFrete() != null) {
            historico = "Valor do Frete sobre a Nota Fiscal n\u00ba " + numeroNota + " de " + ToolDate.dateToStr((Date)dataEmissao) + " de " + pessoa.getNome();
            lancamentos.add(this.newLancamento(pcDebito, parametrizacao.getPlanoContaFrete(), valorFrete, (String)historico, null, empresa));
        }
        if (valorSeguro > 0.0 && parametrizacao.getPlanoContaSeguro() != null) {
            historico = "Valor do Seguro sobre a Nota Fiscal n\u00ba " + numeroNota + " de " + ToolDate.dateToStr((Date)dataEmissao) + " de " + pessoa.getNome();
            lancamentos.add(this.newLancamento(pcDebito, parametrizacao.getPlanoContaSeguro(), valorSeguro, (String)historico, null, empresa));
        }
        if (valorDespAcessorias > 0.0 && parametrizacao.getPlanoContaDespAcess() != null) {
            historico = "Valor das Despesas Acess\u00f3rias sobre a Nota Fiscal n\u00ba " + numeroNota + " de " + ToolDate.dateToStr((Date)dataEmissao) + " de " + pessoa.getNome();
            lancamentos.add(this.newLancamento(pcDebito, parametrizacao.getPlanoContaDespAcess(), valorDespAcessorias, (String)historico, null, empresa));
        }
    }

    private Double getValorCustoNFTerc(ItemNotaTerceiros item) {
        if (ToolMethods.isWithData((Collection)item.getGrade())) {
            GradeItemNotaTerceiros g = (GradeItemNotaTerceiros)item.getGrade().get(0);
            return g.getValorCusto() * item.getQuantidadeTotal();
        }
        return 0.0;
    }

    private Double getValorCustoNFPr(ItemNotaFiscalPropria item) {
        if (ToolMethods.isWithData((Collection)item.getGradesNotaFiscalPropria())) {
            GradeItemNotaFiscalPropria g = (GradeItemNotaFiscalPropria)item.getGradesNotaFiscalPropria().get(0);
            return g.getValorCusto() * item.getQuantidadeTotal();
        }
        return 0.0;
    }
}

