/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumIntegTipoIntegContabil;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParamContabilNFCe;
import com.touchcomp.basementor.model.vo.ParamContabilNFCePlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.borderochequeterceiros.CompLancamentoBorderoChequeTerceiros;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.movimentofinanceiro.CompLancamentoMovimentoFinanceiro;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.transferenciacontavalor.CompTransferenciaContaValor;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesContabeisImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoImpostosNFCe;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoVendas;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoclientes.ServiceClassificacaoClientesImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.nfcecontrolecaixa.ServiceNFCeControleCaixaImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.paramcontabilnfce.ServiceParamContabilNFCeImpl;
import com.touchcomp.basementorservice.service.impl.paramcontabilnfce.ServiceParamContabilNFCePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoNFCe
extends CompLancamentoBase {
    @Autowired
    ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscalImpl;
    @Autowired
    ServiceNFCeControleCaixaImpl serviceNFCeControleCaixaImpl;
    @Autowired
    ServiceParamContabilNFCePlanoContaImpl serviceParamContabilNFCePlanoContaImpl;
    @Autowired
    ServiceParamContabilNFCeImpl serviceParamContabilNFCeImpl;
    @Autowired
    ServiceMeioPagamentoImpl serviceMeioPagamentoImpl;
    @Autowired
    ServiceCategoriaPessoaImpl serviceCategoriaPessoaImpl;
    @Autowired
    ServiceClassificacaoClientesImpl serviceClassificacaoImpl;
    @Autowired
    ServiceClassificacaoClientesImpl serviceClassificacaoClientesImpl;
    @Autowired
    CompLancamentoMovimentoFinanceiro compLancamentoMovimentoFinanceiro;
    @Autowired
    CompTransferenciaContaValor compTransferenciaContaValor;
    @Autowired
    CompLancamentoBorderoChequeTerceiros compLancamentoBorderoChequeTerceiros;

    public LoteContabil gerarLancamentosAgrupado(OpcoesContabeis op, EmpresaContabilidade empresaContabilidade, List<NFCeControleCaixa> controles, LoteContabil lote) throws ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)op.getNfceContabilizarControleCaixas(), (Object)ConstEnumIntegTipoIntegContabil.NAO_INTEGRAR.getValue()) && lote == null) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1814.003"));
        }
        if (lote != null) {
            lote.getLancamentos().clear();
        }
        NFCeControleCaixa[] dados = controles.toArray(new NFCeControleCaixa[0]);
        lote = this.contabilizarReceitasRecebimentos(lote, op, dados);
        lote = this.contabilizarImpostos(lote, op, dados);
        for (NFCeControleCaixa dado : dados) {
            LoteContabil aux = this.contabilizarInternamenteContCaixa(dado.getLoteContabil(), dado, op, empresaContabilidade);
            dado.setLoteContabil(aux);
        }
        return lote;
    }

    public LoteContabil gerarLancamentos(OpcoesContabeis op, EmpresaContabilidade empresaContabilidade, NFCeControleCaixa controlesCaixa) throws ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)op.getNfceContabilizarControleCaixas(), (Object)ConstEnumIntegTipoIntegContabil.NAO_INTEGRAR.getValue()) && controlesCaixa.getLoteContabil() == null) {
            return null;
        }
        LoteContabil lote = controlesCaixa.getLoteContabil();
        if (lote != null) {
            lote.getLancamentos().clear();
        }
        lote = this.contabilizarReceitasRecebimentos(lote, op, controlesCaixa);
        lote = this.contabilizarImpostos(lote, op, controlesCaixa);
        lote = this.contabilizarInternamenteContCaixa(lote, controlesCaixa, op, empresaContabilidade);
        controlesCaixa.setLoteContabil(lote);
        return lote;
    }

    private LoteContabil contabilizarInternamenteContCaixa(LoteContabil lote, NFCeControleCaixa controlesCaixa, OpcoesContabeis op, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        lote = this.contabilizarDiferencaCaixa(controlesCaixa, lote, op);
        this.contabilizarMovimentoFinanceiroDinheiro(controlesCaixa, empresaContabilidade);
        this.contabilizarMovimentoFinanceiroChequeTerceiros(controlesCaixa, empresaContabilidade);
        this.contabilizarMovimentoFinanceiroDiferencaCaixa(controlesCaixa, empresaContabilidade, lote);
        this.contabilizarTransferenciaContaValor(controlesCaixa, op);
        this.contabilizarBorderoChequeTerceiros(controlesCaixa, op);
        return lote;
    }

    private LoteContabil contabilizarReceitasRecebimentos(LoteContabil lote, OpcoesContabeis op, NFCeControleCaixa ... vo) throws ExceptionInvalidData {
        List<GenericMapValues<GenMapResumoVendas>> valoresNFCe = this.serviceNFCeControleCaixaImpl.getValoresAgrupadosPorMeioPagamentoNFCe(vo);
        List<GenericMapValues<GenMapResumoVendas>> valoresNFe = this.serviceNFCeControleCaixaImpl.getValoresAgrupadosPorMeioPagamentoNFe(vo);
        lote = this.contabilizarRecebimentos(lote, valoresNFCe, "NFCe", op, vo);
        lote = this.contabilizarRecebimentos(lote, valoresNFe, "NFe", op, vo);
        return lote;
    }

    private String getHistoricoLancamento(NFCeControleCaixa vo, String complementoHist) {
        StringBuilder sb = new StringBuilder();
        sb.append("Vr. Vendas ");
        sb.append(complementoHist);
        sb.append(" Caixa: ");
        sb.append(vo.getNfceCaixa().getDescricao());
        sb.append(" Data: ");
        sb.append(ToolDate.dateToStr((Date)vo.getDataFechamento()));
        return sb.toString();
    }

    private String getHistoricoImpostos(NFCeControleCaixa vo, String imposto, String complementoHist) {
        StringBuilder sb = new StringBuilder();
        sb.append("Valor ");
        sb.append(imposto);
        sb.append(" sobre vendas ");
        sb.append(complementoHist);
        sb.append(" em ");
        sb.append(ToolDate.dateToStr((Date)vo.getDataFechamento()));
        sb.append(" Caixa: ");
        sb.append(vo.getNfceCaixa().getDescricao());
        return sb.toString();
    }

    private String buildKeyMeioCatEmpClas(Long idMeioPagamento, Long idCatPessoa, Long idEmpresa, Long idClassificacao) {
        return String.valueOf(idMeioPagamento) + String.valueOf(idCatPessoa) + String.valueOf(idEmpresa) + String.valueOf(idClassificacao);
    }

    private String buildKeyCatEmpClas(Long idCatPessoa, Long idEmpresa, Long idClass) {
        return String.valueOf(idCatPessoa) + String.valueOf(idEmpresa) + String.valueOf(idClass);
    }

    private LoteContabil contabilizarRebimentos(GenericMapValues<GenMapResumoVendas> map, ParamContabilNFCePlanoConta found, LoteContabil lote, NFCeControleCaixa vo, String complementoHist) throws ExceptionInvalidData {
        if (lote == null) {
            lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
        }
        Double valor = map.getDouble(GenMapResumoVendas.VALOR_LIQUIDO);
        this.newLancamento(found.getPlanoConta(), found.getParamContabilNFCe().getPlanoContaReceitaNFCe(), valor, this.getHistoricoLancamento(vo, complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        return lote;
    }

    private LoteContabil contabilizarImpostos(LoteContabil lote, OpcoesContabeis op, NFCeControleCaixa ... controlesCaixa) throws ExceptionInvalidData {
        List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFCe = this.serviceNFCeControleCaixaImpl.getValoresImpostosNFe(controlesCaixa);
        List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFe = this.serviceNFCeControleCaixaImpl.getValoresImpostosNFCe(controlesCaixa);
        lote = this.contabilizarImpostos(lote, valoresNFCe, "NFCe", op, controlesCaixa);
        lote = this.contabilizarImpostos(lote, valoresNFe, "NFe", op, controlesCaixa);
        return lote;
    }

    private LoteContabil contabilizarImpostos(GenericMapValues<GenMapResumoImpostosNFCe> map, ParamContabilNFCe found, LoteContabil lote, NFCeControleCaixa vo, String complementoHist) throws ExceptionInvalidData {
        Double valorIcms = map.getDouble(GenMapResumoImpostosNFCe.VALOR_ICMS);
        Double valorIpi = map.getDouble(GenMapResumoImpostosNFCe.VALOR_IPI);
        Double valorCofins = map.getDouble(GenMapResumoImpostosNFCe.VALOR_COFINS);
        Double valorPis = map.getDouble(GenMapResumoImpostosNFCe.VALOR_PIS);
        Double valorIrrf = map.getDouble(GenMapResumoImpostosNFCe.VALOR_IRRF);
        if (valorIcms > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getIcmsDevedora(), found.getIcmsCredora(), valorIcms, this.getHistoricoImpostos(vo, "ICMS", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorIpi > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getIpiDevedora(), found.getIpiCredora(), valorIpi, this.getHistoricoImpostos(vo, "IPI", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorPis > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getPisDevedora(), found.getPisCredora(), valorPis, this.getHistoricoImpostos(vo, "Pis", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorCofins > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getCofinsDevedora(), found.getCofinsCredora(), valorCofins, this.getHistoricoImpostos(vo, "Cofins", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorIrrf > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getIrrfDevedora(), found.getIrrfCredora(), valorIrrf, this.getHistoricoImpostos(vo, "Irrf", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        return lote;
    }

    private LoteContabil contabilizarRecebimentos(LoteContabil lote, List<GenericMapValues<GenMapResumoVendas>> valoresNFCe, String complementoHist, OpcoesContabeis op, NFCeControleCaixa ... controlesCaixas) throws ExceptionInvalidData {
        for (NFCeControleCaixa vo : controlesCaixas) {
            Empresa empresa = vo.getNfceCaixa().getEmpresa();
            TreeMap<String, ParamContabilNFCePlanoConta> cache = new TreeMap<String, ParamContabilNFCePlanoConta>();
            for (GenericMapValues<GenMapResumoVendas> map : valoresNFCe) {
                Long idMeioPagamento = map.getLong(GenMapResumoVendas.ID_MEIO_PAGAMENTO);
                Long idCatPessoa = map.getLong(GenMapResumoVendas.CATEGORIA_PESSOA);
                Long idClassPessoa = map.getLong(GenMapResumoVendas.CLASSIFICACAO_PESSOA);
                CategoriaPessoa cat = (CategoriaPessoa)this.serviceCategoriaPessoaImpl.get(idCatPessoa);
                ClassificacaoClientes classi = (ClassificacaoClientes)this.serviceClassificacaoClientesImpl.get(idClassPessoa);
                MeioPagamento meio = (MeioPagamento)this.serviceMeioPagamentoImpl.get(idMeioPagamento);
                ParamContabilNFCePlanoConta found = (ParamContabilNFCePlanoConta)cache.get(this.buildKeyMeioCatEmpClas(idMeioPagamento, idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClassPessoa));
                if (found == null) {
                    if (ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isWithData((Number)idClassPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCePlanoContaImpl.getByMeioCatPessoaEmp(meio, cat, empresa, classi);
                    }
                    if (found == null && ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCePlanoContaImpl.getByMeioCatPessoaEmp(meio, cat, empresa);
                    }
                    if (found == null && (!ToolMethods.isWithData((Number)idCatPessoa) || ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)0))) {
                        found = this.serviceParamContabilNFCePlanoContaImpl.getByMeioEmp(meio, empresa);
                    }
                    if (found == null) {
                        throw new ExceptionInvalidData("01-02-00721", new Object[]{" Meio Pagamento: " + String.valueOf(meio) + " Categoria Pessoa: " + String.valueOf(cat) + " Empresa: " + String.valueOf(empresa)});
                    }
                    cache.put(this.buildKeyMeioCatEmpClas(idMeioPagamento, idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClassPessoa), found);
                }
                lote = this.contabilizarRebimentos(map, found, lote, vo, complementoHist);
            }
        }
        this.aglutinarLancamentos(lote);
        return lote;
    }

    private LoteContabil contabilizarImpostos(LoteContabil lote, List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFCe, String complementoHist, OpcoesContabeis op, NFCeControleCaixa ... controlesCaixa) throws ExceptionInvalidData {
        for (NFCeControleCaixa vo : controlesCaixa) {
            Empresa emp = vo.getNfceCaixa().getEmpresa();
            TreeMap<String, ParamContabilNFCe> cache = new TreeMap<String, ParamContabilNFCe>();
            for (GenericMapValues<GenMapResumoImpostosNFCe> map : valoresNFCe) {
                Long idCatPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CATEGORIA);
                Long idClaPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CLASSIFICACAO);
                Double valorIcms = map.getDouble(GenMapResumoImpostosNFCe.VALOR_ICMS);
                Double valorIpi = map.getDouble(GenMapResumoImpostosNFCe.VALOR_IPI);
                Double valorCofins = map.getDouble(GenMapResumoImpostosNFCe.VALOR_COFINS);
                Double valorPis = map.getDouble(GenMapResumoImpostosNFCe.VALOR_PIS);
                Double valorIrrf = map.getDouble(GenMapResumoImpostosNFCe.VALOR_IRRF);
                if (!(valorIcms > 0.0 || valorIpi > 0.0 || valorCofins > 0.0 || valorPis > 0.0) && !(valorIrrf > 0.0)) continue;
                CategoriaPessoa cat = (CategoriaPessoa)this.serviceCategoriaPessoaImpl.get(idCatPessoa);
                ClassificacaoClientes cla = (ClassificacaoClientes)this.serviceClassificacaoImpl.get(idClaPessoa);
                ParamContabilNFCe found = (ParamContabilNFCe)cache.get(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa));
                if (found == null) {
                    if (ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isWithData((Number)idClaPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp, cla);
                    }
                    if (found == null && ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp);
                    }
                    if (found == null && (idCatPessoa == 0L || ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)0))) {
                        found = this.serviceParamContabilNFCeImpl.getByEmpGeral(emp);
                    }
                    if (found == null) {
                        throw new ExceptionInvalidData("01-02-00721", new Object[]{"  Categoria Pessoa: " + String.valueOf(cat) + "  Classificacao Pessoa: " + String.valueOf(cla) + "  Empresa: " + String.valueOf(emp)});
                    }
                    cache.put(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa), found);
                }
                lote = this.contabilizarImpostos(map, found, lote, vo, complementoHist);
            }
        }
        return lote;
    }

    private void contabilizarMovimentoFinanceiroDinheiro(NFCeControleCaixa vo, EmpresaContabilidade empresaContabilidade) {
        if (vo.getMovimentoBancario() != null) {
            vo.getMovimentoBancario().setNaoContabilizarMov(Short.valueOf((short)1));
        }
    }

    private void contabilizarMovimentoFinanceiroChequeTerceiros(NFCeControleCaixa vo, EmpresaContabilidade empresaContabilidade) {
        if (vo.getMovimentoBancarioCheque() != null) {
            vo.getMovimentoBancarioCheque().setNaoContabilizarMov(Short.valueOf((short)1));
        }
    }

    private LoteContabil contabilizarMovimentoFinanceiroDiferencaCaixa(NFCeControleCaixa vo, EmpresaContabilidade empresaContabilidade, LoteContabil loteContabil) throws ExceptionInvalidData {
        if (vo.getMovimentoBancarioDiferenca() != null) {
            this.compLancamentoMovimentoFinanceiro.getLancamentos(loteContabil, vo.getMovimentoBancarioDiferenca());
            vo.getMovimentoBancarioDiferenca().setNaoContabilizarMov(Short.valueOf((short)1));
        }
        return loteContabil;
    }

    private void contabilizarTransferenciaContaValor(NFCeControleCaixa vo, OpcoesContabeis op) throws ExceptionInvalidData {
        if (op.getNaoContabilizarTransferecias() == 0) {
            this.compTransferenciaContaValor.contabilizar(vo.getTransferenciaContaValor());
        }
    }

    private void contabilizarBorderoChequeTerceiros(NFCeControleCaixa vo, OpcoesContabeis op) throws ExceptionInvalidData {
        if (vo.getBorderoChequeTerceiros() != null) {
            vo.getBorderoChequeTerceiros().setLoteContabil(this.compLancamentoBorderoChequeTerceiros.contabilizar(vo.getBorderoChequeTerceiros(), op));
        }
    }

    private LoteContabil contabilizarDiferencaCaixa(NFCeControleCaixa vo, LoteContabil lote, OpcoesContabeis op) throws ExceptionInvalidData {
        if (vo.getMovimentoBancarioDiferenca() != null && vo.getMovimentoBancarioDiferenca().getModeloLancamentoBancario() != null) {
            Double valor = vo.getMovimentoBancarioDiferenca().getValor();
            String hist = "Diferen\u00e7a de caixa gerada pelo caixa" + String.valueOf(vo.getNfceCaixa());
            for (ItemModeloLancBancario item : vo.getMovimentoBancarioDiferenca().getModeloLancamentoBancario().getItemModeloLancBancario()) {
                if (valor > 0.0) {
                    this.newLancamento(vo.getMovimentoBancarioDiferenca().getContaValor().getPlanoConta(), item.getPlanoConta(), valor, hist, item.getHistoricoPadrao(), vo.getNfceCaixa().getEmpresa());
                    continue;
                }
                this.newLancamento(item.getPlanoConta(), vo.getMovimentoBancarioDiferenca().getContaValor().getPlanoConta(), valor, hist, item.getHistoricoPadrao(), vo.getNfceCaixa().getEmpresa());
            }
        }
        return lote;
    }

    private OpcoesContabeis findOpcoesContabeis(Empresa empresa) {
        ServiceOpcoesContabeisImpl service = new ServiceOpcoesContabeisImpl(new DaoOpcoesContabeisImpl());
        return service.findByEmpresa(empresa);
    }

    public LoteContabil gerarLancamentosImpostos(OpcoesContabeis op, EmpresaContabilidade empresaContabilidade, NFCeControleCaixa controlesCaixa) throws ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)op.getNfceContabilizarControleCaixas(), (Object)ConstEnumIntegTipoIntegContabil.NAO_INTEGRAR.getValue()) && controlesCaixa.getLoteContabil() == null) {
            return null;
        }
        LoteContabil lote = controlesCaixa.getLoteContabil();
        lote = this.contabilizarSomenteImpostos(lote, op, controlesCaixa);
        controlesCaixa.setLoteContabil(lote);
        return lote;
    }

    private LoteContabil contabilizarSomenteImpostos(LoteContabil lote, OpcoesContabeis op, NFCeControleCaixa ... controlesCaixa) throws ExceptionInvalidData {
        List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFCe = this.serviceNFCeControleCaixaImpl.getValoresImpostosNFe(controlesCaixa);
        List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFe = this.serviceNFCeControleCaixaImpl.getValoresImpostosNFCe(controlesCaixa);
        lote = this.removerLancamentosImpostos(lote, valoresNFCe, op, controlesCaixa);
        lote = this.removerLancamentosImpostos(lote, valoresNFe, op, controlesCaixa);
        lote = this.contabilizarSomenteImpostos(lote, valoresNFCe, "NFCe", op, controlesCaixa);
        lote = this.contabilizarSomenteImpostos(lote, valoresNFe, "NFe", op, controlesCaixa);
        return lote;
    }

    private LoteContabil contabilizarSomenteImpostos(LoteContabil lote, List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFCe, String complementoHist, OpcoesContabeis op, NFCeControleCaixa ... controlesCaixa) throws ExceptionInvalidData {
        for (NFCeControleCaixa vo : controlesCaixa) {
            Empresa emp = vo.getNfceCaixa().getEmpresa();
            TreeMap<String, ParamContabilNFCe> cache = new TreeMap<String, ParamContabilNFCe>();
            for (GenericMapValues<GenMapResumoImpostosNFCe> map : valoresNFCe) {
                Long idCatPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CATEGORIA);
                Long idClaPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CLASSIFICACAO);
                CategoriaPessoa cat = (CategoriaPessoa)this.serviceCategoriaPessoaImpl.get(idCatPessoa);
                ClassificacaoClientes cla = (ClassificacaoClientes)this.serviceClassificacaoImpl.get(idClaPessoa);
                ParamContabilNFCe found = (ParamContabilNFCe)cache.get(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa));
                if (found == null) {
                    if (ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isWithData((Number)idClaPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp, cla);
                    }
                    if (found == null && ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp);
                    }
                    if (found == null && (idCatPessoa == 0L || ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)0))) {
                        found = this.serviceParamContabilNFCeImpl.getByEmpGeral(emp);
                    }
                    if (found == null) {
                        throw new ExceptionInvalidData("01-02-00721", new Object[]{"  Categoria Pessoa: " + String.valueOf(cat) + "  Classificacao Pessoa: " + String.valueOf(cla) + "  Empresa: " + String.valueOf(emp)});
                    }
                    cache.put(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa), found);
                }
                lote = this.contabilizarSomenteImpostos(map, found, lote, vo, complementoHist);
            }
        }
        return lote;
    }

    private LoteContabil contabilizarSomenteImpostos(GenericMapValues<GenMapResumoImpostosNFCe> map, ParamContabilNFCe found, LoteContabil lote, NFCeControleCaixa vo, String complementoHist) throws ExceptionInvalidData {
        Double valorIcms = map.getDouble(GenMapResumoImpostosNFCe.VALOR_ICMS);
        Double valorIpi = map.getDouble(GenMapResumoImpostosNFCe.VALOR_IPI);
        Double valorCofins = map.getDouble(GenMapResumoImpostosNFCe.VALOR_COFINS);
        Double valorPis = map.getDouble(GenMapResumoImpostosNFCe.VALOR_PIS);
        if (valorIcms > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getIcmsDevedora(), found.getIcmsCredora(), valorIcms, this.getHistoricoImpostos(vo, "ICMS", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorIpi > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getIpiDevedora(), found.getIpiCredora(), valorIpi, this.getHistoricoImpostos(vo, "IPI", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorPis > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getPisDevedora(), found.getPisCredora(), valorPis, this.getHistoricoImpostos(vo, "Pis", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        if (valorCofins > 0.0) {
            if (lote == null) {
                lote = this.criarLoteContabil(lote, vo.getDataFechamento(), vo.getNfceCaixa().getEmpresa(), ConstEnumOrigemLoteContabil.NFCE_CONTROLE_CAIXA);
            }
            this.newLancamento(found.getCofinsDevedora(), found.getCofinsCredora(), valorCofins, this.getHistoricoImpostos(vo, "Cofins", complementoHist), lote, null, vo.getNfceCaixa().getEmpresa());
        }
        return lote;
    }

    private void removerLancamentosImpostos(LoteContabil lote, ParamContabilNFCe found) {
        ArrayList<Lancamento> excluidos = new ArrayList<Lancamento>();
        for (Lancamento l : lote.getLancamentos()) {
            if ((ToolMethods.isEquals((Object)l.getPlanoContaCred(), (Object)found.getIcmsCredora()) || ToolMethods.isEquals((Object)l.getPlanoContaCred(), (Object)found.getIpiCredora()) || ToolMethods.isEquals((Object)l.getPlanoContaCred(), (Object)found.getPisCredora()) || ToolMethods.isEquals((Object)l.getPlanoContaCred(), (Object)found.getCofinsCredora())) && l.getIdentificador() != null && l.getIdentificador() > 0L && l.getPlanoContaCred() != null) {
                excluidos.add(l);
                continue;
            }
            if (!ToolMethods.isEquals((Object)l.getPlanoContaDeb(), (Object)found.getIcmsDevedora()) && !ToolMethods.isEquals((Object)l.getPlanoContaDeb(), (Object)found.getIpiDevedora()) && !ToolMethods.isEquals((Object)l.getPlanoContaDeb(), (Object)found.getPisDevedora()) && !ToolMethods.isEquals((Object)l.getPlanoContaDeb(), (Object)found.getCofinsDevedora()) || l.getIdentificador() == null || l.getIdentificador() <= 0L || l.getPlanoContaDeb() == null) continue;
            excluidos.add(l);
        }
        lote.getLancamentos().removeAll(excluidos);
    }

    private LoteContabil removerLancamentosImpostos(LoteContabil lote, List<GenericMapValues<GenMapResumoImpostosNFCe>> valoresNFCe, OpcoesContabeis op, NFCeControleCaixa[] controlesCaixa) throws ExceptionInvalidData {
        for (NFCeControleCaixa vo : controlesCaixa) {
            Empresa emp = vo.getNfceCaixa().getEmpresa();
            TreeMap<String, ParamContabilNFCe> cache = new TreeMap<String, ParamContabilNFCe>();
            for (GenericMapValues<GenMapResumoImpostosNFCe> map : valoresNFCe) {
                Long idCatPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CATEGORIA);
                Long idClaPessoa = map.getLong(GenMapResumoImpostosNFCe.ID_CLASSIFICACAO);
                CategoriaPessoa cat = (CategoriaPessoa)this.serviceCategoriaPessoaImpl.get(idCatPessoa);
                ClassificacaoClientes cla = (ClassificacaoClientes)this.serviceClassificacaoImpl.get(idClaPessoa);
                ParamContabilNFCe found = (ParamContabilNFCe)cache.get(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa));
                if (found == null) {
                    if (ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isWithData((Number)idClaPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp, cla);
                    }
                    if (found == null && ToolMethods.isWithData((Number)idCatPessoa) && ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)1)) {
                        found = this.serviceParamContabilNFCeImpl.getByCatPessoaEmp(cat, emp);
                    }
                    if (found == null && (idCatPessoa == 0L || ToolMethods.isEquals((Object)op.getNfceContabilizarPorCatPessoa(), (Object)0))) {
                        found = this.serviceParamContabilNFCeImpl.getByEmpGeral(emp);
                    }
                    if (found == null) {
                        throw new ExceptionInvalidData("01-02-00721", new Object[]{"  Categoria Pessoa: " + String.valueOf(cat) + "  Classificacao Pessoa: " + String.valueOf(cla) + "  Empresa: " + String.valueOf(emp)});
                    }
                    cache.put(this.buildKeyCatEmpClas(idCatPessoa, vo.getNfceCaixa().getEmpresa().getIdentificador(), idClaPessoa), found);
                }
                this.removerLancamentosImpostos(lote, found);
            }
        }
        return lote;
    }
}

