/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais;

import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentoEntradasFiscais;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentoNFCe;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosSaidasFiscais;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentosEntradaSaidaFiscais {
    @Autowired
    CompLancamentosSaidasFiscais compLancamentosSaidasFiscais;
    @Autowired
    CompLancamentoEntradasFiscais compLancamentoEntradasFiscais;
    @Autowired
    CompLancamentoNFCe compLancamentoNFCe;

    public LoteContabil contabilizar(NotaFiscalPropria nfPropria, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        if (nfPropria.getNfceControleCaixa() != null && ToolMethods.isEquals((Object)nfPropria.getNaturezaOperacao().getContabilizarPorIntegracao(), (Object)0)) {
            if (nfPropria.getIntegracaoNotaPropriaNotas() != null) {
                return nfPropria.getIntegracaoNotaPropriaNotas().getLoteContabil();
            }
            return null;
        }
        if (Objects.equals(nfPropria.getNaturezaOperacao().getEntradaSaida(), (short)1)) {
            return this.compLancamentosSaidasFiscais.gerarLancamentos(nfPropria, opcoesContabeis);
        }
        return this.compLancamentoEntradasFiscais.gerarLancamentos(nfPropria, opcoesContabeis);
    }

    public LoteContabil contabilizar(NotaFiscalTerceiros nfTerceiros, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        return this.compLancamentoEntradasFiscais.gerarLancamentos(nfTerceiros, opcoesContabeis);
    }

    public LoteContabil contabilizar(NFCeControleCaixa vo, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        return this.compLancamentoNFCe.gerarLancamentos(opcoesContabeis, empresaContabilidade, vo);
    }

    public LoteContabil contabilizarImpostos(NFCeControleCaixa vo, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        return this.compLancamentoNFCe.gerarLancamentosImpostos(opcoesContabeis, empresaContabilidade, vo);
    }

    public LoteContabil contabilizarAgrupado(List<NFCeControleCaixa> controles, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade, LoteContabil lote) throws ExceptionInvalidData {
        return this.compLancamentoNFCe.gerarLancamentosAgrupado(opcoesContabeis, empresaContabilidade, controles, lote);
    }

    @Async
    public LoteContabil contabilizarAgrupadoAsync(List<NFCeControleCaixa> controles, OpcoesContabeis opcoesContabeis, EmpresaContabilidade empresaContabilidade, LoteContabil lote) throws ExceptionInvalidData {
        return this.contabilizarAgrupado(controles, opcoesContabeis, empresaContabilidade, lote);
    }
}

