/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbModFiscal;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.AuxLancamentosAjustesIcmsDocFiscal;
import com.touchcomp.basementorservice.service.impl.dadosfiscaisuf.ServiceDadosFiscaisUFImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CompLancamentosSaidasFiscais
extends CompLancamentoBase {
    @Autowired
    ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscalImpl;
    @Autowired
    private ServiceDadosFiscaisUFImpl serviceDadosFiscaisUF;
    @Autowired
    private SCompPlanoConta scPlanoConta;
    private NotaFiscalPropria notaFiscalPropria;
    private OpcoesContabeis opcoesContabeis;

    CompLancamentosSaidasFiscais() {
    }

    public LoteContabil gerarLancamentos(NotaFiscalPropria notaFiscalPropria, OpcoesContabeis opcoesContabeis) throws ExceptionValidacaoDadosRuntime, ExceptionInvalidData, ExceptionReflection {
        this.notaFiscalPropria = notaFiscalPropria;
        this.opcoesContabeis = opcoesContabeis;
        LoteContabil lote = this.contabilizarNota();
        return lote;
    }

    private LoteContabil contabilizarNota() throws ExceptionInvalidData, ExceptionReflection {
        LoteContabil lote = null;
        if (this.notaFiscalPropria.getIntegracaoNotaPropriaNotas() != null) {
            lote = this.notaFiscalPropria.getIntegracaoNotaPropriaNotas().getLoteContabil();
        }
        lote = this.criarLoteContabil(lote, this.notaFiscalPropria.getDataEmissaoNota(), this.notaFiscalPropria.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_PROPRIA);
        UnidadeFederativa uf = this.notaFiscalPropria.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf();
        ClassificacaoClientes classificacao = this.notaFiscalPropria.getClassificacaoCliente();
        CategoriaPessoa categoria = this.notaFiscalPropria.getCategoriaPessoa();
        if (classificacao == null) {
            classificacao = this.notaFiscalPropria.getUnidadeFatCliente().getCliente().getClassificacaoClientes();
        }
        if (categoria == null) {
            categoria = this.notaFiscalPropria.getUnidadeFatCliente().getCategoriaPessoa();
        }
        LinkedList<Lancamento> aux = new LinkedList<Lancamento>();
        aux.addAll(new AuxLancamentosAjustesIcmsDocFiscal(this.compHistoricoPadrao).gerarLancamentosAjustesIcmsDocFiscal(this.notaFiscalPropria));
        for (ItemNotaFiscalPropria item : this.notaFiscalPropria.getItensNotaPropria()) {
            if (!this.isEquals(item.getModeloFiscal().getOpcaoContabilizacao(), (short)1)) continue;
            this.contabilizarItem(aux, item, categoria, classificacao, uf);
        }
        this.aglutinaLancamentos(aux);
        for (Lancamento lancamento : aux) {
            this.addLancamentoLote(lote, lancamento, this.notaFiscalPropria.getEmpresa());
        }
        return lote;
    }

    private void contabilizarItem(List<Lancamento> lancamentos, ItemNotaFiscalPropria item, CategoriaPessoa categoria, ClassificacaoClientes classificacao, UnidadeFederativa uf) throws ExceptionInvalidData {
        Double valorDespAcessorias;
        Double valorSeguro;
        Double valorFrete;
        Object historico;
        Double valorFundoPobreza;
        PlanoConta credito;
        PlanoConta debito;
        Double valorIcmsPartilhaRem;
        Double vrLei10833;
        Double vrFunrural;
        Double vrConfinsST;
        Double vrPisST;
        Double vrContSocial;
        Double vrOutros;
        Double vrSenar;
        Double vrRat;
        Double vrInss;
        Double vrIss;
        Double vrIrrf;
        Double vrIcmsST;
        Double vrIpi;
        Double vrCofins;
        Double vrPis;
        Object historico2;
        ParametrizacaoCtbModFiscal parametrizacao = this.serviceParametrizacaoCtbModFiscalImpl.get(item.getModeloFiscal(), this.notaFiscalPropria.getNaturezaOperacao(), item.getProduto().getSubEspecie(), this.notaFiscalPropria.getEmpresa(), categoria, this.opcoesContabeis, uf, classificacao);
        if (parametrizacao == null) {
            throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.0983.001", new Object[]{this.notaFiscalPropria.getNaturezaOperacao(), item.getModeloFiscal(), item.getProduto().getSubEspecie(), this.notaFiscalPropria.getEmpresa(), categoria, this.notaFiscalPropria.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), item.getNotaFiscalPropria()}));
        }
        PlanoConta pcDebito = item.getPlanoContaDeb();
        PlanoConta pcCredito = item.getPlanoContaCred();
        PlanoConta pcProduto = item.getProduto().getPlanoConta();
        ModeloFiscal modelo = item.getModeloFiscal();
        Cliente cliente = this.notaFiscalPropria.getUnidadeFatCliente().getCliente();
        ItemNotaLivroFiscal itemLF = item.getItemNotaLivroFiscal();
        if (!this.isEquals((short)1, parametrizacao.getNaoContabilizarDebCred())) {
            Double valor = this.getDouble(itemLF.getValorTotal()) - this.getDouble(itemLF.getVrIrrf()) - this.getDouble(itemLF.getVrInss()) - this.getDouble(itemLF.getVrPisSt()) - this.getDouble(itemLF.getVrCofinsSt()) - this.getDouble(itemLF.getVrContSoc()) - this.getDouble(itemLF.getVrFunrural() - this.getDouble(itemLF.getVrLei10833()) - this.getDouble(itemLF.getVrOutros() - this.getDouble(itemLF.getValorSestSenat()) - this.getDouble(itemLF.getValorRat()) - this.getDouble(itemLF.getValorSenar()) - this.getDouble(itemLF.getValorTaxaSanidadeAnimal())));
            if (this.isEquals(modelo.getIssRetido(), (short)1)) {
                valor = valor - this.getDouble(itemLF.getVrIss());
            }
            historico2 = "Valor da Nota Fiscal nr. " + this.notaFiscalPropria.getNumeroNota() + " de " + cliente.getPessoa().getNome();
            lancamentos.add(this.newLancamento(null, pcCredito, this.getDouble(itemLF.getValorTotal()) - this.getDouble(itemLF.getVrIcmsSt()) - this.getDouble(itemLF.getValorFCPSt()), (String)historico2, null, this.notaFiscalPropria.getEmpresa()));
            lancamentos.add(this.newLancamento(pcDebito, null, valor, (String)historico2, null, this.notaFiscalPropria.getEmpresa()));
        }
        Double vrIcms = this.getDouble(itemLF.getVrIcms());
        if (this.isEquals(item.getModeloFiscal().getModeloFiscalIcms().getRecuperarTributosIcms(), (short)1)) {
            vrIcms = vrIcms + itemLF.getValorICMSSimples();
        }
        if (vrIcms > 0.0) {
            historico2 = this.getHistorico(this.notaFiscalPropria, "Icms");
            PlanoConta debito2 = this.getPlanoConta(parametrizacao.getPlanoContaIcmsDevedor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIcmsDevedor(), pcProduto);
            PlanoConta credito2 = this.getPlanoConta(parametrizacao.getPlanoContaIcmsCredor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIcmsCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito2, credito2, vrIcms, (String)historico2, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrPis = this.getDouble(itemLF.getVrPis())) > 0.0) {
            String historico3 = this.getHistorico(this.notaFiscalPropria, "Pis");
            PlanoConta debito3 = this.getPlanoConta(parametrizacao.getPlanoContaPisDevedor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoPisDevedor(), pcProduto);
            PlanoConta credito3 = this.getPlanoConta(parametrizacao.getPlanoContaPisCredor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoPisCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito3, credito3, vrPis, historico3, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrCofins = this.getDouble(itemLF.getVrCofins())) > 0.0) {
            String historico4 = this.getHistorico(this.notaFiscalPropria, "Cofins");
            PlanoConta debito4 = this.getPlanoConta(parametrizacao.getPlanoContaCofinsDevedor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoCofinsDevedor(), pcProduto);
            PlanoConta credito4 = this.getPlanoConta(parametrizacao.getPlanoContaCofinsCredor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoCofinsCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito4, credito4, vrCofins, historico4, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrIpi = this.getDouble(itemLF.getVrIpiIndustria())) > 0.0) {
            String historico5 = this.getHistorico(this.notaFiscalPropria, "IPI");
            PlanoConta debito5 = this.getPlanoContaIPI(parametrizacao.getPlanoContaIpiDevedor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIpiDevedor(), pcProduto, parametrizacao.getRespeitarPlanoContaClienteIpiDevedor());
            PlanoConta credito5 = this.getPlanoContaIPI(parametrizacao.getPlanoContaIpiCredor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIpiCredor(), pcProduto, parametrizacao.getRespeitarPlanoContaClienteIpiCredor());
            lancamentos.add(this.newLancamento(debito5, credito5, vrIpi, historico5, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrIcmsST = this.getDouble(itemLF.getVrIcmsSt() + itemLF.getValorFCPSt())) > 0.0) {
            String historico6 = this.getHistorico(this.notaFiscalPropria, "ICMS ST");
            PlanoConta debito6 = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStDevedor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIcmsStDevedor(), pcProduto);
            PlanoConta credito6 = this.getPlanoConta(parametrizacao.getPlanoContaIcmsStCredor(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIcmsStCredor(), pcProduto);
            lancamentos.add(this.newLancamento(null, credito6, vrIcmsST, historico6, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrIrrf = this.getDouble(itemLF.getVrIrrf())) > 0.0) {
            String historico7 = this.getHistorico(this.notaFiscalPropria, "IRRF");
            PlanoConta debito7 = this.getPlanoConta(parametrizacao.getPlanoContaIrrf(), cliente, (short)0, pcProduto);
            lancamentos.add(this.newLancamento(debito7, null, vrIrrf, historico7, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrIss = this.getDouble(itemLF.getVrIss())) > 0.0) {
            String historico8 = this.getHistorico(this.notaFiscalPropria, "ISS");
            PlanoConta debito8 = this.getPlanoConta(parametrizacao.getPlanoContaIssDebito(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIssDevedor(), pcProduto);
            PlanoConta credito7 = this.getPlanoConta(parametrizacao.getPlanoContaIssCredito(), cliente, parametrizacao.getRespeitarPlanoContaProdutoIssCredor(), pcProduto);
            lancamentos.add(this.newLancamento(debito8, credito7, vrIss, historico8, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrInss = this.getDouble(itemLF.getVrInss())) > 0.0) {
            String historico9 = this.getHistorico(this.notaFiscalPropria, "INSS");
            PlanoConta debito9 = this.getPlanoConta(parametrizacao.getPlanoContaInss(), cliente, parametrizacao.getRespeitarPlanoContaProdutoInss(), pcProduto);
            lancamentos.add(this.newLancamento(debito9, null, vrInss, historico9, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrRat = this.getDouble(itemLF.getValorRat())) > 0.0) {
            String historico10 = this.getHistorico(this.notaFiscalPropria, "RAT");
            PlanoConta debito10 = this.getPlanoConta(parametrizacao.getPlanoContaRat(), cliente, parametrizacao.getRespeitarPlanoContaProdutoRat(), pcProduto);
            lancamentos.add(this.newLancamento(debito10, null, vrRat, historico10, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrSenar = this.getDouble(itemLF.getValorSenar())) > 0.0) {
            String historico11 = this.getHistorico(this.notaFiscalPropria, "SENAR");
            PlanoConta debito11 = this.getPlanoConta(parametrizacao.getPlanoContaInss(), cliente, parametrizacao.getRespeitarPlanoContaProdutoSenar(), pcProduto);
            lancamentos.add(this.newLancamento(debito11, null, vrSenar, historico11, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrOutros = this.getDouble(itemLF.getVrOutros())) > 0.0) {
            String historico12 = this.getHistorico(this.notaFiscalPropria, "Outros");
            PlanoConta debito12 = this.getPlanoConta(parametrizacao.getPlanoContaOutros(), cliente, parametrizacao.getRespeitarPlanoContaProdutoOutros(), pcProduto);
            lancamentos.add(this.newLancamento(debito12, null, vrOutros, historico12, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrContSocial = this.getDouble(itemLF.getVrContSoc())) > 0.0) {
            String historico13 = this.getHistorico(this.notaFiscalPropria, "Contribuicao Social");
            PlanoConta debito13 = this.getPlanoConta(parametrizacao.getPlanoContSocial(), cliente, parametrizacao.getRespeitarPlanoContaProdutoContSocial(), pcProduto);
            lancamentos.add(this.newLancamento(debito13, null, vrContSocial, historico13, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrPisST = this.getDouble(itemLF.getVrPisSt())) > 0.0) {
            String historico14 = this.getHistorico(this.notaFiscalPropria, "Pis ST");
            PlanoConta debito14 = this.getPlanoConta(parametrizacao.getPlanoContaPisSt(), cliente, parametrizacao.getRespeitarPlanoContaProdutoPisSt(), pcProduto);
            lancamentos.add(this.newLancamento(debito14, null, vrPisST, historico14, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrConfinsST = this.getDouble(itemLF.getVrCofinsSt())) > 0.0) {
            String historico15 = this.getHistorico(this.notaFiscalPropria, "Cofins ST");
            PlanoConta debito15 = this.getPlanoConta(parametrizacao.getPlanoContaCofinsSt(), cliente, parametrizacao.getRespeitarPlanoContaProdutoCofinsSt(), pcProduto);
            lancamentos.add(this.newLancamento(debito15, null, vrConfinsST, historico15, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrFunrural = this.getDouble(itemLF.getVrFunrural())) > 0.0) {
            String historico16 = this.getHistorico(this.notaFiscalPropria, "Funrural");
            PlanoConta debito16 = this.getPlanoConta(parametrizacao.getPlanoFunrural(), cliente, parametrizacao.getRespeitarPlanoContaProdutoFunrural(), pcProduto);
            lancamentos.add(this.newLancamento(debito16, null, vrFunrural, historico16, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((vrLei10833 = this.getDouble(itemLF.getVrLei10833())) > 0.0) {
            String historico17 = this.getHistorico(this.notaFiscalPropria, "Lei 10833");
            PlanoConta credito8 = this.getPlanoConta(parametrizacao.getPlanoContaLei10833(), cliente, parametrizacao.getRespeitarPlanoContaProdutoLei10833(), pcProduto);
            lancamentos.add(this.newLancamento(null, credito8, vrLei10833, historico17, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((valorIcmsPartilhaRem = this.getDouble(itemLF.getValorIcmsPartilhaRem())) > 0.0 && parametrizacao.getPlanoContaIcmsDifalOrigemCredor() != null) {
            String historico18 = this.getHistorico(this.notaFiscalPropria, "ICMS Difal Origem");
            lancamentos.add(this.newLancamento(parametrizacao.getPlanoContaIcmsDifalOrigemDevedor(), parametrizacao.getPlanoContaIcmsDifalOrigemCredor(), valorIcmsPartilhaRem, historico18, null, this.notaFiscalPropria.getEmpresa()));
        }
        DadosFiscaisUF dadosFiscais = null;
        Double valorIcmsPartilhaDest = this.getDouble(itemLF.getValorIcmsPartilhaDest());
        if (valorIcmsPartilhaDest > 0.0) {
            String historico19 = this.getHistorico(this.notaFiscalPropria, "ICMS Difal Destino");
            debito = null;
            credito = null;
            if (this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFDevedor(), (short)1) || this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFCredor(), (short)1)) {
                dadosFiscais = this.serviceDadosFiscaisUF.get(this.notaFiscalPropria.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), this.notaFiscalPropria.getEmpresa());
            }
            if (this.isEquals(parametrizacao.getRespeitarPlanoContaIcmsDifalUFDevedor(), (short)1)) {
                PlanoConta planoConta = debito = dadosFiscais != null ? dadosFiscais.getPlanoContaIcmsDifal() : null;
            }
            if (this.isEquals(parametrizacao.getRespeitarPlanoContaIcmsDifalUFCredor(), (short)1)) {
                credito = dadosFiscais != null ? dadosFiscais.getPlanoContaIcmsDifal() : null;
            }
            debito = debito == null ? parametrizacao.getPlanoContaIcmsDifalDestinoDevedor() : debito;
            credito = credito == null ? parametrizacao.getPlanoContaIcmsDifalDestinoCredor() : credito;
            lancamentos.add(this.newLancamento(debito, credito, valorIcmsPartilhaDest, historico19, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((valorFundoPobreza = this.getDouble(itemLF.getValorFundoPobreza())) > 0.0) {
            debito = null;
            credito = null;
            historico = this.getHistorico(this.notaFiscalPropria, "ICMS Difal Destino");
            if (this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFDevedor(), (short)1) || this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFCredor(), (short)1) && dadosFiscais == null) {
                dadosFiscais = this.serviceDadosFiscaisUF.get(this.notaFiscalPropria.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), this.notaFiscalPropria.getEmpresa());
            }
            debito = dadosFiscais != null && this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFDevedor(), (short)1) ? dadosFiscais.getPlanoContaFundoPobreza() : parametrizacao.getPlanoContaFundoPobrezaDevedor();
            credito = dadosFiscais != null && this.isEquals(parametrizacao.getRespeitarPlanoContaFundoPobrezaUFCredor(), (short)1) ? dadosFiscais.getPlanoContaFundoPobreza() : parametrizacao.getPlanoContaFundoPobrezaCredor();
            lancamentos.add(this.newLancamento(debito, credito, valorFundoPobreza, (String)historico, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((valorFrete = this.getDouble(item.getValorFrete())) > 0.0 && parametrizacao.getPlanoContaFrete() != null) {
            String historico20 = "Valor do Frete sobre a Nota Fiscal n\u00ba " + this.notaFiscalPropria.getNumeroNota() + " de " + ToolDate.dateToStr((Date)this.notaFiscalPropria.getDataEmissaoNota()) + " de " + this.notaFiscalPropria.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            lancamentos.add(this.newLancamento(item.getPlanoContaDeb(), parametrizacao.getPlanoContaFrete(), valorFrete, historico20, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((valorSeguro = this.getDouble(item.getVrSeguro())) > 0.0 && parametrizacao.getPlanoContaSeguro() != null) {
            historico = "Valor do Seguro sobre a Nota Fiscal n\u00ba " + this.notaFiscalPropria.getNumeroNota() + " de " + ToolDate.dateToStr((Date)this.notaFiscalPropria.getDataEmissaoNota()) + " de " + this.notaFiscalPropria.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            lancamentos.add(this.newLancamento(item.getPlanoContaDeb(), parametrizacao.getPlanoContaSeguro(), valorSeguro, (String)historico, null, this.notaFiscalPropria.getEmpresa()));
        }
        if ((valorDespAcessorias = this.getDouble(item.getValorDespAcessoria())) > 0.0 && parametrizacao.getPlanoContaDespAcess() != null) {
            String historico21 = "Valor das Despesas Acess\u00f3rias sobre a Nota Fiscal n\u00ba " + this.notaFiscalPropria.getNumeroNota() + " de " + ToolDate.dateToStr((Date)this.notaFiscalPropria.getDataEmissaoNota()) + " de " + this.notaFiscalPropria.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            lancamentos.add(this.newLancamento(item.getPlanoContaDeb(), parametrizacao.getPlanoContaDespAcess(), valorDespAcessorias, historico21, null, this.notaFiscalPropria.getEmpresa()));
        }
    }

    private String getHistorico(NotaFiscalPropria notaFiscalPropria, String imposto) {
        String historico = "Valor " + imposto + " sobre Nota Fiscal no. " + notaFiscalPropria.getNumeroNota() + " de " + notaFiscalPropria.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        return historico;
    }

    private PlanoConta getPlanoConta(PlanoConta pcMovimentacao, Cliente cliente, Short respeitarPCProduto, PlanoConta pcProduto) throws ExceptionInvalidData {
        if (this.isEquals(respeitarPCProduto, (short)1)) {
            return pcProduto;
        }
        if (pcMovimentacao != null) {
            return pcMovimentacao;
        }
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(cliente, this.opcoesContabeis);
        return planoConta;
    }

    private PlanoConta getPlanoContaIPI(PlanoConta pcMovimentacao, Cliente cliente, Short respeitarPCProduto, PlanoConta pcProduto, Short respeitarPCCliente) throws ExceptionInvalidData {
        if (this.isEquals(respeitarPCProduto, (short)1)) {
            return pcProduto;
        }
        if (this.isEquals(respeitarPCCliente, (short)1)) {
            PlanoConta planoConta = this.scPlanoConta.getPlanoConta(cliente, this.opcoesContabeis);
            return planoConta;
        }
        if (pcMovimentacao != null) {
            return pcMovimentacao;
        }
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(cliente, this.opcoesContabeis);
        return planoConta;
    }
}

