/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.geracaoreciborpa;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ParametrizacaoContabilizacaoFolha;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaocontabilizacaofolha.ServiceParametrizacaoContabilizacaoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.planocontaimpostofolha.ServicePlanoContaImpostoFolhaImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoGeracaoReciboRpa
extends CompLancamentoBase {
    ServiceLoteContabilImpl serviceLoteContabilImpl;
    ServiceParametrizacaoContabilizacaoFolhaImpl serviceParametrizacaoContabilizacaoFolhaImpl;
    ServicePlanoContaImpostoFolhaImpl servicePlanoContaImpostoFolhaImpl;

    public CompLancamentoGeracaoReciboRpa(ServiceLoteContabilImpl serviceLoteContabilImpl, ServiceParametrizacaoContabilizacaoFolhaImpl serviceParametrizacaoContabilizacaoFolhaImpl, ServicePlanoContaImpostoFolhaImpl servicePlanoContaImpostoFolhaImpl) {
        this.serviceLoteContabilImpl = serviceLoteContabilImpl;
        this.serviceParametrizacaoContabilizacaoFolhaImpl = serviceParametrizacaoContabilizacaoFolhaImpl;
        this.servicePlanoContaImpostoFolhaImpl = servicePlanoContaImpostoFolhaImpl;
    }

    public List<GeracaoReciboRpa> contabilizarRpa(List<GeracaoReciboRpa> listaRpa) throws ExceptionInvalidData {
        for (GeracaoReciboRpa rpa : listaRpa) {
            ParametrizacaoContabilizacaoFolha paramCont = this.findParametrizacaoContabilizacaoFolha(rpa);
            PlanoContaImpostoFolha planoContaImpostoFolha = this.findPlanoContaImpostoFolha(rpa);
            if (ToolMethods.isNotNull((Object)rpa.getLote()).booleanValue()) {
                this.serviceLoteContabilImpl.delete(rpa.getLote());
                rpa.setLote(null);
            }
            LoteContabil lote = this.criarLoteContabil(rpa.getLote(), rpa.getPeriodoFolha(), rpa.getEmpresa(), ConstEnumOrigemLoteContabil.RECIBO_AUTONOMO);
            this.criarLancamentos(rpa, lote, paramCont, planoContaImpostoFolha);
            rpa.setLote(lote);
        }
        return listaRpa;
    }

    ParametrizacaoContabilizacaoFolha findParametrizacaoContabilizacaoFolha(GeracaoReciboRpa rpa) {
        List<ParametrizacaoContabilizacaoFolha> paramCont = this.serviceParametrizacaoContabilizacaoFolhaImpl.getParamPorTipoColaboradorCentroCustoTipoFolhaTipoCalculo(rpa.getColaborador().getCentroCusto().getIdentificador(), rpa.getTipoCalculoEvento().getIdentificador(), EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getEnumId(), rpa.getColaborador().getTipoColaborador().getIdentificador());
        if (paramCont.size() > 1) {
            String idParam = paramCont.stream().map(i -> i.getIdentificador().toString()).collect(Collectors.joining(","));
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.023", new String[]{rpa.getColaborador().getCentroCusto().getNome(), rpa.getTipoCalculoEvento().getEvento().getDescricao(), rpa.getColaborador().getTipoColaborador().getDescricao(), idParam}));
        }
        if (!ToolMethods.isWithData(paramCont)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.024", new String[]{rpa.getColaborador().getCentroCusto().getCodigo(), rpa.getTipoCalculoEvento().getEvento().getDescricao(), rpa.getColaborador().getTipoColaborador().getDescricao()}));
        }
        return paramCont.getFirst();
    }

    PlanoContaImpostoFolha findPlanoContaImpostoFolha(GeracaoReciboRpa rpa) {
        List<PlanoContaImpostoFolha> planoConta = this.servicePlanoContaImpostoFolhaImpl.getPlanoContaImpostoPorCentroCusto(rpa.getColaborador().getCentroCusto(), rpa.getTipoCalculoEvento().getTipoCalculo());
        if (planoConta.size() > 1) {
            String idPlano = planoConta.stream().map(i -> i.getIdentificador().toString()).collect(Collectors.joining(","));
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.025", new String[]{rpa.getColaborador().getCentroCusto().getNome(), idPlano}));
        }
        if (ToolMethods.isNull(planoConta).booleanValue() || this.isEquals(planoConta.size(), 0)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.025", new String[]{rpa.getColaborador().getCentroCusto().getNome()}));
        }
        return planoConta.getFirst();
    }

    private void criarLancamentos(GeracaoReciboRpa rpa, LoteContabil lote, ParametrizacaoContabilizacaoFolha paramCont, PlanoContaImpostoFolha planoContaImpostoFolha) throws ExceptionInvalidData {
        String historico = "";
        if ((ToolMethods.isNotNull((Object)paramCont.getPlanoContaCredito()).booleanValue() || ToolMethods.isNotNull((Object)paramCont.getPlanoContaDebito()).booleanValue()) && rpa.getValorRpa() > 0.0) {
            historico = ToolMethods.isNotNull((Object)paramCont.getHistorico()) != false ? paramCont.getHistorico().getDescricao() : MessagesBaseMentor.getMsg((String)"M.ERP.1146.001", (Object[])new Object[]{rpa.getColaborador().getPessoa().getNome(), rpa.getIdentificador()});
            this.newLancamento(paramCont.getPlanoContaDebito(), paramCont.getPlanoContaCredito(), rpa.getValorRpa(), historico, lote, null, rpa.getEmpresa());
        }
        if ((ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCCreditoInssFolha()).booleanValue() || ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCDebitoInssFolha()).booleanValue()) && rpa.getVlrInss() > 0.0) {
            historico = ToolMethods.isNotNull((Object)planoContaImpostoFolha.getHistoricoInssFolha()) != false ? planoContaImpostoFolha.getHistoricoInssFolha().getDescricao() : MessagesBaseMentor.getMsg((String)"M.ERP.1146.002", (Object[])new Object[]{rpa.getColaborador().getPessoa().getNome(), rpa.getIdentificador()});
            this.newLancamento(planoContaImpostoFolha.getPlanoCCDebitoInssFolha(), planoContaImpostoFolha.getPlanoCCCreditoInssFolha(), rpa.getVlrInss(), historico, lote, null, rpa.getEmpresa());
        }
        if ((ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCCreditoIrrfFolha()).booleanValue() || ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCDebitoIrrfFolha()).booleanValue()) && rpa.getVlrIrrf() > 0.0) {
            historico = ToolMethods.isNotNull((Object)planoContaImpostoFolha.getHistoricoIrrfFolha()) != false ? planoContaImpostoFolha.getHistoricoIrrfFolha().getDescricao() : MessagesBaseMentor.getMsg((String)"M.ERP.1146.003", (Object[])new Object[]{rpa.getColaborador().getPessoa().getNome(), rpa.getIdentificador()});
            this.newLancamento(planoContaImpostoFolha.getPlanoCCDebitoIrrfFolha(), planoContaImpostoFolha.getPlanoCCCreditoIrrfFolha(), rpa.getVlrIrrf(), historico, lote, null, rpa.getEmpresa());
        }
        if ((ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCCreditoIssFolha()).booleanValue() || ToolMethods.isNotNull((Object)planoContaImpostoFolha.getPlanoCCDebitoIssFolha()).booleanValue()) && rpa.getVlrIss() > 0.0) {
            historico = ToolMethods.isNotNull((Object)planoContaImpostoFolha.getHistoricoIssFolha()) != false ? planoContaImpostoFolha.getHistoricoIssFolha().getDescricao() : MessagesBaseMentor.getMsg((String)"M.ERP.1146.004", (Object[])new Object[]{rpa.getColaborador().getPessoa().getNome(), rpa.getIdentificador()});
            this.newLancamento(planoContaImpostoFolha.getPlanoCCDebitoIssFolha(), planoContaImpostoFolha.getPlanoCCCreditoIssFolha(), rpa.getVlrIss(), historico, lote, null, rpa.getEmpresa());
        }
    }
}

