/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.imptransfsaldoscontabeis;

import com.touchcomp.basementor.constants.enums.imptransfsaldocontabil.ConstEnumImpTransfSaldoContabil;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.ImpTransfSaldoContabil;
import com.touchcomp.basementor.model.vo.ImpTransfSaldoContabilItem;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoImpTransSaldosContabeis
extends CompLancamentoBase {
    public ImpTransfSaldoContabil contabilizarImpTransf(ImpTransfSaldoContabil imp) throws ExceptionInvalidData {
        if (TMethods.isEquals((Object)imp.getTipoImportacao(), (Object)ConstEnumImpTransfSaldoContabil.IMPORTACAO_TRANSF_SALDOS_CONTABIL.getValue())) {
            return imp;
        }
        LoteContabil loteUnico = imp.getLoteContabilUnico();
        if (ToolMethods.isAffirmative((Number)imp.getGerarLoteContabilUnico())) {
            Date dataEscrituracao = imp.getDataEscrituracao();
            if (dataEscrituracao == null && !imp.getItensSaldo().isEmpty()) {
                dataEscrituracao = ((ImpTransfSaldoContabilItem)imp.getItensSaldo().get(0)).getDataLancamento();
            }
            loteUnico = this.criarLoteContabil(loteUnico, dataEscrituracao, imp.getEmpresa(), ConstEnumOrigemLoteContabil.IMPORTACAO_TRANSF_SALDOS_CONTABEIS);
            imp.setLoteContabilUnico(loteUnico);
        }
        for (ImpTransfSaldoContabilItem item : imp.getItensSaldo()) {
            this.contabilizarImpTransf(item, imp, loteUnico);
        }
        return imp;
    }

    private ImpTransfSaldoContabilItem contabilizarImpTransf(ImpTransfSaldoContabilItem item, ImpTransfSaldoContabil imp, LoteContabil loteUnico) throws ExceptionInvalidData {
        String historico = item.getHistorico();
        if (!TMethods.isStrWithData((String)historico)) {
            historico = imp.getDescricao();
        }
        if (this.isEquals(imp.getTipoImportacao(), ConstEnumImpTransfSaldoContabil.IMPORTACAO_LANCAMENTOS_SIMPLES.getValue())) {
            LoteContabil lote = loteUnico;
            if (!ToolMethods.isAffirmative((Number)imp.getGerarLoteContabilUnico())) {
                lote = this.criarLoteContabil(item.getLoteContabil(), item.getDataLancamento(), item.getEmpresaImportacao(), ConstEnumOrigemLoteContabil.IMPORTACAO_TRANSF_SALDOS_CONTABEIS);
                item.setLoteContabil(lote);
            }
            Lancamento lanc = this.newLancamento(item.getPlanoContaDebito(), item.getPlanoContaCredito(), item.getValor(), historico, null, item.getEmpresaImportacao(), item.getCentroResultadoContFin());
            this.addLancamentoLote(lote, lanc, item.getEmpresaImportacao());
        } else if (this.isEquals(imp.getTipoImportacao(), ConstEnumImpTransfSaldoContabil.IMPORTACAO_TRANSF_SALDOS_CONTABIL_COM_LANC_CONTABEIS.getValue())) {
            LoteContabil lote = loteUnico;
            if (!ToolMethods.isAffirmative((Number)imp.getGerarLoteContabilUnico())) {
                lote = this.criarLoteContabil(item.getLoteContabil(), item.getDataLancamento(), item.getEmpresaImportacao(), ConstEnumOrigemLoteContabil.IMPORTACAO_TRANSF_SALDOS_CONTABEIS);
                item.setLoteContabil(lote);
            }
            Lancamento lanc = this.isEquals(item.getCreditoDebito(), (short)0) ? this.newLancamento(null, item.getPlanoContaAtual(), item.getValor(), historico, null, item.getEmpresaImportacao(), item.getCentroResultadoContFin()) : this.newLancamento(item.getPlanoContaAtual(), null, item.getValor(), historico, null, item.getEmpresaImportacao(), item.getCentroResultadoContFin());
            this.addLancamentoLote(lote, lanc, item.getEmpresaImportacao());
        }
        return item;
    }
}

