/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.lancamentocooperado;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.geracaocontapessoa.ServiceGeracaoContaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoEventoCoooperado
extends CompLancamentoBase {
    @Autowired
    private ServiceGeracaoContaPessoaImpl serviceGeracaoContaPessoa;
    @Autowired
    private SCompPlanoConta scPlanoConta;

    public void gerarLancContabilAdicionalDocFinanceiro(LancamentoEventoCooperado evt, OpcoesContabeis opContabeis) throws ExceptionInvalidData {
        if (evt.getEventoCooperado().getContabilizarEvento().equals(EnumConstantsMentorSimNao.SIM.getValue()) && evt != null) {
            LoteContabil lote = this.criarLoteContabil(evt.getLoteContabil(), new Date(), evt.getEmpresa(), ConstEnumOrigemLoteContabil.LANCAMENTO_EVENTO_COOPERADO);
            Lancamento l = CompLancamentoEventoCoooperado.newLancamento(lote, evt.getEmpresa());
            l.setGrupoEmpresa(evt.getEmpresa().getEmpresaDados().getGrupoEmpresa());
            l.setPlanoContaCred(this.getPcCredito(evt, opContabeis));
            l.setPlanoContaDeb(this.getPcDebito(evt, opContabeis));
            l.setHistorico(evt.getHistorico());
            l.setValor(evt.getValorOperacao());
            ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
            lanc.add(l);
            lote.setLancamentos(lanc);
            evt.setLoteContabil(lote);
            evt.setPlanoContaContabilCredito(l.getPlanoContaCred());
            evt.setPlanoContaContabilDebito(l.getPlanoContaDeb());
        }
    }

    PlanoConta getPcDebito(LancamentoEventoCooperado evt, OpcoesContabeis opContabeis) throws ExceptionInvalidData {
        PlanoConta pcDebito = null;
        if (evt.getEventoCooperado() != null) {
            pcDebito = evt.getEventoCooperado().getPlanoContaContabilDebito();
        }
        if (pcDebito == null) {
            pcDebito = evt.getCooperado() != null ? this.getPCCooperado(evt.getCooperado(), opContabeis) : this.scPlanoConta.getPlanoConta(evt.getCliente(), opContabeis);
        }
        return pcDebito;
    }

    PlanoConta getPcCredito(LancamentoEventoCooperado evt, OpcoesContabeis opContabeis) {
        PlanoConta pcCredito = null;
        if (evt.getEventoCooperado() != null) {
            pcCredito = evt.getEventoCooperado().getPlanoContaContabilCredito();
        }
        if (pcCredito == null) {
            pcCredito = evt.getCooperado() != null ? this.getPCCooperado(evt.getCooperado(), opContabeis) : evt.getCliente().getPessoa().getContasPessoa().getPlanoContaAtivo();
        }
        return pcCredito;
    }

    PlanoConta getPCCooperado(Cooperado cooperado, OpcoesContabeis opContabeis) {
        return this.serviceGeracaoContaPessoa.getPlanoContaCooperado(cooperado, opContabeis);
    }
}

