/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.movimentofinanceiro;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.integracaomovbancariomovimento.ServiceIntegracaoMovBancarioMovimentoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoMovimentoFinanceiro
extends CompLancamentoBase {
    @Autowired
    ServiceIntegracaoMovBancarioMovimentoImpl serviceIntegracaoMovBancarioMovimento;

    public LoteContabil contabilizar(MovimentoBancario movimentoBancario, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        if (!this.isValidParamsByContabilizacao(movimentoBancario, empresaContabilidade)) {
            return null;
        }
        IntegracaoMovBancarioMovimento movContabilizado = this.getMovimentoContabilizado(movimentoBancario);
        LoteContabil lote = movContabilizado.getLoteContabil();
        if (lote == null) {
            lote = this.criarLoteContabil(lote, movimentoBancario.getDataLancamento(), movimentoBancario.getEmpresa(), ConstEnumOrigemLoteContabil.MOVIMENTO_BANCARIO);
        } else {
            lote.getLancamentos().clear();
        }
        this.getLancamentos(lote, movimentoBancario);
        if (!ToolMethods.isWithData((Collection)lote.getLancamentos())) {
            return null;
        }
        return lote;
    }

    IntegracaoMovBancarioMovimento getMovimentoContabilizado(MovimentoBancario vo) {
        if (ToolMethods.isEquals((Object)vo, null)) {
            return null;
        }
        return this.serviceIntegracaoMovBancarioMovimento.getByMovimentoBancario(vo.getIdentificador());
    }

    private boolean isValidParamsByContabilizacao(MovimentoBancario movimentoBancario, EmpresaContabilidade empresaContabilidade) {
        if (ToolMethods.isEquals((Object)empresaContabilidade, null)) {
            return false;
        }
        if (ToolMethods.isEquals((Object)movimentoBancario, null)) {
            return false;
        }
        if (!ToolMethods.isEquals((Object)movimentoBancario.getEmpresa(), (Object)empresaContabilidade.getEmpresa())) {
            return false;
        }
        if (!ToolMethods.isEquals((Object)empresaContabilidade.getLancMovimentoBancario(), (Object)0)) {
            return false;
        }
        if (!ToolMethods.isEquals((Object)movimentoBancario.getGrupoDeBaixaFormas(), null)) {
            return false;
        }
        if (ToolMethods.isEquals((Object)movimentoBancario.getNaoContabilizarMov(), (Object)1)) {
            return false;
        }
        return ToolMethods.isEquals((Object)movimentoBancario.getContaValor().getGerarLancamentoContabil(), (Object)1);
    }

    public void getLancamentos(LoteContabil lote, MovimentoBancario movimentoBancario) throws ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)movimentoBancario.getDebCred(), (Object)0)) {
            this.newLancamento(null, movimentoBancario.getContaValor().getPlanoConta(), movimentoBancario.getValor(), movimentoBancario.getHistorico(), lote, movimentoBancario.getHistoricoPadrao(), movimentoBancario.getEmpresa());
        } else {
            this.newLancamento(movimentoBancario.getContaValor().getPlanoConta(), null, movimentoBancario.getValor(), movimentoBancario.getHistorico(), lote, movimentoBancario.getHistoricoPadrao(), movimentoBancario.getEmpresa());
        }
        if (ToolMethods.isWithData((Collection)movimentoBancario.getContraPartMovimentoBancario())) {
            for (ContraPartMovimentoBancario contraPartida : movimentoBancario.getContraPartMovimentoBancario()) {
                if (contraPartida.getPlanoConta() == null) continue;
                if (ToolMethods.isEquals((Object)contraPartida.getDebCred(), (Object)1)) {
                    this.newLancamento(null, contraPartida.getPlanoConta(), contraPartida.getValor(), contraPartida.getHistorico(), lote, contraPartida.getHistoricoPadrao(), movimentoBancario.getEmpresa());
                    continue;
                }
                this.newLancamento(contraPartida.getPlanoConta(), null, contraPartida.getValor(), contraPartida.getHistorico(), lote, contraPartida.getHistoricoPadrao(), movimentoBancario.getEmpresa());
            }
        }
    }
}

