/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.requisicao;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstOpContTpComReq;
import com.touchcomp.basementor.constants.enums.paramhistoricolancctb.EnumConstParamHistLancCtb;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoEspecie;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoItem;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoNaturezaRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoSubespecie;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbrequisicao.ServiceParametrizacaoCtbRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.integracaorequisicao.ValidIntegracaoRequisicao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoRequisicao
extends CompLancamentoBase {
    @Autowired
    ServiceParametrizacaoCtbRequisicaoImpl serviceParamReq;

    public void gerarLancamentos(IntegracaoRequisicao integ, OpcoesContabeis opcoesContabeis, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        for (IntegracaoRequisicaoItem item : integ.getItens()) {
            this.gerarLancamentos(item, integ.getEspecies(), integ.getSubespecies(), integ.getNaturezasRequisicao(), integ.getExcluirItensCustoZero(), ToolMethods.isAffirmative((Number)integ.getGerarLancAnalitico()), integ.getGerarLancCentroCusto(), opcoesContabeis, integ.getEmpresa(), cacheParam, validIntegracaoRequisicao);
        }
    }

    public void gerarLancamentos(IntegracaoRequisicaoItem item, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subEspecies, List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, Short excluirItensCustoZero, boolean gerarAnalitico, Short integrarLancamentoCtb, OpcoesContabeis opcoesContabeis, Empresa empresa, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        this.contabilizarRequisicoes(item, especies, subEspecies, naturezas, excluirItensCustoZero, gerarAnalitico, integrarLancamentoCtb, opcoesContabeis, empresa, cacheParam, validIntegracaoRequisicao);
    }

    private void contabilizarRequisicoes(IntegracaoRequisicaoItem item, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subEspecies, List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, Short excluirLancCustoZero, boolean gerarAnalitico, Short integrarLancamentoCtb, OpcoesContabeis opcoesContabeis, Empresa empresa, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        LinkedList<Lancamento> lancamentos = new LinkedList<Lancamento>();
        this.getLancamentosRequisicoesAgrupadas(item, lancamentos, especies, subEspecies, naturezas, integrarLancamentoCtb, opcoesContabeis, cacheParam, validIntegracaoRequisicao);
        if (lancamentos.isEmpty() && item.getLoteContabil() == null) {
            return;
        }
        LoteContabil lote = item.getLoteContabil();
        lote = this.criarLoteContabil(lote, item.getDataLote(), empresa, ConstEnumOrigemLoteContabil.INTEGRACAO_REQUISICAO_ITEM);
        for (Lancamento lancamento : lancamentos) {
            this.addLancamentoLote(lote, lancamento, empresa);
        }
        if (!gerarAnalitico) {
            this.aglutinarLancamentos(lote);
        }
        if (!this.isEquals((short)1, excluirLancCustoZero)) {
            this.removerLancValorZero(lote);
        }
        item.setLoteContabil(lote);
    }

    private void getLancamentosRequisicoesAgrupadas(IntegracaoRequisicaoItem item, List<Lancamento> lancamentos, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subEspecies, List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, Short integrarLancamentoCtb, OpcoesContabeis opcoesContabeis, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        for (Requisicao vo : item.getRequisicoes()) {
            if (!this.isContabilizavel(vo, opcoesContabeis)) continue;
            this.buildLancRequisicao(vo, lancamentos, especies, subEspecies, naturezas, integrarLancamentoCtb, cacheParam, validIntegracaoRequisicao);
        }
    }

    private void buildLancRequisicao(Requisicao vo, List<Lancamento> lancamentos, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subEspecies, List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, Short integrarLancamentoCtb, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        for (ItemRequisicao itemRequisicao : vo.getItensRequisicao()) {
            this.gerarLancItemRequisicao(vo.getEmpresa(), itemRequisicao, lancamentos, especies, subEspecies, naturezas, integrarLancamentoCtb, cacheParam, validIntegracaoRequisicao);
        }
    }

    private Lancamento buildLancamentos(ItemRequisicao itemRequisicao, PlanoConta debito, Double valor, Empresa empresa, Short integrarLancamentoCtb, List<ParametrizacaoCtbRequisicao> cache, ValidGenericEntitiesImpl validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        ParametrizacaoCtbRequisicao param = this.getParametrizacao(itemRequisicao, empresa, cache, validIntegracaoRequisicao);
        if (param == null) {
            return null;
        }
        PlanoConta credito = param.getPlanoContaCredito();
        if (credito == null) {
            credito = itemRequisicao.getProduto().getPlanoConta();
        }
        if (this.isEquals(integrarLancamentoCtb, (short)1)) {
            return this.newLancamento(debito, credito, valor, this.getHistorico(itemRequisicao), null, empresa, itemRequisicao.getCentroCusto());
        }
        return this.newLancamento(debito, credito, valor, this.getHistorico(itemRequisicao), null, empresa);
    }

    private Lancamento buildLancamentosAd(ItemRequisicao itemRequisicao, double valor, Empresa empresa, Short integrarLancamentoCtb, List<ParametrizacaoCtbRequisicao> cacheParam, ValidGenericEntitiesImpl validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        ParametrizacaoCtbRequisicao param = this.getParametrizacao(itemRequisicao, empresa, cacheParam, validIntegracaoRequisicao);
        if (param == null) {
            return null;
        }
        if (param.getPlanoContaCredAd() != null && param.getPlanoContaDebAd() != null) {
            PlanoConta debito = param.getPlanoContaDebAd();
            PlanoConta credito = param.getPlanoContaCredAd();
            if (this.isEquals(integrarLancamentoCtb, (short)1)) {
                return this.newLancamento(debito, credito, (Double)valor, this.getHistoricoAd(itemRequisicao), null, empresa, itemRequisicao.getCentroCusto());
            }
            return this.newLancamento(debito, credito, valor, this.getHistoricoAd(itemRequisicao), null, empresa);
        }
        return null;
    }

    private void gerarLancItemRequisicao(Empresa empresa, ItemRequisicao itemRequisicao, List<Lancamento> lancamentos, List<IntegracaoRequisicaoEspecie> especies, List<IntegracaoRequisicaoSubespecie> subEspecies, List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, Short integrarLancamentoCtb, List<ParametrizacaoCtbRequisicao> cacheParam, ValidIntegracaoRequisicao validIntegracaoRequisicao) throws ExceptionInvalidData, ExceptionReflection {
        ParametrizacaoCtbRequisicao param;
        if (!this.isContabilizavel(itemRequisicao)) {
            return;
        }
        if ((especies.isEmpty() || this.contemEspecie(especies, itemRequisicao.getProduto().getEspecie())) && (subEspecies.isEmpty() || this.contemSubEspecie(subEspecies, itemRequisicao.getProduto().getSubEspecie())) && (naturezas.isEmpty() || this.contemNatRequisicao(naturezas, itemRequisicao.getNaturezaRequisicao())) && (param = this.getParametrizacao(itemRequisicao, empresa, cacheParam, (ValidGenericEntitiesImpl)validIntegracaoRequisicao)) != null) {
            lancamentos.addAll(this.buildLancamentosItemReq(param.getPlanoConta(), itemRequisicao, empresa, integrarLancamentoCtb, cacheParam, (ValidGenericEntitiesImpl)validIntegracaoRequisicao));
        }
    }

    public List<Lancamento> buildLancamentosItemReq(PlanoConta planoContaDeb, ItemRequisicao itemRequisicao, Empresa empresa, Short integrarLancamentoCtb, List<ParametrizacaoCtbRequisicao> cache, ValidGenericEntitiesImpl valid) throws ExceptionInvalidData, ExceptionReflection {
        Lancamento l;
        LinkedList<Lancamento> ret = new LinkedList<Lancamento>();
        double valor = this.getValor(itemRequisicao);
        if (!ToolMethods.isWithData((Number)valor)) {
            valid.addWarn(new ValidMessages.Code("W.ERP.0375.001", new Object[]{itemRequisicao.getRequisicao(), itemRequisicao.getProduto()}), (Object)itemRequisicao);
        }
        if ((l = this.buildLancamentos(itemRequisicao, planoContaDeb, valor, empresa, integrarLancamentoCtb, cache, valid)) != null) {
            ret.add(l);
        }
        if ((l = this.buildLancamentosAd(itemRequisicao, valor, empresa, integrarLancamentoCtb, cache, valid)) != null) {
            ret.add(l);
        }
        return ret;
    }

    public double getValor(ItemRequisicao itemRequisicao) {
        return this.arrredondarNumero(itemRequisicao.getQuantidadeTotal() * itemRequisicao.getValorPrecoMedioCont());
    }

    public boolean isContabilizavel(ItemRequisicao itemRequisicao) {
        CentroEstoque centroEstoque = itemRequisicao.getCentroEstoque();
        if (!this.isEquals(centroEstoque.getTipoEstProprioTerceiros(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) {
            return false;
        }
        if (itemRequisicao.getNaturezaRequisicao() == null) {
            return false;
        }
        return this.isEquals(itemRequisicao.getNaturezaRequisicao().getContabilizavel(), (short)1);
    }

    public ParametrizacaoCtbRequisicao getParametrizacao(ItemRequisicao itemRequisicao, Empresa empresa, List<ParametrizacaoCtbRequisicao> cache, ValidGenericEntitiesImpl validIntegracaoRequisicao) throws ExceptionInvalidData {
        ParametrizacaoCtbRequisicao found = this.serviceParamReq.get(empresa.getEmpresaDados().getGrupoEmpresa(), itemRequisicao.getProduto(), itemRequisicao.getNaturezaRequisicao(), cache);
        if (found == null) {
            validIntegracaoRequisicao.addError(new ValidMessages.Code("E.ERP.0375.001", new Object[]{empresa, itemRequisicao.getNaturezaRequisicao(), itemRequisicao.getProduto()}), (Object)itemRequisicao.getRequisicao());
        }
        return found;
    }

    private boolean isContabilizavel(Requisicao vo, OpcoesContabeis opcoesContabeis) {
        if (this.isEquals(opcoesContabeis.getOpcoesContabeisComProdReq().getTipoIntegracaCom(), EnumConstOpContTpComReq.CONTABILIZAR_SEPARADAMENTE.getValue())) {
            return true;
        }
        return vo.getItemComunicadoProducao() == null;
    }

    public String getHistorico(ItemRequisicao item) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_REQUISICAO, "HIST.ERP.0375.001", item);
    }

    public String getHistoricoAd(ItemRequisicao item) throws ExceptionReflection, ExceptionInvalidData {
        return super.getHistorico(EnumConstParamHistLancCtb.INTEGRACAO_REQUISICAO, "HIST.ERP.0375.002", item);
    }

    private boolean contemEspecie(List<IntegracaoRequisicaoEspecie> especies, Especie especie) {
        for (IntegracaoRequisicaoEspecie e : especies) {
            if (!ToolMethods.isEquals((Object)e.getEspecie(), (Object)especie)) continue;
            return true;
        }
        return false;
    }

    private boolean contemSubEspecie(List<IntegracaoRequisicaoSubespecie> subespecies, SubEspecie subespecie) {
        for (IntegracaoRequisicaoSubespecie e : subespecies) {
            if (!ToolMethods.isEquals((Object)e.getSubEspecie(), (Object)subespecie)) continue;
            return true;
        }
        return false;
    }

    private boolean contemNatRequisicao(List<IntegracaoRequisicaoNaturezaRequisicao> naturezas, NaturezaRequisicao naturezaRequisicao) {
        for (IntegracaoRequisicaoNaturezaRequisicao e : naturezas) {
            if (!ToolMethods.isEquals((Object)e.getNaturezaRequisicao(), (Object)naturezaRequisicao)) continue;
            return true;
        }
        return false;
    }
}

