/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentocontabil.impl.rps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRPS;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilRps;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoRps
extends CompLancamentoBase {
    public LoteContabil contabilizar(Rps rps, CompParametrizacaoContabilRps.DadosContas dados, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        if (!this.isValidParamsByContabilizacao(rps, opcoesContabeis)) {
            if (rps.getLoteContabil() != null) {
                rps.getLoteContabil().getLancamentos().clear();
            }
            return null;
        }
        LoteContabil lote = rps.getLoteContabil();
        if (lote == null) {
            lote = this.criarLoteContabil(lote, rps.getDataEmissao(), rps.getEmpresa(), ConstEnumOrigemLoteContabil.RPS);
        } else {
            lote.setDataLote(rps.getDataEmissao());
            lote.getLancamentos().clear();
        }
        this.getLancamentos(lote, rps, dados, opcoesContabeis);
        if (!ToolMethods.isWithData((Collection)lote.getLancamentos())) {
            return null;
        }
        this.aglutinarLancamentos(lote);
        rps.setLoteContabil(lote);
        return lote;
    }

    private boolean isValidParamsByContabilizacao(Rps rps, OpcoesContabeis opcoesContabeis) {
        if (ToolMethods.isEquals((Object)rps, null)) {
            return false;
        }
        if (ToolMethods.isEquals((Object)rps, (Object)2)) {
            return false;
        }
        if (ToolMethods.isEquals((Object)opcoesContabeis, null)) {
            return false;
        }
        if (ToolMethods.isEquals((Object)rps.getModeloRps(), null)) {
            return false;
        }
        return !ToolMethods.isEquals((Object)rps.getModeloRps().getContabilizar(), (Object)0);
    }

    public void getLancamentos(LoteContabil lote, Rps vo, CompParametrizacaoContabilRps.DadosContas dados, OpcoesContabeis op) throws ExceptionParametrizacao, ExceptionInvalidData {
        Double vlrLanc;
        Double vrTotal = vo.getValorServico();
        Double vrLiquido = vo.getValorLiquidoNfse();
        Double vrIrrf = vo.getValorIr();
        Double vrInss = vo.getValorInss();
        Double vrIss = vo.getValorIss();
        Double valorIssRetido = vo.getValorIssRetido();
        Double vrPis = vo.getValorPis();
        Double vrCofins = vo.getValorCofins();
        Double valorContSoc = vo.getValorContSoc();
        Double valorOutros = vo.getValorOutros();
        Double vrPisST = vo.getValorPisST();
        Double vrCofinsST = vo.getValorCofinsST();
        PlanoConta planoDeb = vo.getPlanoContaDeb();
        PlanoConta planoContaCred = vo.getPlanoContaCred();
        ParametrizacaoCtbRPS param = dados.getParamCtbRps();
        if (planoContaCred != null) {
            vlrLanc = vrLiquido;
            if (vo.getModeloRps().getEntradaSaida().shortValue() == EnumConstantsMentorEntSaida.SAIDA.getValue()) {
                vlrLanc = vrTotal;
            }
            this.newLancamento(null, planoContaCred, vlrLanc, this.getHistorico("", vo), lote, null, vo.getEmpresa());
        }
        if (planoDeb != null) {
            vlrLanc = vrTotal;
            if (vo.getModeloRps().getEntradaSaida().shortValue() == EnumConstantsMentorEntSaida.SAIDA.getValue()) {
                vlrLanc = vrLiquido;
            }
            this.newLancamento(planoDeb, null, vlrLanc, this.getHistorico("", vo), lote, null, vo.getEmpresa());
        }
        if (ToolMethods.isWithData((Number)vrPis)) {
            if (param.getContaPisCredora() != null || param.getContaPisDevedora() != null) {
                this.newLancamento(param.getContaPisDevedora(), param.getContaPisCredora(), vrPis, this.getHistorico("Pis", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaPisCredora() == null && param.getContaPisDevedora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Pis Credora e Devedora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrCofins)) {
            if (param.getContaCofinsCredora() != null || param.getContaCofinsDevedora() != null) {
                this.newLancamento(param.getContaCofinsDevedora(), param.getContaCofinsCredora(), vrCofins, this.getHistorico("Cofins", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaCofinsCredora() == null && param.getContaCofinsDevedora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Cofins Credora e Devedora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrIrrf)) {
            if (param.getContaIRRFCredora() != null || param.getContaIRRF() != null) {
                this.newLancamento(param.getContaIRRF(), param.getContaIRRFCredora(), vrIrrf, this.getHistorico("IR", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaIRRFCredora() == null && param.getContaIRRF() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta IRRF e Conta IRRF Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrIss)) {
            if (param.getContaISS() != null || param.getContaISSCredora() != null) {
                this.newLancamento(param.getContaISS(), param.getContaISSCredora(), vrIss, this.getHistorico("ISS", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaISS() == null && param.getContaISSCredora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta ISS e Conta ISS Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrInss)) {
            if (param.getContaINSSCredora() != null || param.getContaINSS() != null) {
                this.newLancamento(param.getContaINSS(), param.getContaINSSCredora(), vrInss, this.getHistorico("INSS", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaINSSCredora() == null && param.getContaINSS() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta INSS e Conta INSS Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)valorOutros)) {
            if (param.getContaOutros() != null || param.getContaOutrosCredora() != null) {
                this.newLancamento(param.getContaOutros(), param.getContaOutrosCredora(), valorOutros, this.getHistorico("Outros", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaOutros() == null && param.getContaOutrosCredora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Outros e Conta Outros Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)valorContSoc)) {
            if (param.getContaContSoc() != null || param.getContaContSocCredora() != null) {
                this.newLancamento(param.getContaContSoc(), param.getContaContSocCredora(), valorContSoc, this.getHistorico("Cont. Social", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaContSoc() == null && param.getContaContSocCredora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta ContSoc e Conta ContSoc Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)valorIssRetido)) {
            if (param.getContaISS() != null || param.getContaISSRetidoCredora() != null) {
                this.newLancamento(param.getContaISS(), param.getContaISSRetidoCredora(), valorIssRetido, this.getHistorico("ISS Retido", vo), lote, null, vo.getEmpresa());
            } else if (param.getContaISS() == null && param.getContaISSRetidoCredora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta ISS e Conta ISS Retido Credora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrPisST)) {
            if (param.getContaPisSTCredora() != null || param.getContaPisSTDevedora() != null) {
                this.newLancamento(param.getContaPisSTDevedora(), param.getContaPisSTCredora(), vrPisST, this.getHistorico("Pis ST", vo), lote, null, vo.getEmpresa());
                if (vo.getModeloRps().getGerarLancAdicPisCofinsST().equals((short)1) && (param.getContaPisCredora() != null || param.getContaPisDevedora() != null)) {
                    this.newLancamento(param.getContaPisDevedora(), param.getContaPisCredora(), vrPisST, this.getHistorico("Pis", vo), lote, null, vo.getEmpresa());
                } else if (param.getContaPisCredora() == null && param.getContaPisDevedora() == null) {
                    throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Pis Credora e Conta Pis Devedora"});
                }
            } else if (param.getContaPisSTCredora() == null && param.getContaPisSTDevedora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Pis ST Credora e Conta Pis ST Devedora"});
            }
        }
        if (ToolMethods.isWithData((Number)vrCofinsST)) {
            if (param.getContaCofinsSTCredora() != null || param.getContaCofinsSTDevedora() != null) {
                this.newLancamento(param.getContaCofinsSTDevedora(), param.getContaCofinsSTCredora(), vrCofinsST, this.getHistorico("Cofins ST", vo), lote, null, vo.getEmpresa());
                if (vo.getModeloRps().getGerarLancAdicPisCofinsST().equals((short)1) && (param.getContaCofinsCredora() != null || param.getContaCofinsDevedora() != null)) {
                    this.newLancamento(param.getContaCofinsDevedora(), param.getContaCofinsCredora(), vrCofinsST, this.getHistorico("Cofins", vo), lote, null, vo.getEmpresa());
                } else if (param.getContaCofinsCredora() == null && param.getContaCofinsDevedora() == null) {
                    throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Cofins Credora e Conta Cofins Devedora"});
                }
            } else if (param.getContaCofinsSTCredora() == null && param.getContaCofinsSTDevedora() == null) {
                throw new ExceptionParametrizacao("E.ERP.0657.001", new Object[]{"Conta Cofins ST Credora e Conta Cofins ST Devedora"});
            }
        }
    }

    private String getHistorico(String desc, Rps vo) {
        return "Vr. " + desc + " NFSe nr." + vo.getNumeroNFse() + " de " + vo.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome();
    }
}

