/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseLancamentoCtbGer {
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public List<LancamentoCtbGerencial> aglutinarLancamentos(List<LancamentoCtbGerencial> lancs) {
        LinkedList<LancamentoCtbGerencial> ret = new LinkedList<LancamentoCtbGerencial>();
        for (LancamentoCtbGerencial lanc : lancs) {
            Optional<LancamentoCtbGerencial> found = ret.stream().filter(l -> Objects.equals(lanc.getPlanoContaGerencial(), l.getPlanoContaGerencial()) && Objects.equals(lanc.getCentroCusto(), l.getCentroCusto())).findFirst();
            if (found.isPresent()) {
                found.get().setValor(Double.valueOf(found.get().getValor() + lanc.getValor()));
                continue;
            }
            lanc.setHistorico(MessagesBaseMentor.getMsg((String)"M.ERP.0718.001", (Object[])new Object[]{ToolDate.dateToStr((Date)lanc.getDataCadastro())}));
            ret.add(lanc);
        }
        return ret;
    }

    public LancamentoCtbGerencial newLancamentoCtbGer(short debitoCredito, short realizadoProvisionado, EnumTipoLancamentoCTBGerencial compLiquidacao, CentroCusto centroCusto, Date dataCompetencia, Date dataPrevisao, PlanoContaGerencial pcGer, Empresa empresa, String historico, Double valorCusto, Long idLancOrigem) {
        LancamentoCtbGerencial lancCtbGerencial = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, dataCompetencia, dataPrevisao, debitoCredito, empresa, EnumConstantsMentorSimNao.NAO.getValue(), historico, pcGer, realizadoProvisionado, compLiquidacao.getValue(), centroCusto, valorCusto, idLancOrigem);
        return lancCtbGerencial;
    }
}

