/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class BaseLancamentoCtbGerTitulol<T> {
    protected void criarLancamentosCTBGerencial(T source, List<Titulo> titulos, Empresa emp) {
        List<ResumoContaGerValor> contaGerValores = this.getResumoContaGerValor(source);
        Double valorTotalTitulos = this.getValorTotalTitulos(titulos);
        for (Titulo t : titulos) {
            ArrayList<LancamentoCtbGerencial> lanc = t.getLancCtbGerencial();
            if (lanc == null) {
                lanc = new ArrayList<LancamentoCtbGerencial>();
            } else {
                lanc.clear();
            }
            int count = 0;
            int size = contaGerValores.size();
            double valorAcumulado = 0.0;
            for (ResumoContaGerValor res : contaGerValores) {
                Double valorConta = res.valorTotal;
                Double valorLancGer = 0.0;
                Double valorLanc = this.arrredondarNumero(t.getValor() / valorTotalTitulos * valorConta, 2);
                valorLancGer = count == size - 1 ? Double.valueOf(Math.abs(t.getValor() - valorAcumulado)) : valorLanc;
                valorAcumulado += valorLanc.doubleValue();
                Object historico = "Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                if (((String)historico).length() > 500) {
                    historico = ((String)historico).substring(0, 500);
                }
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue(), emp, EnumConstantsMentorSimNao.NAO.getValue(), (String)historico, res.planoContaGerencial, t.getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), null, valorLancGer, null);
                ++count;
                lanc.add(l);
            }
            t.setLancCtbGerencial(lanc);
        }
    }

    protected abstract List<ResumoContaGerValor> getResumoContaGerValor(T var1);

    protected void somarResumo(PlanoContaGerencial pcg, List<ResumoContaGerValor> ret, Double valorTotal) {
        ResumoContaGerValor res2;
        Optional<ResumoContaGerValor> r = ret.stream().filter(res -> res.planoContaGerencial.equals((Object)pcg)).findFirst();
        if (r.isPresent()) {
            res2 = r.get();
        } else {
            res2 = new ResumoContaGerValor(pcg);
            ret.add(res2);
        }
        res2.setValorTotal(res2.getValorTotal() + valorTotal);
    }

    private Double arrredondarNumero(double numero, int casasDec) {
        return ToolFormatter.arrredondarNumero((Double)numero, (int)casasDec);
    }

    private Double getValorTotalTitulos(List<Titulo> titulos) {
        Double valor = 0.0;
        for (Titulo t : titulos) {
            valor = valor + t.getValor();
        }
        return valor;
    }

    public static class ResumoContaGerValor {
        private PlanoContaGerencial planoContaGerencial;
        private Double valorTotal;

        public ResumoContaGerValor(PlanoContaGerencial planoContaGerencial) {
            this.planoContaGerencial = planoContaGerencial;
            this.valorTotal = 0.0;
        }

        public PlanoContaGerencial getPlanoContaGerencial() {
            return this.planoContaGerencial;
        }

        public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
            this.planoContaGerencial = planoContaGerencial;
        }

        public Double getValorTotal() {
            return this.valorTotal;
        }

        public void setValorTotal(Double valorTotal) {
            this.valorTotal = valorTotal;
        }
    }
}

