/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.IntegComProdItemComunicadoProd;
import com.touchcomp.basementor.model.vo.IntegComProdItemLancCtbGerencial;
import com.touchcomp.basementor.model.vo.IntegracaoComProducaoItem;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.BaseLancamentoCtbGer;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbcomprod.ServiceParametrizacaoCtbComProdImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.integracaocomunicadoproducao.ValidIntegracaoComunicadoProducao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompComunicadoProdLancGer
extends BaseLancamentoCtbGer {
    @Autowired
    ServiceParametrizacaoCtbComProdImpl serviceParamCtb;

    public IntegracaoComunicadoProducao gerarLancamentosGerenciais(IntegracaoComunicadoProducao integracao, List<ParametrizacaoCtbComProd> cache, ValidIntegracaoComunicadoProducao validInteg) {
        validInteg.isValidData((InterfaceVO)integracao);
        if (validInteg.hasErrors()) {
            return integracao;
        }
        for (IntegracaoComProducaoItem item : integracao.getItensLotesContabeisDia()) {
            List<LancamentoCtbGerencial> lancs = new LinkedList<LancamentoCtbGerencial>();
            this.gerarLancamentosGerenciais(item, lancs, cache, integracao.getEmpresa(), validInteg);
            if (!ToolMethods.isEquals((Object)integracao.getGerarLancAnalitico(), (Object)1)) {
                lancs = this.aglutinarLancamentos(lancs);
            }
            item.setLancamentosCtbGerencial(this.buildLancamentosGerenciaisInteg(lancs));
        }
        return integracao;
    }

    private List<IntegComProdItemLancCtbGerencial> buildLancamentosGerenciaisInteg(List<LancamentoCtbGerencial> lancs) {
        LinkedList<IntegComProdItemLancCtbGerencial> ret = new LinkedList<IntegComProdItemLancCtbGerencial>();
        for (LancamentoCtbGerencial l : lancs) {
            ret.add(new IntegComProdItemLancCtbGerencial(l));
        }
        return ret;
    }

    private void gerarLancamentosGerenciais(IntegracaoComProducaoItem itemInteg, List<LancamentoCtbGerencial> lancamentos, List<ParametrizacaoCtbComProd> cache, Empresa emp, ValidIntegracaoComunicadoProducao validInteg) {
        for (IntegComProdItemComunicadoProd vo : itemInteg.getComunicadosProducao()) {
            if (vo.getComunicadoProducao() == null || vo.getComunicadoProducao().getItemComunicadoProducao() == null) continue;
            for (ItemComunicadoProducao item : vo.getComunicadoProducao().getItemComunicadoProducao()) {
                ParametrizacaoCtbComProd param;
                Double valorCusto = 0.0;
                if (item.getGradeItemComunicadoProducao().size() > 0) {
                    valorCusto = ((GradeItemComunicadoProducao)item.getGradeItemComunicadoProducao().get(0)).getValorUnitario() * item.getQuantidadeTotal();
                }
                if ((param = this.getParametrizacaoComProducao(item, emp, cache)) != null) {
                    LancamentoCtbGerencial lanc = this.newLancamentoCtbGer(EnumLancamentoCTBGerencial.CREDITO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, item.getCentroCusto(), vo.getComunicadoProducao().getDataEntradaSaida(), vo.getComunicadoProducao().getDataEntradaSaida(), param.getPlanoContaGerencial(), vo.getComunicadoProducao().getEmpresa(), this.getHistorico(item), valorCusto, item.getIdentificador());
                    if (lanc == null) continue;
                    lancamentos.add(lanc);
                    continue;
                }
                validInteg.addError(new ValidMessages.Code("E.ERP.0940.004", new Object[]{emp.getEmpresaDados().getGrupoEmpresa(), item.getProduto(), item.getProduto().getSubEspecie()}), cache);
            }
        }
    }

    private String getHistorico(ItemComunicadoProducao item) {
        return MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0940.001", (Object[])new Object[]{item.getComunicadoProducao().getIdentificador(), item.getProduto()});
    }

    private ParametrizacaoCtbComProd getParametrizacaoComProducao(ItemComunicadoProducao item, Empresa emp, List<ParametrizacaoCtbComProd> cache) {
        return this.serviceParamCtb.findParametrizacao(emp.getEmpresaDados().getGrupoEmpresa(), item.getProduto(), cache);
    }
}

