/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.BaseLancamentoCtbGer;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.stereotype.Component;

@Component
public class CompFechamentoOrdemServicoLancGer
extends BaseLancamentoCtbGer {
    public void gerarLancGerenciais(FechamentoOrdemServico fechamento, OpcoesManutencEquip opcoesManutencEquip) {
        if (!TMethods.isAffirmative((Number)opcoesManutencEquip.getGerarLancGerFechamOsExecutante())) {
            return;
        }
        for (Executante e : fechamento.getExecutantes()) {
            this.newLancamentoCtbGerencial(e, opcoesManutencEquip.getPlanoContaGerFechamentoOsExecutante());
        }
    }

    private LancamentoCtbGerencial newLancamentoCtbGerencial(Executante e, PlanoContaGerencial planoContaGerencial) {
        String historico = this.getHistorico(e);
        LancamentoCtbGerencial lanc = this.newLancamentoCtbGer(EnumLancamentoCTBGerencial.DEBITO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto(), e.getFechamentoOrdemServico().getDataFechamento(), e.getFechamentoOrdemServico().getDataFechamento(), planoContaGerencial, e.getEmpresa(), historico, e.getValorTotal(), e.getFechamentoOrdemServico().getIdentificador());
        e.setLancamentoCtbGerencial(lanc);
        return lanc;
    }

    private String getHistorico(Executante e) {
        String historico = e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto() != null ? "Lanc. por Fechamento Ordem Servi\u00e7o " + e.getFechamentoOrdemServico().getIdentificador().toString() + " e Ordem de Servico " + e.getFechamentoOrdemServico().getOrdemServico().getIdentificador().toString() + ", para o Executante " + e.getPessoa().getNome() + ", no Centro Custo: " + e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto().getCodigo() + "." : "Lanc. por Fechamento Ordem Servi\u00e7o " + e.getFechamentoOrdemServico().getIdentificador().toString() + " e Ordem de Servico " + e.getFechamentoOrdemServico().getOrdemServico().getIdentificador().toString() + ", para o Executante " + e.getPessoa().getNome() + ".";
        return historico;
    }
}

