/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemLancGerencialFolha;
import com.touchcomp.basementor.model.vo.ItemMovCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.itemmovcentrocustocolaborador.ServiceItemMovCentroCustoColaboradorImpl;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CompBaseLancMovimentoFolha
extends BaseMethods {
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;
    @Autowired
    ServiceItemMovCentroCustoColaboradorImpl serviceItemMovCentroCustoColaborador;

    List<ItemLancGerencialFolha> getItensLancamentosGerenciais(List<LancamentoCtbGerencial> lancs, MovimentoFolha mov) {
        ArrayList<ItemLancGerencialFolha> itens = new ArrayList<ItemLancGerencialFolha>();
        for (LancamentoCtbGerencial lancamento : lancs) {
            ItemLancGerencialFolha item = new ItemLancGerencialFolha(mov, lancamento);
            itens.add(item);
        }
        return itens;
    }

    Double getDiasMes(MovimentoFolha mov) {
        return mov.getDiasTrabalhados() + mov.getDiasFolgas() + mov.getDiasFeriados();
    }

    Double getDiasAlocadoAcumulado(List<ItemMovCentroCustoColaborador> itens, MovimentoFolha mov, Double diasMes) throws ExceptionValidacaoDados {
        Double diasAlocadoAcumulado = 0.0;
        for (ItemMovCentroCustoColaborador itemCentroCusto : itens) {
            if (!((diasAlocadoAcumulado = Double.valueOf(diasAlocadoAcumulado + itemCentroCusto.getNrDiasAlocado())) > diasMes)) continue;
            throw new ExceptionValidacaoDados("E.ERP.1096.002", new Object[]{mov.getColaborador().toString(), diasAlocadoAcumulado.toString(), diasMes.toString()});
        }
        return diasAlocadoAcumulado;
    }

    List<ItemMovCentroCustoColaborador> getItensAlocacaoFolha(MovimentoFolha mov) {
        return this.serviceItemMovCentroCustoColaborador.getItensAlocacaoFolha(mov);
    }

    Boolean validarPlanoContaImposto(PlanoContaGerencial plano, HistoricoPadrao h, CentroCusto centroCusto, String imposto, Long idP) throws ExceptionValidacaoDados {
        if (plano == null || h == null) {
            throw new ExceptionValidacaoDados("E.ERP.1096.012", new Object[]{imposto, centroCusto.getNome(), idP.toString()});
        }
        return true;
    }

    LancamentoCtbGerencial criarLancamentoGerencial(Short tipoLancamento, Double valor, String historico, CentroCusto centroCusto, PlanoContaGerencial planoConta, Date dataCadastro, Timestamp dataAtualizacao, Empresa empresa, Short gerado) {
        LancamentoCtbGerencial l = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, dataCadastro, dataCadastro, tipoLancamento, empresa, gerado, historico, planoConta, EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), centroCusto, valor, null);
        return l;
    }

    ItemMovCentroCustoColaborador getItemMovCentroCustoColaborador(CentroCusto centroCusto, MovimentoFolha mov, Double diasMes, Double diasAlocadoAcumulado) {
        MovimentoCentroCustoColaborador movCentroCusto = new MovimentoCentroCustoColaborador(centroCusto, mov.getAberturaPeriodo().getDataInicio());
        ItemMovCentroCustoColaborador item = new ItemMovCentroCustoColaborador(Double.valueOf(diasMes - diasAlocadoAcumulado), movCentroCusto, mov.getColaborador());
        return item;
    }
}

