/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.IntegracaoMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementorexceptions.exceptions.impl.planoconta.ExceptionPlanoContaEventoNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.CompBaseLancMovimentoFolha;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.util.HashMapTotalizadoresMovimentos;
import com.touchcomp.basementorservice.service.impl.calculoinssempresa.ServiceCalculoInssEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemprovisaodec.ServiceItemProvisaoDecImpl;
import com.touchcomp.basementorservice.service.impl.itemprovisaoferias.ServiceItemProvisaoFeriasImpl;
import com.touchcomp.basementorservice.service.impl.planocontaimpostofolha.ServicePlanoContaImpostoFolhaImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoGerencialImpostoFolha
extends CompBaseLancMovimentoFolha {
    @Autowired
    ServiceItemProvisaoDecImpl serviceItemProvisaoDec;
    @Autowired
    ServicePlanoContaImpostoFolhaImpl servicePlanoContaImpostoFolha;
    @Autowired
    ServiceItemProvisaoFeriasImpl serviceItemProvisaoFerias;
    @Autowired
    ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresa;

    public void gerarLancamentosGerenciaisImpostoFolha(MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh) throws ExceptionValidacaoDados, ExceptionPlanoContaEventoNotFound {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        CentroCusto centroCusto = mov.getColaborador().getCentroCusto();
        List<ItemMovCentroCustoColaborador> itens = this.getItensAlocacaoFolha(mov);
        Double diasMes = this.getDiasMes(mov);
        Double diasAlocadoAcumulado = this.getDiasAlocadoAcumulado(itens, mov, diasMes);
        if (diasMes == 0.0) {
            diasMes = 30.0;
        }
        if (diasAlocadoAcumulado < diasMes) {
            itens.add(this.getItemMovCentroCustoColaborador(centroCusto, mov, diasMes, diasAlocadoAcumulado));
        }
        TipoCalculo tipoCaculo = mov.getAberturaPeriodo().getTipoCalculo();
        HashMapTotalizadoresMovimentos hashTotalizadores = new HashMapTotalizadoresMovimentos();
        Iterator<ItemMovCentroCustoColaborador> iterator = itens.iterator();
        while (iterator.hasNext()) {
            ItemMovCentroCustoColaborador item = iterator.next();
            Double valorBase = this.getValorBase(mov, diasMes, item.getNrDiasAlocado());
            PlanoContaImpostoFolha planoImposto = this.getPlanoContaImpostoFolha(centroCusto, tipoCaculo);
            LancamentoCtbGerencial l = this.calculoLancamentoInssEmpresa(centroCusto, planoImposto, mov, integracao, empresaRh, valorBase);
            if (!this.isEquals(l, null)) {
                lancs.add(l);
            }
            if (!this.isEquals(l = this.calculoLancamentoRAT(centroCusto, planoImposto, mov, integracao, empresaRh, valorBase, iterator.hasNext(), hashTotalizadores), null)) {
                lancs.add(l);
            }
            if (!this.isEquals(l = this.calculoLancamentoTerceiros(centroCusto, planoImposto, mov, integracao, empresaRh, valorBase, iterator.hasNext(), hashTotalizadores), null)) {
                lancs.add(l);
            }
            if (mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                centroCusto = mov.getColaborador().getCentroCusto();
                planoImposto = this.getPlanoContaImpostoFolha(centroCusto, tipoCaculo);
                List<LancamentoCtbGerencial> lancsAutFrete = this.calculoLancamentoAutonomoFrete(centroCusto, planoImposto, mov, integracao, empresaRh, valorBase);
                lancs.addAll(lancsAutFrete);
            }
            if (mov.getColaborador().getCategoriaSefip() != null && mov.getColaborador().getCategoriaSefip().getCodigo().equals("04") && !this.isEquals(l = this.calculoLancamentoAposentadoria(centroCusto, planoImposto, mov, integracao, empresaRh, valorBase, iterator.hasNext(), hashTotalizadores), null)) {
                lancs.add(l);
            }
            if (!this.isAffimative(empresaRh.getContabilizarProvisaoGerencialMensal())) continue;
            l = this.valorProvisaoFerias(mov);
            if (l != null) {
                lancs.add(l);
            }
            if ((l = this.valorProvisaoDecimoTerceiro(mov)) == null) continue;
            lancs.add(l);
        }
        mov.getLancsGerenciais().addAll(this.getItensLancamentosGerenciais(lancs, mov));
        mov.getLancsGerenciais().removeIf(i -> i.getLancamentoGerencial() == null || !ToolMethods.isWithData((Number)i.getLancamentoGerencial().getValor()));
    }

    Double getValorBcInns(MovimentoFolha mov) {
        return mov.getBcInssSalario() + mov.getBcInssFerias() + mov.getBcInss13Sal();
    }

    Double getValorBase(MovimentoFolha mov, Double diasMes, Double diasAlocado) {
        Double valorBase = this.getValorBcInns(mov);
        if (this.isAffimative(mov.getColaborador().getTipoColaborador().getCompoe2200())) {
            valorBase = mov.getBaseEmpresaColaborador();
        }
        valorBase = ToolFormatter.arrredondarNumero((Double)(valorBase / diasMes * diasAlocado), (int)2);
        return valorBase;
    }

    PlanoContaImpostoFolha getPlanoContaImpostoFolha(CentroCusto centroCusto, TipoCalculo tipoCaculo) throws ExceptionPlanoContaEventoNotFound {
        List<PlanoContaImpostoFolha> aux = this.servicePlanoContaImpostoFolha.getPlanoContaImpostoPorCentroCusto(centroCusto, tipoCaculo);
        if (aux.size() > 1) {
            StringBuilder identificadores = new StringBuilder();
            for (PlanoContaImpostoFolha p : aux) {
                identificadores.append(" ").append(p.getIdentificador().toString()).append(";");
            }
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.007", new Object[]{centroCusto.getNome(), tipoCaculo.getDescricao(), identificadores});
        }
        if (aux.isEmpty()) {
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.013", new Object[]{centroCusto.getNome(), tipoCaculo.getDescricao()});
        }
        return aux.get(0);
    }

    Double calculaVlrBaseAposentadoria(EmpresaRh empresaRh, Double valorBase) {
        return ToolFormatter.arrredondarNumero((Double)(valorBase * (empresaRh.getPercAposentadoriaEspecial25Anos() / 100.0)), (int)2);
    }

    Double calculaTotalLancamentoAposentadoria(MovimentoFolha mov, EmpresaRh empresaRh, HashMapTotalizadoresMovimentos hashTotalizadores) {
        return ToolFormatter.arrredondarNumero((Double)((mov.getBcInssSalario() + mov.getBcInssFerias() + mov.getBcInss13Sal()) * (empresaRh.getPercAposentadoriaEspecial25Anos() / 100.0)), (int)2) - hashTotalizadores.getValorAcumuladoAposentadoria();
    }

    Double getValorLancamentoAposentadoria(EmpresaRh empresaRh, MovimentoFolha mov, HashMapTotalizadoresMovimentos hashTotalizadores, Double valorBase, Boolean acumulaValorLanc) {
        Double valor = this.calculaVlrBaseAposentadoria(empresaRh, valorBase);
        if (!acumulaValorLanc.booleanValue()) {
            valor = this.calculaTotalLancamentoAposentadoria(mov, empresaRh, hashTotalizadores);
        } else {
            hashTotalizadores.updateValorAcumuladoAposentadoria(valor);
        }
        return valor;
    }

    LancamentoCtbGerencial calculoLancamentoAposentadoria(CentroCusto centroCusto, PlanoContaImpostoFolha planoImposto, MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh, Double valorBase, Boolean acumulaValorLanc, HashMapTotalizadoresMovimentos hashTotalizadores) throws ExceptionValidacaoDados, ExceptionPlanoContaEventoNotFound {
        if (this.validarPlanoContaImposto(planoImposto.getPlanoCGAposentEspecial(), planoImposto.getHistoricoAposentEspecial(), centroCusto, "APOSENTADORIA ESPECIAL", planoImposto.getIdentificador()).booleanValue()) {
            Double valor = this.getValorLancamentoAposentadoria(empresaRh, mov, hashTotalizadores, valorBase, acumulaValorLanc);
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.CREDITO.getValue(), valor, planoImposto.getHistoricoAposentEspecial().getDescricao(), centroCusto, planoImposto.getPlanoCGAposentEspecial(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.018", new Object[]{centroCusto.getNome()});
    }

    Double calculaPercAutonomoFrete(Double perc, Double valorBase) {
        return ToolFormatter.arrredondarNumero((Double)(valorBase * (perc / 100.0)), (int)2);
    }

    List<LancamentoCtbGerencial> calculoLancamentoAutonomoFrete(CentroCusto centroCusto, PlanoContaImpostoFolha planoImposto, MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh, Double valorBase) throws ExceptionPlanoContaEventoNotFound, ExceptionValidacaoDados {
        ArrayList<LancamentoCtbGerencial> lancamentos = new ArrayList<LancamentoCtbGerencial>();
        if (!this.validarPlanoContaImposto(planoImposto.getPlanoCGInssAutonomoFrete(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "AUTONOMO-FRETE", planoImposto.getIdentificador()).booleanValue()) {
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.016", new Object[]{centroCusto.getNome()});
        }
        Double valor = this.calculaPercAutonomoFrete(empresaRh.getPercFrete(), valorBase);
        lancamentos.add(this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.CREDITO.getValue(), valor, planoImposto.getHistoricoInssTerceiros().getDescricao(), centroCusto, planoImposto.getPlanoCGInssTerceiros(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue()));
        valor = this.calculaPercAutonomoFrete(empresaRh.getPercSEST(), valorBase);
        lancamentos.add(this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.CREDITO.getValue(), valor, planoImposto.getHistoricoInssSestSenac().getDescricao(), centroCusto, planoImposto.getPlanoCGInssSestSenac(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue()));
        return lancamentos;
    }

    Double calculaVlrBaseTerceiros(EmpresaRh empresaRh, Double valorBase) {
        return ToolFormatter.arrredondarNumero((Double)(valorBase * (empresaRh.getPercTerceiros() / 100.0)), (int)2);
    }

    Double calculaTotalLancamentoTerceiros(MovimentoFolha mov, EmpresaRh empresaRh, HashMapTotalizadoresMovimentos hashTotalizadores) {
        return ToolFormatter.arrredondarNumero((Double)((mov.getBcInssSalario() + mov.getBcInssFerias() + mov.getBcInss13Sal()) * (empresaRh.getPercTerceiros() / 100.0)), (int)2) - hashTotalizadores.getValorAcumuladoTerceiros();
    }

    Double getValorLancamentoTerceiros(EmpresaRh empresaRh, MovimentoFolha mov, HashMapTotalizadoresMovimentos hashTotalizadores, Double valorBase, Boolean acumulaValorLanc) {
        Double valor = this.calculaVlrBaseTerceiros(empresaRh, valorBase);
        if (!acumulaValorLanc.booleanValue()) {
            valor = this.calculaTotalLancamentoTerceiros(mov, empresaRh, hashTotalizadores);
        } else {
            hashTotalizadores.updateValorAcumuladoTerceiros(valor);
        }
        return valor;
    }

    LancamentoCtbGerencial calculoLancamentoTerceiros(CentroCusto centroCusto, PlanoContaImpostoFolha planoImposto, MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh, Double valorBase, Boolean acumulaValorLanc, HashMapTotalizadoresMovimentos hashTotalizadores) throws ExceptionValidacaoDados, ExceptionPlanoContaEventoNotFound {
        if (planoImposto.getIncideImpostoGuiInss() != null && planoImposto.getIncideImpostoGuiInss().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            if (this.validarPlanoContaImposto(planoImposto.getPlanoCGInssTerceiros(), planoImposto.getHistoricoInssTerceiros(), centroCusto, "INSS DE TERCEIROS", planoImposto.getIdentificador()).booleanValue()) {
                Double valor = this.getValorLancamentoTerceiros(empresaRh, mov, hashTotalizadores, valorBase, acumulaValorLanc);
                return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valor, planoImposto.getHistoricoInssTerceiros().getDescricao(), centroCusto, planoImposto.getPlanoCGInssTerceiros(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            }
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.015", new Object[]{centroCusto.getNome().toUpperCase()});
        }
        return null;
    }

    Double calculaVlrBaseRAT(EmpresaRh empresaRh, Double valorBase) {
        return ToolFormatter.arrredondarNumero((Double)(valorBase * empresaRh.getIndiceFAP() * (empresaRh.getPercRat() / 100.0)), (int)2);
    }

    Double calculaTotalLancamentoRAT(MovimentoFolha mov, EmpresaRh empresaRh, HashMapTotalizadoresMovimentos hashTotalizadores) {
        return ToolFormatter.arrredondarNumero((Double)((mov.getBcInssSalario() + mov.getBcInssFerias() + mov.getBcInss13Sal()) * empresaRh.getIndiceFAP() * (empresaRh.getPercRat() / 100.0)), (int)2) - hashTotalizadores.getValorAcumuladoRat();
    }

    Double getValorLancamentoRAT(EmpresaRh empresaRh, MovimentoFolha mov, HashMapTotalizadoresMovimentos hashTotalizadores, Double valorBase, Boolean acumulaValorLanc) {
        Double valor = this.calculaVlrBaseRAT(empresaRh, valorBase);
        if (!acumulaValorLanc.booleanValue()) {
            valor = this.calculaTotalLancamentoRAT(mov, empresaRh, hashTotalizadores);
        } else {
            hashTotalizadores.updateValorAcumuladoRat(valor);
        }
        return valor;
    }

    LancamentoCtbGerencial calculoLancamentoRAT(CentroCusto centroCusto, PlanoContaImpostoFolha planoImposto, MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh, Double valorBase, Boolean acumulaValorLanc, HashMapTotalizadoresMovimentos hashTotalizadores) throws ExceptionValidacaoDados, ExceptionPlanoContaEventoNotFound {
        if (planoImposto.getIncideImpostoGuiInss() != null && planoImposto.getIncideImpostoGuiInss().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            if (this.validarPlanoContaImposto(planoImposto.getPlanoCGInssRat(), planoImposto.getHistoricoInssRat(), centroCusto, "RAT", planoImposto.getIdentificador()).booleanValue()) {
                Double valor = this.getValorLancamentoRAT(empresaRh, mov, hashTotalizadores, valorBase, acumulaValorLanc);
                return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valor, planoImposto.getHistoricoInssRat().getDescricao(), centroCusto, planoImposto.getPlanoCGInssRat(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            }
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.014", new Object[]{centroCusto.getNome().toUpperCase()});
        }
        return null;
    }

    Double calculoValorInss(EmpresaRh empresaRh, Double valorBase) {
        return ToolFormatter.arrredondarNumero((Double)(valorBase * (empresaRh.getPercEmpresa() / 100.0)), (int)2);
    }

    Double calculoValorInssComDesoneracao(MovimentoFolha mov, EmpresaRh empresaRh, Double valorBase) {
        Double percDesoneracao = this.getPercDesoneracao(mov.getAberturaPeriodo());
        Double valor = this.calculoValorInss(empresaRh, valorBase);
        valor = ToolFormatter.arrredondarNumero((Double)(valor - ToolFormatter.arrredondarNumero((Double)(valor / 100.0 * percDesoneracao), (int)2)), (int)2);
        return valor;
    }

    LancamentoCtbGerencial calculoLancamentoInssEmpresa(CentroCusto centroCusto, PlanoContaImpostoFolha planoImposto, MovimentoFolha mov, IntegracaoMovimentoFolha integracao, EmpresaRh empresaRh, Double valorBase) throws ExceptionPlanoContaEventoNotFound, ExceptionValidacaoDados {
        if (!this.isAffimative(empresaRh.getPossuiDesoneracao())) {
            if (this.validarPlanoContaImposto(planoImposto.getPlanoCGInssEmpresa(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "INSS EMPRESA", planoImposto.getIdentificador()).booleanValue()) {
                Double valor = this.calculoValorInss(empresaRh, valorBase);
                return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valor, planoImposto.getHistoricoInssEmpresa().getDescricao(), centroCusto, planoImposto.getPlanoCGInssEmpresa(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            }
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.017", new Object[]{centroCusto.getNome().toUpperCase()});
        }
        if (this.validarPlanoContaImposto(planoImposto.getPlanoCGInssEmpresa(), planoImposto.getHistoricoInssEmpresa(), centroCusto, "INSS EMPRESA", planoImposto.getIdentificador()).booleanValue()) {
            Double valor = this.calculoValorInssComDesoneracao(mov, empresaRh, valorBase);
            if (valor > 0.0) {
                return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valor, planoImposto.getHistoricoInssEmpresa().getDescricao(), centroCusto, planoImposto.getPlanoCGInssEmpresa(), mov.getAberturaPeriodo().getDataFinal(), integracao.getDataAtualizacao(), integracao.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
            }
        } else {
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.017", new Object[]{centroCusto.getNome().toUpperCase()});
        }
        return null;
    }

    Double getPercDesoneracao(AberturaPeriodo aberturaPeriodo) {
        Double percDesoneracao = this.serviceCalculoInssEmpresa.getPercDesoneracao(aberturaPeriodo);
        if (percDesoneracao == null || percDesoneracao <= 0.0) {
            return 0.0;
        }
        return percDesoneracao;
    }

    PlanoContaImpostoFolha getPlanoContaProvisao(MovimentoFolha mov) throws ExceptionPlanoContaEventoNotFound {
        List<PlanoContaImpostoFolha> ret = this.servicePlanoContaImpostoFolha.getPlanoContaImpostoProvisao(mov.getColaborador().getCentroCusto());
        if (ret.size() > 1) {
            StringBuilder identificadores = new StringBuilder();
            for (PlanoContaImpostoFolha p : ret) {
                identificadores.append(" ").append(p.getIdentificador().toString()).append(";");
            }
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.008", new Object[]{mov.getColaborador().getCentroCusto().getNome(), identificadores.toString()});
        }
        if (ret.isEmpty()) {
            throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.009", new Object[]{mov.getColaborador().getCentroCusto().getNome()});
        }
        return ret.get(0);
    }

    LancamentoCtbGerencial valorProvisaoFerias(MovimentoFolha mov) throws ExceptionPlanoContaEventoNotFound {
        Double valorProvisaoMensal = this.serviceItemProvisaoFerias.getVlrMensalColaboradorNoPeriodo(mov.getColaborador(), mov.getAberturaPeriodo().getDataFinal());
        if (valorProvisaoMensal != null && valorProvisaoMensal > 0.0) {
            PlanoContaImpostoFolha p = this.getPlanoContaProvisao(mov);
            if (p.getPlanoCGFeriasProv() == null || p.getHistoricoFeriasProv() == null) {
                throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.011", new Object[]{mov.getColaborador().getCentroCusto().getNome(), p.getIdentificador()});
            }
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valorProvisaoMensal, p.getHistoricoFeriasProv().getDescricao(), mov.getColaborador().getCentroCusto(), p.getPlanoCGFeriasProv(), mov.getAberturaPeriodo().getDataFinal(), mov.getDataAtualizacao(), mov.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        return null;
    }

    LancamentoCtbGerencial valorProvisaoDecimoTerceiro(MovimentoFolha mov) throws ExceptionPlanoContaEventoNotFound {
        Double valorProvisaoDec = this.serviceItemProvisaoDec.getVlrMensalColaboradorNoPeriodo(mov.getColaborador(), mov.getAberturaPeriodo().getDataFinal());
        if (valorProvisaoDec != null && valorProvisaoDec > 0.0) {
            PlanoContaImpostoFolha p = this.getPlanoContaProvisao(mov);
            if (p.getPlanoCGDecSalarioProv() == null || p.getHistoricoDecSalarioProv() == null) {
                throw new ExceptionPlanoContaEventoNotFound("E.ERP.1096.010", new Object[]{mov.getColaborador().getCentroCusto().getNome(), p.getIdentificador()});
            }
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valorProvisaoDec, p.getHistoricoDecSalarioProv().getDescricao(), mov.getColaborador().getCentroCusto(), p.getPlanoCGDecSalarioProv(), mov.getAberturaPeriodo().getDataFinal(), mov.getDataAtualizacao(), mov.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        return null;
    }
}

