/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.IntegracaoMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovCentroCustoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.ParametrizacaoContabilizacaoFolha;
import com.touchcomp.basementor.model.vo.PlanoContaImpostoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.CompBaseLancMovimentoFolha;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.util.HashMapTotalizadoresImposto;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.movimentofolha.util.HashMapTotalizadoresPagamento;
import com.touchcomp.basementorservice.service.impl.parametrizacaocontabilizacaofolha.ServiceParametrizacaoContabilizacaoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.planocontaimpostofolha.ServicePlanoContaImpostoFolhaImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoGerencialMovimentoFolha
extends CompBaseLancMovimentoFolha {
    @Autowired
    ServiceParametrizacaoContabilizacaoFolhaImpl serviceParametrizacaoContabilizacaoFolha;
    @Autowired
    ServicePlanoContaImpostoFolhaImpl servicePlanoContaImpostoFolha;

    public void gerarLancamentoGerencialIntegracaoMovFolha(MovimentoFolha mov, IntegracaoMovimentoFolha integracaoFolha) throws ExceptionValidacaoDados {
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        List<ItemMovCentroCustoColaborador> itens = this.getItensAlocacaoFolha(mov);
        TipoCalculo tipoFolha = mov.getAberturaPeriodo().getTipoCalculo();
        TipoColaborador tipoColaborador = mov.getColaborador().getTipoColaborador();
        CentroCusto centroCusto = mov.getColaborador().getCentroCusto();
        HashMapTotalizadoresPagamento hashTotalPagamento = new HashMapTotalizadoresPagamento();
        HashMapTotalizadoresImposto totalizadoresImpostos = new HashMapTotalizadoresImposto();
        Double diasMes = this.getDiasMes(mov);
        Double diasAlocadoAcumulado = this.getDiasAlocadoAcumulado(itens, mov, diasMes);
        if (diasMes == 0.0) {
            diasMes = 30.0;
        }
        if (diasAlocadoAcumulado < diasMes) {
            itens.add(this.getItemMovCentroCustoColaborador(centroCusto, mov, diasMes, diasAlocadoAcumulado));
        }
        Iterator<ItemMovCentroCustoColaborador> iterator = itens.iterator();
        while (iterator.hasNext()) {
            ItemMovCentroCustoColaborador item = iterator.next();
            for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
                TipoCalculoEvento tipoCalculoEvento = itemFolha.getEventoColaborador().getTipoCalculoEvento();
                ParametrizacaoContabilizacaoFolha p = this.getParametrizacaoContabilizacaoFolha(centroCusto, tipoCalculoEvento, tipoColaborador, tipoFolha);
                if (p.getPlanoContaGerencial() == null) {
                    throw new ExceptionValidacaoDados("E.ERP.1096.005", new Object[]{centroCusto.getNome(), tipoCalculoEvento.getEvento().getDescricao(), tipoColaborador.getDescricao(), tipoFolha.getDescricao(), p.getIdentificador()});
                }
                LancamentoCtbGerencial lanc = this.getLancamentoMovimentoFolha(itemFolha, centroCusto, p, integracaoFolha, hashTotalPagamento, iterator.hasNext(), diasMes, item.getNrDiasAlocado());
                if (lanc == null) continue;
                lancs.add(lanc);
            }
            TipoCalculo tipoCalculo = mov.getAberturaPeriodo().getTipoCalculo();
            PlanoContaImpostoFolha planoImposto = this.getPlanoContaImpostoFolha(centroCusto, mov, tipoCalculo);
            LancamentoCtbGerencial l = this.getLancamentoValorFgts(integracaoFolha, centroCusto, mov, planoImposto, diasMes, item.getNrDiasAlocado(), totalizadoresImpostos, iterator.hasNext());
            if (l != null) {
                lancs.add(l);
            }
            if ((l = this.getLancamentoValorInss(integracaoFolha, centroCusto, mov, planoImposto, diasMes, item.getNrDiasAlocado(), totalizadoresImpostos, iterator.hasNext())) != null) {
                lancs.add(l);
            }
            if ((l = this.getLancamentoValorIrrf(integracaoFolha, centroCusto, mov, planoImposto, diasMes, item.getNrDiasAlocado(), totalizadoresImpostos, iterator.hasNext())) == null) continue;
            lancs.add(l);
        }
        mov.setLancsGerenciais(this.getItensLancamentosGerenciais(lancs, mov));
    }

    LancamentoCtbGerencial getLancamentoMovimentoFolha(ItemMovimentoFolha itemFolha, CentroCusto centroCusto, ParametrizacaoContabilizacaoFolha p, IntegracaoMovimentoFolha integracaoFolha, HashMapTotalizadoresPagamento hashTotalPagamento, Boolean acumularVlr, Double diasMes, Double diasAlocado) {
        Short tipoLancamento = this.getTipoLancamento(itemFolha.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento());
        Double valorLancamento = this.getValorLancamentoMovFolha(itemFolha, diasMes, diasAlocado, hashTotalPagamento, acumularVlr);
        return this.criarLancamentoGerencial(tipoLancamento, valorLancamento, p.getHistorico().getDescricao(), centroCusto, p.getPlanoContaGerencial(), integracaoFolha.getAbertura().getDataFinal(), integracaoFolha.getDataAtualizacao(), integracaoFolha.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
    }

    Double getValorLancamentoMovFolha(ItemMovimentoFolha itemFolha, Double diasMes, Double diasAlocado, HashMapTotalizadoresPagamento hashTotalPagamento, Boolean acumularVlr) {
        Double valorLancamento = ToolFormatter.arrredondarNumero((Double)(itemFolha.getValor() / diasMes * diasAlocado), (int)2);
        if (!acumularVlr.booleanValue()) {
            valorLancamento = itemFolha.getValor() - hashTotalPagamento.getValorAcumulado(itemFolha.getEventoColaborador().getTipoCalculoEvento().getEvento());
        } else {
            hashTotalPagamento.updateValorLancamento(itemFolha.getEventoColaborador().getTipoCalculoEvento().getEvento(), valorLancamento);
        }
        return valorLancamento;
    }

    ParametrizacaoContabilizacaoFolha getParametrizacaoContabilizacaoFolha(CentroCusto centroCusto, TipoCalculoEvento tipoCalculoEvento, TipoColaborador tipoColaborador, TipoCalculo tipoFolha) throws ExceptionValidacaoDados {
        List<ParametrizacaoContabilizacaoFolha> ret = this.serviceParametrizacaoContabilizacaoFolha.findParamFolha(centroCusto, tipoColaborador, tipoFolha, tipoCalculoEvento);
        if (ret.size() > 1) {
            StringBuilder identificadores = new StringBuilder();
            for (ParametrizacaoContabilizacaoFolha p : ret) {
                identificadores.append(" ").append(p.getIdentificador().toString()).append(";");
            }
            throw new ExceptionValidacaoDados("E.ERP.1096.003", new Object[]{centroCusto.getNome(), tipoCalculoEvento.getEvento().getDescricao(), tipoColaborador.getDescricao(), tipoFolha.getDescricao(), identificadores.toString()});
        }
        if (ret.isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.1096.004", new Object[]{centroCusto.getNome(), tipoCalculoEvento.getEvento().getDescricao(), tipoColaborador.getDescricao(), tipoFolha.getDescricao()});
        }
        return ret.get(0);
    }

    PlanoContaImpostoFolha getPlanoContaImpostoFolha(CentroCusto centroCusto, MovimentoFolha mov, TipoCalculo tipoCalculo) throws ExceptionValidacaoDados {
        List<PlanoContaImpostoFolha> aux = this.servicePlanoContaImpostoFolha.findPlanoContaImpostoIrrf(mov.getColaborador().getCentroCusto(), tipoCalculo);
        if (aux.isEmpty()) {
            throw new ExceptionValidacaoDados("E.ERP.1096.006", new Object[]{centroCusto.getNome(), tipoCalculo.getDescricao()});
        }
        if (aux.size() > 1) {
            StringBuilder identificadores = new StringBuilder();
            for (PlanoContaImpostoFolha p : aux) {
                identificadores.append(" ").append(p.getIdentificador().toString()).append(";");
            }
            throw new ExceptionValidacaoDados("E.ERP.1096.007", new Object[]{centroCusto.getNome(), tipoCalculo.getDescricao(), identificadores.toString()});
        }
        return aux.get(0);
    }

    Double calculaTotalValorIrrf(MovimentoFolha mov) {
        Double valorIrrf = ToolFormatter.arrredondarNumero((Double)(mov.getVrIrrf13Sal() + mov.getVrIrrfFerias() + mov.getVrIrrfSalario()), (int)2);
        return valorIrrf;
    }

    Double calculaValorIrrf(Double valorIrrf, Double diasMes, Double diasAlocado) {
        Double valorIrrfLancamento = ToolFormatter.arrredondarNumero((Double)(valorIrrf / diasMes * diasAlocado), (int)2);
        return valorIrrfLancamento;
    }

    Double getValorIrrfLancamento(Double valorIrrf, Double diasMes, Double diasAlocado, HashMapTotalizadoresImposto totalizadoresImpostos, Boolean acumularVlr) {
        Double valorIrrfLancamento = this.calculaValorIrrf(valorIrrf, diasMes, diasAlocado);
        if (!acumularVlr.booleanValue()) {
            valorIrrfLancamento = valorIrrf - totalizadoresImpostos.getValorAcumuladoIrrf();
        } else {
            totalizadoresImpostos.updateValorAcumuladoIrrf(valorIrrfLancamento);
        }
        return valorIrrfLancamento;
    }

    LancamentoCtbGerencial getLancamentoValorIrrf(IntegracaoMovimentoFolha integracaoFolha, CentroCusto centroCusto, MovimentoFolha mov, PlanoContaImpostoFolha planoImposto, Double diasMes, Double diasAlocado, HashMapTotalizadoresImposto totalizadoresImpostos, Boolean acumularVlr) throws ExceptionValidacaoDados {
        Double valorIrrf = this.calculaTotalValorIrrf(mov);
        if (valorIrrf > 0.0 && this.validarPlanoContaImposto(planoImposto.getPlanoCGIrrfFolha(), planoImposto.getHistoricoIrrfFolha(), mov.getColaborador().getCentroCusto(), "IRRF", planoImposto.getIdentificador()).booleanValue()) {
            Double valorIrrfLancamento = this.getValorIrrfLancamento(valorIrrf, diasMes, diasAlocado, totalizadoresImpostos, acumularVlr);
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.CREDITO.getValue(), valorIrrfLancamento, planoImposto.getHistoricoIrrfFolha().getDescricao(), centroCusto, planoImposto.getPlanoCGIrrfFolha(), integracaoFolha.getAbertura().getDataFinal(), integracaoFolha.getDataAtualizacao(), integracaoFolha.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        return null;
    }

    Double calculaValorTotalInss(MovimentoFolha mov) {
        Double valorInss = ToolFormatter.arrredondarNumero((Double)(mov.getVrInss13Sal() + mov.getVrInssFerias() + mov.getVrInssSalario()), (int)2);
        return valorInss;
    }

    Double calculaValorInss(Double valorInss, Double diasMes, Double diasAlocado) {
        Double valorInssLancamento = ToolFormatter.arrredondarNumero((Double)(valorInss / diasMes * diasAlocado), (int)2);
        return valorInssLancamento;
    }

    Double getValorLancamentoInss(Double valorInss, Double diasMes, Double diasAlocado, Boolean acumularVlr, HashMapTotalizadoresImposto totalizadoresImpostos) {
        Double valorInssLancamento = this.calculaValorInss(valorInss, diasMes, diasAlocado);
        if (!acumularVlr.booleanValue()) {
            valorInssLancamento = valorInss - totalizadoresImpostos.getValorAcumuladoInss();
        } else {
            totalizadoresImpostos.updateValorAcumuladoInss(valorInssLancamento);
        }
        return valorInssLancamento;
    }

    LancamentoCtbGerencial getLancamentoValorInss(IntegracaoMovimentoFolha integracaoFolha, CentroCusto centroCusto, MovimentoFolha mov, PlanoContaImpostoFolha planoImposto, Double diasMes, Double diasAlocado, HashMapTotalizadoresImposto totalizadoresImpostos, Boolean acumularVlr) throws ExceptionValidacaoDados {
        Double valorInss = this.calculaValorTotalInss(mov);
        if (valorInss > 0.0 && this.validarPlanoContaImposto(planoImposto.getPlanoCGInssFolha(), planoImposto.getHistoricoInssFolha(), mov.getColaborador().getCentroCusto(), "INSS", planoImposto.getIdentificador()).booleanValue()) {
            Double valorInssLancamento = this.getValorLancamentoInss(valorInss, diasMes, diasAlocado, acumularVlr, totalizadoresImpostos);
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.CREDITO.getValue(), valorInssLancamento, planoImposto.getHistoricoInssFolha().getDescricao(), centroCusto, planoImposto.getPlanoCGInssFolha(), integracaoFolha.getAbertura().getDataFinal(), integracaoFolha.getDataAtualizacao(), integracaoFolha.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        return null;
    }

    Double calculaValorTotalFgts(MovimentoFolha mov) {
        Double valorFgts = ToolFormatter.arrredondarNumero((Double)(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()), (int)2);
        return valorFgts;
    }

    Double calculaValorFgts(Double valorFgts, Double diasMes, Double diasAlocado) {
        Double valorFgtsLancamento = ToolFormatter.arrredondarNumero((Double)(valorFgts / diasMes * diasAlocado), (int)2);
        return valorFgtsLancamento;
    }

    Double getValorFgtsLancamento(Double valorFgts, Double diasMes, Double diasAlocado, HashMapTotalizadoresImposto totalizadoresImpostos, Boolean acumularVlr) {
        Double valorFgtsLancamento = this.calculaValorFgts(valorFgts, diasMes, diasAlocado);
        if (!acumularVlr.booleanValue()) {
            valorFgtsLancamento = valorFgts - totalizadoresImpostos.getValorAcumuladoFgts();
        } else {
            totalizadoresImpostos.updateValorAcumuladoFgts(valorFgtsLancamento);
        }
        return valorFgtsLancamento;
    }

    LancamentoCtbGerencial getLancamentoValorFgts(IntegracaoMovimentoFolha integracaoFolha, CentroCusto centroCusto, MovimentoFolha mov, PlanoContaImpostoFolha planoImposto, Double diasMes, Double diasAlocado, HashMapTotalizadoresImposto totalizadoresImpostos, Boolean acumularVlr) throws ExceptionValidacaoDados {
        Double valorFgts = this.calculaValorTotalFgts(mov);
        if (valorFgts > 0.0 && this.validarPlanoContaImposto(planoImposto.getPlanoCGFgtsFolha(), planoImposto.getHistoricoFgtsFolha(), mov.getColaborador().getCentroCusto(), "FGTS", planoImposto.getIdentificador()).booleanValue()) {
            Double valorFgtsLancamento = this.getValorFgtsLancamento(valorFgts, diasMes, diasAlocado, totalizadoresImpostos, acumularVlr);
            return this.criarLancamentoGerencial(EnumLancamentoCTBGerencial.DEBITO.getValue(), valorFgtsLancamento, planoImposto.getHistoricoFgtsFolha().getDescricao(), centroCusto, planoImposto.getPlanoCGFgtsFolha(), integracaoFolha.getAbertura().getDataFinal(), integracaoFolha.getDataAtualizacao(), integracaoFolha.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue());
        }
        return null;
    }

    Short getTipoLancamento(Short tipoEvento) {
        if (this.isEquals(tipoEvento, EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) {
            return EnumLancamentoCTBGerencial.CREDITO.getValue();
        }
        return EnumLancamentoCTBGerencial.DEBITO.getValue();
    }
}

