/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.notapropria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class GerarLancCTBGerencialTitNotaPropria {
    public void criarLancamentosCTBGerencialNotaPropria(NotaFiscalPropria vo, List titulos, Empresa emp, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest, CentroCusto centroCusto) {
        HashMap pc = this.getPlanoContasNotaPropria(vo.getItensNotaPropria(), planoGerencialDescontosNaoDest, planoGerencialFreteNaoDest, planoGerencialSeguroNaoDest, planoGerencialDespAcesNaoDest);
        Double valorTotalTitulos = this.getValorTotalTitulos(titulos);
        this.setLancamentosValoresNaoDestacadosNotaPropria(titulos, vo.getItensNotaPropria(), emp, planoGerencialDescontosNaoDest, planoGerencialFreteNaoDest, planoGerencialSeguroNaoDest, planoGerencialDespAcesNaoDest, centroCusto);
        for (Object ob : titulos) {
            Titulo t = (Titulo)ob;
            Double valorAcumuladoNaoDestacado = this.getValoresLancamentosGerenciaisNaoDestacadoDesconto(t);
            Set keys = pc.keySet();
            List lanc = t.getLancCtbGerencial();
            int count = 0;
            double valorAcumulado = 0.0;
            for (Object o : keys) {
                if (o == null) continue;
                HashMap h = (HashMap)pc.get(o);
                Double valorTotal = (Double)h.get("valorTotal");
                Double valorDescontoNaoDest = (Double)h.get("valorDescontoNaoDest");
                Double valorFreteNaoDest = (Double)h.get("valorFreteNaoDest");
                Double valorSeguroNaoDest = (Double)h.get("valorSeguroNaoDest");
                Double valorDespNaoAcesNaoDest = (Double)h.get("valorDespAcesNaoDest");
                Double naoDestacado = Math.abs(valorFreteNaoDest + valorSeguroNaoDest + valorDespNaoAcesNaoDest - valorDescontoNaoDest) / (double)titulos.size();
                Double valorConta = valorTotal - naoDestacado;
                String historico = "Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                Double valorLanc = ToolFormatter.arrredondarNumero((Double)(t.getValor() / valorTotalTitulos * valorConta), (int)2);
                Double valorLancGer = 0.0;
                valorLancGer = count == pc.size() - 1 ? Double.valueOf(Math.abs(t.getValor() - valorAcumulado - naoDestacado)) : valorLanc;
                valorAcumulado += valorLanc.doubleValue();
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue(), emp, EnumConstantsMentorSimNao.NAO.getValue(), (String)(historico.length() > 500 ? historico.substring(0, 500) : historico), (PlanoContaGerencial)o, t.getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), null, valorLancGer, null);
                ++count;
                lanc.add(l);
            }
        }
    }

    private HashMap getPlanoContasNotaPropria(List<ItemNotaFiscalPropria> itensNota, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest) {
        HashMap<PlanoContaGerencial, HashMap> s = new HashMap<PlanoContaGerencial, HashMap>();
        for (ItemNotaFiscalPropria itemNotaPropria : itensNota) {
            HashMap h;
            Double vrDescontoNaoDest = 0.0;
            Double vrFreteNaoDest = 0.0;
            Double vrSeguroNaoDest = 0.0;
            Double vrDespAcesNaoDest = 0.0;
            Double valor = itemNotaPropria.getItemNotaLivroFiscal().getValorTotal();
            if (itemNotaPropria.getVrFreteNaoDest() != null && planoGerencialFreteNaoDest != null) {
                vrFreteNaoDest = itemNotaPropria.getVrFreteNaoDest();
            }
            if (itemNotaPropria.getVrSeguroNaoDest() != null && planoGerencialSeguroNaoDest != null) {
                vrSeguroNaoDest = itemNotaPropria.getVrSeguroNaoDest();
            }
            if (itemNotaPropria.getVrDespAcessoriaNaoDest() != null && planoGerencialDespAcesNaoDest != null) {
                vrDespAcesNaoDest = itemNotaPropria.getVrDespAcessoriaNaoDest();
            }
            if (itemNotaPropria.getVrDescontoNaoDest() != null && planoGerencialDescontosNaoDest != null) {
                vrDescontoNaoDest = itemNotaPropria.getVrDescontoNaoDest();
            }
            if (s.get(itemNotaPropria.getPlanoContaGerencial()) != null) {
                h = (HashMap)s.get(itemNotaPropria.getPlanoContaGerencial());
                h.put("valorTotal", (Double)h.get("valorTotal") + valor);
                h.put("valorDescontoNaoDest", (Double)h.get("valorDescontoNaoDest") + vrDescontoNaoDest);
                h.put("valorSeguroNaoDest", (Double)h.get("valorSeguroNaoDest") + vrSeguroNaoDest);
                h.put("valorFreteNaoDest", (Double)h.get("valorFreteNaoDest") + vrSeguroNaoDest);
                h.put("valorDespAcesNaoDest", (Double)h.get("valorDespAcesNaoDest") + vrDespAcesNaoDest);
                continue;
            }
            h = new HashMap();
            h.put("valorTotal", valor);
            h.put("valorDescontoNaoDest", vrDescontoNaoDest);
            h.put("valorSeguroNaoDest", vrSeguroNaoDest);
            h.put("valorFreteNaoDest", vrFreteNaoDest);
            h.put("valorDespAcesNaoDest", vrDespAcesNaoDest);
            s.put(itemNotaPropria.getPlanoContaGerencial(), h);
        }
        return s;
    }

    private void setLancamentosValoresNaoDestacadosNotaPropria(List titulos, List itensNotaPropria, Empresa emp, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest, CentroCusto centroCusto) {
        Double valorDescontoNaoDest = 0.0;
        Double valorFreteNaoDest = 0.0;
        Double valorSeguroNaoDest = 0.0;
        Double valorDespAcesNaoDest = 0.0;
        for (Object o : itensNotaPropria) {
            if (!(o instanceof ItemNotaFiscalPropria)) continue;
            ItemNotaFiscalPropria itemNotaPropria = (ItemNotaFiscalPropria)o;
            if (itemNotaPropria.getVrFreteNaoDest() != null) {
                valorFreteNaoDest = valorFreteNaoDest + itemNotaPropria.getVrFreteNaoDest();
            }
            if (itemNotaPropria.getVrSeguroNaoDest() != null) {
                valorSeguroNaoDest = valorSeguroNaoDest + itemNotaPropria.getVrSeguroNaoDest();
            }
            if (itemNotaPropria.getVrDespAcessoriaNaoDest() != null) {
                valorDespAcesNaoDest = valorDespAcesNaoDest + itemNotaPropria.getVrDespAcessoriaNaoDest();
            }
            if (itemNotaPropria.getVrDescontoNaoDest() == null) continue;
            valorDescontoNaoDest = valorDescontoNaoDest + itemNotaPropria.getVrDescontoNaoDest();
        }
        int qtdeTitulos = titulos.size();
        Double vrAcumuladoDesconto = 0.0;
        Double vrAcumuladoFrete = 0.0;
        Double vrAcumuladoSeguro = 0.0;
        Double vrAcumuladoDespAces = 0.0;
        int count = 1;
        for (Object o : titulos) {
            String historico;
            Double valorLanc;
            Titulo t = (Titulo)o;
            t.setLancCtbGerencial(new ArrayList());
            if (valorDescontoNaoDest > 0.0 && planoGerencialDescontosNaoDest != null) {
                valorLanc = ToolFormatter.arrredondarNumero((Double)(valorDescontoNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorDescontoNaoDest - vrAcumuladoDesconto);
                }
                vrAcumuladoDesconto = vrAcumuladoDesconto + valorLanc;
                historico = "Lancamento referente ao desconto nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialDescontosNaoDest, EnumLancamentoCTBGerencial.DEBITO.getValue(), centroCusto));
            }
            if (valorFreteNaoDest > 0.0 && planoGerencialFreteNaoDest != null) {
                valorLanc = ToolFormatter.arrredondarNumero((Double)(valorFreteNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorFreteNaoDest - vrAcumuladoFrete);
                }
                vrAcumuladoFrete = vrAcumuladoFrete + valorLanc;
                historico = "Lancamento referente ao frete nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialFreteNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            if (valorSeguroNaoDest > 0.0 && planoGerencialSeguroNaoDest != null) {
                valorLanc = ToolFormatter.arrredondarNumero((Double)(valorSeguroNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorSeguroNaoDest - vrAcumuladoSeguro);
                }
                vrAcumuladoSeguro = vrAcumuladoSeguro + valorLanc;
                historico = "Lancamento referente ao seguro nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialSeguroNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            if (valorDespAcesNaoDest > 0.0 && planoGerencialDespAcesNaoDest != null) {
                valorLanc = ToolFormatter.arrredondarNumero((Double)(valorDespAcesNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorDespAcesNaoDest - vrAcumuladoDespAces);
                }
                vrAcumuladoDespAces = vrAcumuladoDespAces + valorLanc;
                historico = "Lancamento referente a despesa acessoria nao destacada do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialDespAcesNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            ++count;
        }
    }

    private LancamentoCtbGerencial getLancamentoCtbGerencialValoresNaoDestacados(Titulo t, Double valor, String historico, Empresa emp, PlanoContaGerencial planoGerencial, Short debCred, CentroCusto centroCusto) {
        Short debCredGer = null;
        if (t.getPagRec() == 0 && debCred.equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.CREDITO.getValue();
        } else if (t.getPagRec() == 0 && debCred.equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.DEBITO.getValue();
        } else if (t.getPagRec() == 1 && debCred.equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.DEBITO.getValue();
        } else if (t.getPagRec() == 1 && debCred.equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.CREDITO.getValue();
        }
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), debCredGer, emp, EnumConstantsMentorSimNao.NAO.getValue(), historico, planoGerencial, t.getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), centroCusto, valor, null);
        return l;
    }

    private Double getValorTotalTitulos(List titulos) {
        Double valor = 0.0;
        for (Object o : titulos) {
            valor = valor + ((Titulo)o).getValor();
        }
        return valor;
    }

    private Double getValoresLancamentosGerenciaisNaoDestacadoDesconto(Titulo t) {
        Double valor = 0.0;
        for (LancamentoCtbGerencial l : t.getLancCtbGerencial()) {
            if (t.getPagRec().equals((short)0) && l.getDebCred().equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
                valor = valor + l.getValor();
                continue;
            }
            if (!t.getPagRec().equals((short)1) || !l.getDebCred().equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) continue;
            valor = valor + l.getValor();
        }
        return valor;
    }
}

