/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.requisicao;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoItem;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.BaseLancamentoCtbGer;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbrequisicao.ServiceParametrizacaoCtbRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.ValidGenericEntitiesImpl;
import com.touchcomp.basementorvalidator.entities.ValidMessages;
import com.touchcomp.basementorvalidator.entities.impl.integracaorequisicao.ValidIntegracaoRequisicao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoProdLancGer
extends BaseLancamentoCtbGer {
    @Autowired
    ServiceParametrizacaoCtbRequisicaoImpl serviceParamCtb;

    public void gerarLancamentosGerenciais(IntegracaoRequisicao integracao, List<ParametrizacaoCtbRequisicao> cache, ValidIntegracaoRequisicao validIntegracaoRequisicao, OpcoesGerenciais opGerenciais) {
        for (IntegracaoRequisicaoItem item : integracao.getItens()) {
            List<LancamentoCtbGerencial> lancs = new LinkedList<LancamentoCtbGerencial>();
            this.gerarLancamentosGerenciais(item, lancs, cache, integracao.getEmpresa(), validIntegracaoRequisicao, opGerenciais);
            if (!ToolMethods.isEquals((Object)integracao.getGerarLancAnalitico(), (Object)1)) {
                lancs = this.aglutinarLancamentos(lancs);
            }
            item.setLancamentosCtbGerencial(lancs);
        }
    }

    private void gerarLancamentosGerenciais(IntegracaoRequisicaoItem itemInteg, List<LancamentoCtbGerencial> lancamentos, List<ParametrizacaoCtbRequisicao> cache, Empresa emp, ValidIntegracaoRequisicao validIntegracaoRequisicao, OpcoesGerenciais opGereciais) {
        for (Requisicao vo : itemInteg.getRequisicoes()) {
            for (ItemRequisicao item : vo.getItensRequisicao()) {
                LancamentoCtbGerencial lanc;
                Double valorCusto = 0.0;
                valorCusto = item.getValorPrecoMedioCont() * item.getQuantidadeTotal();
                ParametrizacaoCtbRequisicao param = this.getParametrizacao(item, emp, cache, (ValidGenericEntitiesImpl)validIntegracaoRequisicao);
                if (param == null || (lanc = this.newLancamentoCtbGer(EnumLancamentoCTBGerencial.DEBITO.getValue(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, item.getCentroCusto(), vo.getDataRequisicao(), vo.getDataRequisicao(), param.getPlanoCtbGerencial(), vo.getEmpresa(), this.getHistorico(item, itemInteg), valorCusto, item.getIdentificador())) == null) continue;
                lanc.setTipoLancamento(opGereciais.getGerarLancamentosGerenciaisComo());
                lancamentos.add(lanc);
            }
        }
    }

    private String getHistorico(ItemRequisicao item, IntegracaoRequisicaoItem itemInteg) {
        if (ToolMethods.isEquals((Object)itemInteg.getIntegracaoRequisicao().getGerarLancAnalitico(), (Object)1)) {
            return MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0375.001", (Object[])new Object[]{item.getRequisicao().getIdentificador(), item.getProduto()});
        }
        return MessagesBaseMentor.getBaseHistoricoLancamentosGer((String)"DHISTGER.ERP.0375.002", (Object[])new Object[]{item.getRequisicao().getIdentificador()});
    }

    public ParametrizacaoCtbRequisicao getParametrizacao(ItemRequisicao itemRequisicao, Empresa empresa, List<ParametrizacaoCtbRequisicao> cache, ValidGenericEntitiesImpl validIntegracaoRequisicao) {
        if (itemRequisicao.getNaturezaRequisicao() == null) {
            validIntegracaoRequisicao.addWarn(new ValidMessages.Code("W.ERP.0375.002", new Object[]{itemRequisicao.getRequisicao()}), (Object)itemRequisicao);
            return null;
        }
        ParametrizacaoCtbRequisicao found = this.serviceParamCtb.get(empresa.getEmpresaDados().getGrupoEmpresa(), itemRequisicao.getProduto(), itemRequisicao.getNaturezaRequisicao(), cache);
        if (found == null) {
            validIntegracaoRequisicao.addError(new ValidMessages.Code("E.ERP.0375.001", new Object[]{empresa, itemRequisicao.getNaturezaRequisicao(), itemRequisicao.getProduto()}), cache);
        }
        return found;
    }
}

