/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lancamentomovimentobancario;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompLancamentoMovimentoBancario
extends CompLancamentoBase {
    public LoteContabil gerarLancamentos(IntegracaoMovBancarioMovimento vo) {
        if (vo == null) {
            return null;
        }
        LoteContabil lote = this.getLancamentosMovimentos(vo);
        if (lote != null && lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    Boolean isValid(MovimentoBancario vo) {
        if (vo.getGrupoDeBaixaFormas() != null) {
            return false;
        }
        if (ToolMethods.isAffirmative((Number)vo.getNaoContabilizarMov())) {
            return false;
        }
        return true;
    }

    private LoteContabil getLancamentosMovimentos(IntegracaoMovBancarioMovimento param) {
        MovimentoBancario vo = param.getMovimentoBancario();
        if (!this.isValid(vo).booleanValue()) {
            return null;
        }
        LoteContabil lote = this.criarLoteContabil(param.getLoteContabil(), vo.getDataLancamento(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.MOVIMENTO_BANCARIO);
        List<Lancamento> lancamentos = this.getLancamento(vo, lote);
        lote.getLancamentos().addAll(lancamentos);
        if (lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    Lancamento getLancamentoContraPart(ContraPartMovimentoBancario contra, LoteContabil lote, MovimentoBancario vo) {
        Lancamento lancamentoContra = null;
        if (contra.getPlanoConta() != null) {
            lancamentoContra = CompLancamentoBase.newLancamento(lote, vo.getEmpresa());
            if (contra.getDebCred().equals((short)1)) {
                lancamentoContra.setPlanoContaCred(contra.getPlanoConta());
            } else {
                lancamentoContra.setPlanoContaDeb(contra.getPlanoConta());
            }
            lancamentoContra.setHistoricoPadrao(contra.getHistoricoPadrao());
            lancamentoContra.setValor(contra.getValor());
            lancamentoContra.setHistorico(contra.getHistorico());
        }
        return lancamentoContra;
    }

    List<Lancamento> getLancamentosContraPart(MovimentoBancario vo, LoteContabil lote) {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        for (Object objContta : vo.getContraPartMovimentoBancario()) {
            Lancamento lancamentoContra = this.getLancamentoContraPart((ContraPartMovimentoBancario)objContta, lote, vo);
            if (lancamentoContra == null) continue;
            lancamentos.add(lancamentoContra);
        }
        return lancamentos;
    }

    Lancamento iniciaLancamento(MovimentoBancario vo, LoteContabil lote) {
        Lancamento lancamento = CompLancamentoBase.newLancamento(lote, vo.getEmpresa());
        lancamento.setHistoricoPadrao(vo.getHistoricoPadrao());
        lancamento.setValor(vo.getValor());
        lancamento.setHistorico(vo.getHistorico());
        if (vo.getCentroResultadoContFin() != null) {
            lancamento.setCentroResultadoContFin(vo.getCentroResultadoContFin());
        } else {
            lancamento.setCentroResultadoContFin(vo.getEmpresa().getEmpresaDados().getCentroResultadoContFin());
        }
        return lancamento;
    }

    List<Lancamento> getLancamento(MovimentoBancario vo, LoteContabil lote) {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (vo.getContaValor().getGerarLancamentoContabil() == 1) {
            Lancamento lancamento = this.iniciaLancamento(vo, lote);
            if (vo.getDebCred() == 0) {
                lancamento.setPlanoContaCred(vo.getContaValor().getPlanoConta());
                lancamentos.addAll(this.getLancamentosContraPart(vo, lote));
            } else {
                lancamento.setPlanoContaDeb(vo.getContaValor().getPlanoConta());
                lancamentos.addAll(this.getLancamentosContraPart(vo, lote));
            }
            if (lancamento.getPlanoContaCred() != null || lancamento.getPlanoContaDeb() != null) {
                lancamentos.add(lancamento);
            }
        }
        return lancamentos;
    }
}

