/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.livrofiscal;

import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class CompLivroFiscalBase
extends BaseMethods {
    protected LivroFiscal findLivro(List<LivroFiscal> livros, Cfop cfop, PlanoConta planoContaCred, IncidenciaIcms incidenciaIcms, IncidenciaIpi incidenciaIpi, Double aliquotaIcms, Double aliquotaIcmsProd, Date dataLivro, IncidenciaPisCofins incidenciaPis, IncidenciaPisCofins incidenciaCofins, Double aliquotaPis, Double aliquotaCofins, Double aliquotaPisQtde, Double aliquotaCofinsQtde) {
        Optional<LivroFiscal> found = livros.stream().filter(l -> ToolMethods.isEquals((Object)l.getCfop(), (Object)cfop) && ToolMethods.isEquals((Object)l.getCfop(), (Object)cfop) && ToolMethods.isEquals((Object)l.getPlanoConta(), (Object)planoContaCred) && ToolMethods.isEquals((Object)l.getIncidenciaIcms(), (Object)incidenciaIcms) && ToolMethods.isEquals((Object)l.getIncidenciaIpi(), (Object)incidenciaIpi) && ToolMethods.isEquals((Object)l.getAliquotaIcms(), (Object)aliquotaIcms) && ToolMethods.isEquals((Object)l.getAliqutoaIcmsProduto(), (Object)aliquotaIcmsProd) && ToolMethods.isEquals((Object)l.getDataLivro(), (Object)dataLivro) && ToolMethods.isEquals((Object)l.getIncidenciaPis(), (Object)incidenciaPis) && ToolMethods.isEquals((Object)l.getIncidenciaCofins(), (Object)incidenciaCofins) && ToolMethods.isEquals((Object)l.getAliquotaPis(), (Object)aliquotaPis) && ToolMethods.isEquals((Object)l.getAliquotaCofins(), (Object)aliquotaCofins) && ToolMethods.isEquals((Object)l.getAliquotaCofinsQtde(), (Object)aliquotaCofinsQtde) && ToolMethods.isEquals((Object)l.getAliquotaPisQtde(), (Object)aliquotaPisQtde)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    protected LivroFiscal novoLivro(Cfop cfop, PlanoConta planoContaCred, IncidenciaIcms incidenciaIcms, IncidenciaIpi incidenciaIpi, Double aliquotaIcms, Double aliquotaIcmsProd, Date dataLivro, IncidenciaPisCofins incidenciaPis, IncidenciaPisCofins incidenciaCofins, Double aliquotaPis, Double aliquotaCofins, Double aliquotaPisQtde, Double aliquotaCofinsQtde, Empresa emp, Short entSai) {
        LivroFiscal lv = new LivroFiscal(cfop, planoContaCred, incidenciaIcms, incidenciaIpi, aliquotaIcms, aliquotaIcmsProd, dataLivro, incidenciaPis, incidenciaCofins, aliquotaPis, aliquotaCofins, aliquotaPisQtde, aliquotaCofinsQtde);
        lv.setEmpresa(emp);
        lv.setUf(emp.getPessoa().getEndereco().getCidade().getUf());
        lv.setCidade(emp.getPessoa().getEndereco().getCidade());
        lv.setEntradaSaidaNaturezaOp(entSai);
        return lv;
    }

    protected boolean gerarLivros(ModeloDocFiscal modeloDocFiscal, SituacaoDocumento situacaoDocumento, List<NFCeItem> itens, List<LivroFiscal> livros) {
        if (modeloDocFiscal == null) {
            livros.clear();
            return false;
        }
        if (!ToolMethods.isEquals((Object)modeloDocFiscal.getGeraLivroFiscal(), (Object)1)) {
            livros.clear();
            return false;
        }
        if (itens == null) {
            livros.clear();
            return false;
        }
        if (situacaoDocumento == null) {
            livros.clear();
            return false;
        }
        EnumConstSituacaoDocumento sit = EnumConstSituacaoDocumento.get((Object)situacaoDocumento.getCodigo());
        if (sit.isCanceladoDenegado()) {
            livros.clear();
            return false;
        }
        return true;
    }

    protected void zerarValoresLivros(List<LivroFiscal> livros) {
        for (LivroFiscal lv : livros) {
            lv.setValorIcmsTributado(Double.valueOf(0.0));
            lv.setValorIcmsIsento(Double.valueOf(0.0));
            lv.setValorIcmsOutros(Double.valueOf(0.0));
            lv.setValorIcms(Double.valueOf(0.0));
            lv.setValorIcmsSemAprov(Double.valueOf(0.0));
            lv.setValorBCIcmsSt(Double.valueOf(0.0));
            lv.setValorIcmsSt(Double.valueOf(0.0));
            lv.setValorIpiTributado(Double.valueOf(0.0));
            lv.setValorIpiIsento(Double.valueOf(0.0));
            lv.setValorIpiOutros(Double.valueOf(0.0));
            lv.setValorIpiIndustria(Double.valueOf(0.0));
            lv.setValorIpiComercio(Double.valueOf(0.0));
            lv.setValorIpiObservacao(Double.valueOf(0.0));
            lv.setValorInss(Double.valueOf(0.0));
            lv.setValorIrrf(Double.valueOf(0.0));
            lv.setValorIss(Double.valueOf(0.0));
            lv.setValorLei10833(Double.valueOf(0.0));
            lv.setValorOutros(Double.valueOf(0.0));
            lv.setValorFunrural(Double.valueOf(0.0));
            lv.setValorTotal(Double.valueOf(0.0));
            lv.setValorPis(Double.valueOf(0.0));
            lv.setValorCofins(Double.valueOf(0.0));
            lv.setValorContSocial(Double.valueOf(0.0));
            lv.setValorDifAliquota(Double.valueOf(0.0));
            lv.setValorSestSenat(Double.valueOf(0.0));
            lv.setVrNaoTribIcms(Double.valueOf(0.0));
            lv.setValorFreteIcmsST(Double.valueOf(0.0));
            lv.setVrBCCofins(Double.valueOf(0.0));
            lv.setVrBCPis(Double.valueOf(0.0));
            lv.setVrCustoICMSST(Double.valueOf(0.0));
            lv.setVrBCCustoICMSST(Double.valueOf(0.0));
            lv.setValorIcmsPartilhaDest(Double.valueOf(0.0));
            lv.setValorIcmsPartilhaRem(Double.valueOf(0.0));
            lv.setValorFundoPobreza(Double.valueOf(0.0));
            lv.setValorIcmsDesonerado(Double.valueOf(0.0));
            lv.setValorFCP(Double.valueOf(0.0));
            lv.setValorFCPSt(Double.valueOf(0.0));
            lv.setValorFCPStRetido(Double.valueOf(0.0));
            lv.setValorIpiDevolucao(Double.valueOf(0.0));
            lv.setValorIcmsDiferimento(Double.valueOf(0.0));
        }
    }

    protected double format(Double d) {
        if (d == null) {
            d = 0.0;
        }
        return ToolFormatter.arrredondarNumero((Double)d, (int)2);
    }

    protected void updateLivros(List<LivroFiscal> livrosOld, List<LivroFiscal> livros) {
        if (livrosOld != null && !livrosOld.isEmpty()) {
            for (LivroFiscal lvNew : livros) {
                int index = livrosOld.indexOf(lvNew);
                if (index <= -1) continue;
                LivroFiscal lvOld = livrosOld.get(index);
                lvNew.setIdentificador(lvOld.getIdentificador());
                lvNew.setObsLivroFiscal(lvOld.getObsLivroFiscal());
                if (lvNew.getObsLivroFiscal() == null) continue;
                for (ObservacaoLivroFiscal os : lvNew.getObsLivroFiscal()) {
                    os.setLivroFiscal(lvNew);
                }
            }
        }
    }
}

