/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.livrofiscal.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.impl.LivroFiscalItem;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.livrofiscal.CompLivroFiscalBase;
import com.touchcomp.basementorservice.components.notapropria.ajustes.CompAjustesIcmsDocFiscalNotaPropria;
import com.touchcomp.basementorservice.components.totalizadores.CompTotalizadores;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLivroFiscalNotaPropria
extends CompLivroFiscalBase {
    @Autowired
    private CompTotalizadores compTotalizadores;
    @Autowired
    private CompAjustesIcmsDocFiscalNotaPropria compAjustesIcmsDocFiscalNotaPropria;

    public void regerarLivrosFiscaisNotasProprias(NotaFiscalPropria n) throws ExceptionAvaliadorExpressoes {
        this.compTotalizadores.calculaTotalizadores(n);
        if (ToolMethods.isWithData((Collection)n.getLivrosFiscais())) {
            n.getLivrosFiscais().clear();
        }
        List<LivroFiscal> livros = this.getLivroFiscaisResumo(n.getItensNotaPropria(), n.getLivrosFiscais(), n.getModeloDocFiscal(), n.getSituacaoDocumento());
        n.setLivrosFiscais(livros);
    }

    public List<LivroFiscal> getLivroFiscaisResumo(List<ItemNotaFiscalPropria> itens, List livrosOld, ModeloDocFiscal modeloDocFiscal, SituacaoDocumento situacaoDoc) throws ExceptionAvaliadorExpressoes {
        if (modeloDocFiscal == null) {
            return new ArrayList<LivroFiscal>();
        }
        if (itens == null || modeloDocFiscal.getGeraLivroFiscal() != null && !modeloDocFiscal.getGeraLivroFiscal().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            return new ArrayList<LivroFiscal>();
        }
        ArrayList<LivroFiscal> livros = new ArrayList<LivroFiscal>();
        Boolean achou = false;
        HashMap<LivroFiscal, LivroFiscalItem> h = new HashMap<LivroFiscal, LivroFiscalItem>();
        for (ItemNotaFiscalPropria n : itens) {
            Date date = n.getNotaFiscalPropria().getDataEmissaoNota();
            PlanoConta planoConta = n.getPlanoContaCred();
            LivroFiscal lv = new LivroFiscal(n.getItemNotaLivroFiscal().getCfop(), planoConta, n.getIncidenciaIcms(), n.getIncidenciaIpi(), n.getItemNotaLivroFiscal().getAliquotaIcms(), n.getProduto().getAliquotaIcms(), n.getNotaFiscalPropria() != null ? date : new Date(), n.getIncidenciaPisCofins(), n.getIncidenciaPisCofins(), n.getItemNotaLivroFiscal().getAliquotaPis(), n.getItemNotaLivroFiscal().getAliquotaCofins(), n.getItemNotaLivroFiscal().getAliquotaPisQtde(), n.getItemNotaLivroFiscal().getAliquotaCofinsQtde());
            Integer aux = livros.indexOf(lv);
            if (aux > -1) {
                lv = (LivroFiscal)livros.get(aux);
                achou = true;
                if (h.get(lv) != null) {
                    LivroFiscalItem itemLivroItem = (LivroFiscalItem)h.get(lv);
                    itemLivroItem.getItensNotaPopria().add(n);
                    h.put(lv, itemLivroItem);
                }
            }
            this.build(lv, n, situacaoDoc);
            if (!achou.booleanValue()) {
                livros.add(lv);
                LivroFiscalItem l = new LivroFiscalItem();
                l.setLivroFiscal(lv);
                l.getItensNotaPopria().add(n);
                h.put(lv, l);
            }
            achou = false;
        }
        ArrayList<LivroFiscalItem> lista = new ArrayList<LivroFiscalItem>();
        for (Object e : livros) {
            LivroFiscal lvf = (LivroFiscal)e;
            LivroFiscalItem livroItem = (LivroFiscalItem)h.get(lvf);
            if (livroItem == null) continue;
            lista.add(livroItem);
        }
        this.updateLivros(livrosOld, livros);
        this.compAjustesIcmsDocFiscalNotaPropria.gerarAjustesIcmsDocFiscal(lista);
        return livros;
    }

    void build(LivroFiscal lv, ItemNotaFiscalPropria n, SituacaoDocumento situacaoDoc) {
        ItemNotaLivroFiscal lf = n.getItemNotaLivroFiscal();
        lv.setValorFreteIcmsST(n.getItemNotaLivroFiscal().getFreteIcmsST());
        lv.setCancelado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        lv.setValorBCIcmsSt(Double.valueOf(lv.getValorBCIcmsSt() + lf.getVrBcCalculoIcmsSt()));
        lv.setValorIcms(ToolFormatter.arrredondarNumero((Double)(lv.getValorIcms() + lf.getVrIcms()), (int)2));
        lv.setValorIcmsIsento(Double.valueOf(lv.getValorIcmsIsento() + lf.getVrIcmsIsento()));
        lv.setValorIcmsOutros(Double.valueOf(lv.getValorIcmsOutros() + lf.getVrIcmsOutros()));
        lv.setValorIcmsSt(Double.valueOf(lv.getValorIcmsSt() + lf.getVrIcmsSt()));
        lv.setValorIcmsTributado(Double.valueOf(lv.getValorIcmsTributado() + lf.getVrIcmsTributado()));
        lv.setValorIcmsSemAprov(Double.valueOf(lv.getValorIcmsSemAprov() + lf.getVrIcmsSemAprov()));
        lv.setValorInss(Double.valueOf(lv.getValorInss() + lf.getVrInss()));
        lv.setValorIpiIndustria(Double.valueOf(lv.getValorIpiIndustria() + lf.getVrIpiIndustria()));
        lv.setValorIpiIsento(Double.valueOf(lv.getValorIpiIsento() + lf.getVrIpiIsento()));
        lv.setValorIpiOutros(Double.valueOf(lv.getValorIpiOutros() + lf.getVrIpiOutros()));
        lv.setValorIpiTributado(Double.valueOf(lv.getValorIpiTributado() + lf.getVrIpiTributado()));
        lv.setValorIpiComercio(Double.valueOf(lv.getValorIpiComercio() + lf.getVrIpiComercio()));
        lv.setValorIpiObservacao(Double.valueOf(lv.getValorIpiObservacao() + lf.getVrIpiObservacao()));
        lv.setValorIrrf(Double.valueOf(lv.getValorIrrf() + lf.getVrIrrf()));
        lv.setValorIss(Double.valueOf(lv.getValorIss() + lf.getVrIss()));
        lv.setValorLei10833(Double.valueOf(lv.getValorLei10833() + lf.getVrLei10833()));
        lv.setValorFunrural(Double.valueOf(lv.getValorFunrural() + lf.getVrFunrural()));
        lv.setValorOutros(Double.valueOf(lv.getValorOutros() + lf.getVrOutros()));
        lv.setValorTotal(ToolFormatter.arrredondarNumero((Double)(lv.getValorTotal() + lf.getValorTotal()), (int)2));
        lv.setVrBCCofins(Double.valueOf(lv.getVrBCCofins() + lf.getVrBCCofins()));
        lv.setVrBCPis(Double.valueOf(lv.getVrBCPis() + lf.getVrBCPis()));
        if (lv.getValorDifAliquota() == null) {
            lv.setValorDifAliquota(Double.valueOf(0.0));
        }
        lv.setValorDifAliquota(Double.valueOf(lv.getValorDifAliquota() + lf.getVrDifAliquota()));
        lv.setUfIcmsSt(lf.getUfIcmsSt());
        if (lv.getValorContSocial() == null) {
            lv.setValorContSocial(Double.valueOf(0.0));
        }
        if (lf.getVrContSoc() == null) {
            lf.setVrContSoc(Double.valueOf(0.0));
        }
        lv.setValorContSocial(Double.valueOf(lv.getValorContSocial() + lf.getVrContSoc()));
        if (lv.getValorCofins() == null) {
            lv.setValorCofins(Double.valueOf(0.0));
        }
        lv.setValorCofins(Double.valueOf(lv.getValorCofins() + lf.getVrCofins()));
        if (lv.getValorPis() == null) {
            lv.setValorPis(Double.valueOf(0.0));
        }
        lv.setValorPis(Double.valueOf(lv.getValorPis() + lf.getVrPis()));
        if (lf.getValorSestSenat() == null) {
            lf.setValorSestSenat(Double.valueOf(0.0));
        }
        lv.setValorSestSenat(Double.valueOf(lv.getValorSestSenat() + lf.getValorSestSenat()));
        if (lf.getVrNaoTribICMS() == null) {
            lf.setVrNaoTribICMS(Double.valueOf(0.0));
        }
        lv.setVrNaoTribIcms(Double.valueOf(lv.getVrNaoTribIcms() + lf.getVrNaoTribICMS()));
        if (n.getNotaFiscalPropria() != null) {
            lv.setEmpresa(n.getNotaFiscalPropria().getEmpresa());
            lv.setUf(n.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf());
            lv.setCidade(n.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade());
        }
        if (n.getNotaFiscalPropria() != null && n.getNotaFiscalPropria().getNaturezaOperacao() != null) {
            lv.setEntradaSaidaNaturezaOp(n.getNotaFiscalPropria().getNaturezaOperacao().getEntradaSaida());
        }
        if (n.getModeloFiscal() != null) {
            lv.setDescartarDapi(n.getModeloFiscal().getDescartarDapi());
        }
        if (situacaoDoc != null && situacaoDoc.getCodigo().equalsIgnoreCase(EnumConstSituacaoDocumento.CANCELADO.getValue())) {
            lv.setCancelado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        }
        lv.setVrBCCustoICMSST(Double.valueOf(lv.getVrBCCustoICMSST() + lf.getVrBCCustoICMSST()));
        lv.setVrCustoICMSST(Double.valueOf(lv.getVrCustoICMSST() + lf.getVrCustoICMSST()));
        lv.setValorIcmsPartilhaDest(Double.valueOf(lv.getValorIcmsPartilhaDest() + lf.getValorIcmsPartilhaDest()));
        lv.setValorIcmsPartilhaRem(Double.valueOf(lv.getValorIcmsPartilhaRem() + lf.getValorIcmsPartilhaRem()));
        lv.setValorFundoPobreza(Double.valueOf(lv.getValorFundoPobreza() + lf.getValorFundoPobreza()));
        lv.setValorFCP(Double.valueOf(lv.getValorFCP() + lf.getValorFCP()));
        lv.setAliquotaFCP(lf.getAliquotaFCP());
        lv.setValorFCPSt(Double.valueOf(lv.getValorFCPSt() + lf.getValorFCPSt()));
        lv.setAliquotaFCPSt(lf.getAliquotaFCPSt());
        lv.setValorFCPStRetido(Double.valueOf(lv.getValorFCPStRetido() + lf.getValorFCPStRetido()));
        lv.setAliquotaFCPStRetido(lf.getAliquotaFCPStRetido());
        lv.setValorIpiDevolucao(Double.valueOf(lv.getValorIpiDevolucao() + lf.getValorIpiDevolucao()));
        lv.setValorIcmsDiferimento(Double.valueOf(lv.getValorIcmsDiferimento() + lf.getValorIcmsDiferimento()));
        if (lf.getValorIcmsDiferimento() == null) {
            lf.setValorIcmsDiferimento(Double.valueOf(0.0));
        }
    }
}

