/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.logusuario;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.service.impl.hibernate.ServiceHibernateImpl;
import com.touchcomp.basementorservice.service.impl.logusuario.ServiceLogUsuarioImpl;
import com.touchcomp.basementortools.model.reflection.ClassInfo;
import com.touchcomp.basementortools.model.reflection.FieldClassInfo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.vo.logusuario.DTOLogUsuario;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLogUsuario {
    @Autowired
    ServiceLogUsuarioImpl serviceLog;
    @Autowired
    ServiceHibernateImpl serviceHibernate;

    public DTOLogUsuario buildLogs(String entidade, Serializable idObject) throws Exception {
        return this.buildLogs(entidade, idObject, 3);
    }

    public DTOLogUsuario buildLogs(String entidade, Serializable idObject, int profundidadeMax) throws Exception {
        Object entity = this.serviceLog.getEntity(entidade, idObject);
        return this.buildLogs(entity, profundidadeMax);
    }

    public DTOLogUsuario buildLogs(Object entity, int profundidadeMax) throws Exception {
        DTOLogUsuario dto = new DTOLogUsuario();
        dto.setEntityExists(entity != null);
        if (entity == null) {
            return dto;
        }
        dto.setEntityName(ToolReflections.getDescName(entity.getClass()));
        dto.setEntityClass(entity.getClass().getCanonicalName());
        dto.setIdentificador((Serializable)ToolReflections.getIdValueFromVOModel((Object)entity));
        dto.setEntityToString(String.valueOf(entity));
        List<ClassInfo> entitiesHibernate = this.serviceHibernate.getMappedClassInfo();
        LinkedList<DTOLogUsuario.DTOLogUsuarioObj> all = new LinkedList<DTOLogUsuario.DTOLogUsuarioObj>();
        this.buildFields(entity, dto.getEntityFields(), 0, profundidadeMax, entitiesHibernate, all);
        return dto;
    }

    private void buildFields(Object entity, List<DTOLogUsuario.DTOLogUsuarioObj> dto, int profundidade, int profundidadeMax, List<ClassInfo> entitiesHibernate, List<DTOLogUsuario.DTOLogUsuarioObj> all) throws Exception {
        if (entity == null) {
            return;
        }
        if (profundidade > profundidadeMax) {
            return;
        }
        List fields = ToolReflections.getFieldClass((String)entity.getClass().getCanonicalName());
        for (FieldClassInfo field : fields) {
            this.addFields(field, entity, dto, entitiesHibernate, profundidade, profundidadeMax, all);
        }
    }

    private void addFields(FieldClassInfo field, Object entity, List<DTOLogUsuario.DTOLogUsuarioObj> listDTO, List<ClassInfo> entitiesHibernate, int profundidade, int profundidadeMax, List<DTOLogUsuario.DTOLogUsuarioObj> all) throws ExceptionReflection, Exception {
        ++profundidade;
        if (this.isAndEntity(field.getFieldClassType(), entitiesHibernate)) {
            this.addField(field, entity, listDTO, entitiesHibernate, profundidade, profundidadeMax, all);
        }
        if (Collection.class.isAssignableFrom(field.getFieldClassType())) {
            this.addCollection(field, entity, listDTO, entitiesHibernate, profundidade, profundidadeMax, all);
        }
    }

    private DTOLogUsuario.DTOLogUsuarioObj buildAndAddObj(FieldClassInfo field, Object data, List<DTOLogUsuario.DTOLogUsuarioObj> dto, List<ClassInfo> entitiesHibernate, List<DTOLogUsuario.DTOLogUsuarioObj> all, boolean isCollection) throws ExceptionReflection {
        if (this.contains(all, field.getFieldName(), field.getFieldClass(), isCollection)) {
            return null;
        }
        DTOLogUsuario.DTOLogUsuarioObj aux = new DTOLogUsuario.DTOLogUsuarioObj();
        aux.setEntityName(field.getFieldName());
        aux.setCollection(isCollection);
        aux.setEntityClass(field.getFieldClass());
        if (data != null && this.isAndEntity(this.getEntityClass(data), entitiesHibernate)) {
            aux.setEntityClass(this.getEntityClass(data).getCanonicalName());
            aux.setEntityToString(String.valueOf(data));
            Class clazz = this.getEntityClass(data);
            Object id = ToolReflections.getFieldValueFromGetMethod((String)this.serviceHibernate.getIdProperty(clazz), (Object)data);
            aux.setIdentificador((Serializable)id);
        }
        dto.add(aux);
        all.add(aux);
        return aux;
    }

    private Class getEntityClass(Object data) {
        if (data instanceof HibernateProxy) {
            return ((HibernateProxy)data).getHibernateLazyInitializer().getPersistentClass();
        }
        return data.getClass();
    }

    private boolean isAndEntity(Class cl, List<ClassInfo> entitiesHibernate) {
        Optional<ClassInfo> found = entitiesHibernate.stream().filter(i -> ToolMethods.isEquals((Object)cl, (Object)i.getClassType())).findFirst();
        return found.isPresent();
    }

    private void addCollection(FieldClassInfo field, Object entity, List<DTOLogUsuario.DTOLogUsuarioObj> listDTO, List<ClassInfo> entitiesHibernate, int profundidade, int profundidadeMax, List<DTOLogUsuario.DTOLogUsuarioObj> all) throws Exception {
        Collection data = (Collection)ToolReflections.getFieldValueFromGetMethod((String)field.getFieldName(), (Object)entity);
        if (data == null || data.isEmpty()) {
            return;
        }
        DTOLogUsuario.DTOLogUsuarioObj tempList = this.buildAndAddObj(field, data, listDTO, entitiesHibernate, all, true);
        for (Object obj : data) {
            DTOLogUsuario.DTOLogUsuarioObj temp;
            if (obj == null || tempList == null || tempList.getEntityFields() == null || (temp = this.buildAndAddObj(field, obj, tempList.getEntityFields(), entitiesHibernate, all, false)) == null) continue;
            this.buildFields(obj, temp.getEntityFields(), profundidade, profundidadeMax, entitiesHibernate, all);
        }
    }

    private void addField(FieldClassInfo field, Object entity, List<DTOLogUsuario.DTOLogUsuarioObj> listDTO, List<ClassInfo> entitiesHibernate, int profundidade, int profundidadeMax, List<DTOLogUsuario.DTOLogUsuarioObj> all) throws Exception {
        DTOLogUsuario.DTOLogUsuarioObj temp;
        Object data = ToolReflections.getFieldValueFromGetMethod((String)field.getFieldName(), (Object)entity);
        if (data != null && (temp = this.buildAndAddObj(field, data, listDTO, entitiesHibernate, all, false)) != null) {
            this.buildFields(data, temp.getEntityFields(), profundidade, profundidadeMax, entitiesHibernate, all);
        }
    }

    private boolean contains(List<DTOLogUsuario.DTOLogUsuarioObj> all, String fieldName, String fieldClass, boolean isCollection) {
        for (DTOLogUsuario.DTOLogUsuarioObj dto : all) {
            if (!ToolMethods.isEquals((Object)dto.getEntityClass(), (Object)fieldClass) || !ToolMethods.isEquals((Object)dto.getEntityName(), (Object)fieldName) || !ToolMethods.isEquals((Object)dto.isCollection(), (Object)isCollection)) continue;
            return true;
        }
        return false;
    }
}

