/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.lotefabricacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.ServiceComunicadoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.gradeitemnotafiscalpropria.ServiceGradeItemNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.gradeitemnotaterceiros.ServiceGradeItemNotaTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.implantacaosaldos.ServiceImplantacaoSaldosImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRastreioLoteFabricacao {
    private ServiceRequisicaoImpl serviceRequisicao;
    private ServiceGradeItemNotaTerceirosImpl serviceGradeItemNotaTerceiros;
    private ServiceComunicadoProducaoImpl serviceComunicadoProducao;
    private ServiceImplantacaoSaldosImpl serviceImplantacaoSaldos;
    private ServiceGradeItemNotaFiscalPropriaImpl serviceGradeItemNotaFiscalPropria;

    @Autowired
    public CompRastreioLoteFabricacao(ServiceRequisicaoImpl serviceRequisicao, ServiceGradeItemNotaTerceirosImpl serviceGradeItemNotaTerceiros, ServiceComunicadoProducaoImpl serviceComunicadoProducao, ServiceImplantacaoSaldosImpl serviceImplantacaoSaldos, ServiceGradeItemNotaFiscalPropriaImpl serviceGradeItemNotaFiscalPropria) {
        this.serviceRequisicao = serviceRequisicao;
        this.serviceGradeItemNotaTerceiros = serviceGradeItemNotaTerceiros;
        this.serviceComunicadoProducao = serviceComunicadoProducao;
        this.serviceImplantacaoSaldos = serviceImplantacaoSaldos;
        this.serviceGradeItemNotaFiscalPropria = serviceGradeItemNotaFiscalPropria;
    }

    public List<DTORastreioLoteFabricacao> rastreabilidadeLoteFabricacao(Short filtrarData, Date dataInicial, Date dataFinal, List listLoteFabricacao, Short tipoEstoque, Short filtrarProduto, Long produtoInicial, Long produtoFinal) {
        return this.gerarRastLoteFaturamento(filtrarData, dataInicial, dataFinal, listLoteFabricacao, tipoEstoque, filtrarProduto, produtoInicial, produtoFinal);
    }

    public List<DTORastreioLoteFabricacao> rastreabilidadeLoteFabricacao(Long loteFabricacao) {
        ArrayList<Long> lotes = new ArrayList<Long>();
        lotes.add(loteFabricacao);
        return this.gerarRastLoteFaturamento(EnumConstantsMentorSimNao.NAO.getValue(), null, null, lotes, EnumConstantsMentorEntSaida.ENTRADAS_E_SAIDAS.getValue(), EnumConstantsMentorSimNao.NAO.getValue(), null, null);
    }

    private List<DTORastreioLoteFabricacao> gerarRastLoteFaturamento(Short filtrarData, Date dataInicial, Date dataFinal, List listLoteFabricacao, Short tipoEstoque, Short filtrarProduto, Long produtoInicial, Long produtoFinal) {
        ArrayList<DTORastreioLoteFabricacao> rastreabilidade = new ArrayList<DTORastreioLoteFabricacao>();
        if (!ToolMethods.isAffirmative((Number)filtrarData)) {
            dataInicial = null;
            dataFinal = null;
        }
        if (!ToolMethods.isAffirmative((Number)filtrarProduto)) {
            produtoInicial = null;
            produtoFinal = null;
        }
        if (ToolMethods.isEquals((Object)tipoEstoque, (Object)EnumConstantsMentorEntSaida.ENTRADA.getValue())) {
            rastreabilidade.addAll(this.getRastreabilidadeEntradas(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        } else if (ToolMethods.isEquals((Object)tipoEstoque, (Object)EnumConstantsMentorEntSaida.SAIDA.getValue())) {
            rastreabilidade.addAll(this.getRastreabilidadeSaidas(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        } else if (ToolMethods.isEquals((Object)tipoEstoque, (Object)EnumConstantsMentorEntSaida.ENTRADAS_E_SAIDAS.getValue())) {
            rastreabilidade.addAll(this.getRastreabilidadeEntradas(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
            rastreabilidade.addAll(this.getRastreabilidadeSaidas(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        }
        return rastreabilidade;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeEntradas(Date dataInicial, Date dataFinal, List listLoteFabricacao, Long produtoInicial, Long produtoFinal) {
        ArrayList<DTORastreioLoteFabricacao> entradas = new ArrayList<DTORastreioLoteFabricacao>();
        entradas.addAll(this.getRastreabilidadeNotaTerceiros(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        entradas.addAll(this.getRastreabilidadeComunicadoProducao(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        entradas.addAll(this.getRastreabilidadeImplantacaoSaldos(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        return entradas;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeSaidas(Date dataInicial, Date dataFinal, List listLoteFabricacao, Long produtoInicial, Long produtoFinal) {
        ArrayList<DTORastreioLoteFabricacao> saidas = new ArrayList<DTORastreioLoteFabricacao>();
        saidas.addAll(this.getRastreabilidadeNotaPropria(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        saidas.addAll(this.getRastreabilidadeRequisicao(dataInicial, dataFinal, listLoteFabricacao, produtoInicial, produtoFinal));
        return saidas;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeNotaTerceiros(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        List<DTORastreioLoteFabricacao> result = this.serviceGradeItemNotaTerceiros.rastreioLoteNotaTerceiros(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
        this.setTipoDoc(MessagesBaseMentor.getDefMsg((String)"notaFiscalTerceiros", (Object[])new Object[0]), EnumConstantsMentorEntSaida.ENTRADA, result);
        return result;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeRequisicao(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        List<DTORastreioLoteFabricacao> result = this.serviceRequisicao.rastreioLotesRequisicao(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
        this.setTipoDoc(MessagesBaseMentor.getDefMsg((String)"requisicao", (Object[])new Object[0]), EnumConstantsMentorEntSaida.SAIDA, result);
        return result;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeNotaPropria(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        List<DTORastreioLoteFabricacao> result = this.serviceGradeItemNotaFiscalPropria.rastreioLoteNotaPropria(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
        this.setTipoDoc(MessagesBaseMentor.getDefMsg((String)"notaFiscalPropria", (Object[])new Object[0]), EnumConstantsMentorEntSaida.SAIDA, result);
        return result;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeImplantacaoSaldos(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        List<DTORastreioLoteFabricacao> result = this.serviceImplantacaoSaldos.rastreioLoteImplantacaoSaldo(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
        this.setTipoDoc(MessagesBaseMentor.getDefMsg((String)"implantacaoSaldos", (Object[])new Object[0]), EnumConstantsMentorEntSaida.ENTRADA, result);
        return result;
    }

    private List<DTORastreioLoteFabricacao> getRastreabilidadeComunicadoProducao(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        List<DTORastreioLoteFabricacao> result = this.serviceComunicadoProducao.rastreioLoteComunicadoProducao(dataInicial, dataFinal, loteFabricacao, produtoInicial, produtoFinal);
        this.setTipoDoc(MessagesBaseMentor.getDefMsg((String)"comunicadoProducao", (Object[])new Object[0]), EnumConstantsMentorEntSaida.ENTRADA, result);
        return result;
    }

    private void setTipoDoc(String tipoDoc, EnumConstantsMentorEntSaida mov, List<DTORastreioLoteFabricacao> rastreios) {
        if (rastreios != null) {
            rastreios.forEach(i -> {
                i.setTipoDoc(tipoDoc);
                i.setEntradaSaida(Short.valueOf(mov.getValue()));
            });
        }
    }
}

