/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.materiaisplanejamentoproducao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstTipoAnalNecCompraSe;
import com.touchcomp.basementor.constants.enums.planejamentolinhaproducao.materiais.EnumTipoGrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GrupoPlanejamentoMateriaisLin;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemMaterialPlanejLin;
import com.touchcomp.basementor.model.vo.ItemPlanProducaoOSLinProd;
import com.touchcomp.basementor.model.vo.ItemPlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.ItemPlanejamentoProdLinProd;
import com.touchcomp.basementor.model.vo.NecessidadeProducao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanejProdLinProdPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoMateriaisProdLin;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.itemnotaterceiros.ServiceItemNotaTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.ordemcompra.ServiceOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceOrdemServicoProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceSubdivisaoOSProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Ceil;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Round;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompMateriaisPlanejamentoProducao
extends BaseMethods {
    @Autowired
    private ServiceOrdemServicoProdLinhaProdImpl serviceOrdemServicoProdLinhaProd;
    @Autowired
    private ServiceSubdivisaoOSProdLinhaProdImpl serviceSubdivisaoOSProdLinProd;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    private ServiceItemNotaTerceirosImpl serviceItemNotaTerc;
    @Autowired
    private ServiceOrdemCompraImpl serviceOrdemCompra;
    @Autowired
    private ServicePessoaImpl servicePessoa;
    private final short CALCULO_PREV_PROD_OS = 0;

    public List<PlanejProdLinProdPrevConsProd> calcularMaterialNecessarioSubOsAbertas(PlanejamentoProdLinhaProd planejProdLinha, Date dataConsulta, Empresa empresa) throws ExceptionInvalidData {
        return this.calcularMaterialNecessarioSubOsAbertas(EnumConstantsMentorSimNao.NAO.getValue(), null, null, EnumConstantsMentorSimNao.NAO.getValue(), null, null, dataConsulta, empresa, EnumConstantsMentorSimNao.NAO.getValue(), null, null, EnumConstantsMentorSimNao.NAO.getValue(), null, null, EnumConstantsMentorSimNao.NAO.getValue(), null, null, EnumConstantsMentorSimNao.NAO.getValue(), null, null, EnumConstantsMentorSimNao.NAO.getValue(), planejProdLinha.getPeriodoProducao().getIdentificador(), this.getOS(planejProdLinha), planejProdLinha.getListarPrevSomentePlan(), planejProdLinha);
    }

    private List<OrdemServicoProdLinhaProd> getOS(PlanejamentoProdLinhaProd planejProdLinha) {
        ArrayList<OrdemServicoProdLinhaProd> objects = new ArrayList<OrdemServicoProdLinhaProd>();
        Iterator iterator = planejProdLinha.getItemplanProdLinProd().iterator();
        while (iterator.hasNext()) {
            ItemPlanejamentoProdLinProd o;
            ItemPlanejamentoProdLinProd i = o = (ItemPlanejamentoProdLinProd)iterator.next();
            for (ItemPlanProducaoOSLinProd io : i.getItemPlanProducaoOS()) {
                if (!this.isNotNull(io.getOrdemServicoProdLinProd()).booleanValue()) continue;
                objects.add(io.getOrdemServicoProdLinProd());
            }
        }
        return objects;
    }

    public List<PlanejProdLinProdPrevConsProd> calcularMaterialNecessarioSubOsAbertas(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Date dataPosicao, Empresa empresa, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Short filtrarLocalizacao, Long localizacaoInicial, Long localizacaoFinal, Short exibirUltCompra, Long periodoProducao, List<OrdemServicoProdLinhaProd> osNaoSalva, Short calcularApenasPlanej, PlanejamentoProdLinhaProd pl) throws ExceptionInvalidData {
        List<Map<String, Object>> formProd = new LinkedList<Map<String, Object>>();
        List<Map<String, Object>> qtdPrevProd = new LinkedList<Map<String, Object>>();
        Short tipoRel = 1;
        if (!this.isAffimative(calcularApenasPlanej)) {
            if (!this.isAffimative(tipoRel)) {
                formProd = this.serviceOrdemServicoProdLinhaProd.getFormProdPOSLinha(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
                qtdPrevProd = this.serviceOrdemServicoProdLinhaProd.getPrevQtdProdFormProdPOSLinha(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
            } else {
                formProd = this.serviceSubdivisaoOSProdLinProd.getFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao, pl);
                qtdPrevProd = this.serviceSubdivisaoOSProdLinProd.getPrevQtdProdFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
            }
        }
        this.putOsNaoSalvas(osNaoSalva, formProd, tipoRel, calcularApenasPlanej);
        this.putQtdPrev(formProd, qtdPrevProd);
        if (this.isAffimative(exibirUltCompra)) {
            for (Map map : formProd) {
                this.putDadosUltCompraProduto(map);
                map.put("QUANTIDADE_COMPRADA", this.putQuantidadeCompradaProduto(map));
            }
        }
        return this.convertHashToObject(formProd, empresa, pl);
    }

    private void putOsNaoSalvas(List<OrdemServicoProdLinhaProd> osNaoSalva, List<Map<String, Object>> formProd, Short tipoRel, Short processarPlanejamento) throws ExceptionInvalidData {
        if (!CompMateriaisPlanejamentoProducao.isWithData(osNaoSalva)) {
            return;
        }
        for (OrdemServicoProdLinhaProd os : osNaoSalva) {
            if (this.isEquals(tipoRel, (short)0)) {
                this.putGradesTemporarias(os.getGradeFormulaProduto(), os.getQuantidadeRefPrevProd(), formProd, os);
                this.putProducaoProdutosTemporario(os.getGradeCor(), os.getQuantidadeRefPrevProd(), formProd);
                continue;
            }
            this.definirModeoFormProduto(os, formProd);
            for (SubdivisaoOSProdLinhaProd s : os.getSubDivisoesOS()) {
                this.putGradesTemporarias(s.getGradeFormulaProduto(), s.getQuantidadeRefPrevProd(), formProd, s.getOrdemServicoProdLinhaProd());
                this.putProducaoProdutosTemporario(s.getGradeCor(), s.getQuantidadeRefPrevProd(), formProd);
                for (NecessidadeProducao nec : s.getNecessidadesProducao()) {
                    this.putProducaoProdutosTemporario(nec.getGradeCor(), nec.getQuantidade(), formProd);
                }
            }
        }
    }

    private void putGradesTemporarias(GradeFormulaProduto gf, Double qtd, List<Map<String, Object>> formProd, OrdemServicoProdLinhaProd os) throws ExceptionInvalidData {
        if (this.isNull(gf).booleanValue()) {
            return;
        }
        for (ItemGradeFormulaProduto it : gf.getItemGradeFormulaProduto()) {
            Double calc;
            Map<String, Object> found = null;
            GradeCor gc = it.getGradeCor();
            for (Map<String, Object> h : formProd) {
                Long idParceiro = (Long)h.get("PARCEIRO");
                if (!this.isEquals(h.get("ID_GRADE_COR"), gc.getIdentificador()) || this.isNotNull(idParceiro) == null || !this.isNotNull(os.getPessoaParceiro()).booleanValue() || !this.isEquals(idParceiro, os.getPessoaParceiro().getIdentificador())) continue;
                found = h;
                break;
            }
            if (found == null) {
                found = this.serviceGradeCor.getMapDadosBaseGradeCor(gc);
                if (this.isNotNull(os.getPessoaParceiro()).booleanValue()) {
                    found.put("PARCEIRO", os.getPessoaParceiro().getIdentificador());
                }
                found.put("QUANTIDADE", 0.0);
                found.put("DESCRICAO_CALC", "");
                found.put("LIST_PRODUTOS", new ArrayList());
                formProd.add(found);
            }
            try {
                calc = (it.getPercAdicional() / 100.0 * it.getQuantidade() + it.getQuantidade()) * qtd;
            }
            catch (Exception ex) {
                throw new ExceptionInvalidData("E.ERP.2016.002", new Object[]{String.valueOf(it.getGradeCor().getProdutoGrade().getProduto()) + "/" + String.valueOf(it.getGradeFormulaProduto())});
            }
            calc = ToolNumber.asZeroIfNull((Double)calc);
            found.put("QUANTIDADE", (Double)found.get("QUANTIDADE") + calc);
            List listProdutos = (List)found.get("LIST_PRODUTOS");
            this.criarItemProdutosGradesTemporarias(listProdutos, it, calc, qtd);
            Object desc = (String)found.get("DESCRICAO_CALC");
            desc = (String)desc + "\n ";
            desc = (String)desc + " Prod: " + os.getGradeCor().getProdutoGrade().getProduto().getIdentificador();
            desc = (String)desc + " Form: " + gf.getIdentificador();
            desc = (String)desc + " Fator: " + ToolFormatter.formataNumero((Number)gf.getQuantidadeReferenciaProd(), (int)10);
            desc = (String)desc + " Qtd Form: " + ToolFormatter.formataNumero((Number)it.getQuantidade(), (int)6);
            desc = (String)desc + " % Adic: " + ToolFormatter.formataNumero((Number)it.getPercAdicional(), (int)6);
            desc = (String)desc + " Qtd OS: " + ToolFormatter.formataNumero((Number)qtd, (int)6);
            desc = (String)desc + " Calc: " + ToolFormatter.formataNumero((Number)calc, (int)6);
            found.put("DESCRICAO_CALC", desc);
        }
    }

    private void criarItemProdutosGradesTemporarias(List<Map<String, Object>> listProdutos, ItemGradeFormulaProduto it, Double calc, Double qtd) {
        Boolean b = true;
        for (Map<String, Object> h : listProdutos) {
            Double comprimento = (Double)h.get("COMPRIMENTO");
            Double altura = (Double)h.get("ALTURA");
            Double largura = (Double)h.get("LARGURA");
            if (!this.isEquals(comprimento, it.getComprimento()) || !this.isEquals(altura, it.getAltura()) || !this.isEquals(largura, it.getLargura())) continue;
            h.put("QUANTIDADE", (Double)h.get("QUANTIDADE") + calc);
            h.put("QTD_REFERENCIA", (Double)h.get("QTD_REFERENCIA") + qtd);
            b = false;
            break;
        }
        if (this.isEquals(b, Boolean.TRUE)) {
            HashMap<String, Double> ha = new HashMap<String, Double>();
            ha.put("QUANTIDADE", calc);
            ha.put("QTD_REFERENCIA", qtd);
            ha.put("COMPRIMENTO", it.getComprimento());
            ha.put("ALTURA", it.getAltura());
            ha.put("LARGURA", it.getLargura());
            ha.put("VOLUME", it.getVolume());
            listProdutos.add(ha);
        }
    }

    private void putProducaoProdutosTemporario(GradeCor gradeCor, Double quantidadePrevProd, List<Map<String, Object>> formProd) {
        for (Map<String, Object> h : formProd) {
            Long idGradeCor = (Long)h.get("ID_GRADE_COR");
            if (!this.isEquals(idGradeCor, gradeCor.getIdentificador())) continue;
            if (this.isNull(h.get("QTD_PREV_PRODUCAO")).booleanValue()) {
                h.put("QTD_PREV_PRODUCAO", 0.0);
            }
            h.put("QTD_PREV_PRODUCAO", (Double)h.get("QTD_PREV_PRODUCAO") + quantidadePrevProd);
        }
    }

    private void definirModeoFormProduto(OrdemServicoProdLinhaProd os, List<Map<String, Object>> formProd) {
        for (SubdivisaoOSProdLinhaProd subOs : os.getSubDivisoesOS()) {
            GradeFormulaProduto gf = subOs.getGradeFormulaProduto();
            for (ItemGradeFormulaProduto it : gf.getItemGradeFormulaProduto()) {
                Long idParceiro = 0L;
                Long idGradeCor = it.getGradeCor().getIdentificador();
                if (this.isNotNull(os.getPessoaParceiro()).booleanValue()) {
                    idParceiro = os.getPessoaParceiro().getIdentificador();
                }
                Long idParceiroF = idParceiro;
                Optional<Map> found = formProd.stream().filter(i -> TMethods.isEqualsNumber((Number)idGradeCor, (Number)((Number)i.get("ID_GRADE_COR"))) && TMethods.isEqualsNumber((Number)idParceiroF, (Number)((Number)i.get("PARCEIRO")))).findFirst();
                if (found.isPresent()) continue;
                Map<String, Object> hash = this.serviceGradeCor.getMapDadosBaseGradeCor(it.getGradeCor());
                if (os.getPessoaParceiro() != null) {
                    hash.put("PARCEIRO", idParceiro);
                }
                hash.put("QUANTIDADE", 0.0);
                hash.put("DESCRICAO_CALC", "");
                hash.put("LIST_PRODUTOS", new ArrayList());
                if (formProd.contains(hash)) continue;
                formProd.add(hash);
            }
        }
    }

    private void putQtdPrev(List<Map<String, Object>> formProd, List<Map<String, Object>> qtdPrevProd) {
        for (Map<String, Object> h : formProd) {
            Long idGrade = (Long)h.get("ID_GRADE_COR");
            Map<String, Object> hEst = null;
            for (Map<String, Object> auxH : qtdPrevProd) {
                Long idGradeEst = (Long)auxH.get("ID_GRADE_COR");
                if (this.isEquals(idGrade, idGradeEst)) {
                    hEst = auxH;
                    break;
                }
                hEst = null;
            }
            if (!this.isNotNull(hEst).booleanValue()) continue;
            qtdPrevProd.remove(hEst);
            h.putAll(hEst);
        }
    }

    private void setarParceiros(List<Map<String, Object>> formProd, Empresa empresa) {
        for (Map<String, Object> h : formProd) {
            Long idParceiro = (Long)h.get("PARCEIRO");
            if (!this.isNull(idParceiro).booleanValue()) continue;
            h.put("PARCEIRO", empresa.getPessoa().getIdentificador());
        }
    }

    private void putDadosUltCompraProduto(Map<String, Object> h) {
        List<Map<String, Object>> notas = this.serviceItemNotaTerc.findUltimasComprasProduto((Long)h.get("ID_GRADE_COR"));
        h.put("NOTAS_FISCAIS", notas);
        double vlr = 0.0;
        double contador = 0.0;
        for (Map<String, Object> map : notas) {
            Double vlrUnitario = (Double)map.get("VALOR_UNITARIO");
            vlr += vlrUnitario.doubleValue();
            contador += 1.0;
        }
        if (contador <= 0.0) {
            contador = 1.0;
        }
        h.put("VALOR_MEDIO", vlr / contador);
    }

    private Double putQuantidadeCompradaProduto(Map<String, Object> map) {
        List<Map<String, Object>> dadosCompra = this.serviceOrdemCompra.findQuantidadeCompradaItem((Long)map.get("ID_GRADE_COR"));
        Double total = 0.0;
        if (CompMateriaisPlanejamentoProducao.isWithData(dadosCompra)) {
            for (Map<String, Object> m : dadosCompra) {
                total = total + (Double)m.get("QUANTIDADE_COMPRADA") * (Double)m.get("FATOR_CONVERSAO");
            }
        }
        return total;
    }

    private HashMap buildParameters(String expressao, Double estoqueMinimo, Double estoqueMaximo, Double pontoRessuprimento, Double qtdeEstoque, Double qtdeFormulacao, Double qtdePrevistaProducao) {
        HashMap<String, String> m = new HashMap<String, String>();
        List token = ToolString.getReplaceTokens((String)expressao);
        for (StringToken sk : token) {
            String chave = sk.getChave();
            String valor = "0";
            switch (chave) {
                case "estoque": {
                    valor = qtdeEstoque.toString();
                    break;
                }
                case "estoque_maximo": {
                    valor = estoqueMaximo.toString();
                    break;
                }
                case "estoque_minimo": {
                    valor = estoqueMinimo.toString();
                    break;
                }
                case "ponto_ressuprimento": {
                    valor = pontoRessuprimento.toString();
                    break;
                }
                case "qtde_formulacao": {
                    valor = qtdeFormulacao.toString();
                    break;
                }
                case "qtde_prevista_producao": {
                    valor = qtdePrevistaProducao.toString();
                    break;
                }
            }
            m.put(chave, valor);
        }
        return m;
    }

    private Double getTotalFormulaCalculoQtdeProduzida(String expressao, Double estoqueMinimo, Double estoqueMaximo, Double pontoRessuprimento, Double qtdeEstoque, Double qtdeFormulacao, Double qtdePrevistaProducao) throws ExceptionInvalidData {
        HashMap m = this.buildParameters(expressao, estoqueMinimo, estoqueMaximo, pontoRessuprimento, qtdeEstoque, qtdeFormulacao, qtdePrevistaProducao);
        expressao = ToolString.build((String)expressao, (Map)m);
        JEP myParser = new JEP();
        myParser.addFunction("arredondar", (PostfixMathCommandI)new Round());
        myParser.addFunction("teto", (PostfixMathCommandI)new Ceil());
        myParser.addFunction("piso", (PostfixMathCommandI)new Floor());
        myParser.addFunction("abs", (PostfixMathCommandI)new Abs());
        try {
            Node node = myParser.parse(expressao);
            Double b = (Double)myParser.evaluate(node);
            return b;
        }
        catch (ParseException ex) {
            throw new ExceptionInvalidData("E.ERP.2016.004", new Object[]{expressao});
        }
    }

    private List<PlanejProdLinProdPrevConsProd> convertHashToObject(List<Map<String, Object>> formProd, Empresa emp, PlanejamentoProdLinhaProd pl) {
        LinkedList<PlanejProdLinProdPrevConsProd> ret = new LinkedList<PlanejProdLinProdPrevConsProd>();
        for (Map<String, Object> h : formProd) {
            PlanejProdLinProdPrevConsProd p = new PlanejProdLinProdPrevConsProd();
            Double qtd = (Double)h.get("QUANTIDADE");
            String descCalc = (String)h.get("DESCRICAO_CALC");
            Double qtdPrevProd = (Double)h.get("QTD_PREV_PRODUCAO");
            Double qtdMin = (Double)h.get("QTD_MIN");
            Double qtdRessuprimento = (Double)h.get("PTO_RESSUPRIMENTO");
            Double qtdMax = (Double)h.get("QTD_MAX");
            Double vlrPrecoMedio = (Double)h.get("VLR_PRECO_MEDIO");
            Long idGradeCor = (Long)h.get("ID_GRADE_COR");
            Long idParceiro = (Long)h.get("PARCEIRO");
            List notasFiscais = (List)h.get("NOTAS_FISCAIS");
            List listProdutos = (List)h.get("LIST_PRODUTOS");
            GradeCor gc = (GradeCor)this.serviceGradeCor.get(idGradeCor);
            p.setGradeCor(gc);
            if (this.isNotNull(idParceiro).booleanValue()) {
                p.setParceiro((Pessoa)this.servicePessoa.get(idParceiro));
            }
            p.setQuantidade(qtd);
            p.setQtdePrevProducao(ToolNumber.asZeroIfNull((Double)qtdPrevProd));
            p.setQtdeMin(ToolNumber.asZeroIfNull((Double)qtdMin));
            p.setQtdeMax(ToolNumber.asZeroIfNull((Double)qtdMax));
            p.setQtdeRessuprimento(ToolNumber.asZeroIfNull((Double)qtdRessuprimento));
            p.setVlrPrecoMedio(ToolNumber.asZeroIfNull((Double)vlrPrecoMedio));
            p.setObservacao(descCalc);
            if (this.isNotNull(notasFiscais).booleanValue()) {
                p.setNotasFiscais(notasFiscais.stream().map(m -> new HashMap(m)).collect(Collectors.toList()));
            } else {
                p.setNotasFiscais(new LinkedList());
            }
            if (this.isNotNull(listProdutos).booleanValue()) {
                for (Map ha : listProdutos) {
                    Double quantidade = (Double)ha.get("QUANTIDADE");
                    Double qtdReferencia = (Double)ha.get("QTD_REFERENCIA");
                    Double comprimento = (Double)ha.get("COMPRIMENTO");
                    Double altura = (Double)ha.get("ALTURA");
                    Double largura = (Double)ha.get("LARGURA");
                    Double volume = (Double)ha.get("VOLUME");
                    ItemPlanejProdLinProdPrevConsProd i = new ItemPlanejProdLinProdPrevConsProd();
                    i.setQuantidade(quantidade);
                    i.setQtdReferencia(qtdReferencia);
                    i.setComprimento(comprimento);
                    i.setAltura(altura);
                    i.setLargura(largura);
                    i.setVolume(volume);
                    i.setPlanejProdLinProdPrevConsProd(p);
                    p.getItemPlanejProdLinProdPrevConsProd().add(i);
                }
            }
            p.setPlanejamentoProdLinhaProd(pl);
            ret.add(p);
        }
        return ret;
    }

    public List<PlanejProdLinProdPrevConsProd> agruparMateriais(List<PlanejProdLinProdPrevConsProd> materiais, Empresa emp, OpcoesPCP opcoesPCP, Date dataPosicao) throws ExceptionInvalidData {
        HashMap<GradeCor, PlanejProdLinProdPrevConsProd> materiaisXplanej = new HashMap<GradeCor, PlanejProdLinProdPrevConsProd>();
        if (CompMateriaisPlanejamentoProducao.isWithData(materiais)) {
            ArrayList<SaldoEstoqueGeralBasico> saldosUtilizados = new ArrayList<SaldoEstoqueGeralBasico>();
            for (PlanejProdLinProdPrevConsProd pm : materiais) {
                SaldoEstoqueGeralBasico saldo = this.consultaEstoque(saldosUtilizados, pm, emp, dataPosicao);
                if (materiaisXplanej.containsKey(pm.getGradeCor())) {
                    PlanejProdLinProdPrevConsProd aux = (PlanejProdLinProdPrevConsProd)materiaisXplanej.get(pm.getGradeCor());
                    aux.setQtdePrevProducao(Double.valueOf(aux.getQtdePrevProducao() + pm.getQtdePrevProducao()));
                    this.processarQtdNecessaria(pm, saldo, opcoesPCP);
                    aux.setQuantidade(Double.valueOf(aux.getQuantidade() + pm.getQuantidade()));
                    aux.setQtdCompra(Double.valueOf(aux.getQtdCompra() + pm.getQtdCompra()));
                    aux.setQtdReserva(Double.valueOf(aux.getQtdReserva() + pm.getQtdReserva()));
                    if (TMethods.isWithData((Collection)pm.getItemPlanejProdLinProdPrevConsProd())) {
                        if (TMethods.isWithData((Collection)aux.getItemPlanejProdLinProdPrevConsProd())) {
                            ((ItemPlanejProdLinProdPrevConsProd)aux.getItemPlanejProdLinProdPrevConsProd().getFirst()).setQuantidade(Double.valueOf(ToolNumber.asZeroIfNull((Double)((ItemPlanejProdLinProdPrevConsProd)aux.getItemPlanejProdLinProdPrevConsProd().getFirst()).getQuantidade()) + ToolNumber.asZeroIfNull((Double)((ItemPlanejProdLinProdPrevConsProd)pm.getItemPlanejProdLinProdPrevConsProd().getFirst()).getQuantidade())));
                        } else {
                            aux.getItemPlanejProdLinProdPrevConsProd().addAll(pm.getItemPlanejProdLinProdPrevConsProd());
                        }
                    }
                    aux.getItemPlanejProdLinProdPrevConsProd().forEach(i -> i.setQtdReferencia(Double.valueOf(0.0)));
                    materiaisXplanej.put(pm.getGradeCor(), aux);
                    continue;
                }
                this.processarQtdNecessaria(pm, saldo, opcoesPCP);
                materiaisXplanej.put(pm.getGradeCor(), pm);
            }
        }
        return new LinkedList<PlanejProdLinProdPrevConsProd>(materiaisXplanej.values());
    }

    private Double getQuantidadeCompra(OpcoesPCP opcoesPCP, Double qtdMin, Double qtdMax, Double qtdPtoSup) {
        if (this.isEquals(opcoesPCP.getTipoAnalNecCompraLP(), EnumConstTipoAnalNecCompraSe.ESTOQUE_MAXIMO.getValue())) {
            return qtdMax;
        }
        if (this.isEquals(opcoesPCP.getTipoAnalNecCompraLP(), EnumConstTipoAnalNecCompraSe.ESTOQUE_MINIMO.getValue())) {
            return qtdMin;
        }
        return qtdPtoSup;
    }

    private void processarQtdNecessaria(PlanejProdLinProdPrevConsProd p, SaldoEstoqueGeralBasico saldoEstoque, OpcoesPCP opcoesPCP) throws ExceptionInvalidData {
        Double aux;
        Double qtdMax = ToolNumber.asZeroIfNull((Double)p.getQtdeMax());
        Double qtdMin = ToolNumber.asZeroIfNull((Double)p.getQtdeMin());
        Double qtdPtoSup = ToolNumber.asZeroIfNull((Double)p.getQtdeRessuprimento());
        Double qtd = ToolNumber.asZeroIfNull((Double)p.getQuantidade());
        Double qtdPrevProd = ToolNumber.asZeroIfNull((Double)p.getQtdePrevProducao());
        Double saldoQtd = saldoEstoque != null ? ToolNumber.asZeroIfNull((Double)saldoEstoque.getQuantidade()) : 0.0;
        Double qtdAnalCompra = this.getQuantidadeCompra(opcoesPCP, qtdMin, qtdMax, qtdPtoSup);
        String formula = opcoesPCP.getFormulaCalculoPrevisaoConsumo();
        if (formula != null && !formula.isEmpty()) {
            aux = this.getTotalFormulaCalculoQtdeProduzida(formula, qtdMin, qtdMax, qtdPtoSup, saldoQtd, qtd, qtdPrevProd);
            if (aux < 0.0) {
                aux = aux * -1.0;
                p.setQtdCompra(aux);
                p.setEnviarParaCompras(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            if (saldoQtd > 0.0 && qtd > 0.0) {
                Double qtdReserva = saldoQtd > qtd ? qtd.doubleValue() : saldoQtd.doubleValue();
                p.setQtdReserva(qtdReserva);
                p.setEnviarParaReserva(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                if (TMethods.isNotNull((Object)saldoEstoque).booleanValue()) {
                    saldoEstoque.setQuantidade(Double.valueOf(saldoEstoque.getQuantidade() - p.getQuantidade()));
                    if (saldoEstoque.getQuantidade() < 0.0) {
                        saldoEstoque.setQuantidade(Double.valueOf(0.0));
                    }
                }
                if (this.isNull(p.getQtdCompra()).booleanValue() || this.isEquals(p.getQtdCompra(), 0.0)) {
                    aux = 0.0;
                }
            }
        } else {
            throw new ExceptionInvalidData("E.ERP.2016.003", new Object[0]);
        }
        p.setPontoEstoque(qtdAnalCompra);
        p.setQtdeFalta(aux);
    }

    private SaldoEstoqueGeralBasico consultaEstoque(PlanejProdLinProdPrevConsProd p, Empresa emp, Date dataPosicao) {
        return this.serviceSaldoEstoque.findSaldoGradeCor(p.getGradeCor().getProdutoGrade().getProduto(), p.getGradeCor(), dataPosicao, emp, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
    }

    private SaldoEstoqueGeralBasico consultaEstoque(List<SaldoEstoqueGeralBasico> saldosUtilizados, PlanejProdLinProdPrevConsProd p, Empresa emp, Date dataPosicao) {
        Optional<SaldoEstoqueGeralBasico> opt = saldosUtilizados.stream().filter(i -> this.isEquals(i.getIdProduto(), p.getGradeCor().getProdutoGrade().getProduto().getIdentificador()) && this.isEquals(i.getIdGradeCor(), p.getGradeCor().getIdentificador())).findFirst();
        if (opt.isEmpty()) {
            SaldoEstoqueGeralBasico saldo = this.consultaEstoque(p, emp, dataPosicao);
            if (TMethods.isNotNull((Object)saldo).booleanValue()) {
                p.setQtdeSaldo(saldo.getQuantidade());
                saldosUtilizados.add(saldo);
                return saldo;
            }
            return null;
        }
        return opt.get();
    }

    public void separarGruposMateriaisCompraReserva(PlanejamentoMateriaisProdLin vo, List<PlanejProdLinProdPrevConsProd> materiais) {
        vo.getGruposPlanejMat().clear();
        vo.getPrevisaoConsProdutos().clear();
        GrupoPlanejamentoMateriaisLin grupoCompra = new GrupoPlanejamentoMateriaisLin();
        GrupoPlanejamentoMateriaisLin grupoReserva = new GrupoPlanejamentoMateriaisLin();
        grupoCompra.setTipo(Short.valueOf(EnumTipoGrupoPlanejamentoMateriaisLin.COMPRA.getValue()));
        grupoCompra.setData(vo.getDataConsulta());
        grupoReserva.setTipo(Short.valueOf(EnumTipoGrupoPlanejamentoMateriaisLin.RESERVA.getValue()));
        grupoReserva.setData(vo.getDataConsulta());
        if (CompMateriaisPlanejamentoProducao.isWithData(materiais)) {
            for (PlanejProdLinProdPrevConsProd material : materiais) {
                if (this.isAffimative(material.getEnviarParaCompras())) {
                    grupoCompra.getItensMateriaisPlanejLin().add(this.getItemMaterialPlanejLin(material, EnumTipoGrupoPlanejamentoMateriaisLin.COMPRA));
                }
                if (this.isAffimative(material.getEnviarParaReserva())) {
                    grupoReserva.getItensMateriaisPlanejLin().add(this.getItemMaterialPlanejLin(material, EnumTipoGrupoPlanejamentoMateriaisLin.RESERVA));
                }
                vo.getPrevisaoConsProdutos().add(material);
            }
        }
        vo.getGruposPlanejMat().add(grupoCompra);
        vo.getGruposPlanejMat().add(grupoReserva);
    }

    public ItemMaterialPlanejLin getItemMaterialPlanejLin(PlanejProdLinProdPrevConsProd material, EnumTipoGrupoPlanejamentoMateriaisLin tipo) {
        ItemMaterialPlanejLin itemMaterial = new ItemMaterialPlanejLin();
        if (TMethods.isEquals((Object)tipo, (Object)EnumTipoGrupoPlanejamentoMateriaisLin.COMPRA)) {
            itemMaterial.setQuantidade(material.getQtdCompra());
        } else if (TMethods.isEquals((Object)tipo, (Object)EnumTipoGrupoPlanejamentoMateriaisLin.RESERVA)) {
            itemMaterial.setQuantidade(material.getQtdReserva());
        }
        itemMaterial.setPrevisaoConsProduto(material);
        itemMaterial.setTipo(Short.valueOf(tipo.getValue()));
        return itemMaterial;
    }
}

