/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.movimentobancario;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.movimentobancario.EnumConstMovimentoBancario;
import com.touchcomp.basementor.constants.enums.tipocompesacaocheque.EnumConstTipoCompesacaoCheque;
import com.touchcomp.basementor.model.vo.BaixaChequeTerceiros;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.GrupoCompensacao;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.compensacaochequeproprio.CompCompensacaoChequeProprio;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.BaseLancamentoCtbGer;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompMovimentoBancario
extends BaseLancamentoCtbGer {
    @Autowired
    CompCompensacaoChequeProprio compCompensacaoChequeProprio;
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public void newMovimentoBancario(GrupoCompensacao g, PlanoConta pc, ContaValores conta) throws ExceptionInvalidData {
        for (CompensacaoCheque c : g.getCompensacaoCheques()) {
            if (!TMethods.isEquals((Object)c.getTipoCompensacao(), (Object)EnumConstTipoCompesacaoCheque.PRESCRITO.getValue())) continue;
            MovimentoBancario m = new MovimentoBancario();
            m.setEmpresa(g.getEmpresa());
            m.setDataCadastro(new Date());
            m.setDataLancamento(c.getDataCompensacao());
            m.setDataCompensacao(c.getDataCompensacao());
            m.setDebCred(Short.valueOf(EnumConstMovimentoBancario.CREDITO.getValue()));
            m.setValor(c.getCheque().getValor());
            m.setContaValor(conta);
            m.setModeloLancamentoBancario(g.getModeloLancBancario());
            m.setHistoricoPadrao(g.getHistorico());
            m.setHistorico(g.getDescricaoHistorico());
            m.setContraPartMovimentoBancario(this.newContraPartMovimentoBancario(g.getModeloLancBancario(), c.getCheque().getValor()));
            m.setNaoContabilizarMov(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            m.setCentroResultadoContFin(g.getEmpresa().getEmpresaDados().getCentroResultadoContFin());
            c.setMovimentoBancario(m);
            this.compCompensacaoChequeProprio.criaLoteContabil(g, pc);
        }
    }

    public void newMovimentoBancario(BaixaChequeTerceiros baixa) {
        if (ToolMethods.isNull((Object)baixa.getGerarMovFinanceiro()).booleanValue() || ToolMethods.isEquals((Object)baixa.getGerarMovFinanceiro(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            return;
        }
        MovimentoBancario mov = baixa.getMovimentoFinanceiro();
        if (ToolMethods.isNull((Object)baixa.getMovimentoFinanceiro()).booleanValue()) {
            mov = new MovimentoBancario();
        }
        mov.setModeloLancamentoBancario(baixa.getModeloLancBancario());
        mov.setBaixaChequeTerceiros(baixa);
        mov.setContaValor(baixa.getContaValor());
        mov.setDataCadastro(baixa.getDataCadastro());
        mov.setDataCompensacao(baixa.getDataBaixa());
        mov.setDataLancamento(baixa.getDataBaixa());
        mov.setDebCred(Short.valueOf(EnumConstMovimentoBancario.DEBITO.getValue()));
        mov.setEmpresa(baixa.getEmpresa());
        mov.setHistorico(MessagesBaseMentor.getMsg((String)"M.ERP.1541.001", (Object[])new Object[]{baixa.getChequeTerceiros().getNumero(), baixa.getChequeTerceiros().getTitular()}));
        mov.setValor(baixa.getValorBaixa());
        mov.setNaoContabilizarMov(baixa.getModeloLancBancario().getNaoContabilizarMov());
        mov.setContraPartMovimentoBancario(this.newContraPartMovimentoBancario(mov));
        baixa.setMovimentoFinanceiro(mov);
        for (ContraPartMovimentoBancario c : mov.getContraPartMovimentoBancario()) {
            c.setMovimentoBancario(mov);
            LancamentoCtbGerencial lancCtbGerencial = c.getLancamentoCtbGerencial();
            if (!ToolMethods.isNull((Object)c.getLancamentoCtbGerencial()).booleanValue()) continue;
            this.newLancamentoCtbGer(c.getDebCred(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, null, mov.getDataLancamento(), mov.getDataCompensacao(), c.getPlanoContaGerencial(), mov.getEmpresa(), MessagesBaseMentor.getMsg((String)"M.ERP.1541.002", (Object[])new Object[0]), c.getValor(), null);
            c.setLancamentoCtbGerencial(lancCtbGerencial);
        }
    }

    public List<ContraPartMovimentoBancario> newContraPartMovimentoBancario(MovimentoBancario vo) {
        ArrayList<ContraPartMovimentoBancario> listaContraPart = new ArrayList<ContraPartMovimentoBancario>();
        for (ItemModeloLancBancario item : vo.getModeloLancamentoBancario().getItemModeloLancBancario()) {
            ContraPartMovimentoBancario contraPartida = this.buildContraPartMovimentoBancario(item, vo.getValor());
            contraPartida.setLancamentoCtbGerencial(this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, vo.getDataLancamento(), vo.getDataCompensacao(), item.getDebCred(), vo.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), contraPartida.getHistorico(), item.getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), item.getCentroCusto(), vo.getValor(), null));
            listaContraPart.add(contraPartida);
        }
        return listaContraPart;
    }

    public List<ContraPartMovimentoBancario> newContraPartMovimentoBancario(ModeloLancBancario modelo, Double valor) {
        ArrayList<ContraPartMovimentoBancario> listaContraPart = new ArrayList<ContraPartMovimentoBancario>();
        for (ItemModeloLancBancario item : modelo.getItemModeloLancBancario()) {
            ContraPartMovimentoBancario contraPartida = this.buildContraPartMovimentoBancario(item, valor);
            listaContraPart.add(contraPartida);
        }
        return listaContraPart;
    }

    private ContraPartMovimentoBancario buildContraPartMovimentoBancario(ItemModeloLancBancario item, Double valor) {
        ContraPartMovimentoBancario contraPartida = new ContraPartMovimentoBancario();
        contraPartida.setDebCred(item.getDebCred());
        contraPartida.setBuscaTitulos(item.getBuscarTitulo());
        contraPartida.setHistorico(item.getHistoricoPadrao().getDescricao());
        contraPartida.setHistoricoPadrao(item.getHistoricoPadrao());
        contraPartida.setPlanoConta(item.getPlanoConta());
        contraPartida.setPlanoContaGerencial(item.getPlanoContaGerencial());
        contraPartida.setContraPartidaGeradaModeloLancamentoBancario(item.getContraPartida());
        contraPartida.setValor(valor);
        return contraPartida;
    }
}

