/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.FusoHorario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.AuxConverteEmitente;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class BaseNFeMethods {
    final String AMERICA_MANAUS = "America/Manaus";
    final String AMERICA_RIO_BRANCO = "America/Rio_Branco";
    final String AMERICA_CUIABA = "America/Cuiaba";
    final String AMERICA_EIRUNEPE = "America/Eirunepe";
    final String AMERICA_BOA_VISTA = "America/Boa_Vista";
    final String AMERICA_PORTO_VELHO = "America/Porto_Velho";
    final String AMERICA_SANTAREM = "America/Santarem";
    final String AMERICA_CAMPO_GRANDE = "America/Campo_Grande";
    final String AMERICA_NORONHA = "America/Campo_Grande";
    final String AMERICA_BELEM = "America/Belem";
    final String AMERICA_FORTALEZA = "America/Fortaleza";
    final String AMERICA_RECIFE = "America/Recife";
    final String AMERICA_ARAGUAINA = "America/Araguaina";
    final String AMERICA_MACEIO = "America/Maceio";
    final String DIFF_01_HORAS = "-01:00";
    final String DIFF_02_HORAS = "-02:00";
    final String DIFF_03_HORAS = "-03:00";
    final String DIFF_04_HORAS = "-04:00";
    final Short FUSO_HORARIO_COMPUTADOR = 0;
    protected final String ISENTO = "ISENTO";
    protected static final TLogger logger = TLogger.get(AuxConverteEmitente.class);

    protected String refina(String to) {
        return ToolString.refina((String)to);
    }

    protected String refinaNull(String to) {
        String str = ToolString.refina((String)to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    protected String refina(Object to) {
        if (to == null) {
            return null;
        }
        return ToolString.refina((String)to.toString());
    }

    protected String refinaXML(String to) {
        return ToolString.clearSpecialCharacXML((String)to);
    }

    protected String refinaXMLNull(String to) {
        String str = ToolString.clearSpecialCharacXML((String)to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    protected Double formatarNumeros(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        Double aux = ToolFormatter.arrredondarNumero((Double)num, (int)decimalSize);
        return aux;
    }

    protected Double formatarNumerosNullCaso0(Double num, int decimalSize) {
        if (num == null) {
            num = 0.0;
        }
        if (num == 0.0) {
            return null;
        }
        return this.formatarNumeros(num, decimalSize);
    }

    protected String formatarNumeros(Integer num) {
        if (num == null) {
            num = 0;
        }
        return this.refina(num.toString());
    }

    protected String formatarNumerosNullCaso0(Integer num) {
        if (num == null) {
            num = 0;
        }
        if (num == 0) {
            return null;
        }
        return this.refina(num.toString());
    }

    protected String formatarNumeros(Long num) {
        if (num == null) {
            num = 0L;
        }
        return this.refina(num.toString());
    }

    protected String formatarNumerosNullCaso0(Long num) {
        if (num == null) {
            num = 0L;
        }
        if (num == 0L) {
            return null;
        }
        return this.refina(num.toString());
    }

    protected String formatarNumeros(Short num) {
        if (num == null) {
            num = 0;
        }
        return this.refina(num.toString());
    }

    protected String formatarData(Date data) {
        if (data == null) {
            return null;
        }
        return ToolDate.dateToStr((Date)data, (String)"yyyy-MM-dd");
    }

    protected LocalDate formatarLocalData(Date data) {
        if (data == null) {
            return null;
        }
        return data.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    protected String formatarDataNull(Date data) {
        if (data == null) {
            return null;
        }
        return this.formatarData(data);
    }

    protected String formatarData(Date data, String mask) {
        if (data == null) {
            return null;
        }
        return ToolDate.dateToStr((Date)data, (String)mask);
    }

    protected String formatarHora(Date data) {
        if (data == null) {
            return null;
        }
        return ToolDate.dateToStr((Date)data, (String)"HH:mm:ss");
    }

    protected ZonedDateTime dateToZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.dateToZonedDateTime(date, ZoneId.systemDefault());
    }

    protected ZonedDateTime dateToZonedDateTime(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), zone);
    }

    protected ZonedDateTime dateToZonedDateTime(Date date, FusoHorario fusoH) {
        if (date == null) {
            return null;
        }
        ZoneId zone = null;
        if (fusoH != null && !this.isEmptyString(fusoH.getCodigo()).booleanValue()) {
            zone = ZoneId.of(fusoH.getCodigo());
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return ZonedDateTime.ofInstant(date.toInstant(), zone);
    }

    protected Boolean isEmptyString(String value) {
        return !ToolMethods.isStrWithData((String)value);
    }

    protected Boolean isAffirmative(Number value) {
        return ToolMethods.isAffirmative((Number)value);
    }

    protected Boolean isEquals(Object o1, Object o2) {
        return ToolMethods.isEquals((Object)o1, (Object)o2);
    }

    protected Boolean isEquals(String o1, String o2) {
        return o1.equalsIgnoreCase(o2);
    }

    protected Boolean startsWith(String string, String caracter) {
        return string.startsWith(caracter);
    }

    protected Integer stringToInteger(String value) {
        if (this.isEmptyString(value).booleanValue() || !ToolString.isAIntegerNumber((String)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    protected String combinaStrings(String ... args) {
        Object strFinal = "";
        for (String arg : args) {
            if (this.isEmptyString(arg).booleanValue()) continue;
            strFinal = (String)strFinal + " " + arg;
        }
        if (this.isEmptyString(((String)strFinal).trim()).booleanValue()) {
            return ((String)strFinal).trim();
        }
        return null;
    }

    protected Boolean contains(Object o, List itens) {
        if (o == null) {
            return false;
        }
        if (itens == null || itens.isEmpty()) {
            return false;
        }
        return itens.contains(o);
    }

    protected Integer yearFromDate(Date date) {
        if (date == null) {
            return null;
        }
        return ToolDate.yearFromDate((Object)date);
    }

    protected String onlyNumbers(String value) {
        if (value == null) {
            return null;
        }
        return ToolString.onlyNumbers((String)value);
    }

    protected String formatarData(Date dataNota, Date horaNota, Short tipoFusoHorario, FusoHorario fusoHorario) {
        if (dataNota == null) {
            return null;
        }
        String data = ToolDate.dateToStr((Date)dataNota, (String)"yyyy-MM-dd");
        String hora = ToolDate.dateToStr((Date)horaNota, (String)"HH:mm:ss");
        String formatado = data + "T" + hora;
        if (tipoFusoHorario.equals(this.FUSO_HORARIO_COMPUTADOR)) {
            formatado = TimeZone.getDefault().getID().equalsIgnoreCase("America/Manaus") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Rio_Branco") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Eirunepe") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Boa_Vista") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Porto_Velho") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Santarem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Cuiaba") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") ? (ToolDate.isHorarioVerao() ? formatado + "-03:00" : formatado + "-04:00") : (TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Belem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Fortaleza") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Recife") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Araguaina") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Maceio") ? (ToolDate.isHorarioVerao() ? formatado + "-01:00" : formatado + "-02:00") : (ToolDate.isHorarioVerao() ? formatado + "-02:00" : formatado + "-03:00"));
        } else {
            String codigo = fusoHorario.getCodigo();
            formatado = formatado + codigo;
        }
        return formatado;
    }

    protected ZonedDateTime formatarDataZonedDateTime(Date dataHoraNota, Short tipoFusoHorario, FusoHorario fusoHorario) {
        ZonedDateTime data;
        if (dataHoraNota == null) {
            return null;
        }
        if (tipoFusoHorario.equals(this.FUSO_HORARIO_COMPUTADOR)) {
            data = TimeZone.getDefault().getID().equalsIgnoreCase("America/Manaus") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Rio_Branco") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Eirunepe") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Boa_Vista") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Porto_Velho") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Santarem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Cuiaba") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") ? ZonedDateTime.ofInstant(dataHoraNota.toInstant(), ZoneId.of("America/Manaus")) : (TimeZone.getDefault().getID().equalsIgnoreCase("America/Campo_Grande") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Belem") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Fortaleza") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Recife") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Araguaina") || TimeZone.getDefault().getID().equalsIgnoreCase("America/Maceio") ? ZonedDateTime.ofInstant(dataHoraNota.toInstant(), ZoneId.of("America/Campo_Grande")) : ZonedDateTime.ofInstant(dataHoraNota.toInstant(), ZoneId.systemDefault()));
        } else {
            String codigo = fusoHorario.getCodigo();
            data = ZonedDateTime.ofInstant(dataHoraNota.toInstant(), ZoneId.of(codigo));
        }
        return data;
    }

    protected String getFone(Complemento complemento) {
        String fone = null;
        if (complemento.getFone1() != null && complemento.getFone1().trim().length() > 0) {
            fone = complemento.getFone1();
        }
        if (complemento.getFone2() != null && complemento.getFone2().trim().length() > 0) {
            fone = complemento.getFone2();
        }
        if (complemento.getCel1() != null && complemento.getCel1().trim().length() > 0) {
            fone = complemento.getFone1();
        }
        if (complemento.getCel2() != null && complemento.getCel2().trim().length() > 0) {
            fone = complemento.getCel2();
        }
        return fone;
    }
}

