/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consulta.v400;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeProtocolo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.nfe.consulta.base.BaseMethodsAtualizarNota;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarConteudoAprovacao;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperCancDenegaNotaPropria;
import com.touchcomp.basementortools.tools.xtream.ToolXtreamXML;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AtualizarConteudoAprovacao
extends BaseMethodsAtualizarNota
implements InterfaceAtualizarConteudoAprovacao {
    private static final TLogger logger = TLogger.get(AtualizarConteudoAprovacao.class);

    @Override
    public void atualizarConteudoAprovacao(NFeProtocolo protRec, NotaFiscalPropria nfe, Usuario usuario, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento) throws Exception {
        try {
            nfe.setStatus(Short.valueOf(protRec.getStatus()));
            String motivo = this.getMotivo(protRec);
            nfe.setMotivo(motivo);
            Short status = Short.valueOf(protRec.getStatus());
            if (EnumConstNFeStatus.isStatusAutorizada((Integer)status.intValue())) {
                this.atualizarNFeAprovada(nfe, protRec, usuario, opcoesFaturamento, opcoesRelacionamento);
            } else if (EnumConstNFeStatus.isStatusDenegada((Integer)status.intValue())) {
                this.atualizarNFeDenegada(nfe, protRec, status, motivo, opcoesFaturamento);
            } else {
                this.atualizarNFeOutroStatus(nfe);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AtualizarConteudoAprovacao.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception(ex);
        }
    }

    private String getMotivo(NFeProtocolo protRec) {
        String motivo = protRec.getMotivo();
        if (motivo != null && motivo.length() > 255) {
            motivo = motivo.substring(0, 255);
        }
        return motivo;
    }

    private void atualizarNFeOutroStatus(NotaFiscalPropria nfe) {
        nfe.setLiberarImpDanfe(Short.valueOf((short)0));
        nfe.setNrProtocolo(null);
    }

    private void atualizarNFeAprovada(NotaFiscalPropria nfe, NFeProtocolo protRec, Usuario usuario, OpcoesFaturamento opcoes, OpcoesRelacionamento opcoesRel) throws Exception {
        nfe.setLiberarImpDanfe(Short.valueOf((short)1));
        nfe.setNrProtocolo(protRec.getNumeroProtocolo());
        XMLNfePropria x = this.findCreateXMLNfePropria(nfe);
        x.setIdNotaPropria(nfe.getIdentificador());
        x.setConteudoAprovacao(ToolXtreamXML.toXML((Object)protRec, (ToolXtreamXML.Pair[])new ToolXtreamXML.Pair[0]));
        this.saveOrUpdateXMLNotaPropria(x);
        this.atualizarSituacaoPedido(nfe, opcoes.getSituacaoPedidosFat());
        this.sendEmail(nfe, usuario, opcoesRel);
    }

    private void atualizarNFeDenegada(NotaFiscalPropria nfe, NFeProtocolo protRec, Short status, String motivo, OpcoesFaturamento opcoes) {
        nfe.setLiberarImpDanfe(Short.valueOf((short)0));
        nfe.setNrProtocolo(protRec.getNumeroProtocolo());
        this.atualizaDadosNfeDenegada(nfe, status, motivo, opcoes.getSituacaoPedidosInutExc());
    }

    private void atualizaDadosNfeDenegada(NotaFiscalPropria nfe, Short status, String motivo, SituacaoPedidos s) {
        nfe.setStatus(status);
        nfe.setMotivo(motivo);
        new HelperCancDenegaNotaPropria().build(nfe).denegarNotaFiscal(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendEmail(NotaFiscalPropria nfe, Usuario usuario, OpcoesRelacionamento opcoesRelacionamento) throws Exception {
        try {
            if (!EnumConstNFeStatus.isStatusAutorizada((Integer)nfe.getStatus().intValue())) return;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }
}

