/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consulta.v400;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeProtocolo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.nfe.consulta.base.BaseMethodsAtualizarNota;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarDadosCancelamento;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperCancDenegaNotaPropria;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AtualizarDadosCancelamento
extends BaseMethodsAtualizarNota
implements InterfaceAtualizarDadosCancelamento {
    private static final TLogger logger = TLogger.get(AtualizarDadosCancelamento.class);

    @Override
    public void atualizarDadosCancelamentoSemRetornoDeEvento(NFeProtocolo retCancNFe, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario) throws Exception {
        try {
            Integer status = Integer.valueOf(retCancNFe.getStatus());
            if (ToolMethods.isEquals((Object)EnumConstNFeStatus.CANCELADA.getValue(), (Object)status) || ToolMethods.isEquals((Object)EnumConstNFeStatus.CANCELADA_FORA_DO_PRAZO.getValue(), (Object)status)) {
                this.atualizaDadosNfeCancelada(nfe, retCancNFe.getStatus(), retCancNFe.getMotivo(), opcoesFaturamento.getSituacaoPedidosCanc());
                this.atualizarSituacaoPedido(nfe, opcoesFaturamento.getSituacaoPedidosCanc());
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private NotaFiscalPropria atualizaDadosNfeCancelada(NotaFiscalPropria nfe, String cStat, String xMotivo, SituacaoPedidos sitCanc) throws Exception {
        this.setStatusNFeCancelada(nfe, cStat, xMotivo);
        return new HelperCancDenegaNotaPropria().build(nfe).cancelarNotaFiscal(sitCanc);
    }
}

