/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consulta.v400;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeEpec;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFEventoInfoRet;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.nfe.consulta.base.BaseMethodsAtualizarNota;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarDadosEvento;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperCancDenegaNotaPropria;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.xtream.ToolXtreamXML;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoNFe;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class AtualizarDadosEvento
extends BaseMethodsAtualizarNota
implements InterfaceAtualizarDadosEvento {
    private static final TLogger logger = TLogger.get(AtualizarDadosEvento.class);

    @Override
    public void atualizarDadosEvento(NFEventoInfoRet t, EventoNFe p, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws Exception {
        try {
            Integer s = t.getEventoRetorno().getCodigoStatus();
            if (s == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_VINC_NFE.getCodigo() || s == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_NAO_VINC_NFE.getCodigo() || s == 155) {
                this.saveXMLEventoNFe(t, p);
                p.setNrProtocolo(t.getEventoRetorno().getNumeroProtocolo());
                p.setStatus(Short.valueOf(s.shortValue()));
                if (p instanceof EvtNFeCancelamento && (p.getStatus().shortValue() == NFeConstStatusEventoNFe.EVENTO_REGISTRADO_VINC_NFE.getCodigo().shortValue() || p.getStatus() == 155)) {
                    this.saveEventoCancelamentoNFe(t, p, opcoesFaturamento);
                } else if (p instanceof EvtNFeManifestoDest) {
                    this.saveEventoNFeManifesto(p);
                } else if (p instanceof EvtNFeEpec) {
                    this.saveEventoNFeEpec(t, p);
                }
            }
            p.setStatus(Short.valueOf(s.shortValue()));
            p.setMotivo(t.getEventoRetorno().getMotivo());
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void saveEventoNFeEpec(NFEventoInfoRet t, EventoNFe p) throws Exception {
        DaoNotaFiscalPropriaImpl daoNotaFiscalPropria = (DaoNotaFiscalPropriaImpl)ConfApplicationContext.getBean(DaoNotaFiscalPropriaImpl.class);
        EvtNFeEpec ev = (EvtNFeEpec)p;
        NotaFiscalPropria nota = ev.getNotaFiscalPropria();
        nota.setEvtentoEpec(ev);
        nota.setLiberarImpDanfe(Short.valueOf((short)1));
        nota = daoNotaFiscalPropria.saveOrUpdate(nota);
        ev.setNotaFiscalPropria(nota);
        ev.setDataHoraProt(this.getDataHoraRegistroEvento(t.getEventoRetorno().getDataHoraRegistro()));
        XMLNfePropria x = this.findCreateXMLNfePropria(ev.getNotaFiscalPropria());
        x.setIdNotaPropria(ev.getNotaFiscalPropria().getIdentificador());
        x.setXmlDpec(ToolXtreamXML.toXML((Object)t, (ToolXtreamXML.Pair[])new ToolXtreamXML.Pair[0]));
        this.saveOrUpdateXMLNotaPropria(x);
    }

    private void saveEventoNFeManifesto(EventoNFe p) {
        EvtNFeManifestoDest ec = (EvtNFeManifestoDest)p;
        this.atualizarNFeDestinada(ec);
    }

    private void saveEventoCancelamentoNFe(NFEventoInfoRet t, EventoNFe p, OpcoesFaturamento opcoesFaturamento) throws Exception {
        EvtNFeCancelamento ec = (EvtNFeCancelamento)p;
        ec.setNotaFiscalPropria(this.atualizaDadosNfeCancelada(ec.getNotaFiscalPropria(), t.getEventoRetorno().getCodigoStatus().toString(), t.getEventoRetorno().getMotivo(), opcoesFaturamento.getSituacaoPedidosCanc()));
        this.atualizarSituacaoPedido(ec.getNotaFiscalPropria(), opcoesFaturamento.getSituacaoPedidosCanc());
    }

    private void saveXMLEventoNFe(NFEventoInfoRet t, EventoNFe p) {
        ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
        XMLEventoNFe xml = service.getOrCreateXMLEventoNFe(p.getIdentificador());
        xml.setConteudoRecebido(ToolXtreamXML.toXML((Object)t, (ToolXtreamXML.Pair[])new ToolXtreamXML.Pair[0]));
        service.saveOrUpdate((Object)xml);
    }

    private NotaFiscalPropria atualizaDadosNfeCancelada(NotaFiscalPropria nfe, String cStat, String xMotivo, SituacaoPedidos sitCanc) throws Exception {
        this.setStatusNFeCancelada(nfe, cStat, xMotivo);
        return new HelperCancDenegaNotaPropria().build(nfe).cancelarNotaFiscal(sitCanc);
    }

    private Date getDataHoraRegistroEvento(LocalDateTime dhRegEvento) {
        Date date1 = Date.from(dhRegEvento.atZone(ZoneId.systemDefault()).toInstant());
        return date1;
    }

    private void atualizarNFeDestinada(EvtNFeManifestoDest ec) {
    }
}

