/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consulta.v400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.certificado.ConfigCertificateNFe;
import com.touchcomp.basementorclientwebservices.nfe.impl.consultanota.UtilNfeSendWebServices;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.ConsultaNFeRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFEventoInfoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeConsultaNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeProtocolo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.nfe.consulta.base.BaseMethodsConsultaNFeBuilder;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarConteudoAprovacao;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarDadosCancelamento;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceAtualizarDadosEvento;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceConsultaNfeBuilder;
import com.touchcomp.basementorservice.components.nfe.consulta.interfaces.InterfaceConverteConsultaNFe;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.List;

public class ConsultaNFeBuilder
extends BaseMethodsConsultaNFeBuilder
implements InterfaceConsultaNfeBuilder {
    InterfaceAtualizarConteudoAprovacao atualizarConteudoAprovacao;
    InterfaceAtualizarDadosCancelamento atualizarDadosCancelamento;
    InterfaceAtualizarDadosEvento atualizarDadosEvento;
    InterfaceConverteConsultaNFe converteConsultaNFe;
    private static final TLogger logger = TLogger.get(ConsultaNFeBuilder.class);

    public ConsultaNFeBuilder(InterfaceAtualizarConteudoAprovacao atualizarConteudoAprovacao, InterfaceAtualizarDadosCancelamento atualizarDadosCancelamento, InterfaceAtualizarDadosEvento atualizarDadosEvento, InterfaceConverteConsultaNFe converteConsultaNFe) {
        this.atualizarConteudoAprovacao = atualizarConteudoAprovacao;
        this.atualizarDadosCancelamento = atualizarDadosCancelamento;
        this.atualizarDadosEvento = atualizarDadosEvento;
        this.converteConsultaNFe = converteConsultaNFe;
    }

    @Override
    public ConsultaNFeRet consultaNFe(TipoEmissaoNFe tmAmb, String versao, NotaFiscalPropria nfe, Usuario usuario, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento) throws Exception {
        try {
            ConfiguracaoCertificado certificado = this.getCertificado(opcoesFaturamento);
            ConfigCertificateNFe config = new ConfigCertificateNFe(nfe.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), opcoesFaturamento, tmAmb, certificado);
            NFeConsultaNota consulta = this.converteConsultaNFe.getNFeConsultaNota(nfe);
            ConsultaNFeRet consultaNFeRet = UtilNfeSendWebServices.consultarNFe((ConfigCertificateNFe)config, (NFeConsultaNota)consulta);
            this.atualizarNFe(nfe, consultaNFeRet, usuario, opcoesFaturamento, opcoesRelacionamento);
            Object ret = new String();
            ret = (String)ret + "Resultado da Consulta da NFe " + nfe.getNumeroNota() + ":";
            ret = (String)ret + "\nStatus: " + consultaNFeRet.getStatus();
            ret = (String)ret + "\nSUF: " + String.valueOf(consultaNFeRet.getUf());
            ret = (String)ret + "\nMotivo: " + consultaNFeRet.getMotivo();
            consultaNFeRet.setMensagemProcessada((String)ret);
            return consultaNFeRet;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw ex;
        }
    }

    private void atualizarNFe(NotaFiscalPropria nfe, ConsultaNFeRet toReceive, Usuario usuario, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento) throws Exception {
        if (toReceive.getProtocolo() != null && this.nfeNaoCancelada(toReceive.getStatus()).booleanValue()) {
            this.atualizarConteudoAprovacao.atualizarConteudoAprovacao(toReceive.getProtocolo(), nfe, usuario, opcoesFaturamento, opcoesRelacionamento);
        }
        if (toReceive.getProtocoloEvento() != null && toReceive.getProtocoloEvento().size() > 0) {
            this.atualizarDadosEvento(toReceive.getProtocoloEvento(), nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
        } else if (toReceive.getProtocoloCancelamento() != null) {
            this.atualizarDadosCancelamentoSemRetornoDeEvento(toReceive.getProtocoloCancelamento(), nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
        }
    }

    private void atualizarDadosEvento(List<NFEventoInfoRet> procEventoNFe, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento op, Usuario usuario) throws Exception {
        try {
            for (NFEventoInfoRet t : procEventoNFe) {
                EventoNFe ev = this.getEventoNFe(t.getEvento(), nfe);
                if (ev == null) continue;
                this.atualizarDadosEvento.atualizarDadosEvento(t, ev, nfe, opcoesFaturamento, op, usuario);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex.getMessage(), ex);
        }
    }

    private void atualizarDadosCancelamentoSemRetornoDeEvento(NFeProtocolo retCancNFe, NotaFiscalPropria nfe, OpcoesFaturamento opcoesFaturamento, OpcoesRelacionamento opcoesRelacionamento, Usuario usuario) throws Exception {
        try {
            if (retCancNFe != null) {
                this.atualizarDadosCancelamento.atualizarDadosCancelamentoSemRetornoDeEvento(retCancNFe, nfe, opcoesFaturamento, opcoesRelacionamento, usuario);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex.getMessage(), ex);
        }
    }

    private ConfiguracaoCertificado getCertificado(OpcoesFaturamento opcoes) {
        ServiceConfiguracaoCertificadoImpl daoConfCertificado = (ServiceConfiguracaoCertificadoImpl)ConfApplicationContext.getBean(ServiceConfiguracaoCertificadoImpl.class);
        ConfiguracaoCertificado conf = daoConfCertificado.getByEmpresa(opcoes.getEmpresa());
        return conf;
    }
}

