/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consultanfedoc;

import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaResumo;
import com.fincatto.documentofiscal.utils.DFPersister;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLNFes;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstTipoEventoNFe;
import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDist;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDocsDist;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestEvtDist;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNSU;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorclientwebservices.nfe.model.dto.NFDistribuicaoProcEventoNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.dto.NFDistribuicaoResEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorrules.nfe.CompNFe;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.consultanfedestdist.ServiceConsultaNFeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdocsdist.ServiceConsultaNFeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestevtdist.ServiceConsultaNFeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNFeCTeEvt;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.io.File;
import java.util.Date;

class AuxProcessaEventoDistNFe {
    final ServiceXMLNFeCTe serviceXmlNFeCte;
    final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    final ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    final ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtDistImpl;
    final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl;
    final ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl;
    final CompStatusConsNFeDoc compStatusConsDoc;
    final ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl;
    final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    final ConfigServicos configServicos;
    Short salvarApenasNFRespEmpresa;
    private final String NFE_4_0_R = "procNFe";
    private final String NFE_RES_R = "resNFe";
    private final String PROC_EVT_RES_R = "resEvento";
    private final String PROC_EVT_R = "procEventoNFe";

    public AuxProcessaEventoDistNFe(ServiceXMLNFeCTe serviceXmlNFeCte, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtDistImpl, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl, ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl, CompStatusConsNFeDoc compStatusConsDoc, ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, ConfigServicos configServicos, HelperConfigServicos helperConfigServicos) {
        String salvarApenasNFRespEmpresaStr;
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaNFeDestDocImpl = serviceConsultaNFeDestDocImpl;
        this.serviceConsultaNFeDestEvtDistImpl = serviceConsultaNFeDestEvtDistImpl;
        this.serviceUnidadeFatFornecedorImpl = serviceUnidadeFatFornecedorImpl;
        this.serviceUnidadeFederativaImpl = serviceUnidadeFederativaImpl;
        this.compStatusConsDoc = compStatusConsDoc;
        this.serviceConsultaNFeDestNSUImpl = serviceConsultaNFeDestNSUImpl;
        this.serviceNotaFiscalTerceiros = serviceNotaFiscalTerceiros;
        this.configServicos = configServicos;
        this.salvarApenasNFRespEmpresa = 1;
        if (helperConfigServicos != null && TMethods.isStrWithData((String)TString.onlyNumbers((String)(salvarApenasNFRespEmpresaStr = helperConfigServicos.getValue(ConstantsDistribuicaoXMLNFes.CONSIDERAR_APENAS_NOTAS_RESP_EMPRESA.getChave()))))) {
            this.salvarApenasNFRespEmpresa = Short.valueOf(salvarApenasNFRespEmpresaStr);
        }
    }

    void readAndSave(NFDistribuicaoDocumentoZip doc, TaskProcessResult result, Empresa empresa) throws ExceptionZip, ExceptionDecodeHexString64, Exception {
        this.readAndSave(doc, result, empresa, null);
    }

    void readAndSave(NFDistribuicaoDocumentoZip doc, TaskProcessResult result, Empresa empresa, ConsultaNFeDestDist consulta) throws ExceptionZip, ExceptionDecodeHexString64, Exception {
        String xml = doc.getValue();
        String schema = doc.getSchema();
        String nsu = doc.getNsu();
        ConsultaNFeDestNSU consultaNsu = this.serviceConsultaNFeDestNSUImpl.getOrCreate(schema, nsu, empresa);
        boolean proc = false;
        try {
            byte[] data = ToolBase64.decodeBase64((String)xml);
            xml = ToolZipUtils.decompress((byte[])data);
            proc = this.processaXML(schema, xml, nsu, result, empresa, consultaNsu, consulta);
        }
        catch (Exception ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.005", empresa, nsu, ex.getMessage());
        }
        consultaNsu.setProcessado(Short.valueOf(proc ? (short)1 : 0));
        this.serviceConsultaNFeDestNSUImpl.saveOrUpdateFlush(consultaNsu);
    }

    protected boolean processaXML(String schema, String xml, String nsu, TaskProcessResult result, Empresa empresa, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta) throws Exception {
        this.saveXml(xml, nsu, schema);
        if (schema.contains("procNFe")) {
            this.readNFe_3_0(xml, nsu, result, consultaNsu, consulta, empresa);
            return true;
        }
        if (schema.contains("resNFe")) {
            this.readResNFe_3_0(xml, nsu, result, empresa, consultaNsu, consulta);
            return true;
        }
        if (schema.contains("resEvento")) {
            this.processarEventoRes(xml, nsu, result, consultaNsu, consulta, empresa);
            return true;
        }
        if (schema.contains("procEventoNFe")) {
            this.processarEvento(xml, nsu, result, consultaNsu, consulta, empresa);
            return true;
        }
        result.addError("E.TSK.0022.004", empresa, nsu, schema);
        return false;
    }

    private void processarEventoRes(String xml, String nsu, TaskProcessResult result, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta, Empresa empresa) throws Exception {
        try {
            NFDistribuicaoResEvento nfe = this.getData(NFDistribuicaoResEvento.class, xml);
            this.processarEvento(nfe.getChNFe(), Long.valueOf(nfe.getTpEvento()), nsu, nfe.getnSeqEvento(), xml, consultaNsu, consulta);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.003", empresa, nfe.getChNFe(), EnumConstTipoEventoNFe.getByCodigo((String)nfe.getTpEvento()));
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.005", empresa, nsu, ex.getMessage());
        }
    }

    private void saveXmlErroLeitura(String xml) {
        try {
            File f = new File(ToolFile.getUserDir() + File.separator + "xml_dist_erro_nfe" + File.separator + new Date().getTime() + ".xml");
            f.getParentFile().mkdirs();
            ToolFile.writeStringInFile((File)f, (String)xml);
        }
        catch (ExceptionIO ex) {
            this.logError(ex);
        }
    }

    private void processarEvento(String xml, String nsu, TaskProcessResult result, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta, Empresa empresa) throws Exception {
        try {
            NFDistribuicaoProcEventoNFe nfe = this.getData(NFDistribuicaoProcEventoNFe.class, xml);
            this.processarEvento(nfe.getEvento().getInfEvento().getChNFe(), Long.valueOf(nfe.getEvento().getInfEvento().getTpEvento()), nsu, nfe.getEvento().getInfEvento().getNSeqEvento(), xml, consultaNsu, consulta);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.004", empresa, nfe.getEvento().getInfEvento().getChNFe(), EnumConstTipoEventoNFe.getByCodigo((String)nfe.getEvento().getInfEvento().getTpEvento()));
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.006", empresa, nsu, ex.getMessage());
            this.saveXmlErroLeitura(xml);
        }
    }

    private void readNFe_3_0(String xml, String nsu, TaskProcessResult result, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta, Empresa empresa) {
        try {
            NFNotaProcessada nfe = this.getData(NFNotaProcessada.class, xml);
            String dest = nfe.getNota().getInfo().getDestinatario().getCnpj();
            if (TMethods.isStrWithData((String)nfe.getNota().getInfo().getDestinatario().getCpf())) {
                dest = nfe.getNota().getInfo().getDestinatario().getCpf();
            }
            if (!this.arquivarNota(nfe.getNota().getInfo().getIdentificacao().getTipo(), dest, empresa)) {
                return;
            }
            String chaveNFe = nfe.getNota().getInfo().getChaveAcesso();
            String cnpjAgreg = null;
            String cnpjEmitente = nfe.getNota().getInfo().getEmitente().getCnpj();
            String cnpjCliente = nfe.getNota().getInfo().getDestinatario().getCnpj();
            String inscCliente = nfe.getNota().getInfo().getDestinatario().getInscricaoEstadual();
            String ie = nfe.getNota().getInfo().getEmitente().getInscricaoEstadual();
            String natOperacao = nfe.getNota().getInfo().getIdentificacao().getNaturezaOperacao();
            String fatEntSaida = nfe.getNota().getInfo().getIdentificacao().getTipo().getCodigo();
            if (!ToolMethods.isStrWithData((String)cnpjCliente)) {
                cnpjCliente = nfe.getNota().getInfo().getDestinatario().getCpf();
            }
            XMLNFeCTe x = this.readAndSaveXMLNFe(xml, cnpjEmitente, cnpjCliente, cnpjEmitente, chaveNFe, cnpjAgreg);
            ConsultaNFeDestDocsDist c = this.serviceConsultaNFeDestDocImpl.getByChave(chaveNFe);
            if (c == null) {
                c = new ConsultaNFeDestDocsDist();
                c.setConsultaNFeDestDist(consulta);
            }
            this.completInfo(c, cnpjEmitente, ie, chaveNFe);
            c.setNsu(nsu);
            c.setNaturezaOperacao(natOperacao);
            if (TMethods.isStrWithData((String)fatEntSaida)) {
                c.setTipoFatEntSaida(Short.valueOf(fatEntSaida));
            }
            c.setEmpresa(empresa);
            c.setIdRegXMLTerc(x.getIdentificador());
            c.setCnpjDestinatarioTomador(cnpjCliente);
            c.setInscricaoEstadualDestinatario(inscCliente);
            c.setCnpjEmitente(cnpjEmitente);
            c.setStatusSefaz(EnumConstCTeStatus.AUTORIZADO.getValueShort());
            c.setChave(chaveNFe);
            c.setConsultaNFeDestDist(consulta);
            c.setConsultaNFeDestNSU(consultaNsu);
            consultaNsu.setChaveNFe(chaveNFe);
            c.setDataEmissao(Date.from(nfe.getNota().getInfo().getIdentificacao().getDataHoraEmissao().toInstant()));
            c.setNome(nfe.getNota().getInfo().getEmitente().getRazaoSocial());
            c.setValor(Double.valueOf(nfe.getNota().getInfo().getTotal().getIcmsTotal().getValorTotalNFe()));
            c.setInscricaoEstadual(nfe.getNota().getInfo().getEmitente().getInscricaoEstadual());
            c.setObservacao(MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.1910.001", (Object[])new Object[0]));
            this.compStatusConsDoc.definirStatusConsultaDoc(c, EnumConstStatLancNFTerceiros.STAT_INTER_DOWNLOAD_COMPLETO);
            ConsultaNFeDestEvtDist evt = this.serviceConsultaNFeDestEvtDistImpl.getEventoTpEvtSefaz(chaveNFe, EnumConstTipoEventoNFe.CANCELAMENTO);
            if (evt != null) {
                c.setStatusSefaz(EnumConstNFeStatus.CANCELADA.getValueShort());
                this.compStatusConsDoc.definirStatusConsultaDoc(c, EnumConstStatLancNFTerceiros.STAT_FINAL_DENEGADADA_CANCELADA);
            }
            c.setNotaFiscalTerceiros(this.serviceNotaFiscalTerceiros.findNotaTerceirosPorChave(chaveNFe));
            c = this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush(c);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.001", empresa, chaveNFe);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.007", empresa, nsu, ex.getMessage());
            this.saveXmlErroLeitura(xml);
        }
    }

    private void readResNFe_3_0(String xml, String nsu, TaskProcessResult result, Empresa emp, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta) {
        String cnpjCliente = emp.getPessoa().getComplemento().getCnpj();
        String inscCliente = emp.getPessoa().getComplemento().getInscEst();
        try {
            ConsultaNFeDestDocsDist c;
            NFNotaResumo nfe = this.getData(NFNotaResumo.class, xml);
            String dest = nfe.getCNPJ();
            if (TMethods.isStrWithData((String)nfe.getCPF())) {
                dest = nfe.getCPF();
            }
            System.out.println("teste");
            if (!this.arquivarNota(nfe.getTipo(), emp.getPessoa().getComplemento().getCnpj(), emp)) {
                return;
            }
            String chaveNFe = nfe.getChave();
            String cnpjEmitente = nfe.getCNPJ();
            String ie = nfe.getIE();
            if (!ToolMethods.isStrWithData((String)cnpjEmitente)) {
                cnpjEmitente = nfe.getCPF();
            }
            if ((c = this.serviceConsultaNFeDestDocImpl.getByChave(chaveNFe)) == null) {
                c = new ConsultaNFeDestDocsDist();
                c.setConsultaNFeDestDist(consulta);
            }
            this.completInfo(c, cnpjEmitente, ie, chaveNFe);
            c.setNsu(nsu);
            c.setEmpresa(emp);
            c.setConsultaNFeDestDist(consulta);
            c.setConsultaNFeDestNSU(consultaNsu);
            consultaNsu.setChaveNFe(chaveNFe);
            c.setCnpjDestinatarioTomador(cnpjCliente);
            c.setInscricaoEstadualDestinatario(inscCliente);
            c.setCnpjEmitente(cnpjEmitente);
            c.setStatusSefaz(EnumConstCTeStatus.AUTORIZADO.getValueShort());
            c.setChave(chaveNFe);
            c.setStatusSistema(Short.valueOf(EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue()));
            c.setDataEmissao(Date.from(nfe.getDataHoraEmissao().toInstant()));
            c.setNome(nfe.getNome());
            c.setValor(Double.valueOf(nfe.getValor().doubleValue()));
            c.setTipoFatEntSaida(Short.valueOf(nfe.getTipo().getCodigo()));
            c.setInscricaoEstadual(ie);
            c.setObservacao(MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.1910.002", (Object[])new Object[0]));
            c.setNotaFiscalTerceiros(this.serviceNotaFiscalTerceiros.findNotaTerceirosPorChave(chaveNFe));
            c = this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush(c);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.002", emp, chaveNFe);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.008", emp, nsu, ex.getMessage());
            this.saveXmlErroLeitura(xml);
        }
    }

    private void processarEvento(String chaveDoc, Long tipoEventoSefaz, String nsu, Integer nrSeq, String xml, ConsultaNFeDestNSU consultaNsu, ConsultaNFeDestDist consulta) {
        ConsultaNFeDestEvtDist evt = this.serviceConsultaNFeDestEvtDistImpl.getEvento(chaveDoc, tipoEventoSefaz, nrSeq);
        if (evt == null) {
            evt = new ConsultaNFeDestEvtDist();
        }
        evt.setChave(chaveDoc);
        evt.setTipoEventoSefaz(tipoEventoSefaz);
        evt.setNrSeqEvento(nrSeq);
        evt.setNsu(nsu);
        evt.setConsultaNFeDestDist(consulta);
        evt.setConsultaNFeDoc(this.serviceConsultaNFeDestDocImpl.getByChave(chaveDoc));
        evt.setConsultaNFeDestNSU(consultaNsu);
        consultaNsu.setChaveNFe(chaveDoc);
        this.definirStatusNFeConfEvento(tipoEventoSefaz, evt);
        evt = this.serviceConsultaNFeDestEvtDistImpl.saveOrUpdateFlush(evt);
        XMLNFeCTeEvt xmlEvt = this.serviceXmlNFeCteEvt.getByNSU(nsu);
        if (xmlEvt == null) {
            xmlEvt = new XMLNFeCTeEvt();
        }
        xmlEvt.setChaveDoc(evt.getChave());
        xmlEvt.setConteudoXML(xml);
        xmlEvt.setNsu(nsu);
        xmlEvt.setDataChegada(new Date());
        this.serviceXmlNFeCteEvt.saveOrUpdate((Object)xmlEvt);
    }

    private XMLNFeCTe readAndSaveXMLNFe(String xml, String cnpjEmitente, String cnpjClienteTomador, String cnpjTransportador, String chave, String cnpjTranspAgreg) {
        XMLNFeCTe x = this.serviceXmlNFeCte.getOrCreateXMlNfeCTeChaveNFe(chave);
        x.setChaveNFe(chave);
        x.setCnpjEmitente(cnpjEmitente);
        x.setCnpjTransportador(cnpjTransportador);
        x.setCnpjTranspAgregado(cnpjTranspAgreg);
        x.setCnpjDestinatarioCliente(cnpjClienteTomador);
        x.setFlag(Integer.valueOf(0));
        x.setConteudoXML(xml);
        x.setDataChegada(new Date());
        x = (XMLNFeCTe)this.serviceXmlNFeCte.saveOrUpdate((Object)x);
        return x;
    }

    private void logError(Throwable ex) {
        TLogger.get(this.getClass()).error(ex);
    }

    private UnidadeFatFornecedor getUnidadeFatForn(String cnpjEmitente, String ie) {
        return this.serviceUnidadeFatFornecedorImpl.getCNPJInscEstAtivo(cnpjEmitente, ie);
    }

    private void completInfo(ConsultaNFeDestDocsDist c, String cnpjEmitente, String ie, String chaveNFe) {
        String serie = CompNFe.getSerie((EnumConstNFeVersao)EnumConstNFeVersao.VERSAO_3_10, (String)chaveNFe);
        Long numeroNota = CompNFe.getNumeroDoc((EnumConstNFeVersao)EnumConstNFeVersao.VERSAO_3_10, (String)chaveNFe);
        String codUF = CompNFe.getCodigoUf((EnumConstNFeVersao)EnumConstNFeVersao.VERSAO_3_10, (String)chaveNFe);
        c.setUnidadeFatFornecedor(this.getUnidadeFatForn(cnpjEmitente, ie));
        c.setSerieDoc(serie);
        c.setNumeroDoc(numeroNota);
        c.setUfEmissaoDoc(this.serviceUnidadeFederativaImpl.getByCodIBGE(codUF));
    }

    private <E> E getData(Class<E> aClass, String xml) throws Exception {
        Object e = null;
        Object data = new DFPersister().read(aClass, xml, false);
        return (E)data;
    }

    private void saveXml(String nsu, String schema, String xml) {
    }

    protected boolean arquivarNota(NFTipo tipo, String cnpjDestinatario, Empresa empresa) {
        return !TMethods.isAffirmative((Number)this.salvarApenasNFRespEmpresa) || TMethods.isEquals((Object)cnpjDestinatario, (Object)empresa.getPessoa().getComplemento().getCnpj());
    }

    private void definirStatusNFeConfEvento(Long tipoEventoSefaz, ConsultaNFeDestEvtDist evt) {
        if (evt.getConsultaNFeDoc() == null) {
            return;
        }
        boolean atualizarStatusNota = this.compStatusConsDoc.definirStatusSefazConsultaDoc(evt, tipoEventoSefaz);
        if (atualizarStatusNota) {
            evt.setConsultaNFeDoc(this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush(evt.getConsultaNFeDoc()));
        }
    }
}

