/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consultanfedoc;

import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDownloadXMLAutoNFe;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstDistribuicaoNFeStatus;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDocsDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.distribuicaonfe.WebDistribuicaoDocXMLNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.distdocxmlnfe.ParamsDistribDocXMLNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.ComponentsBase;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.AuxProcessaEventoDistNFe;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdist.ServiceConsultaNFeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdocsdist.ServiceConsultaNFeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestevtdist.ServiceConsultaNFeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompConsultaNFeDownloadXMLDoc
extends ComponentsBase {
    final ServiceXMLNFeCTe serviceXmlNFeCte;
    final HelperConfigServicos helperConfigServicos;
    final CompStatusConsNFeDoc compStatusConsDoc;
    final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    final WebDistribuicaoDocXMLNFe webDistribuicaoNFe;
    final ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    final ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl;
    final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl;
    final ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl;
    final HelperConfiguracaoCertificado helperConfigCertificado;
    final ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl;
    final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    final ServiceConfigServicosImpl serviceConfigServicosImpl;
    private final Integer MAX_REGS_PER_TIME = 50;
    private final Integer MAX_DEF_DELAY = 0;

    public CompConsultaNFeDownloadXMLDoc(ServiceXMLNFeCTe serviceXmlNFeCte, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, WebDistribuicaoDocXMLNFe webDistribuicaoNFe, ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl, HelperConfiguracaoCertificado helperConfigCertificado, ServiceUnidadeFederativaImpl serviceUnidadeFederativaImpl, CompStatusConsNFeDoc compStatusConsDoc, ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtDistImpl, HelperConfigServicos helperConfigServicos, ServiceConfigServicosImpl serviceConfigServicosImpl) {
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.webDistribuicaoNFe = webDistribuicaoNFe;
        this.serviceConsultaNFeDestDocImpl = serviceConsultaNFeDestDocImpl;
        this.serviceConsultaNFeDestEvtImpl = serviceConsultaNFeDestEvtImpl;
        this.serviceUnidadeFatFornecedorImpl = serviceUnidadeFatFornecedorImpl;
        this.helperConfigCertificado = helperConfigCertificado;
        this.compStatusConsDoc = compStatusConsDoc;
        this.serviceUnidadeFederativaImpl = serviceUnidadeFederativaImpl;
        this.helperConfigServicos = helperConfigServicos;
        this.serviceConsultaNFeDestNSUImpl = serviceConsultaNFeDestNSUImpl;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceiros;
        this.serviceConfigServicosImpl = serviceConfigServicosImpl;
    }

    public TaskProcessResult consultaERealizaDownloadXMLPendentes(ConfiguracaoCertificado configCert, Empresa empresa) {
        TaskProcessResult result = new TaskProcessResult();
        this.consultaERealizaDownloadXMLPendentes(configCert, empresa, result, this.MAX_DEF_DELAY);
        return result;
    }

    public void consultaERealizaDownloadXMLPendentes(ConfiguracaoCertificado configCert, Empresa empresa, TaskProcessResult result, Integer delayAposCiencia) {
        List<ConsultaNFeDestDocsDist> docs;
        int count = 0;
        int page = 0;
        ConfigServicos configServicos = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.DOWNLOAD_AUTOMATICO_NFE, ConstantsDownloadXMLAutoNFe.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        while (this.efetuarDownload(docs = this.serviceConsultaNFeDestDocImpl.getDocsAgDownloadXML(empresa, delayAposCiencia, this.MAX_REGS_PER_TIME, page), configCert, empresa, result, configServicos)) {
            count = docs.size();
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0026.001", count + ": " + String.valueOf(empresa));
            page += this.MAX_REGS_PER_TIME.intValue();
            if (count > 0) continue;
        }
    }

    private boolean efetuarDownload(List<ConsultaNFeDestDocsDist> evtsManifesto, ConfiguracaoCertificado configCert, Empresa empresa, TaskProcessResult result, ConfigServicos configServicos) {
        ParamsCertificado params = this.helperConfigCertificado.build(configCert).getParamsCertificado(ConstAmbiente.PRODUCAO);
        for (ConsultaNFeDestDocsDist ev : evtsManifesto) {
            try {
                NFDistribuicaoIntRetorno ret = this.webDistribuicaoNFe.consultarDistribuicaoXML(params, this.getParamsDist(empresa, ev.getChave()));
                if (!EnumConstDistribuicaoNFeStatus.isStatusFinal((String)ret.getCodigoStatusReposta())) {
                    result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ret.getCodigoStatusReposta() + " - " + ret.getMotivo() + ": " + String.valueOf(empresa));
                    return false;
                }
                if (EnumConstDistribuicaoNFeStatus.isServicoParado((String)ret.getCodigoStatusReposta())) {
                    result.addDet(EnumConstantsTaskResult.RESULT_ADVERTENCIA, ret.getCodigoStatusReposta() + " - " + ret.getMotivo() + ": " + String.valueOf(empresa));
                    return false;
                }
                if (!EnumConstDistribuicaoNFeStatus.isDocFound((String)ret.getCodigoStatusReposta())) {
                    result.addDet(EnumConstantsTaskResult.RESULT_OK, ret.getCodigoStatusReposta() + " - " + ret.getMotivo() + ": " + ev.getChave() + ": " + String.valueOf(empresa));
                    break;
                }
                AuxProcessaEventoDistNFe auxProcessamento = this.getAuxProcessamentoNFe(configServicos);
                for (NFDistribuicaoDocumentoZip doc : ret.getLote().getDocZip()) {
                    auxProcessamento.readAndSave(doc, result, empresa);
                }
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, this.getMessage("E.TSK.0024.004", ev.getChave(), ex.getMessage()) + ": " + String.valueOf(empresa));
                return false;
            }
        }
        return true;
    }

    private AuxProcessaEventoDistNFe getAuxProcessamentoNFe(ConfigServicos configServicos) {
        return new AuxProcessaEventoDistNFe(this.serviceXmlNFeCte, this.serviceXmlNFeCteEvt, this.serviceConsultaNFeDestDocImpl, this.serviceConsultaNFeDestEvtImpl, this.serviceUnidadeFatFornecedorImpl, this.serviceUnidadeFederativaImpl, this.compStatusConsDoc, this.serviceConsultaNFeDestNSUImpl, this.serviceNotaFiscalTerceirosImpl, configServicos, this.helperConfigServicos);
    }

    private ParamsDistribDocXMLNFe getParamsDist(Empresa empresa, String chave) throws Exception {
        ParamsDistribDocXMLNFe paramsDist = new ParamsDistribDocXMLNFe();
        paramsDist.setAmbiente(ConstAmbiente.PRODUCAO);
        paramsDist.setChaveAcesso(chave);
        paramsDist.setCnpj(empresa.getPessoa().getComplemento().getCnpj());
        paramsDist.setCodIbgeUF(empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        return paramsDist;
    }

    public TaskProcessResult consultaERealizaDownloadXMLPendentes(List<String> chavesNotas, ConfiguracaoCertificado configCert, Empresa empresa) {
        TaskProcessResult result = new TaskProcessResult();
        ConfigServicos configServicos = this.serviceConfigServicosImpl.getContainsValue(EnumConstConfigServicos.DOWNLOAD_AUTOMATICO_NFE, ConstantsDownloadXMLAutoNFe.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        if (configServicos == null) {
            return result;
        }
        List<ConsultaNFeDestDocsDist> docs = this.serviceConsultaNFeDestDocImpl.getDocsAgDownloadXML(chavesNotas, empresa);
        this.efetuarDownload(docs, configCert, empresa, result, configServicos);
        return result;
    }
}

